/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.blacklist;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.bklist.BlackListStrategyDto;
import com.qiho.center.api.dto.bklist.StrategyDto;
import com.qiho.center.api.enums.DealTypeEnum;
import com.qiho.center.api.enums.blacklist.BaiqiBlackListTypeEnum;
import com.qiho.center.api.enums.blacklist.BlackListUseTypeEnum;
import com.qiho.center.biz.service.blacklist.BlackListStrategyService;
import com.qiho.center.biz.service.merchant.MerchantService;
import com.qiho.center.common.daoh.qiho.blacklist.BaiqiBKStrategyMCMapper;
import com.qiho.center.common.daoh.qiho.blacklist.BaiqiBlackListStrategyMapper;
import com.qiho.center.common.entityd.qiho.blacklist.BaiqiBKStrategyMCEntity;
import com.qiho.center.common.entityd.qiho.blacklist.BaiqiBlackListStrategyEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BlackListStrategyServiceImpl
implements BlackListStrategyService {
    @Autowired
    private BaiqiBlackListStrategyMapper baiqiBlackListStrategyMapper;
    @Autowired
    private MerchantService merchantService;
    @Autowired
    private BaiqiBKStrategyMCMapper baiqiBKStrategyMCMapper;

    @Override
    public List<BlackListStrategyDto> listByMerchantId(Long merchantId) {
        if (null == merchantId) {
            return Lists.newArrayList();
        }
        List strategyEntities = Lists.newArrayList();
        if (merchantId == -1L) {
            strategyEntities = this.baiqiBlackListStrategyMapper.listAllStrategy();
        } else if (merchantId == 0L) {
            strategyEntities = this.baiqiBlackListStrategyMapper.listCommonStrategy();
        } else if (merchantId > 0L) {
            List baiqiBKStrategyMCEntities = this.baiqiBKStrategyMCMapper.listByMerchantId(merchantId);
            if (CollectionUtils.isEmpty((Collection)baiqiBKStrategyMCEntities)) {
                return Lists.newArrayList();
            }
            List strategyIds = baiqiBKStrategyMCEntities.stream().map(BaiqiBKStrategyMCEntity::getStrategyId).collect(Collectors.toList());
            strategyEntities = this.baiqiBlackListStrategyMapper.listByIds(strategyIds);
        }
        return this.convertStrategyToDto(strategyEntities);
    }

    @Override
    @Transactional(value="QIHO")
    public ResultDto<Boolean> createBlackStrategy(BlackListStrategyDto param) {
        if (param.getUseType() == BlackListUseTypeEnum.ALL) {
            return this.insertCommonStrategy(param);
        }
        if (param.getUseType() == BlackListUseTypeEnum.PART) {
            return this.insertPartMerchatStrategy(param);
        }
        return ResultDto.failResult((String)"\u9002\u7528\u5546\u5bb6\u7c7b\u578b\u9519\u8bef");
    }

    @Override
    @Transactional(value="QIHO")
    public ResultDto<Boolean> deleteBlackListStrategy(Long id, String name) {
        BaiqiBlackListStrategyEntity entity = this.baiqiBlackListStrategyMapper.findById(id);
        if (entity == null) {
            return ResultDto.failResult((String)"\u7b56\u7565\u4e0d\u5b58\u5728");
        }
        this.baiqiBlackListStrategyMapper.deleteBlackListStrategy(id, name);
        if (entity.getUseType().intValue() == BlackListUseTypeEnum.PART.getNum()) {
            this.baiqiBKStrategyMCMapper.deletedByStrategyId(id);
        }
        return ResultDto.successResult((Object)Boolean.TRUE);
    }

    @Override
    @Transactional(value="QIHO")
    public ResultDto<Boolean> updateBlackListStrategy(BlackListStrategyDto param) {
        Long strategyId = param.getId();
        if (strategyId == null) {
            return ResultDto.failResult((String)"\u7b56\u7565id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BaiqiBlackListStrategyEntity blackListStrategyEntity = this.baiqiBlackListStrategyMapper.findById(strategyId);
        if (null == blackListStrategyEntity) {
            return ResultDto.failResult((String)"\u7b56\u7565\u4e0d\u5b58\u5728");
        }
        BlackListUseTypeEnum oldUseType = BlackListUseTypeEnum.getByNum((int)blackListStrategyEntity.getUseType());
        BlackListUseTypeEnum newUseType = param.getUseType();
        if (oldUseType == BlackListUseTypeEnum.ALL && newUseType == BlackListUseTypeEnum.ALL) {
            return this.allToAll(param);
        }
        if (oldUseType == BlackListUseTypeEnum.ALL && newUseType == BlackListUseTypeEnum.PART) {
            return this.allToPart(param);
        }
        if (oldUseType == BlackListUseTypeEnum.PART && newUseType == BlackListUseTypeEnum.PART) {
            return this.partToPart(param);
        }
        if (oldUseType == BlackListUseTypeEnum.PART && newUseType == BlackListUseTypeEnum.ALL) {
            return this.partToAll(param);
        }
        return ResultDto.failResult((String)"\u9002\u7528\u5546\u5bb6\u53c2\u6570\u9519\u8bef");
    }

    @Override
    public BlackListStrategyDto findById(Long id) {
        if (null == id || id <= 0L) {
            return null;
        }
        BaiqiBlackListStrategyEntity entity = this.baiqiBlackListStrategyMapper.findById(id);
        if (null == entity) {
            return null;
        }
        return this.convertStrategyToDto(Lists.newArrayList((Object[])new BaiqiBlackListStrategyEntity[]{entity})).get(0);
    }

    private ResultDto<Boolean> allToPart(BlackListStrategyDto blackListStrategyDto) {
        List merchantIdList = blackListStrategyDto.getMerchantIdList();
        if (CollectionUtils.isEmpty((Collection)merchantIdList)) {
            return ResultDto.failResult((String)"\u4f20\u5165\u7684\u5546\u5bb6id\u4e3a\u7a7a");
        }
        List bkStrategyMCEntities = this.baiqiBKStrategyMCMapper.listByMerchantIds(merchantIdList);
        if (CollectionUtils.isNotEmpty((Collection)bkStrategyMCEntities)) {
            List existIds = bkStrategyMCEntities.stream().map(BaiqiBKStrategyMCEntity::getMerchantId).collect(Collectors.toList());
            return ResultDto.failResult((String)("\u5546d\u4e3a\uff1a" + existIds.toString() + "\u5df2\u5b58\u5728\u9ed1\u540d\u5355\u7b56\u7565"));
        }
        BaiqiBlackListStrategyEntity entity = this.convertStrategyToEntity(blackListStrategyDto);
        this.baiqiBlackListStrategyMapper.update(entity);
        Long strategyId = blackListStrategyDto.getId();
        List bkStrategyMCEntityList = merchantIdList.stream().map(e -> {
            BaiqiBKStrategyMCEntity strategyMCEntity = new BaiqiBKStrategyMCEntity();
            strategyMCEntity.setMerchantId(e);
            strategyMCEntity.setStrategyId(strategyId);
            return strategyMCEntity;
        }).collect(Collectors.toList());
        this.baiqiBKStrategyMCMapper.insetBatch(bkStrategyMCEntityList);
        return ResultDto.successResult((Object)Boolean.TRUE);
    }

    private ResultDto<Boolean> allToAll(BlackListStrategyDto blackListStrategyDto) {
        BaiqiBlackListStrategyEntity entity = this.convertStrategyToEntity(blackListStrategyDto);
        this.baiqiBlackListStrategyMapper.update(entity);
        return ResultDto.successResult();
    }

    private ResultDto<Boolean> partToAll(BlackListStrategyDto blackListStrategyDto) {
        List commonStrategy = this.baiqiBlackListStrategyMapper.listCommonStrategy();
        if (CollectionUtils.isNotEmpty((Collection)commonStrategy)) {
            return ResultDto.failResult((String)"\u9002\u7528\u5168\u90e8\u5546\u5bb6\u7684\u7b56\u7565\u5df2\u5b58\u5728");
        }
        this.baiqiBlackListStrategyMapper.update(this.convertStrategyToEntity(blackListStrategyDto));
        this.baiqiBKStrategyMCMapper.deletedByStrategyId(blackListStrategyDto.getId());
        return ResultDto.successResult((Object)Boolean.TRUE);
    }

    private ResultDto<Boolean> partToPart(BlackListStrategyDto blackListStrategyDto) {
        List newMerchantIds = blackListStrategyDto.getMerchantIdList();
        if (CollectionUtils.isEmpty((Collection)newMerchantIds)) {
            return ResultDto.failResult((String)"\u4f20\u5165\u7684\u5546\u5bb6id\u5217\u8868\u4e3a\u7a7a");
        }
        List originMerchantIds = this.baiqiBKStrategyMCMapper.listByStrategyId(blackListStrategyDto.getId()).stream().map(BaiqiBKStrategyMCEntity::getMerchantId).collect(Collectors.toList());
        List copyOriginMerchantIds = originMerchantIds.stream().collect(Collectors.toList());
        copyOriginMerchantIds.retainAll(newMerchantIds);
        originMerchantIds.removeAll(copyOriginMerchantIds);
        newMerchantIds.removeAll(copyOriginMerchantIds);
        this.baiqiBlackListStrategyMapper.update(this.convertStrategyToEntity(blackListStrategyDto));
        if (CollectionUtils.isNotEmpty(originMerchantIds)) {
            this.baiqiBKStrategyMCMapper.deleteByMerchantIds(originMerchantIds);
        }
        if (CollectionUtils.isNotEmpty((Collection)newMerchantIds)) {
            List insertEntities = newMerchantIds.stream().map(e -> new BaiqiBKStrategyMCEntity(blackListStrategyDto.getId(), e)).collect(Collectors.toList());
            this.baiqiBKStrategyMCMapper.insetBatch(insertEntities);
        }
        return ResultDto.successResult((Object)Boolean.TRUE);
    }

    private ResultDto<Boolean> insertPartMerchatStrategy(BlackListStrategyDto param) {
        if (CollectionUtils.isEmpty((Collection)param.getMerchantIdList())) {
            return ResultDto.failResult((String)"\u4f20\u5165\u7684\u5546\u5bb6id\u4e3a\u7a7a");
        }
        List bkStrategyMCEntityList = this.baiqiBKStrategyMCMapper.listByMerchantIds(param.getMerchantIdList());
        if (CollectionUtils.isNotEmpty((Collection)bkStrategyMCEntityList)) {
            List existMerchantIds = bkStrategyMCEntityList.stream().map(BaiqiBKStrategyMCEntity::getMerchantId).collect(Collectors.toList());
            return ResultDto.failResult((String)("id\u4e3a\uff1a" + existMerchantIds.toString() + "\u7684\u5546\u5bb6\u5df2\u5b58\u5728\u9ed1\u540d\u5355\u7b56\u7565"));
        }
        BaiqiBlackListStrategyEntity entity = this.convertStrategyToEntity(param);
        this.baiqiBlackListStrategyMapper.insertStrategy(entity);
        Long strategyId = entity.getId();
        ArrayList bkStrategyMCEntities = Lists.newArrayList();
        param.getMerchantIdList().stream().forEach(e -> bkStrategyMCEntities.add(new BaiqiBKStrategyMCEntity(strategyId, e)));
        this.baiqiBKStrategyMCMapper.insetBatch((List)bkStrategyMCEntities);
        return ResultDto.successResult((Object)Boolean.TRUE);
    }

    private ResultDto<Boolean> insertCommonStrategy(BlackListStrategyDto param) {
        List blackListStrategyEntities = this.baiqiBlackListStrategyMapper.listCommonStrategy();
        if (CollectionUtils.isNotEmpty((Collection)blackListStrategyEntities)) {
            return ResultDto.failResult((String)"\u9002\u7528\u4e8e\u5168\u90e8\u5546\u5bb6\u7684\u9ed1\u540d\u5355\u7b56\u7565\u5df2\u5b58\u5728");
        }
        BaiqiBlackListStrategyEntity entity = this.convertStrategyToEntity(param);
        this.baiqiBlackListStrategyMapper.insertStrategy(entity);
        return ResultDto.successResult((Object)Boolean.TRUE);
    }

    private BaiqiBlackListStrategyEntity convertStrategyToEntity(BlackListStrategyDto dto) {
        if (null == dto) {
            return null;
        }
        BaiqiBlackListStrategyEntity entity = (BaiqiBlackListStrategyEntity)BeanUtils.copy((Object)dto, BaiqiBlackListStrategyEntity.class);
        entity.setBkType(Integer.valueOf(dto.getBkType().getNum()));
        entity.setDealType(Integer.valueOf(dto.getDealType().getNum()));
        entity.setStrategyValue(JSONObject.toJSONString((Object)dto.getStrategy()));
        entity.setUseType(Integer.valueOf(dto.getUseType().getNum()));
        entity.setOperator(dto.getOperator());
        return entity;
    }

    private List<BlackListStrategyDto> convertStrategyToDto(List<BaiqiBlackListStrategyEntity> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        ArrayList blackListStrategyDtoList = Lists.newArrayList();
        ArrayList needMerchantInfoIds = Lists.newArrayList();
        for (BaiqiBlackListStrategyEntity entity : list) {
            BlackListStrategyDto dto = new BlackListStrategyDto();
            dto.setId(entity.getId());
            dto.setBkType(BaiqiBlackListTypeEnum.getByNum((int)entity.getBkType()));
            dto.setDealType(DealTypeEnum.FORBID_SUBMIT);
            dto.setOperator(entity.getOperator());
            dto.setStrategy((StrategyDto)JSON.parseObject((String)entity.getStrategyValue(), StrategyDto.class));
            dto.setUseType(BlackListUseTypeEnum.getByNum((int)entity.getUseType()));
            if (entity.getUseType().intValue() == BlackListUseTypeEnum.PART.getNum()) {
                needMerchantInfoIds.add(entity.getId());
            }
            blackListStrategyDtoList.add(dto);
        }
        if (CollectionUtils.isNotEmpty((Collection)needMerchantInfoIds)) {
            List bkStrategyMCEntities = this.baiqiBKStrategyMCMapper.listByStrategyIds((List)needMerchantInfoIds);
            Map<Long, String> merchantMap = this.merchantService.fetchNamesWithCache();
            bkStrategyMCEntities.stream().forEach(e -> e.setMerchantName((String)merchantMap.get(e.getMerchantId())));
            for (BlackListStrategyDto dto : blackListStrategyDtoList) {
                for (BaiqiBKStrategyMCEntity strategyMCEntity : bkStrategyMCEntities) {
                    if (dto.getId().longValue() != strategyMCEntity.getStrategyId().longValue()) continue;
                    dto.setMerchant(strategyMCEntity.getMerchantId(), strategyMCEntity.getMerchantName());
                }
            }
        }
        return blackListStrategyDtoList;
    }
}

