/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.check.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.biz.service.impl.check.IPMobileCheckService;
import com.qiho.center.biz.util.AMapUtil;
import com.qiho.center.biz.util.MobileHomeLocationUtil;
import com.qiho.center.common.daoh.qiho.CheckAddressMapper;
import com.qiho.center.common.entityd.qiho.CheckAddressEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IPMobileCheckServiceImpl
implements IPMobileCheckService {
    @Autowired
    CheckAddressMapper checkAddressMapper;

    @Override
    public void checkToSave(OrderSnapshotDto orderSnapshotDto) {
        String mobileHomeLocation = MobileHomeLocationUtil.getHomeLocation(orderSnapshotDto.getMobile());
        String mobileProvince = "";
        String mobileCity = "";
        if (StringUtils.isNotBlank((CharSequence)mobileHomeLocation)) {
            JSONObject mobileJson = JSONObject.parseObject((String)mobileHomeLocation);
            mobileProvince = mobileJson.getString("province");
            JSONArray jsonArray = JSONArray.parseArray((String)mobileJson.getString("area"));
            mobileCity = jsonArray.getJSONObject(0).getString("city");
        }
        String ipHomeLocation = AMapUtil.getAMapAddress(orderSnapshotDto.getIp());
        JSONObject ipJson = JSONObject.parseObject((String)ipHomeLocation);
        String ipProvince = ipJson.getString("province");
        String ipCity = ipJson.getString("city");
        CheckAddressEntity entity = new CheckAddressEntity();
        entity.setOrderId(orderSnapshotDto.getOrderId());
        if ("[]".equals(ipCity)) {
            entity.setIpCity("");
        } else {
            entity.setIpCity(ipCity);
        }
        if ("[]".equals(ipProvince)) {
            entity.setIpProvince("");
        } else {
            entity.setIpProvince(ipProvince);
        }
        entity.setMobileCity(mobileCity);
        entity.setMobileProvince(mobileProvince);
        this.checkAddressMapper.insert(entity);
    }
}

