/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.coupon;

import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import com.google.common.collect.Lists;
import com.google.common.eventbus.Subscribe;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.coupon.CouponConsumerDto;
import com.qiho.center.api.enums.coupon.ActiveRuleEnum;
import com.qiho.center.api.enums.coupon.AstrictMark;
import com.qiho.center.api.enums.coupon.CouponAstrictEnum;
import com.qiho.center.api.enums.coupon.CouponStatusEnum;
import com.qiho.center.api.params.AstrictCouponParams;
import com.qiho.center.api.params.CouponConsumerQuery;
import com.qiho.center.api.params.CouponConsumerQueryParams;
import com.qiho.center.biz.bo.CouponBo;
import com.qiho.center.biz.engine.coupon.AstrictContextDecider;
import com.qiho.center.biz.engine.coupon.AstrictFactory;
import com.qiho.center.biz.engine.coupon.AstrictTemplate;
import com.qiho.center.biz.event.OrderClosedEvent;
import com.qiho.center.biz.service.coupon.CouponConsumerService;
import com.qiho.center.common.annotations.BizEventListener;
import com.qiho.center.common.dao.QihoOrderSnapshotDAO;
import com.qiho.center.common.dao.coupon.QihoActiveDAO;
import com.qiho.center.common.dao.coupon.QihoCouponActiveDAO;
import com.qiho.center.common.dao.coupon.QihoCouponAstrictDAO;
import com.qiho.center.common.dao.coupon.QihoCouponConsumerDAO;
import com.qiho.center.common.dao.coupon.QihoCouponDAO;
import com.qiho.center.common.dao.coupon.QihoCouponOrderDAO;
import com.qiho.center.common.entity.BaseEntity;
import com.qiho.center.common.entity.coupon.QihoActiveEntity;
import com.qiho.center.common.entity.coupon.QihoCouponActiveEntity;
import com.qiho.center.common.entity.coupon.QihoCouponAstrictEntity;
import com.qiho.center.common.entity.coupon.QihoCouponConsumerEntity;
import com.qiho.center.common.entity.coupon.QihoCouponEntity;
import com.qiho.center.common.entity.coupon.QihoCouponOrderEntity;
import com.qiho.center.common.entity.order.QihoOrderSnapshotEntity;
import com.qiho.center.common.util.AppLogUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@BizEventListener
public class CouponConsumerServiceImpl
implements CouponConsumerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CouponConsumerServiceImpl.class);
    @Resource
    private QihoCouponConsumerDAO qihoCouponConsumerDAO;
    @Resource
    private QihoActiveDAO qihoActiveDAO;
    @Resource
    private QihoCouponActiveDAO qihoCouponActiveDAO;
    @Resource
    private QihoCouponDAO qihoCouponDAO;
    @Resource
    private QihoCouponAstrictDAO qihoCouponAstrictDAO;
    @Resource
    private AstrictContextDecider astrictContextDecider;
    @Resource
    private CouponBo couponBo;
    @Resource
    private QihoOrderSnapshotDAO qihoOrderSnapshotDAO;
    @Resource
    private QihoCouponOrderDAO qihoCouponOrderDAO;

    @Override
    @Transactional(value="QIHO")
    public Integer insert(CouponConsumerDto entity) {
        return this.qihoCouponConsumerDAO.insert((QihoCouponConsumerEntity)BeanUtils.copy((Object)entity, QihoCouponConsumerEntity.class));
    }

    @Override
    public List<CouponConsumerDto> findAllCouponByMobile(String mobile) {
        CouponConsumerQuery query = new CouponConsumerQuery();
        query.setMobile(mobile);
        List allCoupon = this.qihoCouponConsumerDAO.findByQuery(query);
        return BeanUtils.copyList((List)allCoupon, CouponConsumerDto.class);
    }

    @Override
    public PagenationDto<CouponConsumerDto> findCouponConsumerByQuery(CouponConsumerQueryParams params) {
        PagenationDto page = new PagenationDto();
        Integer count = this.qihoCouponConsumerDAO.countCouponConsumerByQuery(params);
        page.setTotal(count);
        if (count == 0) {
            return page;
        }
        List couponConsumerEntityList = this.qihoCouponConsumerDAO.findCouponConsumerByQuery(params);
        List couponConsumerList = BeanUtils.copyList((List)couponConsumerEntityList, CouponConsumerDto.class);
        page.setList(couponConsumerList);
        return page;
    }

    @Override
    @Transactional(value="QIHO")
    public List<CouponConsumerDto> consumerGetCoupon(AstrictCouponParams params) {
        List<QihoCouponConsumerEntity> qihoCouponConsumerEntities = this.sentDownCoupon(params);
        return BeanUtils.copyList(qihoCouponConsumerEntities, CouponConsumerDto.class);
    }

    @Override
    public Boolean verfiyConsumer(AstrictCouponParams params) {
        Long activeId = params.getActiveId();
        QihoActiveEntity activeEntity = this.qihoActiveDAO.findByActiveId(activeId);
        String activeRule = activeEntity.getActiveRule();
        if (StringUtils.isBlank((CharSequence)activeRule)) {
            return Boolean.TRUE;
        }
        ActiveRuleEnum astrictEnum = ActiveRuleEnum.getByCode((String)activeRule);
        AstrictTemplate astrictTemplate = this.astrictContextDecider.decidePayChannel((AstrictMark)astrictEnum);
        if (null == astrictTemplate) {
            AppLogUtil.error((Logger)LOGGER, (String)"\u6d3b\u52a8\u89c4\u5219\u914d\u7f6e\u51fa\u73b0\u810f\u6570\u636e activeId={} activeRule={}", (Object[])new Object[]{activeId, activeRule});
            return Boolean.FALSE;
        }
        return astrictTemplate.astrictProcess(AstrictFactory.createContextAsNotVerfiy(params));
    }

    @Override
    public List<CouponConsumerDto> findCouponUseAble(AstrictCouponParams params) {
        List couponAstricts;
        String mobile = params.getMobile();
        CouponConsumerQuery query = new CouponConsumerQuery();
        query.setMobile(mobile);
        query.setCouponStatus(CouponStatusEnum.UN_USE.getVal());
        query.setNowTime(new Date());
        List ableCoupon = this.qihoCouponConsumerDAO.findByQuery(query);
        ArrayList filterCouponIds = new ArrayList();
        List sentCoupon = ableCoupon.stream().filter(e -> {
            String employConditType = e.getEmployConditType();
            CouponAstrictEnum astrictMark = CouponAstrictEnum.getByCode((String)employConditType);
            AstrictTemplate astrictTemplate = this.astrictContextDecider.decidePayChannel((AstrictMark)astrictMark);
            return astrictTemplate.astrictProcess(AstrictFactory.createAstrictContext(params, e));
        }).peek(e -> filterCouponIds.add(e.getCouponId())).collect(Collectors.toList());
        if (!params.getInWechat().booleanValue() && CollectionUtils.isNotEmpty(sentCoupon) && CollectionUtils.isNotEmpty((Collection)(couponAstricts = this.qihoCouponAstrictDAO.batchFindByCouponIds(filterCouponIds)))) {
            for (QihoCouponAstrictEntity couponAstrict : couponAstricts) {
                Long couponAstrictId = couponAstrict.getCouponId();
                int index = filterCouponIds.indexOf(couponAstrictId);
                sentCoupon.remove(index);
                filterCouponIds.remove(index);
            }
        }
        return BeanUtils.copyList(sentCoupon, CouponConsumerDto.class);
    }

    @Override
    public List<CouponConsumerDto> findByOrderId(String orderId) {
        List entityList = this.qihoCouponConsumerDAO.listByOrderId(orderId);
        return BeanUtils.copyList((List)entityList, CouponConsumerDto.class);
    }

    @Subscribe
    public void closedOrderEventLister(OrderClosedEvent orderClosedEvent) {
        DBTimeProfile.enter((String)"closedOrderEventLister");
        if (orderClosedEvent == null) {
            DBTimeProfile.release();
            return;
        }
        String orderId = orderClosedEvent.getOrderId();
        QihoOrderSnapshotEntity orderSnapshot = this.qihoOrderSnapshotDAO.findByOrderId(orderId);
        String mobile = orderSnapshot.getMobile();
        List couponOrders = this.qihoCouponOrderDAO.listByOrderId(orderId);
        if (CollectionUtils.isEmpty((Collection)couponOrders)) {
            DBTimeProfile.release();
            return;
        }
        QihoCouponOrderEntity couponOrder = (QihoCouponOrderEntity)couponOrders.get(0);
        Long couponId = couponOrder.getCouponId();
        QihoCouponEntity qihoCouponEntity = this.qihoCouponDAO.findByCouponId(couponId);
        QihoCouponConsumerEntity qihoCouponConsumer = (QihoCouponConsumerEntity)BeanUtils.copy((Object)qihoCouponEntity, QihoCouponConsumerEntity.class);
        qihoCouponConsumer.setActiveId(Long.valueOf(0L));
        qihoCouponConsumer.setCouponId(qihoCouponEntity.getId());
        qihoCouponConsumer.setCouponStatus(CouponStatusEnum.UN_USE.getVal());
        qihoCouponConsumer.setMobile(mobile);
        CouponConsumerQuery couponConsumerQuery = new CouponConsumerQuery();
        couponConsumerQuery.setCouponId(couponId);
        couponConsumerQuery.setMobile(mobile);
        List couponConsumers = this.qihoCouponConsumerDAO.findByQuery(couponConsumerQuery);
        Date couponBeUsedTime = ((QihoCouponConsumerEntity)couponConsumers.get(0)).getEmployTime();
        Date couponExpireTime = ((QihoCouponConsumerEntity)couponConsumers.get(0)).getExpireTime();
        int subDays = DateUtils.daysBetween((Date)couponBeUsedTime, (Date)couponExpireTime);
        qihoCouponConsumer.setStartTime(new Date());
        qihoCouponConsumer.setExpireTime(this.getExpireTime(subDays + 1));
        QihoCouponAstrictEntity couponAstrict = this.qihoCouponAstrictDAO.findByCouponId(couponId);
        qihoCouponConsumer.setAstrictRule(couponAstrict.getAstrictRule());
        this.qihoCouponConsumerDAO.insert(qihoCouponConsumer);
        DBTimeProfile.release();
    }

    private List<QihoCouponConsumerEntity> sentDownCoupon(AstrictCouponParams params) {
        List couponActiveEntities = this.qihoCouponActiveDAO.findByActiveId(params.getActiveId());
        if (CollectionUtils.isEmpty((Collection)couponActiveEntities)) {
            AppLogUtil.error((Logger)LOGGER, (String)"\u8be5\u6d3b\u52a8\u4e0b\u65e0\u53ef\u4ee5\u9886\u53d6\u7684\u4f18\u60e0\u5238 activeId={}", (Object[])new Object[]{params.getActiveId()});
            return Lists.newArrayList();
        }
        List couponIds = couponActiveEntities.stream().map(QihoCouponActiveEntity::getCouponId).collect(Collectors.toList());
        List couponEntities = this.qihoCouponDAO.batchFindCouponByIds(couponIds);
        return this.insertCouponConsumerEntity(couponEntities, params);
    }

    private List<QihoCouponConsumerEntity> insertCouponConsumerEntity(List<QihoCouponEntity> couponEntities, AstrictCouponParams verfiyParam) {
        ArrayList<QihoCouponConsumerEntity> couponConsumers = new ArrayList<QihoCouponConsumerEntity>();
        if (CollectionUtils.isEmpty(couponEntities)) {
            return couponConsumers;
        }
        String mobile = verfiyParam.getMobile();
        Long activeId = verfiyParam.getActiveId();
        Date nowTime = new Date();
        List couponIds = couponEntities.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List couponAstricts = this.qihoCouponAstrictDAO.batchFindByCouponIds(couponIds);
        for (QihoCouponEntity couponEntity : couponEntities) {
            QihoCouponConsumerEntity qihoCouponConsumer = (QihoCouponConsumerEntity)BeanUtils.copy((Object)couponEntity, QihoCouponConsumerEntity.class);
            qihoCouponConsumer.setActiveId(activeId);
            qihoCouponConsumer.setCouponId(couponEntity.getId());
            qihoCouponConsumer.setCouponStatus(CouponStatusEnum.UN_USE.getVal());
            qihoCouponConsumer.setMobile(mobile);
            qihoCouponConsumer.setStartTime(nowTime);
            qihoCouponConsumer.setExpireTime(this.getExpireTime(couponEntity.getAbsoluteEmployTime()));
            for (QihoCouponAstrictEntity couponAstrict : couponAstricts) {
                if (!couponAstrict.getCouponId().toString().equals(couponEntity.getId().toString())) continue;
                qihoCouponConsumer.setAstrictRule(couponAstrict.getAstrictRule());
            }
            couponConsumers.add(qihoCouponConsumer);
        }
        this.couponBo.batchInsertCoupon(couponConsumers);
        return couponConsumers;
    }

    private Date getExpireTime(int absoluteEmployTime) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.add(5, absoluteEmployTime);
        return calendar.getTime();
    }
}

