/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.coupon;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.coupon.CouponAstrictDto;
import com.qiho.center.api.dto.coupon.CouponDto;
import com.qiho.center.api.dto.coupon.CouponOrderDto;
import com.qiho.center.api.params.CouponQueryParams;
import com.qiho.center.biz.service.coupon.CouponSerivce;
import com.qiho.center.common.dao.coupon.QihoCouponActiveDAO;
import com.qiho.center.common.dao.coupon.QihoCouponAstrictDAO;
import com.qiho.center.common.dao.coupon.QihoCouponDAO;
import com.qiho.center.common.entity.coupon.QihoCouponAstrictEntity;
import com.qiho.center.common.entity.coupon.QihoCouponEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CouponServiceImpl
implements CouponSerivce {
    @Resource
    private QihoCouponDAO qihoCouponDAO;
    @Resource
    private QihoCouponAstrictDAO qihoCouponAstrictDAO;
    @Resource
    private QihoCouponActiveDAO qihoCouponActiveDAO;

    @Override
    @Transactional(value="QIHO")
    public Boolean insert(CouponDto dto) {
        QihoCouponEntity entity = (QihoCouponEntity)BeanUtils.copy((Object)dto, QihoCouponEntity.class);
        this.qihoCouponDAO.insert(entity);
        List couponAstrictList = dto.getCouponAstrictList();
        if (CollectionUtils.isNotEmpty((Collection)couponAstrictList)) {
            for (CouponAstrictDto couponAstrictDto : couponAstrictList) {
                QihoCouponAstrictEntity couponAstrictEntity = (QihoCouponAstrictEntity)BeanUtils.copy((Object)couponAstrictDto, QihoCouponAstrictEntity.class);
                couponAstrictEntity.setCouponId(entity.getId());
                this.qihoCouponAstrictDAO.insert(couponAstrictEntity);
            }
        }
        return Boolean.TRUE;
    }

    @Override
    public Integer update(CouponOrderDto dto) {
        return this.qihoCouponDAO.update((QihoCouponEntity)BeanUtils.copy((Object)dto, QihoCouponEntity.class));
    }

    @Override
    @Transactional(value="QIHO")
    public Integer delete(Long couponId) {
        this.qihoCouponAstrictDAO.deleteByCouponId(couponId);
        this.qihoCouponActiveDAO.deleteByCouponId(couponId);
        return this.qihoCouponDAO.delete(couponId);
    }

    @Override
    public CouponOrderDto findByCouponId(Long couponId) {
        return null;
    }

    @Override
    public PagenationDto<CouponDto> findCouponByQuery(CouponQueryParams params) {
        PagenationDto pagenation = new PagenationDto();
        Integer total = this.qihoCouponDAO.countCouponByQuery(params);
        pagenation.setTotal(total);
        if (total == 0) {
            return pagenation;
        }
        List entities = this.qihoCouponDAO.findCouponByQuery(params);
        List couponList = BeanUtils.copyList((List)entities, CouponDto.class);
        ArrayList couponIds = Lists.newArrayList();
        entities.stream().forEach(e -> couponIds.add(e.getId()));
        List couponAstrictEntityList = this.qihoCouponAstrictDAO.batchFindByCouponIds((List)couponIds);
        List couponAstrictList = BeanUtils.copyList((List)couponAstrictEntityList, CouponAstrictDto.class);
        for (CouponDto coupon : couponList) {
            ArrayList<CouponAstrictDto> couponAstrictDtos = new ArrayList<CouponAstrictDto>();
            for (CouponAstrictDto couponAstrictDto : couponAstrictList) {
                if (!String.valueOf(coupon.getId()).equals(String.valueOf(couponAstrictDto.getCouponId()))) continue;
                couponAstrictDtos.add(couponAstrictDto);
            }
            coupon.setCouponAstrictList(couponAstrictDtos);
        }
        pagenation.setList(couponList);
        return pagenation;
    }

    @Override
    public List<CouponDto> batchFindCouponByIds(List<Long> couponIds) {
        List couponEntities = this.qihoCouponDAO.batchFindCouponByIds(couponIds);
        return BeanUtils.copyList((List)couponEntities, CouponDto.class);
    }
}

