/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.data;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.dto.GoodsDataDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.advert.ItemCostDto;
import com.qiho.center.api.params.data.GoodsQueryParam;
import com.qiho.center.api.params.data.ItemDataQueryParam;
import com.qiho.center.api.params.item.QihoItemParam;
import com.qiho.center.biz.service.ItemService;
import com.qiho.center.biz.service.data.GoodsDataService;
import com.qiho.center.common.dao.QihoItemDAO;
import com.qiho.center.common.daoh.qihostatistics.data.QihoItemDailyConsumeMapper;
import com.qiho.center.common.entity.item.QihoItemEntity;
import com.qiho.center.common.entity.item.QihoItemSimpleEntity;
import com.qiho.center.common.entityd.qiho.data.QihoItemDailyConsumeEntity;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GoodsDataServiceImpl
implements GoodsDataService {
    @Autowired
    private QihoItemDailyConsumeMapper qihoItemDailyConsumeMapper;
    @Autowired
    private QihoItemDAO qihoItemDAO;
    @Autowired
    private ItemService itemService;

    @Override
    public PagenationDto<GoodsDataDto> getGoodsData(GoodsQueryParam param) {
        PagenationDto pagenationDto = new PagenationDto();
        String name = param.getName();
        if (param.getItemId() != null) {
            param.setItemIds((List)Lists.newArrayList((Object[])new Long[]{param.getItemId()}));
        }
        if (StringUtils.isNotBlank((String)name)) {
            QihoItemParam qihoItemParam = new QihoItemParam();
            qihoItemParam.setItemName(name);
            Long merchantId = param.getMerchantId();
            qihoItemParam.setMerchantId(merchantId);
            List itemSimpleEntities = this.qihoItemDAO.selectByParam(qihoItemParam);
            if (CollectionUtils.isEmpty((Collection)itemSimpleEntities)) {
                pagenationDto.setList(Collections.emptyList());
                pagenationDto.setTotal(Integer.valueOf(0));
                return pagenationDto;
            }
            List itemIds = itemSimpleEntities.stream().filter(e -> e.getMerchantId().equals(merchantId)).map(QihoItemSimpleEntity::getItemId).collect(Collectors.toList());
            param.setItemIds(itemIds);
        }
        Integer count = this.qihoItemDailyConsumeMapper.countItemData(param);
        List list = this.qihoItemDailyConsumeMapper.getItemDataByParam(param);
        if (CollectionUtils.isEmpty((Collection)list)) {
            pagenationDto.setTotal(Integer.valueOf(0));
            pagenationDto.setList(Collections.emptyList());
            return pagenationDto;
        }
        List<Long> getItemIds = list.stream().map(QihoItemDailyConsumeEntity::getItemId).collect(Collectors.toList());
        Map<Long, QihoItemEntity> map = this.itemService.selectByIdList(getItemIds);
        List goodsDataDtoList = list.stream().map(e -> this.entityToDto((QihoItemDailyConsumeEntity)e, map)).collect(Collectors.toList());
        pagenationDto.setList(goodsDataDtoList);
        pagenationDto.setTotal(count);
        return pagenationDto;
    }

    private GoodsDataDto entityToDto(QihoItemDailyConsumeEntity entity, Map<Long, QihoItemEntity> map) {
        GoodsDataDto goodsDataDto = (GoodsDataDto)BeanUtils.copy((Object)entity, GoodsDataDto.class);
        if (map.containsKey(entity.getItemId())) {
            goodsDataDto.setItemName(map.get(entity.getItemId()).getItemName());
        }
        DecimalFormat twoDecimalPlaces = new DecimalFormat("0.00");
        goodsDataDto.setConsumeTotal(twoDecimalPlaces.format((double)entity.getConsumeTotal().longValue() * 1.0 / 100.0));
        if (entity.getClickCount() != 0L) {
            Double clickFlod = (double)entity.getConsumeTotal().longValue() * 1.0 / (double)entity.getClickCount().longValue() / 100.0;
            goodsDataDto.setClickFlod(twoDecimalPlaces.format(clickFlod));
            Double placeAnOrderRate = (double)entity.getSalesVolume().longValue() * 1.0 / (double)entity.getClickCount().longValue() * 100.0;
            goodsDataDto.setPlaceAnOrderRate(twoDecimalPlaces.format(placeAnOrderRate) + "%");
        }
        if (entity.getSalesVolume() != 0L) {
            Double placeAnOrderCost = (double)entity.getConsumeTotal().longValue() * 1.0 / (double)entity.getSalesVolume().longValue() / 100.0;
            goodsDataDto.setPlaceAnOrderCost(twoDecimalPlaces.format(placeAnOrderCost));
        }
        if (entity.getExposureCount() != 0L) {
            Double clickRate = (double)entity.getClickCount().longValue() * 1.0 / (double)entity.getExposureCount().longValue() * 100.0;
            goodsDataDto.setClickRate(twoDecimalPlaces.format(clickRate) + "%");
        }
        return goodsDataDto;
    }

    @Override
    public PagenationDto<ItemCostDto> queryPage(ItemDataQueryParam param) {
        PagenationDto page = new PagenationDto();
        HashMap itemNameMap = Maps.newHashMap();
        List<Object> itemIds = Lists.newArrayList();
        if (StringUtils.isNotBlank((String)param.getItemName()) || param.getItemId() != null) {
            QihoItemEntity itemEntity = new QihoItemEntity();
            itemEntity.setId(param.getItemId());
            itemEntity.setItemName(param.getItemName());
            List itemList = this.qihoItemDAO.queryItemByParam(itemEntity);
            if (CollectionUtils.isEmpty((Collection)itemList)) {
                page.setTotal(Integer.valueOf(0));
                page.setList((List)Lists.newArrayList());
                return page;
            }
            itemIds = itemList.stream().map(e -> {
                itemNameMap.put(e.getId(), e.getItemName());
                return e.getId();
            }).collect(Collectors.toList());
        }
        GoodsQueryParam queryParam = new GoodsQueryParam();
        queryParam.setStartTime(param.getStartTime());
        queryParam.setEndTime(param.getEndTime());
        queryParam.setOffset(param.getOffset());
        queryParam.setMax(param.getMax());
        if (CollectionUtils.isNotEmpty((Collection)itemIds)) {
            queryParam.setItemIds((List)itemIds);
        }
        Integer total = this.qihoItemDailyConsumeMapper.countItemData(queryParam);
        List consumeList = this.qihoItemDailyConsumeMapper.getItemDataByParam(queryParam);
        page.setTotal(total);
        if (total == 0) {
            page.setList((List)Lists.newArrayList());
            return page;
        }
        if (itemNameMap.size() == 0) {
            List ids = consumeList.stream().map(QihoItemDailyConsumeEntity::getItemId).collect(Collectors.toList());
            this.qihoItemDAO.queryItemByIds(ids).stream().forEach(e -> itemNameMap.put(e.getId(), e.getItemName()));
        }
        List list = Lists.transform((List)consumeList, consume -> {
            ItemCostDto itemCost = new ItemCostDto();
            itemCost.setItemId(consume.getItemId());
            itemCost.setItemName((String)itemNameMap.get(consume.getItemId()));
            itemCost.setClick(consume.getClickCount());
            itemCost.setExpose(consume.getExposureCount());
            itemCost.setCost(consume.getConsumeTotal());
            return itemCost;
        });
        page.setList(list);
        return page;
    }
}

