/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.edb;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.logistics.ErpLogisticsSyncDto;
import com.qiho.center.api.enums.LogisticsNameEnum;
import com.qiho.center.biz.service.EdbApiService;
import com.qiho.center.common.util.AppLogUtil;
import com.qiho.center.common.util.EdbLib;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EdbApiServiceImpl
implements EdbApiService {
    @Resource
    private EdbLib edbLib;
    private static final Logger LOG = LoggerFactory.getLogger(EdbApiServiceImpl.class);

    @Override
    public List<ErpLogisticsSyncDto> edbTradeGet(int pageNo, String pageSize, String beginTime, String endTime) {
        Map params = this.edbLib.edbGetCommonParams("edbTradeGet");
        params.put("page_no", String.valueOf(pageNo));
        params.put("page_size", pageSize);
        params.put("begin_time", beginTime);
        params.put("end_time", endTime);
        params.put("date_type", "\u53d1\u8d27\u65e5\u671f");
        String res = this.edbLib.edbRequstPost(params);
        if (StringUtils.isBlank((String)res)) {
            return Collections.emptyList();
        }
        JSONObject json = JSONObject.parseObject((String)res);
        JSONObject successList = json.getJSONObject("Success");
        if (successList == null) {
            return Collections.emptyList();
        }
        Integer totalResults = successList.getInteger("total_results");
        if (totalResults == 0) {
            return Collections.emptyList();
        }
        String items = successList.getJSONObject("items").getString("item");
        return this.getLogisticsOrderDtoList(items);
    }

    private List<ErpLogisticsSyncDto> getLogisticsOrderDtoList(String items) {
        ArrayList list = Lists.newArrayList();
        try {
            if (StringUtils.isBlank((String)items)) {
                return Collections.emptyList();
            }
            JSONArray temp = JSON.parseArray((String)items);
            if (CollectionUtils.isEmpty((Collection)temp)) {
                return Collections.emptyList();
            }
            for (int j = 0; j < temp.size(); ++j) {
                JSONObject t = temp.getJSONObject(j);
                ErpLogisticsSyncDto queryLogisticsReturnDto = new ErpLogisticsSyncDto();
                queryLogisticsReturnDto.setTid(String.valueOf(t.get((Object)"out_tid")));
                queryLogisticsReturnDto.setLogisticsNo(String.valueOf(t.get((Object)"express_no")));
                queryLogisticsReturnDto.setLogisticsCode(String.valueOf(t.get((Object)"express_coding")));
                queryLogisticsReturnDto.setLogisticsName(String.valueOf(t.get((Object)"express")));
                queryLogisticsReturnDto.setLogisticsNameErp(String.valueOf(t.get((Object)"express")));
                LogisticsNameEnum logisticsName = LogisticsNameEnum.getByName((String)queryLogisticsReturnDto.getLogisticsName());
                if (logisticsName != null) {
                    queryLogisticsReturnDto.setLogisticsCode(logisticsName.getCode());
                }
                list.add(queryLogisticsReturnDto);
            }
        }
        catch (Exception e) {
            AppLogUtil.warn((Logger)LOG, (String)"\u540c\u6b65\u7269\u6d41\u8ba2\u5355\u5931\u8d25", (Object[])new Object[]{e});
            return Collections.emptyList();
        }
        return list;
    }
}

