/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.finance;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.tuia.core.api.remoteservice.baiqi.RemoteBaiQiService;
import cn.com.duiba.wolf.utils.UUIDUtils;
import com.qiho.center.api.dto.finance.AllocateAmountDto;
import com.qiho.center.api.enums.finance.BaiqiFinanceRechargeStateEnum;
import com.qiho.center.api.enums.finance.CashRebateAmountEnum;
import com.qiho.center.api.enums.finance.FinanceDetailStatusEnum;
import com.qiho.center.api.enums.finance.FinanceOptTypeEnum;
import com.qiho.center.api.enums.finance.FinanceTypeEnum;
import com.qiho.center.api.enums.finance.ParterTypeEnum;
import com.qiho.center.api.enums.finance.PartnerResultStateEnum;
import com.qiho.center.api.enums.finance.TuiaTradeTypeEnum;
import com.qiho.center.biz.service.finance.AllocateAmountService;
import com.qiho.center.biz.service.finance.FinanceDetailService;
import com.qiho.center.biz.service.finance.FinanceService;
import com.qiho.center.biz.service.impl.finance.bean.CashRebateAmountBean;
import com.qiho.center.biz.service.impl.finance.bean.PartnerAllocateAmountBean;
import com.qiho.center.common.daoh.qiho.finance.BaiqiFinanceDetailMapper;
import com.qiho.center.common.daoh.qiho.finance.BaiqiFinanceMapper;
import com.qiho.center.common.daoh.qiho.finance.BaiqiFinanceRechargeMapper;
import com.qiho.center.common.entityd.qiho.finance.BaiqiFinanceDetailEntity;
import com.qiho.center.common.entityd.qiho.finance.BaiqiFinanceEntity;
import com.qiho.center.common.util.BaiqiSerialUtil;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class AllocateAmountImpl
implements AllocateAmountService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AllocateAmountImpl.class);
    @Resource
    private BaiqiFinanceDetailMapper baiqiFinanceDetailMapper;
    @Resource
    private FinanceService financeService;
    @Resource
    private RemoteBaiQiService remoteBaiQiService;
    @Resource
    private BaiqiFinanceMapper baiqiFinanceMapper;
    @Resource
    private BaiqiFinanceRechargeMapper baiqiFinanceRechargeMapper;
    @Resource
    private FinanceDetailService financeDetailService;

    @Override
    public PartnerResultStateEnum callPartnerAllocateAmount(PartnerAllocateAmountBean bean) {
        try {
            if (this.remoteBaiQiService.allocateAmount(bean.getBaiqiTradeNo(), bean.getTradeType().getCode(), bean.getAccountId(), bean.getAmount()).booleanValue()) {
                return PartnerResultStateEnum.SUCCEED;
            }
            return PartnerResultStateEnum.FAILED;
        }
        catch (Exception e) {
            LOGGER.error("[\u91d1\u989d\u5206\u914d]\u9519\u8bef. BaiqiTradeNo:{}, {}", new Object[]{bean.getBaiqiTradeNo(), bean, e});
            return PartnerResultStateEnum.EXCEPTION;
        }
    }

    @Override
    public PartnerResultStateEnum checkPartnerAllocateAmount(String baiqiTradeNo) {
        try {
            if (this.remoteBaiQiService.checkTrade(baiqiTradeNo).booleanValue()) {
                return PartnerResultStateEnum.SUCCEED;
            }
            return PartnerResultStateEnum.FAILED;
        }
        catch (Exception e) {
            LOGGER.error("[\u68c0\u67e5\u91d1\u989d\u5206\u914d]\u9519\u8bef, baiqiTradeNo:{}", (Object)baiqiTradeNo);
            return PartnerResultStateEnum.EXCEPTION;
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public PartnerResultStateEnum allocateAmountRecharge(AllocateAmountDto param) throws BizException {
        Assert.notNull((Object)param, (String)"\u53c2\u6570\u4e3a\u7a7a");
        Assert.notNull((Object)param.getAgentId(), (String)"\u4ee3\u7406\u5546\u8d26\u53f7ID\u4e3a\u7a7a");
        Assert.notNull((Object)param.getAgentFinanceId(), (String)"\u4ee3\u7406\u5546\u8d26\u6237ID\u4e3a\u7a7a");
        Assert.notNull((Object)param.getMerchantId(), (String)"\u5546\u5bb6\u8d26\u53f7ID\u4e3a\u7a7a");
        Assert.notNull((Object)param.getMerchantFinanceId(), (String)"\u5546\u5bb6\u8d26\u6237ID\u4e3a\u7a7a");
        Assert.notNull((Object)param.getAdvertId(), (String)"\u5e7f\u544a\u4e3bID\u4e3a\u7a7a");
        Assert.notNull((Object)param.getAmount(), (String)"\u5145\u503c\u91d1\u989d\u4e3a\u7a7a");
        Assert.notNull((Object)param.getOperator(), (String)"\u64cd\u4f5c\u4eba\u4e3a\u7a7a");
        LOGGER.info("[\u91d1\u989d\u5212\u62e8\u53c2\u6570] {}", (Object)param);
        CashRebateAmountBean amountBean = this.financeService.calcCashAndRebateAmount(param.getAgentFinanceId(), param.getAmount(), CashRebateAmountEnum.EXPENDITURE);
        if (null == amountBean) {
            LOGGER.error("\u8ba1\u7b97\u4ee3\u7406\u5546\u7684\u73b0\u91d1\u548c\u8fd4\u70b9\u6263\u6bd4\u4e3a\u7a7a");
            return PartnerResultStateEnum.FAILED;
        }
        LOGGER.info("[\u91d1\u989d\u5212\u62e8\u5206\u914d\u6bd4\u4f8b] {}", (Object)amountBean);
        String tradeNo = UUIDUtils.createUUID();
        BaiqiFinanceDetailEntity agentDetail = this.insertAgentDetailRecharge(param.getAgentFinanceId(), param.getAgentId(), param.getOperator(), tradeNo, amountBean);
        LOGGER.info("[\u4ee3\u7406\u5546\u652f\u51fa\u6d41\u6c34] {}", (Object)agentDetail);
        BaiqiFinanceDetailEntity merchantDetail = this.insertMerchantDetailRecharge(param.getMerchantFinanceId(), param.getMerchantId(), param.getOperator(), tradeNo, amountBean);
        LOGGER.info("[\u5546\u5bb6\u6536\u5165\u6d41\u6c34] {}", (Object)merchantDetail);
        amountBean.setOpType(CashRebateAmountEnum.EXPENDITURE);
        boolean isFinanceAmount = this.financeService.updateFinanceAmountById(agentDetail.getFinanceId(), amountBean);
        LOGGER.info("[\u4ee3\u7406\u5546\u8d26\u6237\u603b\u91d1\u989d\u51cf\u5c11] {}", (Object)isFinanceAmount);
        PartnerAllocateAmountBean partnerAllocateAmountBean = new PartnerAllocateAmountBean();
        partnerAllocateAmountBean.setBaiqiTradeNo(agentDetail.getFinanceTradeNo());
        partnerAllocateAmountBean.setTradeType(TuiaTradeTypeEnum.RECHARGE);
        partnerAllocateAmountBean.setAccountId(param.getAdvertId());
        partnerAllocateAmountBean.setAmount(param.getAmount());
        PartnerResultStateEnum resultStateEnum = this.callPartnerAllocateAmount(partnerAllocateAmountBean);
        LOGGER.info("[\u8c03\u7528\u91d1\u989d\u5212\u62e8] {}", (Object)resultStateEnum);
        if (PartnerResultStateEnum.SUCCEED == resultStateEnum) {
            LOGGER.info("[\u91d1\u989d\u5212\u62e8]\u6210\u529f, baiqiTradeNo:{}, {}", (Object)agentDetail.getFinanceTradeNo(), (Object)agentDetail);
            this.callPartnerRechargeAsSucceed(agentDetail, merchantDetail);
            return resultStateEnum;
        }
        if (PartnerResultStateEnum.FAILED == resultStateEnum) {
            LOGGER.warn("[\u91d1\u989d\u5212\u62e8]\u5931\u8d25 BaiqiTradeNo:{}, {}", (Object)agentDetail.getFinanceTradeNo(), (Object)agentDetail);
            this.callPartnerRechargeAsFailed(agentDetail, merchantDetail);
            return resultStateEnum;
        }
        LOGGER.error("[\u91d1\u989d\u5212\u62e8]\u9519\u8bef, baiqiTradeNo:{}, {}", (Object)agentDetail.getFinanceTradeNo(), (Object)agentDetail);
        this.callPartnerRechargeAsException(agentDetail, merchantDetail);
        return resultStateEnum;
    }

    private Boolean callPartnerRechargeAsSucceed(BaiqiFinanceDetailEntity agent, BaiqiFinanceDetailEntity merchant) throws BizException {
        this.checkCallPartnerRecharge(agent);
        Assert.notNull((Object)agent.getFinanceId(), (String)"\u8d26\u6237ID\u4e3a\u7a7a");
        Assert.notNull((Object)agent.getRelationId(), (String)"\u6d41\u6c34\u5173\u8054ID\u4e3a\u7a7a");
        Assert.notNull((Object)agent.getExpenditureTotal(), (String)"\u6d41\u6c34\u652f\u51fa\u603b\u91d1\u989d\u4e3a\u7a7a");
        Assert.notNull((Object)agent.getExpenditureCash(), (String)"\u6d41\u6c34\u652f\u51fa\u73b0\u91d1\u4e3a\u7a7a");
        Assert.notNull((Object)agent.getExpenditureRebate(), (String)"\u6d41\u6c34\u652f\u51fa\u8fd4\u70b9\u4e3a\u7a7a");
        Assert.notNull((Object)agent.getOperator(), (String)"\u6d41\u6c34\u64cd\u4f5c\u4eba\u4e3a\u7a7a");
        Assert.notNull((Object)agent.getFinanceTradeNo(), (String)"\u6d41\u6c34\u4ea4\u6613\u53f7\u4e3a\u7a7a");
        CashRebateAmountBean amountBean = new CashRebateAmountBean();
        amountBean.setTotalAmount(agent.getExpenditureTotal());
        amountBean.setCashAmount(agent.getExpenditureCash());
        amountBean.setRebateAmount(agent.getExpenditureRebate());
        Long merchantId = merchant.getRelationId();
        Long merchantFinanceId = merchant.getFinanceId();
        amountBean.setOpType(CashRebateAmountEnum.INCOME);
        boolean isFinanceAmount = this.financeService.updateFinanceAmountById(merchantFinanceId, amountBean);
        LOGGER.info("[\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u8fd4\u56de\u6210\u529f\uff0c\u5546\u5bb6\u91d1\u989d\u589e\u52a0] merchantId:{}, financeId:{}, {}", new Object[]{merchantId, merchantFinanceId, isFinanceAmount});
        merchant.setRemark("");
        merchant.setState(FinanceDetailStatusEnum.SUCCESS.getNum());
        if (0 == this.baiqiFinanceDetailMapper.updateStateById(merchant)) {
            LOGGER.error("[\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u8fd4\u56de\u6210\u529f\uff0c\u4fee\u6539\u5546\u5bb6\u6d41\u6c34\u72b6\u6001\u4e3a\u5b8c\u6210]\u6267\u884c\u9519\u8bef. merchantId:{}, financeId:{}", (Object)merchantId, (Object)merchantFinanceId);
            throw new BizException("[\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u8fd4\u56de\u6210\u529f]\u6267\u884c\u9519\u8bef.");
        }
        agent.setRemark("");
        agent.setState(FinanceDetailStatusEnum.SUCCESS.getNum());
        if (0 == this.baiqiFinanceDetailMapper.updateStateById(agent)) {
            LOGGER.error("[\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u8fd4\u56de\u6210\u529f\uff0c\u4fee\u6539\u4ee3\u7406\u5546\u6d41\u6c34\u72b6\u6001\u4e3a\u5b8c\u6210]\u6267\u884c\u6210\u529f. agentId:{}, financeId:{}", (Object)agent.getRelationId(), (Object)agent.getFinanceId());
            throw new BizException("[\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u8fd4\u56de\u6210\u529f]\u6267\u884c\u9519\u8bef.");
        }
        return Boolean.TRUE;
    }

    private Boolean callPartnerRechargeAsFailed(BaiqiFinanceDetailEntity agent, BaiqiFinanceDetailEntity merchant) throws BizException {
        this.checkCallPartnerRecharge(agent);
        Assert.notNull((Object)agent.getRelationId(), (String)"\u6d41\u6c34\u5173\u8054ID\u4e3a\u7a7a");
        Assert.notNull((Object)agent.getExpenditureTotal(), (String)"\u6d41\u6c34\u652f\u51fa\u603b\u91d1\u989d\u4e3a\u7a7a");
        Assert.notNull((Object)agent.getExpenditureCash(), (String)"\u6d41\u6c34\u652f\u51fa\u73b0\u91d1\u4e3a\u7a7a");
        Assert.notNull((Object)agent.getExpenditureRebate(), (String)"\u6d41\u6c34\u652f\u51fa\u8fd4\u70b9\u4e3a\u7a7a");
        CashRebateAmountBean amountBean = new CashRebateAmountBean();
        amountBean.setOpType(CashRebateAmountEnum.INCOME);
        amountBean.setTotalAmount(agent.getExpenditureTotal());
        amountBean.setCashAmount(agent.getExpenditureCash());
        amountBean.setRebateAmount(agent.getExpenditureRebate());
        boolean isFinanceAmount = this.financeService.updateFinanceAmountById(agent.getFinanceId(), amountBean);
        LOGGER.info("[\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5931\u8d25\uff0c\u91d1\u989d\u53cd\u8fd8\u7ed9\u4ee3\u7406\u5546] id:{}, {}", (Object)agent.getId(), (Object)isFinanceAmount);
        agent.setRemark("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5931\u8d25");
        agent.setState(FinanceDetailStatusEnum.FAILED.getNum());
        if (0 == this.baiqiFinanceDetailMapper.updateStateById(agent)) {
            LOGGER.error("[\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5931\u8d25\uff0c\u4fee\u6539\u4ee3\u7406\u5546\u6d41\u6c34\u4fe1\u606f]\u6267\u884c\u5931\u8d25. id:{}", (Object)agent.getId());
            throw new BizException("[\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5931\u8d25\uff0c\u4fee\u6539\u4ee3\u7406\u5546\u6d41\u6c34\u4fe1\u606f]\u6267\u884c\u9519\u8bef.");
        }
        merchant.setRemark("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5931\u8d25");
        merchant.setState(FinanceDetailStatusEnum.FAILED.getNum());
        if (0 == this.baiqiFinanceDetailMapper.updateStateById(merchant)) {
            LOGGER.info("[\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5931\u8d25\uff0c\u4fee\u6539\u5546\u5bb6\u6d41\u6c34\u4fe1\u606f]\u6267\u884c\u6210\u529f. id:{}", (Object)merchant.getId());
            throw new BizException("[\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5931\u8d25]\u6267\u884c\u9519\u8bef.");
        }
        return Boolean.TRUE;
    }

    private Boolean callPartnerRechargeAsException(BaiqiFinanceDetailEntity agent, BaiqiFinanceDetailEntity merchant) throws BizException {
        this.checkCallPartnerRecharge(agent);
        this.checkCallPartnerRecharge(merchant);
        agent.setRemark("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5f02\u5e38\u6216\u8d85\u65f6");
        agent.setState(FinanceDetailStatusEnum.ERROR.getNum());
        if (0 == this.baiqiFinanceDetailMapper.updateStateById(agent)) {
            LOGGER.error("[\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u8d85\u65f6\u6216\u5f02\u5e38\uff0c\u66f4\u65b0\u4ee3\u7406\u5546\u6d41\u6c34\u4fe1\u606f]\u6267\u884c\u6210\u529f. id:{}", (Object)agent.getId());
            throw new BizException("[\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5f02\u5e38\u6216\u8d85\u65f6]\u6267\u884c\u9519\u8bef.");
        }
        merchant.setRemark("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5f02\u5e38\u6216\u8d85\u65f6");
        merchant.setState(FinanceDetailStatusEnum.ERROR.getNum());
        if (0 == this.baiqiFinanceDetailMapper.updateStateById(merchant)) {
            LOGGER.info("[\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u8d85\u65f6\u6216\u5f02\u5e38\uff0c\u66f4\u65b0\u5546\u5bb6\u6d41\u6c34\u4fe1\u606f]\u6267\u884c\u6210\u529f. id:{}", (Object)merchant.getId());
            throw new BizException("[\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5f02\u5e38\u6216\u8d85\u65f6]\u6267\u884c\u9519\u8bef.");
        }
        return Boolean.TRUE;
    }

    private void checkCallPartnerRecharge(BaiqiFinanceDetailEntity detailEntity) {
        Assert.notNull((Object)detailEntity, (String)"\u6d41\u6c34\u53c2\u6570\u4e3a\u7a7a");
        Assert.notNull((Object)detailEntity.getId(), (String)"\u6d41\u6c34ID\u4e3a\u7a7a");
        Assert.notNull((Object)detailEntity.getRelationType(), (String)"\u6d41\u6c34\u5173\u8054\u7c7b\u578b\u4e3a\u7a7a");
    }

    private BaiqiFinanceDetailEntity insertAgentDetailRecharge(Long financeId, Long agentId, Long operatorId, String tradeNo, CashRebateAmountBean cashRebateAmountBo) throws BizException {
        BaiqiFinanceDetailEntity agentDetail = new BaiqiFinanceDetailEntity();
        agentDetail.setFinanceId(financeId);
        agentDetail.setRelationType(Integer.valueOf(FinanceTypeEnum.AGENT_ACCOUNT.getCode()));
        agentDetail.setRelationId(agentId);
        agentDetail.setSerialNo(BaiqiSerialUtil.getSerialNo((FinanceOptTypeEnum)FinanceOptTypeEnum.AGENT_TRANSFER, (FinanceTypeEnum)FinanceTypeEnum.AGENT_ACCOUNT, (long)agentId));
        agentDetail.setExpenditureTotal(cashRebateAmountBo.getTotalAmount());
        agentDetail.setExpenditureCash(cashRebateAmountBo.getCashAmount());
        agentDetail.setExpenditureRebate(cashRebateAmountBo.getRebateAmount());
        agentDetail.setOperator(operatorId);
        agentDetail.setOperatorType(FinanceOptTypeEnum.AGENT_TRANSFER.getNum());
        agentDetail.setState(FinanceDetailStatusEnum.PROCESSING.getNum());
        agentDetail.setPartnerType(ParterTypeEnum.TUIA.getCode());
        agentDetail.setFinanceTradeNo(tradeNo);
        if (0L < this.baiqiFinanceDetailMapper.insert(agentDetail)) {
            LOGGER.info("[\u4fdd\u5b58\u4ee3\u7406\u5546\u6d41\u6c34]\u6267\u884c\u6210\u529f. financeId:{}", (Object)agentDetail.getFinanceId());
            return agentDetail;
        }
        LOGGER.error("[\u4fdd\u5b58\u4ee3\u7406\u5546\u6d41\u6c34]\u6267\u884c\u9519\u8bef. financeId:{}, {}", (Object)agentDetail.getFinanceId(), (Object)agentDetail);
        throw new BizException("[\u4fdd\u5b58\u4ee3\u7406\u5546\u6d41\u6c34]\u6267\u884c\u9519\u8bef");
    }

    private BaiqiFinanceDetailEntity insertMerchantDetailRecharge(Long financeId, Long merchantId, Long operatorId, String financeTradeNo, CashRebateAmountBean cashRebateAmountBo) throws BizException {
        BaiqiFinanceDetailEntity merchantDetail = new BaiqiFinanceDetailEntity();
        merchantDetail.setFinanceId(financeId);
        merchantDetail.setRelationType(Integer.valueOf(FinanceTypeEnum.MAIN_ACCOUNT.getCode()));
        merchantDetail.setRelationId(merchantId);
        merchantDetail.setSerialNo(BaiqiSerialUtil.getSerialNo((FinanceOptTypeEnum)FinanceOptTypeEnum.AGENT_TRANSFER, (FinanceTypeEnum)FinanceTypeEnum.MAIN_ACCOUNT, (long)merchantId));
        merchantDetail.setIncomeTotal(cashRebateAmountBo.getTotalAmount());
        merchantDetail.setIncomeCash(cashRebateAmountBo.getCashAmount());
        merchantDetail.setIncomeRebate(cashRebateAmountBo.getRebateAmount());
        merchantDetail.setOperator(operatorId);
        merchantDetail.setOperatorType(FinanceOptTypeEnum.AGENT_TRANSFER.getNum());
        merchantDetail.setState(FinanceDetailStatusEnum.PROCESSING.getNum());
        merchantDetail.setPartnerType(ParterTypeEnum.TUIA.getCode());
        merchantDetail.setFinanceTradeNo(financeTradeNo);
        if (0L < this.baiqiFinanceDetailMapper.insert(merchantDetail)) {
            LOGGER.info("[\u4fdd\u5b58\u5546\u5bb6\u6d41\u6c34\u9519\u8bef]\u6267\u884c\u6210\u529f. financeId:{}", (Object)merchantDetail.getFinanceId());
            return merchantDetail;
        }
        LOGGER.error("[\u4fdd\u5b58\u5546\u5bb6\u6d41\u6c34\u9519\u8bef]\u6267\u884c\u9519\u8bef. financeId:{}, {}", (Object)merchantDetail.getFinanceId(), (Object)merchantDetail);
        throw new BizException("[\u4fdd\u5b58\u5546\u5bb6\u6d41\u6c34\u9519\u8bef]\u6267\u884c\u9519\u8bef.");
    }

    @Override
    public void retryCallPartner() {
        LOGGER.info("\u5b9a\u65f6\u4efb\u52a1\u91cd\u8bd5\u8c03\u7528\u5916\u90e8\u63a5\u53e3");
        List detailEntityList = this.baiqiFinanceDetailMapper.selectByState(FinanceDetailStatusEnum.ERROR.getNum());
        if (CollectionUtils.isEmpty((Collection)detailEntityList)) {
            return;
        }
        LOGGER.info("\u91cd\u8bd5\u8c03\u7528\u5916\u90e8\u63a5\u53e3, {}", (Object)detailEntityList);
        for (BaiqiFinanceDetailEntity detailEntity : detailEntityList) {
            try {
                if (FinanceTypeEnum.AGENT_ACCOUNT.getCode() == detailEntity.getRelationType().intValue() && FinanceOptTypeEnum.AGENT_TRANSFER.getNum().equals(detailEntity.getOperatorType())) {
                    this.doRetryCallPartnerRecharge(detailEntity);
                    continue;
                }
                if (FinanceTypeEnum.AGENT_ACCOUNT.getCode() == detailEntity.getRelationType().intValue() && FinanceOptTypeEnum.AGENT_CALLBACK.getNum().equals(detailEntity.getOperatorType())) {
                    this.doRetryCallPartnerReverse(detailEntity);
                    continue;
                }
                if (!FinanceOptTypeEnum.OFFLINE_RECHARGE.getNum().equals(detailEntity.getOperatorType()) || FinanceTypeEnum.MAIN_ACCOUNT.getCode() != detailEntity.getRelationType().intValue()) continue;
                this.doRetryCallMerchantArtificialRecharge(detailEntity);
            }
            catch (Exception e) {
                LOGGER.error("\u91cd\u8bd5\u8c03\u7528\u5408\u4f5c\u5546\u63a5\u53e3\u9519\u8bef\uff0cid:{}", (Object)detailEntity.getId(), (Object)e);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void doRetryCallMerchantArtificialRecharge(BaiqiFinanceDetailEntity detailEntity) {
        LOGGER.info("\u68c0\u67e5\u5546\u5bb6\u4eba\u5de5\u5145\u503c, baiqiTradeNo:{}, {}", (Object)detailEntity.getFinanceTradeNo(), (Object)detailEntity);
        PartnerResultStateEnum resultStateEnum = this.checkPartnerAllocateAmount(detailEntity.getFinanceTradeNo());
        if (PartnerResultStateEnum.SUCCEED == resultStateEnum) {
            LOGGER.info("[\u68c0\u67e5\u5546\u5bb6\u4eba\u5de5\u5145\u503c]\u6210\u529f, baiqiTradeNo:{}, {}", (Object)detailEntity.getFinanceTradeNo(), (Object)detailEntity);
            this.artificialRechargeToSuccess(detailEntity);
            return;
        }
        if (PartnerResultStateEnum.FAILED == resultStateEnum) {
            LOGGER.warn("[\u68c0\u67e5\u5546\u5bb6\u4eba\u5de5\u5145\u503c]\u5931\u8d25, baiqiTradeNo:{}, {}", (Object)detailEntity.getFinanceTradeNo(), (Object)detailEntity);
            this.artificialRechargeToFailed(detailEntity);
            return;
        }
        if (System.currentTimeMillis() >= detailEntity.getGmtCreate().getTime() + 86400000L) {
            LOGGER.info("[\u68c0\u67e5\u5546\u5bb6\u4eba\u5de5\u5145\u503c]\u9519\u8bef, \u8d85\u8fc7\u4e00\u5929\u6309\u5931\u8d25\u5904\u7406, baiqiTradeNo:{}, {}", (Object)detailEntity.getFinanceTradeNo(), (Object)detailEntity);
            this.artificialRechargeToFailed(detailEntity);
        } else {
            LOGGER.error("[\u68c0\u67e5\u5546\u5bb6\u4eba\u5de5\u5145\u503c]\u9519\u8bef, baiqiTradeNo:{}, {}", (Object)detailEntity.getFinanceTradeNo(), (Object)detailEntity);
        }
    }

    private void artificialRechargeToFailed(BaiqiFinanceDetailEntity detailEntity) {
        this.checkCallArtificialRecharge(detailEntity);
        BaiqiFinanceDetailEntity financeDetailEntity = new BaiqiFinanceDetailEntity();
        financeDetailEntity.setState(FinanceDetailStatusEnum.FAILED.getNum());
        financeDetailEntity.setId(detailEntity.getId());
        this.baiqiFinanceDetailMapper.updateStateById(financeDetailEntity);
        this.baiqiFinanceRechargeMapper.updateState(BaiqiFinanceRechargeStateEnum.WAIT_CHARGE.getState(), Long.parseLong(detailEntity.getFinanceTradeNo()), "\u7cfb\u7edf");
    }

    private void artificialRechargeToSuccess(BaiqiFinanceDetailEntity detailEntity) {
        this.checkCallArtificialRecharge(detailEntity);
        Long incomeTotalAmout = detailEntity.getIncomeTotal();
        BaiqiFinanceEntity financeEntity = this.baiqiFinanceMapper.findByRelation(detailEntity.getRelationType().intValue(), detailEntity.getRelationId().longValue());
        financeEntity.setCashAmount(Long.valueOf(detailEntity.getIncomeCash() == null ? financeEntity.getCashAmount() : detailEntity.getIncomeCash() + financeEntity.getCashAmount()));
        financeEntity.setRebateAmount(Long.valueOf(detailEntity.getIncomeRebate() == null ? financeEntity.getRebateAmount() : detailEntity.getIncomeRebate() + financeEntity.getRebateAmount()));
        financeEntity.setTotalAmount(Long.valueOf(financeEntity.getTotalAmount() + incomeTotalAmout));
        this.baiqiFinanceMapper.updateAmount(financeEntity);
        BaiqiFinanceDetailEntity financeDetailEntity = new BaiqiFinanceDetailEntity();
        financeDetailEntity.setState(FinanceDetailStatusEnum.SUCCESS.getNum());
        financeDetailEntity.setId(detailEntity.getId());
        this.baiqiFinanceDetailMapper.updateStateById(financeDetailEntity);
        this.baiqiFinanceRechargeMapper.updateState(BaiqiFinanceRechargeStateEnum.SUCCEED.getState(), Long.parseLong(detailEntity.getFinanceTradeNo()), "\u7cfb\u7edf");
    }

    private void checkCallArtificialRecharge(BaiqiFinanceDetailEntity detailEntity) {
        Assert.notNull((Object)detailEntity, (String)"\u6d41\u6c34\u53c2\u6570\u4e3a\u7a7a");
        Assert.notNull((Object)detailEntity.getId(), (String)"\u6d41\u6c34ID\u4e3a\u7a7a");
        Assert.notNull((Object)detailEntity.getRelationType(), (String)"\u6d41\u6c34\u5173\u8054\u7c7b\u578b\u4e3a\u7a7a");
    }

    @Transactional(rollbackFor={Exception.class})
    public void doRetryCallPartnerRecharge(BaiqiFinanceDetailEntity agentEntity) throws BizException {
        LOGGER.info("\u68c0\u67e5\u91d1\u989d\u5212\u62e8, baiqiTradeNo:{}, {}", (Object)agentEntity.getFinanceTradeNo(), (Object)agentEntity);
        BaiqiFinanceDetailEntity merchantDetail = this.financeDetailService.findFinanceDetailByTradeNo(FinanceTypeEnum.MAIN_ACCOUNT.getCode(), agentEntity.getFinanceTradeNo());
        if (null == merchantDetail) {
            return;
        }
        PartnerResultStateEnum resultStateEnum = this.checkPartnerAllocateAmount(agentEntity.getFinanceTradeNo());
        if (PartnerResultStateEnum.SUCCEED == resultStateEnum) {
            LOGGER.info("[\u68c0\u67e5\u91d1\u989d\u5212\u62e8]\u6210\u529f, baiqiTradeNo:{}, {}", (Object)agentEntity.getFinanceTradeNo(), (Object)agentEntity);
            this.callPartnerRechargeAsSucceed(agentEntity, merchantDetail);
            return;
        }
        if (PartnerResultStateEnum.FAILED == resultStateEnum) {
            LOGGER.warn("[\u68c0\u67e5\u91d1\u989d\u5212\u62e8]\u5931\u8d25, baiqiTradeNo:{}, {}", (Object)agentEntity.getFinanceTradeNo(), (Object)agentEntity);
            this.callPartnerRechargeAsFailed(agentEntity, merchantDetail);
            return;
        }
        if (System.currentTimeMillis() >= agentEntity.getGmtCreate().getTime() + 86400000L) {
            LOGGER.info("[\u68c0\u67e5\u91d1\u989d\u5212\u62e8]\u9519\u8bef, \u8d85\u8fc7\u4e00\u5929\u6309\u5931\u8d25\u5904\u7406, baiqiTradeNo:{}, {}", (Object)agentEntity.getFinanceTradeNo(), (Object)agentEntity);
            this.callPartnerRechargeAsFailed(agentEntity, merchantDetail);
        } else {
            LOGGER.error("[\u68c0\u67e5\u91d1\u989d\u5212\u62e8]\u9519\u8bef, baiqiTradeNo:{}, {}", (Object)agentEntity.getFinanceTradeNo(), (Object)agentEntity);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void doRetryCallPartnerReverse(BaiqiFinanceDetailEntity agentDetail) throws BizException {
        LOGGER.info("\u68c0\u67e5\u91d1\u989d\u56de\u62e8, baiqiTradeNo:{}, {}", (Object)agentDetail.getFinanceTradeNo(), (Object)agentDetail);
        BaiqiFinanceDetailEntity metchantDetail = this.financeDetailService.findFinanceDetailByTradeNo(FinanceTypeEnum.MAIN_ACCOUNT.getCode(), agentDetail.getFinanceTradeNo());
        if (null == metchantDetail) {
            return;
        }
        PartnerResultStateEnum resultStateEnum = this.checkPartnerAllocateAmount(agentDetail.getFinanceTradeNo());
        if (PartnerResultStateEnum.SUCCEED == resultStateEnum) {
            LOGGER.info("[\u68c0\u67e5\u91d1\u989d\u56de\u62e8]\u6210\u529f, baiqiTradeNo:{}, {}", (Object)agentDetail.getFinanceTradeNo(), (Object)agentDetail);
            this.callPartnerReverseAsSucceed(metchantDetail, agentDetail);
            return;
        }
        if (PartnerResultStateEnum.FAILED == resultStateEnum) {
            LOGGER.warn("[\u68c0\u67e5\u91d1\u989d\u56de\u62e8]\u5931\u8d25, baiqiTradeNo:{}, {}", (Object)agentDetail.getFinanceTradeNo(), (Object)agentDetail);
            this.callPartnerReverseAsFailed(metchantDetail, agentDetail);
            return;
        }
        if (System.currentTimeMillis() >= agentDetail.getGmtCreate().getTime() + 86400000L) {
            LOGGER.info("[\u68c0\u67e5\u91d1\u989d\u56de\u62e8]\u9519\u8bef, \u8d85\u8fc7\u4e00\u5929\u6309\u5931\u8d25\u5904\u7406, baiqiTradeNo:{}, {}", (Object)agentDetail.getFinanceTradeNo(), (Object)agentDetail);
            this.callPartnerReverseAsFailed(metchantDetail, agentDetail);
        } else {
            LOGGER.error("[\u68c0\u67e5\u91d1\u989d\u56de\u62e8]\u9519\u8bef, baiqiTradeNo:{}, {}", (Object)agentDetail.getFinanceTradeNo(), (Object)agentDetail);
        }
    }

    @Override
    public PartnerResultStateEnum allocateAmountReverse(AllocateAmountDto param) throws BizException {
        Assert.notNull((Object)param, (String)"\u53c2\u6570\u4e3a\u7a7a");
        Assert.notNull((Object)param.getAgentId(), (String)"\u4ee3\u7406\u5546\u8d26\u53f7ID\u4e3a\u7a7a");
        Assert.notNull((Object)param.getAgentFinanceId(), (String)"\u4ee3\u7406\u5546\u8d26\u6237ID\u4e3a\u7a7a");
        Assert.notNull((Object)param.getMerchantId(), (String)"\u5546\u5bb6\u8d26\u53f7ID\u4e3a\u7a7a");
        Assert.notNull((Object)param.getMerchantFinanceId(), (String)"\u5546\u5bb6\u8d26\u6237ID\u4e3a\u7a7a");
        Assert.notNull((Object)param.getAdvertId(), (String)"\u5e7f\u544a\u4e3bID\u4e3a\u7a7a");
        Assert.notNull((Object)param.getAmount(), (String)"\u5145\u503c\u91d1\u989d\u4e3a\u7a7a");
        Assert.notNull((Object)param.getOperator(), (String)"\u64cd\u4f5c\u4eba\u4e3a\u7a7a");
        LOGGER.info("[\u91d1\u989d\u56de\u62e8\u53c2\u6570] {}", (Object)param);
        CashRebateAmountBean amountBean = this.financeService.calcCashAndRebateAmount(param.getMerchantFinanceId(), param.getAmount(), CashRebateAmountEnum.EXPENDITURE);
        if (null == amountBean) {
            LOGGER.error("\u8ba1\u7b97\u4ee3\u7406\u5546\u7684\u73b0\u91d1\u548c\u8fd4\u70b9\u6263\u6bd4\u4e3a\u7a7a");
            return PartnerResultStateEnum.FAILED;
        }
        LOGGER.info("[\u91d1\u989d\u56de\u62e8\u5206\u914d\u6bd4\u4f8b] {}", (Object)amountBean);
        String tradeNo = UUIDUtils.createUUID();
        BaiqiFinanceDetailEntity agentDetail = this.insertAgentDetailReverse(param.getAgentFinanceId(), param.getAgentId(), param.getOperator(), tradeNo, amountBean);
        LOGGER.info("[\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u8fd4\u56de\u6210\u529f\uff0c\u6dfb\u52a0\u4ee3\u7406\u5546\u6536\u5165\u6d41\u6c34] agentId:{}, financeId:{}, {}", new Object[]{param.getAgentId(), param.getAgentFinanceId(), agentDetail});
        BaiqiFinanceDetailEntity merchantDetail = this.insertMerchantDetailReverse(param.getMerchantFinanceId(), param.getMerchantId(), param.getOperator(), tradeNo, amountBean);
        LOGGER.info("[\u56de\u62e8\u5546\u5bb6\u6d41\u6c34] {}", (Object)merchantDetail);
        amountBean.setOpType(CashRebateAmountEnum.EXPENDITURE);
        boolean isFinanceAmount = this.financeService.updateFinanceAmountById(merchantDetail.getFinanceId(), amountBean);
        LOGGER.info("[\u4ee3\u7406\u5546\u8d26\u6237\u603b\u91d1\u989d\u51cf\u5c11] {}", (Object)isFinanceAmount);
        PartnerAllocateAmountBean partnerAllocateAmountBean = new PartnerAllocateAmountBean();
        partnerAllocateAmountBean.setBaiqiTradeNo(merchantDetail.getFinanceTradeNo());
        partnerAllocateAmountBean.setTradeType(TuiaTradeTypeEnum.REVERSE);
        partnerAllocateAmountBean.setAccountId(param.getAdvertId());
        partnerAllocateAmountBean.setAmount(param.getAmount());
        PartnerResultStateEnum resultStateEnum = this.callPartnerAllocateAmount(partnerAllocateAmountBean);
        LOGGER.info("[\u8c03\u7528\u91d1\u989d\u56de\u62e8] {}", (Object)resultStateEnum);
        if (PartnerResultStateEnum.SUCCEED == resultStateEnum) {
            LOGGER.info("[\u91d1\u989d\u56de\u62e8]\u6210\u529f, baiqiTradeNo:{}, {}", (Object)merchantDetail.getFinanceTradeNo(), (Object)merchantDetail);
            this.callPartnerReverseAsSucceed(merchantDetail, agentDetail);
            return resultStateEnum;
        }
        if (PartnerResultStateEnum.FAILED == resultStateEnum) {
            LOGGER.warn("[\u91d1\u989d\u56de\u62e8]\u5931\u8d25 BaiqiTradeNo:{}, {}", (Object)merchantDetail.getFinanceTradeNo(), (Object)merchantDetail);
            this.callPartnerReverseAsFailed(merchantDetail, agentDetail);
            return resultStateEnum;
        }
        LOGGER.error("[\u91d1\u989d\u56de\u62e8]\u9519\u8bef, baiqiTradeNo:{}, {}", (Object)merchantDetail.getFinanceTradeNo(), (Object)merchantDetail);
        this.callPartnerReverseAsException(merchantDetail, agentDetail);
        return resultStateEnum;
    }

    private void checkCallPartnerReverse(BaiqiFinanceDetailEntity detailEntity) {
        Assert.notNull((Object)detailEntity, (String)"\u6d41\u6c34\u53c2\u6570\u4e3a\u7a7a");
        Assert.notNull((Object)detailEntity.getId(), (String)"\u6d41\u6c34ID\u4e3a\u7a7a");
        Assert.notNull((Object)detailEntity.getRelationType(), (String)"\u6d41\u6c34\u5173\u8054\u7c7b\u578b\u4e3a\u7a7a");
    }

    private Boolean callPartnerReverseAsFailed(BaiqiFinanceDetailEntity merchant, BaiqiFinanceDetailEntity agent) throws BizException {
        this.checkCallPartnerReverse(merchant);
        Assert.notNull((Object)merchant.getRelationId(), (String)"\u6d41\u6c34\u5173\u8054ID\u4e3a\u7a7a");
        Assert.notNull((Object)merchant.getExpenditureTotal(), (String)"\u6d41\u6c34\u652f\u51fa\u603b\u91d1\u989d\u4e3a\u7a7a");
        Assert.notNull((Object)merchant.getExpenditureCash(), (String)"\u6d41\u6c34\u652f\u51fa\u73b0\u91d1\u4e3a\u7a7a");
        Assert.notNull((Object)merchant.getExpenditureRebate(), (String)"\u6d41\u6c34\u652f\u51fa\u8fd4\u70b9\u4e3a\u7a7a");
        CashRebateAmountBean amountBean = new CashRebateAmountBean();
        amountBean.setOpType(CashRebateAmountEnum.INCOME);
        amountBean.setTotalAmount(merchant.getExpenditureTotal());
        amountBean.setCashAmount(merchant.getExpenditureCash());
        amountBean.setRebateAmount(merchant.getExpenditureRebate());
        boolean isFinanceAmount = this.financeService.updateFinanceAmountById(merchant.getFinanceId(), amountBean);
        LOGGER.info("[\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5931\u8d25\uff0c\u91d1\u989d\u53cd\u8fd8\u7ed9\u5546\u5bb6] id:{}, {}", (Object)merchant.getId(), (Object)isFinanceAmount);
        merchant.setRemark("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5931\u8d25");
        merchant.setState(FinanceDetailStatusEnum.FAILED.getNum());
        if (0 == this.baiqiFinanceDetailMapper.updateStateById(merchant)) {
            LOGGER.error("[\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5931\u8d25\uff0c\u66f4\u65b0\u5546\u5bb6\u6d41\u6c34]\u6267\u884c\u9519\u8bef. id:{}", (Object)merchant.getId());
            throw new BizException("[\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5931\u8d25]\u6267\u884c\u9519\u8bef.");
        }
        agent.setRemark("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5931\u8d25");
        agent.setState(FinanceDetailStatusEnum.FAILED.getNum());
        if (0 == this.baiqiFinanceDetailMapper.updateStateById(agent)) {
            LOGGER.info("[\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5931\u8d25\uff0c\u66f4\u65b0\u4ee3\u7406\u5546\u6d41\u6c34]\u6267\u884c\u9519\u8bef\u3002id:{}", (Object)merchant.getId());
            throw new BizException("[\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5931\u8d25]\u6267\u884c\u9519\u8bef.");
        }
        return Boolean.TRUE;
    }

    private Boolean callPartnerReverseAsException(BaiqiFinanceDetailEntity merchant, BaiqiFinanceDetailEntity agent) throws BizException {
        this.checkCallPartnerReverse(merchant);
        this.checkCallPartnerReverse(agent);
        merchant.setRemark("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5f02\u5e38\u6216\u8d85\u65f6");
        merchant.setState(FinanceDetailStatusEnum.ERROR.getNum());
        if (0 == this.baiqiFinanceDetailMapper.updateStateById(merchant)) {
            LOGGER.error("[\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u8d85\u65f6\u6216\u5f02\u5e38\uff0c\u66f4\u65b0\u5546\u5bb6\u6d41\u6c34\u4fe1\u606f]\u6267\u884c\u6210\u529f. id:{}", (Object)merchant.getId());
            throw new BizException("[\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5f02\u5e38\u6216\u8d85\u65f6]\u6267\u884c\u9519\u8bef.");
        }
        agent.setRemark("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5f02\u5e38\u6216\u8d85\u65f6");
        agent.setState(FinanceDetailStatusEnum.ERROR.getNum());
        if (0 == this.baiqiFinanceDetailMapper.updateStateById(agent)) {
            LOGGER.error("[\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u8d85\u65f6\u6216\u5f02\u5e38\uff0c\u66f4\u65b0\u4ee3\u7406\u5546\u6d41\u6c34\u4fe1\u606f]\u6267\u884c\u6210\u529f. id:{}", (Object)agent.getId());
            throw new BizException("[\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5f02\u5e38\u6216\u8d85\u65f6]\u6267\u884c\u9519\u8bef.");
        }
        return Boolean.TRUE;
    }

    private Boolean callPartnerReverseAsSucceed(BaiqiFinanceDetailEntity merchant, BaiqiFinanceDetailEntity agent) throws BizException {
        this.checkCallPartnerReverse(merchant);
        Assert.notNull((Object)merchant.getFinanceId(), (String)"\u8d26\u6237ID\u4e3a\u7a7a");
        Assert.notNull((Object)merchant.getRelationId(), (String)"\u6d41\u6c34\u5173\u8054ID\u4e3a\u7a7a");
        Assert.notNull((Object)merchant.getExpenditureTotal(), (String)"\u6d41\u6c34\u652f\u51fa\u603b\u91d1\u989d\u4e3a\u7a7a");
        Assert.notNull((Object)merchant.getExpenditureCash(), (String)"\u6d41\u6c34\u652f\u51fa\u73b0\u91d1\u4e3a\u7a7a");
        Assert.notNull((Object)merchant.getExpenditureRebate(), (String)"\u6d41\u6c34\u652f\u51fa\u8fd4\u70b9\u4e3a\u7a7a");
        Assert.notNull((Object)merchant.getOperator(), (String)"\u6d41\u6c34\u64cd\u4f5c\u4eba\u4e3a\u7a7a");
        Assert.notNull((Object)merchant.getFinanceTradeNo(), (String)"\u6d41\u6c34\u4ea4\u6613\u53f7\u4e3a\u7a7a");
        CashRebateAmountBean amountBean = new CashRebateAmountBean();
        amountBean.setTotalAmount(merchant.getExpenditureTotal());
        amountBean.setCashAmount(merchant.getExpenditureCash());
        amountBean.setRebateAmount(merchant.getExpenditureRebate());
        amountBean.setOpType(CashRebateAmountEnum.INCOME);
        boolean isFinanceAmount = this.financeService.updateFinanceAmountById(agent.getFinanceId(), amountBean);
        LOGGER.info("[\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u8fd4\u56de\u6210\u529f\uff0c\u4ee3\u7406\u5546\u91d1\u989d\u589e\u52a0] agentId:{}, financeId:{}, {}", new Object[]{agent.getRelationId(), agent.getFinanceId(), isFinanceAmount});
        agent.setRemark("");
        agent.setState(FinanceDetailStatusEnum.SUCCESS.getNum());
        if (0 == this.baiqiFinanceDetailMapper.updateStateById(agent)) {
            LOGGER.error("[\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u8fd4\u56de\u6210\u529f\uff0c\u4fee\u6539\u4ee3\u7406\u5546\u6d41\u6c34\u72b6\u6001\u4e3a\u5b8c\u6210]\u6267\u884c\u6210\u529f. agentId:{}, financeId:{}", (Object)agent.getRelationId(), (Object)agent.getFinanceId());
            throw new BizException("[\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u8fd4\u56de\u6210\u529f]\u6267\u884c\u9519\u8bef.");
        }
        merchant.setRemark("");
        merchant.setState(FinanceDetailStatusEnum.SUCCESS.getNum());
        if (0 == this.baiqiFinanceDetailMapper.updateStateById(merchant)) {
            LOGGER.error("[\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u8fd4\u56de\u6210\u529f\uff0c\u4fee\u6539\u5546\u5bb6\u6d41\u6c34\u72b6\u6001\u4e3a\u5b8c\u6210]\u6267\u884c\u6210\u529f. merchantId:{}, financeId:{}", (Object)merchant.getRelationId(), (Object)merchant.getFinanceId());
            throw new BizException("[\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u8fd4\u56de\u6210\u529f]\u6267\u884c\u9519\u8bef.");
        }
        return Boolean.TRUE;
    }

    private BaiqiFinanceDetailEntity insertMerchantDetailReverse(Long financeId, Long merchantId, Long operatorId, String tradeNo, CashRebateAmountBean cashRebateAmountBo) throws BizException {
        BaiqiFinanceDetailEntity merchantDetail = new BaiqiFinanceDetailEntity();
        merchantDetail.setFinanceId(financeId);
        merchantDetail.setRelationType(Integer.valueOf(FinanceTypeEnum.MAIN_ACCOUNT.getCode()));
        merchantDetail.setRelationId(merchantId);
        merchantDetail.setSerialNo(BaiqiSerialUtil.getSerialNo((FinanceOptTypeEnum)FinanceOptTypeEnum.AGENT_CALLBACK, (FinanceTypeEnum)FinanceTypeEnum.MAIN_ACCOUNT, (long)merchantId));
        merchantDetail.setExpenditureTotal(cashRebateAmountBo.getTotalAmount());
        merchantDetail.setExpenditureCash(cashRebateAmountBo.getCashAmount());
        merchantDetail.setExpenditureRebate(cashRebateAmountBo.getRebateAmount());
        merchantDetail.setOperator(operatorId);
        merchantDetail.setOperatorType(FinanceOptTypeEnum.AGENT_CALLBACK.getNum());
        merchantDetail.setState(FinanceDetailStatusEnum.PROCESSING.getNum());
        merchantDetail.setPartnerType(ParterTypeEnum.TUIA.getCode());
        merchantDetail.setFinanceTradeNo(tradeNo);
        if (0L < this.baiqiFinanceDetailMapper.insert(merchantDetail)) {
            LOGGER.info("[\u4fdd\u5b58\u5546\u5bb6\u6d41\u6c34\u9519\u8bef]\u6267\u884c\u6210\u529f. financeId:{}", (Object)merchantDetail.getFinanceId());
            return merchantDetail;
        }
        LOGGER.error("[\u4fdd\u5b58\u5546\u5bb6\u6d41\u6c34\u9519\u8bef]\u6267\u884c\u9519\u8bef. financeId:{}, {}", (Object)merchantDetail.getFinanceId(), (Object)merchantDetail);
        throw new BizException("[\u4fdd\u5b58\u5546\u5bb6\u6d41\u6c34\u9519\u8bef]\u6267\u884c\u9519\u8bef.");
    }

    private BaiqiFinanceDetailEntity insertAgentDetailReverse(Long financeId, Long agentId, Long operatorId, String financeTradeNo, CashRebateAmountBean cashRebateAmountBo) throws BizException {
        BaiqiFinanceDetailEntity agentDetail = new BaiqiFinanceDetailEntity();
        agentDetail.setFinanceId(financeId);
        agentDetail.setRelationType(Integer.valueOf(FinanceTypeEnum.AGENT_ACCOUNT.getCode()));
        agentDetail.setRelationId(agentId);
        agentDetail.setSerialNo(BaiqiSerialUtil.getSerialNo((FinanceOptTypeEnum)FinanceOptTypeEnum.AGENT_CALLBACK, (FinanceTypeEnum)FinanceTypeEnum.AGENT_ACCOUNT, (long)agentId));
        agentDetail.setIncomeTotal(cashRebateAmountBo.getTotalAmount());
        agentDetail.setIncomeCash(cashRebateAmountBo.getCashAmount());
        agentDetail.setIncomeRebate(cashRebateAmountBo.getRebateAmount());
        agentDetail.setOperator(operatorId);
        agentDetail.setOperatorType(FinanceOptTypeEnum.AGENT_CALLBACK.getNum());
        agentDetail.setState(FinanceDetailStatusEnum.PROCESSING.getNum());
        agentDetail.setPartnerType(ParterTypeEnum.TUIA.getCode());
        agentDetail.setFinanceTradeNo(financeTradeNo);
        if (0L < this.baiqiFinanceDetailMapper.insert(agentDetail)) {
            LOGGER.info("[\u4fdd\u5b58\u4ee3\u7406\u5546\u6d41\u6c34]\u6267\u884c\u6210\u529f. financeId:{}", (Object)agentDetail.getFinanceId());
            return agentDetail;
        }
        LOGGER.error("[\u4fdd\u5b58\u4ee3\u7406\u5546\u6d41\u6c34]\u6267\u884c\u9519\u8bef. financeId:{}, {}", (Object)agentDetail.getFinanceId(), (Object)agentDetail);
        throw new BizException("[\u4fdd\u5b58\u4ee3\u7406\u5546\u6d41\u6c34]\u6267\u884c\u9519\u8bef");
    }
}

