/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.finance;

import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.finance.FinanceDetailDto;
import com.qiho.center.api.dto.finance.FinanceDto;
import com.qiho.center.api.dto.finance.HistoricalBalanceDto;
import com.qiho.center.api.dto.merchant.MerchantDto;
import com.qiho.center.api.enums.GetParamTimeEnum;
import com.qiho.center.api.enums.finance.FinanceDetailStatusEnum;
import com.qiho.center.api.enums.finance.FinanceOptTypeEnum;
import com.qiho.center.api.enums.finance.FinanceTypeEnum;
import com.qiho.center.api.params.PageQueryParams;
import com.qiho.center.api.params.finance.BaiqiMerchantFreetextParam;
import com.qiho.center.api.params.finance.FinanceBasePageParam;
import com.qiho.center.biz.service.agent.BaiqiAgentService;
import com.qiho.center.biz.service.finance.FinanceDetailService;
import com.qiho.center.biz.service.finance.FinanceService;
import com.qiho.center.biz.service.merchant.MerchantService;
import com.qiho.center.common.daoh.qiho.finance.BaiqiFinanceDetailMapper;
import com.qiho.center.common.daoh.qiho.finance.BaiqiHistoricalBalanceMapper;
import com.qiho.center.common.entityd.qiho.agent.BaiqiAgentEntity;
import com.qiho.center.common.entityd.qiho.finance.BaiqiFinanceDetailEntity;
import com.qiho.center.common.entityd.qiho.finance.BaiqiHistoricalBalanceEntity;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FinanceDetailServiceImpl
implements FinanceDetailService {
    @Autowired
    private BaiqiFinanceDetailMapper financeDetailMapper;
    @Autowired
    private BaiqiHistoricalBalanceMapper historicalBalanceMapper;
    @Resource
    private MerchantService merchantService;
    @Resource
    private BaiqiAgentService baiqiAgentService;
    @Resource
    private FinanceService financeService;

    @Override
    public PagenationDto<FinanceDetailDto> findByParams(BaiqiMerchantFreetextParam params) {
        PagenationDto pagenationDto = new PagenationDto();
        this.splitMerchantOrAgent((PagenationDto<FinanceDetailDto>)pagenationDto, params);
        return pagenationDto;
    }

    @Override
    public Long insert(FinanceDetailDto financeDetailDto) {
        BaiqiFinanceDetailEntity entity = (BaiqiFinanceDetailEntity)BeanUtils.copy((Object)financeDetailDto, BaiqiFinanceDetailEntity.class);
        entity.setOperatorType(financeDetailDto.getOperatorType().getNum());
        entity.setState(financeDetailDto.getState().getNum());
        return this.financeDetailMapper.insert(entity);
    }

    @Override
    public PagenationDto<FinanceDetailDto> findFinanceDetailByMerchantId(BaiqiMerchantFreetextParam pageParam) {
        List list = this.financeDetailMapper.selectFinanceDetailByMerchantId(pageParam);
        ArrayList resultList = Lists.newArrayList();
        for (BaiqiFinanceDetailEntity entity : list) {
            FinanceDetailDto financeDetailDto = (FinanceDetailDto)BeanUtils.copy((Object)entity, FinanceDetailDto.class);
            financeDetailDto.setOperatorType(FinanceOptTypeEnum.getByNum((Integer)entity.getOperatorType()));
            financeDetailDto.setState(FinanceDetailStatusEnum.getByNum((Integer)entity.getState()));
            resultList.add(financeDetailDto);
        }
        PagenationDto pagenationDto = new PagenationDto();
        pagenationDto.setList((List)resultList);
        int total = this.financeDetailMapper.countFinanceDetailByMerchantId(pageParam);
        pagenationDto.setTotal(Integer.valueOf(total));
        return pagenationDto;
    }

    @Override
    public PagenationDto<FinanceDetailDto> findFinanceDetailByAgentId(BaiqiMerchantFreetextParam pageParam) {
        List list = this.financeDetailMapper.selectFinanceDetailByAgentId(pageParam);
        ArrayList resultList = Lists.newArrayList();
        for (BaiqiFinanceDetailEntity entity : list) {
            FinanceDetailDto financeDetailDto = (FinanceDetailDto)BeanUtils.copy((Object)entity, FinanceDetailDto.class);
            financeDetailDto.setOperatorType(FinanceOptTypeEnum.getByNum((Integer)entity.getOperatorType()));
            financeDetailDto.setState(FinanceDetailStatusEnum.getByNum((Integer)entity.getState()));
            resultList.add(financeDetailDto);
        }
        PagenationDto pagenationDto = new PagenationDto();
        pagenationDto.setList((List)resultList);
        int total = this.financeDetailMapper.countFinanceDetailByAgentId(pageParam);
        pagenationDto.setTotal(Integer.valueOf(total));
        return pagenationDto;
    }

    @Override
    public BaiqiFinanceDetailEntity findFinanceDetailByTradeNo(int relationType, String tradeNo) {
        List detailEntityList = this.financeDetailMapper.selectByTradeNo(tradeNo);
        if (null == detailEntityList || detailEntityList.isEmpty()) {
            return null;
        }
        for (BaiqiFinanceDetailEntity entity : detailEntityList) {
            if (relationType != entity.getRelationType()) continue;
            return entity;
        }
        return null;
    }

    private void splitMerchantOrAgent(PagenationDto<FinanceDetailDto> pagenationDto, BaiqiMerchantFreetextParam param) {
        List entities;
        if (param.getRelationType() == null || param.getRelationType() == 0) {
            param.setRelationType(null);
        }
        if (CollectionUtils.isEmpty((Collection)(entities = this.financeDetailMapper.findByParams(param)))) {
            pagenationDto.setList(Collections.emptyList());
            pagenationDto.setTotal(Integer.valueOf(0));
            return;
        }
        ArrayList<Long> merchantIds = new ArrayList<Long>();
        ArrayList<Long> agentIds = new ArrayList<Long>();
        this.setRelationIds(merchantIds, agentIds, entities);
        Map<Object, Object> merchantDtoMap = new HashMap();
        Map<Object, Object> agentMap = new HashMap();
        if (CollectionUtils.isNotEmpty(merchantIds)) {
            merchantDtoMap = this.merchantService.findByIdList(merchantIds);
        }
        if (CollectionUtils.isNotEmpty(agentIds)) {
            agentMap = this.baiqiAgentService.findByIdsMap(agentIds);
        }
        ArrayList<FinanceDetailDto> detailDtos = new ArrayList<FinanceDetailDto>();
        for (BaiqiFinanceDetailEntity entity : entities) {
            Long relationId = entity.getRelationId();
            int accountType = entity.getRelationType();
            FinanceDetailDto detailDto = this.entityToDto(entity);
            if (accountType == FinanceTypeEnum.AGENT_ACCOUNT.getCode()) {
                BaiqiAgentEntity agentEntity = (BaiqiAgentEntity)agentMap.get(relationId);
                detailDto.setName(agentEntity == null ? null : agentEntity.getAgentName());
            } else {
                MerchantDto merchantDto = (MerchantDto)merchantDtoMap.get(relationId);
                detailDto.setName(merchantDto == null ? null : merchantDto.getMerchantName());
            }
            detailDtos.add(detailDto);
        }
        Integer count = this.financeDetailMapper.count(param);
        pagenationDto.setTotal(count);
        pagenationDto.setList(detailDtos);
    }

    private FinanceDetailDto entityToDto(BaiqiFinanceDetailEntity entity) {
        FinanceDetailDto financeDetailDto = (FinanceDetailDto)BeanUtils.copy((Object)entity, FinanceDetailDto.class);
        financeDetailDto.setRelationType(FinanceTypeEnum.getByCode((Integer)entity.getRelationType()));
        financeDetailDto.setState(FinanceDetailStatusEnum.getByNum((Integer)entity.getState()));
        financeDetailDto.setOperatorType(FinanceOptTypeEnum.getByNum((Integer)entity.getOperatorType()));
        return financeDetailDto;
    }

    private void setRelationIds(List<Long> merchantIds, List<Long> agentIds, List<BaiqiFinanceDetailEntity> entities) {
        for (BaiqiFinanceDetailEntity entity : entities) {
            int accountType = entity.getRelationType();
            Long relationId = entity.getRelationId();
            if (accountType == FinanceTypeEnum.AGENT_ACCOUNT.getCode()) {
                agentIds.add(relationId);
                continue;
            }
            merchantIds.add(relationId);
        }
    }

    @Override
    public PagenationDto<HistoricalBalanceDto> findHistoricalBalanceByPara(BaiqiMerchantFreetextParam params) {
        PagenationDto pagenationDto = new PagenationDto();
        this.splitMerchantAndAgent((PagenationDto<HistoricalBalanceDto>)pagenationDto, params);
        return pagenationDto;
    }

    private void splitMerchantAndAgent(PagenationDto<HistoricalBalanceDto> pagenationDto, BaiqiMerchantFreetextParam param) {
        if (param.getRelationType() == null || param.getRelationType() == 0) {
            param.setRelationType(null);
        }
        param.setStartTime(DateUtils.getDayDate((Date)param.getStartTime()));
        param.setEndTime(DateUtils.getDayDate((Date)param.getEndTime()));
        List entities = this.historicalBalanceMapper.findHistoricalBalanceByPara(param);
        if (CollectionUtils.isEmpty((Collection)entities)) {
            pagenationDto.setList(Collections.emptyList());
            pagenationDto.setTotal(Integer.valueOf(0));
            return;
        }
        ArrayList<Long> merchantIds = new ArrayList<Long>();
        ArrayList<Long> agentIds = new ArrayList<Long>();
        for (BaiqiHistoricalBalanceEntity entity : entities) {
            int accountType = entity.getRelationType();
            Long relationId = entity.getRelationId();
            if (accountType == FinanceTypeEnum.AGENT_ACCOUNT.getCode()) {
                agentIds.add(relationId);
                continue;
            }
            merchantIds.add(relationId);
        }
        HashMap<Long, MerchantDto> merchantDtoMap = new HashMap();
        Map<Long, BaiqiAgentEntity> agentMap = new HashMap<Long, BaiqiAgentEntity>();
        if (CollectionUtils.isNotEmpty(merchantIds)) {
            merchantDtoMap = this.merchantService.findByIdList(merchantIds);
        }
        if (CollectionUtils.isNotEmpty(agentIds)) {
            agentMap = this.baiqiAgentService.findByIdsMap(agentIds);
        }
        List<HistoricalBalanceDto> historicalBalanceDtos = this.entitiesToDtoList(entities, agentMap, merchantDtoMap);
        Integer count = this.historicalBalanceMapper.findCountByReportDate(param);
        pagenationDto.setTotal(count);
        pagenationDto.setList(historicalBalanceDtos);
    }

    private List<HistoricalBalanceDto> entitiesToDtoList(List<BaiqiHistoricalBalanceEntity> entities, Map<Long, BaiqiAgentEntity> agentMap, Map<Long, MerchantDto> merchantDtoMap) {
        ArrayList<HistoricalBalanceDto> historicalBalanceDtos = new ArrayList<HistoricalBalanceDto>();
        for (BaiqiHistoricalBalanceEntity entity : entities) {
            Long relationId = entity.getRelationId();
            int accountType = entity.getRelationType();
            HistoricalBalanceDto historicalBalanceDto = (HistoricalBalanceDto)BeanUtils.copy((Object)entity, HistoricalBalanceDto.class);
            historicalBalanceDto.setRelationType(FinanceTypeEnum.getByCode((Integer)entity.getRelationType()));
            if (accountType == FinanceTypeEnum.AGENT_ACCOUNT.getCode()) {
                BaiqiAgentEntity agentEntity = agentMap.get(relationId);
                historicalBalanceDto.setName(agentEntity == null ? null : agentEntity.getAgentName());
            } else {
                MerchantDto merchantDto = merchantDtoMap.get(relationId);
                historicalBalanceDto.setName(merchantDto == null ? null : merchantDto.getMerchantName());
            }
            historicalBalanceDtos.add(historicalBalanceDto);
        }
        return historicalBalanceDtos;
    }

    @Override
    public Boolean historicalBalanceSync() {
        Integer baseInfoCount;
        BaiqiMerchantFreetextParam params = new BaiqiMerchantFreetextParam();
        FinanceBasePageParam basePageParam = new FinanceBasePageParam();
        Integer historicalBalanceCount = this.historicalBalanceMapper.findHistoricalBalanceCount();
        Date dayDate = DateUtils.getDayDate((Date)FinanceDetailServiceImpl.getParamTime(-1, GetParamTimeEnum.START_TIME));
        if (historicalBalanceCount != 0) {
            params.setMax(historicalBalanceCount);
            List historicalBalanceDtoList = this.financeService.findAllHistoricalBalance((PageQueryParams)params).getList();
            for (HistoricalBalanceDto dto : historicalBalanceDtoList) {
                if (!DateUtils.getDayStr((Date)dayDate).equals(DateUtils.getDayStr((Date)dto.getReportDate()))) continue;
                return Boolean.FALSE;
            }
        }
        if ((baseInfoCount = this.financeService.findBaseInfoCount()) == 0) {
            return Boolean.FALSE;
        }
        basePageParam.setMax(baseInfoCount);
        List<FinanceDto> financeDtoList = this.financeService.findAll(basePageParam).getList();
        params.setStartTime(this.getBeginTime(financeDtoList));
        params.setEndTime(FinanceDetailServiceImpl.getParamTime(-1, GetParamTimeEnum.END_TIME));
        financeDtoList = this.financeService.findByParam(params);
        ArrayList<BaiqiHistoricalBalanceEntity> list = new ArrayList<BaiqiHistoricalBalanceEntity>();
        for (FinanceDto dto : financeDtoList) {
            BaiqiHistoricalBalanceEntity baiqiHistoricalBalanceEntity = new BaiqiHistoricalBalanceEntity();
            baiqiHistoricalBalanceEntity.setRelationType(Integer.valueOf(dto.getRelationType().getCode()));
            baiqiHistoricalBalanceEntity.setRelationId(dto.getRelationId());
            baiqiHistoricalBalanceEntity.setReportDate(dto.getGmtCreate());
            baiqiHistoricalBalanceEntity.setTotalAmount(dto.getTotalAmount());
            baiqiHistoricalBalanceEntity.setCashAmount(dto.getCashAmount());
            baiqiHistoricalBalanceEntity.setRebateAmount(dto.getRebateAmount());
            baiqiHistoricalBalanceEntity.setReportDate(dayDate);
            list.add(baiqiHistoricalBalanceEntity);
        }
        return this.historicalBalanceMapper.historicalBalanceSync(list) > 0;
    }

    public static Date getParamTime(int date, GetParamTimeEnum timeType) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, date);
        calendar.set(11, timeType.getNum() == 0 ? 0 : 23);
        calendar.set(12, timeType.getNum() == 0 ? 0 : 59);
        calendar.set(13, timeType.getNum() == 0 ? 0 : 59);
        return calendar.getTime();
    }

    private Date getBeginTime(List<FinanceDto> list) {
        Date startTime = list.get(0).getGmtCreate();
        for (FinanceDto dto : list) {
            if (!startTime.after(dto.getGmtCreate())) continue;
            startTime = dto.getGmtCreate();
        }
        return startTime;
    }

    @Override
    public Integer findIncomeInfoCount() {
        return this.financeDetailMapper.findIncomeInfoCount();
    }

    @Override
    public Integer findHistoricalBalanceCount() {
        return this.historicalBalanceMapper.findHistoricalBalanceCount();
    }
}

