/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.finance;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.finance.FinanceDto;
import com.qiho.center.api.dto.finance.HistoricalBalanceDto;
import com.qiho.center.api.dto.merchant.MerchantDto;
import com.qiho.center.api.enums.account.BaiqiAccountTypeEnum;
import com.qiho.center.api.enums.finance.CashRebateAmountEnum;
import com.qiho.center.api.enums.finance.FinanceStatusEnum;
import com.qiho.center.api.enums.finance.FinanceTypeEnum;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.api.params.PageQueryParams;
import com.qiho.center.api.params.finance.BaiqiMerchantFreetextParam;
import com.qiho.center.api.params.finance.FinanceBasePageParam;
import com.qiho.center.biz.service.agent.BaiqiAgentService;
import com.qiho.center.biz.service.finance.FinanceService;
import com.qiho.center.biz.service.impl.finance.bean.CashRebateAmountBean;
import com.qiho.center.biz.service.merchant.MerchantService;
import com.qiho.center.common.dao.QihoMerchantDAO;
import com.qiho.center.common.daoh.qiho.agent.BaiqiAgentMapper;
import com.qiho.center.common.daoh.qiho.finance.BaiqiFinanceMapper;
import com.qiho.center.common.daoh.qiho.finance.BaiqiHistoricalBalanceMapper;
import com.qiho.center.common.entity.BaseEntity;
import com.qiho.center.common.entityd.qiho.agent.BaiqiAgentEntity;
import com.qiho.center.common.entityd.qiho.finance.BaiqiFinanceEntity;
import com.qiho.center.common.entityd.qiho.finance.BaiqiHistoricalBalanceEntity;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class FinanceServiceImpl
implements FinanceService {
    @Resource
    private BaiqiFinanceMapper baiqiFinanceMapper;
    @Resource
    private MerchantService merchantService;
    @Resource
    private BaiqiAgentService baiqiAgentService;
    @Resource
    private BaiqiHistoricalBalanceMapper historicalBalanceMapper;
    @Autowired
    private QihoMerchantDAO qihoMerchantDAO;
    @Autowired
    private BaiqiAgentMapper baiqiAgentMapper;

    @Override
    public Boolean insertFinance(FinanceDto dto) {
        if (dto.getRelationType() == null || dto.getRelationId() == null) {
            throw new QihoException("\u8d44\u91d1\u8d26\u6237\u672a\u6307\u5b9a\u5546\u5bb6\u6216\u4ee3\u7406\u5546");
        }
        BaiqiFinanceEntity entity = new BaiqiFinanceEntity();
        entity.setRelationType(Integer.valueOf(dto.getRelationType().getCode()));
        return this.baiqiFinanceMapper.insertAccountFinance(entity) > 0;
    }

    @Override
    public PagenationDto<FinanceDto> findAll(FinanceBasePageParam pageParam) {
        PagenationDto pagenationDto = new PagenationDto();
        if (StringUtils.isNotEmpty((CharSequence)pageParam.getMerchantName())) {
            List merchantEntityList = this.qihoMerchantDAO.listByMerchantName(pageParam.getMerchantName());
            if (CollectionUtils.isEmpty((Collection)merchantEntityList)) {
                return pagenationDto.emptyPage();
            }
            pageParam.setMerchantIdList(merchantEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList()));
        }
        if (StringUtils.isNotEmpty((CharSequence)pageParam.getAgentName())) {
            List baiqiAgentEntityList = this.baiqiAgentMapper.listByAgentName(pageParam.getAgentName());
            if (CollectionUtils.isEmpty((Collection)baiqiAgentEntityList)) {
                return pagenationDto.emptyPage();
            }
            pageParam.setAgentIdList(baiqiAgentEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList()));
        }
        Integer count = this.baiqiFinanceMapper.countPageMainAccount(pageParam);
        pagenationDto.setTotal(count);
        if (count == 0) {
            return pagenationDto.emptyPage();
        }
        List entities = this.baiqiFinanceMapper.findAll(pageParam);
        pagenationDto.setList(this.convertDtoList(entities));
        return pagenationDto;
    }

    private List<FinanceDto> convertDtoList(List<BaiqiFinanceEntity> entities) {
        if (CollectionUtils.isEmpty(entities)) {
            return Lists.newArrayList();
        }
        ArrayList<Long> merchantIds = new ArrayList<Long>();
        ArrayList<Long> agentIds = new ArrayList<Long>();
        this.setRelationIds(merchantIds, agentIds, entities);
        Map<Object, Object> merchantDtoMap = new HashMap();
        Map<Object, Object> agentMap = new HashMap();
        if (CollectionUtils.isNotEmpty(merchantIds)) {
            merchantDtoMap = this.merchantService.findByIdList(merchantIds);
        }
        if (CollectionUtils.isNotEmpty(agentIds)) {
            agentMap = this.baiqiAgentService.findByIdsMap(agentIds);
        }
        ArrayList<FinanceDto> financeDtos = new ArrayList<FinanceDto>();
        for (BaiqiFinanceEntity entity : entities) {
            Long relationId = entity.getRelationId();
            int relationType = entity.getRelationType();
            FinanceDto accountDto = this.entityToDto(entity);
            if (relationType == FinanceTypeEnum.AGENT_ACCOUNT.getCode()) {
                BaiqiAgentEntity agentEntity = (BaiqiAgentEntity)agentMap.get(relationId);
                accountDto.setName(agentEntity == null ? "" : agentEntity.getAgentName());
            } else {
                MerchantDto merchantDto = (MerchantDto)merchantDtoMap.get(relationId);
                accountDto.setName(merchantDto == null ? "" : merchantDto.getMerchantName());
            }
            financeDtos.add(accountDto);
        }
        return financeDtos;
    }

    @Override
    public FinanceDto findFinanceByMerchantId(long merchantId) {
        BaiqiFinanceEntity entity = this.baiqiFinanceMapper.selectByMerchantId(merchantId);
        return (FinanceDto)BeanUtils.copy((Object)entity, FinanceDto.class);
    }

    @Override
    public CashRebateAmountBean calcCashAndRebateAmount(Long financeId, Long amount, CashRebateAmountEnum opType) {
        Assert.notNull((Object)financeId, (String)"financeId\u4e3a\u7a7a");
        Assert.notNull((Object)amount, (String)"amount\u4e3a\u7a7a");
        BaiqiFinanceEntity financeEntity = this.baiqiFinanceMapper.findById(financeId);
        if (null == financeEntity) {
            return null;
        }
        CashRebateAmountBean amountBean = new CashRebateAmountBean();
        amountBean.setOpType(opType);
        if (0L == financeEntity.getTotalAmount()) {
            amountBean.setTotalAmount(Math.abs(amount));
            amountBean.setCashAmount(amountBean.getTotalAmount());
            amountBean.setRebateAmount(0L);
        } else {
            BigDecimal amountTmp = new BigDecimal(Math.abs(amount));
            BigDecimal amountTotal = new BigDecimal(Math.abs(financeEntity.getTotalAmount()));
            BigDecimal cashAmount = new BigDecimal(Math.abs(financeEntity.getCashAmount()));
            BigDecimal costCashTmp = cashAmount.divide(amountTotal, 10, 6).multiply(amountTmp);
            Long costCash = costCashTmp.setScale(0, RoundingMode.CEILING).longValue();
            amountBean.setTotalAmount(amountTmp.longValue());
            amountBean.setCashAmount(costCash);
            amountBean.setRebateAmount(amountTmp.longValue() - costCash);
        }
        return amountBean;
    }

    @Override
    public Boolean updateFinanceAmountById(Long financeId, CashRebateAmountBean cashRebateAmountBean) throws BizException {
        Assert.notNull((Object)cashRebateAmountBean, (String)"\u91d1\u989d\u4e3a\u7a7a");
        Assert.notNull((Object)cashRebateAmountBean.getTotalAmount(), (String)"\u603b\u91d1\u989d\u4e3a\u7a7a");
        Assert.notNull((Object)cashRebateAmountBean.getCashAmount(), (String)"\u73b0\u91d1\u4e3a\u7a7a");
        Assert.notNull((Object)cashRebateAmountBean.getRebateAmount(), (String)"\u8fd4\u70b9\u91d1\u989d\u4e3a\u7a7a");
        Assert.notNull((Object)cashRebateAmountBean.getOpType(), (String)"\u91d1\u989d\u64cd\u4f5c\u7c7b\u578b\u4e3a\u7a7a");
        BaiqiFinanceEntity financeEntity = this.baiqiFinanceMapper.findById(financeId);
        Assert.notNull((Object)financeEntity, (String)("\u8d26\u6237\u4e0d\u5b58\u5728. financeId:" + financeId));
        if (CashRebateAmountEnum.INCOME == cashRebateAmountBean.getOpType()) {
            financeEntity.setTotalAmount(Long.valueOf(financeEntity.getTotalAmount() + cashRebateAmountBean.getTotalAmount()));
            financeEntity.setCashAmount(Long.valueOf(financeEntity.getCashAmount() + cashRebateAmountBean.getCashAmount()));
            financeEntity.setRebateAmount(Long.valueOf(financeEntity.getRebateAmount() + cashRebateAmountBean.getRebateAmount()));
        } else {
            financeEntity.setTotalAmount(Long.valueOf(financeEntity.getTotalAmount() - cashRebateAmountBean.getTotalAmount()));
            financeEntity.setCashAmount(Long.valueOf(financeEntity.getCashAmount() - cashRebateAmountBean.getCashAmount()));
            financeEntity.setRebateAmount(Long.valueOf(financeEntity.getRebateAmount() - cashRebateAmountBean.getRebateAmount()));
        }
        if (1 == this.baiqiFinanceMapper.updateAmountById(financeEntity)) {
            return Boolean.TRUE;
        }
        throw new BizException("\u66f4\u65b0\u8d26\u6237\u91d1\u989d\u9519\u8bef");
    }

    @Override
    public BaiqiFinanceEntity findByRelation(FinanceTypeEnum typeEnum, Long relationId) {
        Assert.notNull((Object)relationId, (String)"\u5173\u8054id\u4e3a\u7a7a");
        Assert.notNull((Object)typeEnum, (String)"\u5173\u8054\u7c7b\u578b\u7a7a");
        return this.baiqiFinanceMapper.findByRelation(typeEnum.getCode(), relationId.longValue());
    }

    private FinanceDto entityToDto(BaiqiFinanceEntity entity) {
        FinanceDto financeDto = (FinanceDto)BeanUtils.copy((Object)entity, FinanceDto.class);
        financeDto.setRelationType(FinanceTypeEnum.getByCode((Integer)entity.getRelationType()));
        financeDto.setState(FinanceStatusEnum.getByCode((int)entity.getState()));
        return financeDto;
    }

    private void setRelationIds(List<Long> merchantIds, List<Long> agentIds, List<BaiqiFinanceEntity> entities) {
        for (BaiqiFinanceEntity entity : entities) {
            int accountType = entity.getRelationType();
            Long relationId = entity.getRelationId();
            if (accountType == BaiqiAccountTypeEnum.AGENT_ACCOUNT.getCode()) {
                agentIds.add(relationId);
                continue;
            }
            merchantIds.add(relationId);
        }
    }

    @Override
    public Integer findBaseInfoCount() {
        return this.baiqiFinanceMapper.findBaseInfoCount();
    }

    @Override
    public List<FinanceDto> findByParam(BaiqiMerchantFreetextParam pageParam) {
        List entities = this.baiqiFinanceMapper.findByParam(pageParam);
        List<FinanceDto> dtoList = this.entitiesToDtoList(entities);
        return dtoList;
    }

    private List<FinanceDto> entitiesToDtoList(List<BaiqiFinanceEntity> entities) {
        ArrayList<FinanceDto> dtoList = new ArrayList<FinanceDto>();
        for (BaiqiFinanceEntity entity : entities) {
            FinanceDto dto = new FinanceDto();
            dto.setRelationId(entity.getRelationId());
            dto.setRelationType(FinanceTypeEnum.getByCode((Integer)entity.getRelationType()));
            dto.setTotalAmount(entity.getTotalAmount());
            dto.setCashAmount(entity.getCashAmount());
            dto.setRebateAmount(entity.getRebateAmount());
            dto.setGmtCreate(entity.getGmtCreate());
            dto.setGmtModified(entity.getGmtModified());
            dtoList.add(dto);
        }
        return dtoList;
    }

    @Override
    public PagenationDto<HistoricalBalanceDto> findAllHistoricalBalance(PageQueryParams pageParam) {
        List entities = this.historicalBalanceMapper.findAll(pageParam);
        PagenationDto pagenationDto = new PagenationDto();
        if (CollectionUtils.isEmpty((Collection)entities)) {
            pagenationDto.setList(Collections.emptyList());
            pagenationDto.setTotal(Integer.valueOf(0));
            return pagenationDto;
        }
        pagenationDto.setTotal(Integer.valueOf(entities.size()));
        ArrayList<Long> merchantIds = new ArrayList<Long>();
        ArrayList<Long> agentIds = new ArrayList<Long>();
        this.setRelationIdsWithBaiqiHistoricalBalanceEntity(merchantIds, agentIds, entities);
        Map<Object, Object> merchantDtoMap = new HashMap();
        Map<Object, Object> agentMap = new HashMap();
        if (CollectionUtils.isNotEmpty(merchantIds)) {
            merchantDtoMap = this.merchantService.findByIdList(merchantIds);
        }
        if (CollectionUtils.isNotEmpty(agentIds)) {
            agentMap = this.baiqiAgentService.findByIdsMap(agentIds);
        }
        ArrayList<HistoricalBalanceDto> historicalBalanceDto = new ArrayList<HistoricalBalanceDto>();
        for (BaiqiHistoricalBalanceEntity entity : entities) {
            Long relationId = entity.getRelationId();
            int relationType = entity.getRelationType();
            HistoricalBalanceDto accountDto = (HistoricalBalanceDto)BeanUtils.copy((Object)entity, HistoricalBalanceDto.class);
            accountDto.setRelationType(FinanceTypeEnum.getByCode((Integer)entity.getRelationType()));
            if (relationType == FinanceTypeEnum.AGENT_ACCOUNT.getCode()) {
                BaiqiAgentEntity agentEntity = (BaiqiAgentEntity)agentMap.get(relationId);
                accountDto.setName(agentEntity == null ? null : agentEntity.getAgentName());
            } else {
                MerchantDto merchantDto = (MerchantDto)merchantDtoMap.get(relationId);
                accountDto.setName(merchantDto == null ? null : merchantDto.getMerchantName());
            }
            historicalBalanceDto.add(accountDto);
        }
        pagenationDto.setList(historicalBalanceDto);
        pagenationDto.setTotal(Integer.valueOf(historicalBalanceDto.size()));
        return pagenationDto;
    }

    private void setRelationIdsWithBaiqiHistoricalBalanceEntity(List<Long> merchantIds, List<Long> agentIds, List<BaiqiHistoricalBalanceEntity> entities) {
        for (BaiqiHistoricalBalanceEntity entity : entities) {
            int accountType = entity.getRelationType();
            Long relationId = entity.getRelationId();
            if (accountType == BaiqiAccountTypeEnum.AGENT_ACCOUNT.getCode()) {
                agentIds.add(relationId);
                continue;
            }
            merchantIds.add(relationId);
        }
    }
}

