/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.homepage;

import cn.com.duiba.stock.service.api.remoteservice.RemoteStockService;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.dto.ItemDto;
import com.qiho.center.api.dto.homepage.TabItemDto;
import com.qiho.center.api.enums.ItemStatusEnum;
import com.qiho.center.api.enums.TabItemStatusEnum;
import com.qiho.center.api.params.TabItemParams;
import com.qiho.center.api.params.TabItemQueryParam;
import com.qiho.center.biz.service.ItemSaleCountService;
import com.qiho.center.biz.service.ItemService;
import com.qiho.center.biz.service.homepage.TabItemService;
import com.qiho.center.biz.service.order.OrderSnapshotService;
import com.qiho.center.common.dao.QihoItemDAO;
import com.qiho.center.common.dao.QihoItemSkuDAO;
import com.qiho.center.common.dao.QihoTabItemDAO;
import com.qiho.center.common.entity.BaseEntity;
import com.qiho.center.common.entity.homepage.QihoTabItemEntity;
import com.qiho.center.common.entity.item.QihoItemSkuEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.javatuples.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TabItemServiceImpl
implements TabItemService {
    private static final Logger LOG = LoggerFactory.getLogger(TabItemServiceImpl.class);
    @Resource
    private QihoTabItemDAO qihoTabItemDAO;
    @Resource
    private ItemService itemService;
    @Resource
    private OrderSnapshotService orderSnapshotService;
    @Resource
    private ItemSaleCountService itemSaleCountService;
    @Resource
    private TabItemService tabItemService;
    @Resource
    private QihoItemDAO qihoItemDAO;
    @Resource
    private RemoteStockService remoteStockService;
    @Resource
    private QihoItemSkuDAO qihoItemSkuDAO;

    @Override
    public Integer saveTabItemList(List<TabItemParams> list) {
        if (CollectionUtils.isEmpty(list)) {
            return 0;
        }
        ArrayList entityList = Lists.newArrayList();
        list.stream().forEach(param -> {
            QihoTabItemEntity entity = this.qihoTabItemDAO.queryTabItemByTabIdAndItemId(param.getTabId(), param.getItemId());
            if (null == entity) {
                entity = new QihoTabItemEntity();
                entity.setItemId(param.getItemId());
                entity.setTabId(param.getTabId());
                entity.setDeleted(Integer.valueOf(0));
                entity.setTopPayload(Long.valueOf(0L));
                entity.setRecentlySaleNum(this.queryRecentThreeDaysSaleNum(entity.getItemId()));
                entityList.add(entity);
            }
        });
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            return 0;
        }
        return this.qihoTabItemDAO.batchInsertQihoTabItem((List)entityList);
    }

    private Integer queryRecentThreeDaysSaleNum(Long itemId) {
        Date startTime = DateUtils.getStartTime((Date)DateUtils.daysAddOrSub((Date)new Date(), (int)-3));
        Date endTime = DateUtils.getStartTime((Date)new Date());
        return this.orderSnapshotService.queryItemSaleCount(itemId, startTime, endTime);
    }

    @Override
    public Integer deleteTabItemByIdList(List<Long> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return 0;
        }
        return this.qihoTabItemDAO.deleteQihoTabItem(idList);
    }

    @Override
    @Transactional(value="QIHO")
    public Integer updateTabItemTopPayloadByList(List<Long> idList, Long tabId, Boolean top) {
        if (CollectionUtils.isEmpty(idList)) {
            return 0;
        }
        Long maxValue = null;
        if (top.booleanValue()) {
            Long max = this.qihoTabItemDAO.selectMaxPayload();
            maxValue = null == max ? (long)idList.size() : max + (long)idList.size();
        }
        for (Long id : idList) {
            QihoTabItemEntity entity = new QihoTabItemEntity();
            entity.setId(id);
            entity.setTopPayload(Long.valueOf(top != false ? maxValue : 0L));
            entity.setTabId(tabId);
            this.qihoTabItemDAO.updateTabItemTopPayload(entity);
            if (!top.booleanValue()) continue;
            Long l = maxValue;
            Long l2 = maxValue = Long.valueOf(maxValue - 1L);
        }
        return idList.size();
    }

    @Override
    public List<TabItemDto> findTabItemList(TabItemQueryParam params) {
        List list = this.qihoTabItemDAO.findQihoTabItemList(params);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (QihoTabItemEntity it : list) {
            map.put(it.getItemId(), it);
        }
        List<ItemDto> dtoList = this.itemService.findItemDtoByItemIds(map.keySet());
        HashMap itemDtoMap = Maps.newHashMap();
        dtoList.stream().forEach(dto -> itemDtoMap.put(dto.getId(), dto));
        return this.converToResult(list, itemDtoMap);
    }

    private List<TabItemDto> converToResult(List<QihoTabItemEntity> list, Map<Long, ItemDto> itemDtoMap) {
        ArrayList resultList = Lists.newArrayList();
        for (QihoTabItemEntity entity : list) {
            TabItemDto dto = new TabItemDto();
            dto.setId(entity.getId());
            dto.setItemId(entity.getItemId());
            dto.setTabId(entity.getTabId());
            dto.setRecentlySaleNum(entity.getRecentlySaleNum());
            dto.setTopPayload(entity.getTopPayload());
            dto.setTabItemStatus(entity.getTabItemStatus());
            dto.setStyleConfig(entity.getStyleConfig());
            ItemDto itemDto = itemDtoMap.get(entity.getItemId());
            if (null == itemDto) continue;
            dto.setItemNo(itemDto.getItemNo());
            dto.setImage(itemDto.getExtParamValue("image"));
            dto.setItemName(itemDto.getItemName());
            dto.setItemShortName(itemDto.getItemShortName());
            dto.setMinPrice(itemDto.getMinPrice());
            dto.setStock(itemDto.getStock());
            dto.setItemStatus(itemDto.getItemStatus());
            resultList.add(dto);
        }
        return resultList;
    }

    @Override
    public List<ItemDto> queryTabItemIndex(TabItemQueryParam params) {
        List list = this.qihoTabItemDAO.findQihoTabItemList(params);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        LinkedHashMap map = Maps.newLinkedHashMap();
        ArrayList itemList = Lists.newArrayList();
        for (QihoTabItemEntity it : list) {
            map.put(it.getItemId(), it);
            itemList.add(it.getItemId());
        }
        List<ItemDto> dtoList = this.itemService.findItemDtoByItemIds(map.keySet());
        Map<Long, Integer> saleMap = this.itemSaleCountService.queryItemSaleNum(itemList);
        List<TabItemDto> tabItemDtos = this.tabItemService.queryTabItemByTabIdAndItemIds(itemList, params.getTabId());
        ArrayList resultList = Lists.newArrayList();
        HashMap resultMap = Maps.newHashMap();
        for (ItemDto item : dtoList) {
            if (StringUtils.equals((CharSequence)"OFF", (CharSequence)item.getItemStatus()) || item.getStock().intValue() <= 0) continue;
            this.setStyle(item, tabItemDtos);
            item.setSaleNum(Integer.valueOf(null == saleMap.get(item.getId()) ? 0 : saleMap.get(item.getId())));
            item.setVirtualRemainRate(this.setVirRemain(item));
            resultMap.put(item.getId(), item);
        }
        map.entrySet().forEach(e -> {
            if (null != resultMap.get(e.getKey())) {
                resultList.add(resultMap.get(e.getKey()));
            }
        });
        return resultList;
    }

    private void setStyle(ItemDto item, List<TabItemDto> tabItemDtos) {
        for (TabItemDto dto : tabItemDtos) {
            if (!item.getId().equals(dto.getItemId())) continue;
            if (StringUtils.isNotBlank((CharSequence)dto.getStyleConfig())) {
                item.setStyleConfig(dto.getStyleConfig());
            }
            item.setTabItemStatus(dto.getTabItemStatus());
        }
    }

    private Double setVirRemain(ItemDto item) {
        Long stock = item.getEnableStock();
        if (stock == 0L) {
            return 0.0;
        }
        Long virStock = Long.valueOf(item.getExtParamValue("virtualStock") == null ? "0" : item.getExtParamValue("virtualStock"));
        if (virStock == 0L || virStock < stock) {
            virStock = this.itemService.updateVirtailStock(item.getId());
        }
        BigDecimal paramNs = new BigDecimal(virStock);
        BigDecimal itemStocks = new BigDecimal(stock);
        return itemStocks.divide(paramNs, 2, 4).doubleValue();
    }

    @Override
    public List<QihoTabItemEntity> queryAllItemListByPage(int offSet, int pageSize) {
        return this.qihoTabItemDAO.queryAllItemListByPage(offSet, pageSize);
    }

    @Override
    public Integer updateTabItem(QihoTabItemEntity enitiy) {
        return this.qihoTabItemDAO.updateTabItem(enitiy);
    }

    @Override
    public void updateStatus(List<Long> itemIds, Long tabId, Integer status, Long gmtModifier) {
        this.qihoTabItemDAO.updateStatus(itemIds, tabId, status, gmtModifier);
    }

    @Override
    public List<TabItemDto> queryTabItemByTabIdAndItemIds(List<Long> itemIdList, Long tabId) {
        List list = this.qihoTabItemDAO.queryTabItemByTabIdAndItemIds(tabId, itemIdList);
        return BeanUtils.copyList((List)list, TabItemDto.class);
    }

    @Override
    public Integer saveTabItem(TabItemParams params) {
        QihoTabItemEntity entity = this.qihoTabItemDAO.queryTabItemByTabIdAndItemId(params.getTabId(), params.getItemId());
        if (null == entity) {
            entity = new QihoTabItemEntity();
            entity.setItemId(params.getItemId());
            entity.setTabId(params.getTabId());
            entity.setDeleted(Integer.valueOf(0));
            entity.setTopPayload(Long.valueOf(0L));
            entity.setRecentlySaleNum(this.queryRecentThreeDaysSaleNum(entity.getItemId()));
            entity.setStyleConfig(params.getStyleConfig());
            return this.qihoTabItemDAO.insertQihoTabItem(entity);
        }
        entity.setStyleConfig(params.getStyleConfig());
        return this.qihoTabItemDAO.updateTabItem(entity);
    }

    @Override
    public Integer initTabItemStatus() {
        List qihoTabItemList = this.qihoTabItemDAO.findQihoTabItemList(new TabItemQueryParam());
        if (CollectionUtils.isEmpty((Collection)qihoTabItemList)) {
            LOG.info("\u67e5\u8be2tab\u5546\u54c1\u533a\u5185\u65e0\u5546\u54c1\u6570\u636e");
            return -1;
        }
        List itemIdList = qihoTabItemList.stream().map(QihoTabItemEntity::getItemId).distinct().collect(Collectors.toList());
        List itemDetailList = this.qihoItemDAO.findByIds(itemIdList);
        if (CollectionUtils.isEmpty((Collection)itemDetailList)) {
            LOG.info("\u67e5\u8be2\u6240\u6709\u5546\u54c1\u533a\u5185\u65e0\u5546\u54c1, itemIdList: {}", itemIdList);
            return -1;
        }
        List statusOnItemIdList = itemDetailList.stream().filter(e -> ItemStatusEnum.STATUS_ON.getCode().equals(e.getItemStatus())).map(BaseEntity::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(statusOnItemIdList)) {
            LOG.info("\u8fc7\u6ee4\u5546\u54c1\u540e\u65e0\u4e0a\u67b6\u5546\u54c1");
            return -1;
        }
        List skuList = this.qihoItemSkuDAO.getSkuByItemIds(statusOnItemIdList);
        if (CollectionUtils.isEmpty((Collection)skuList)) {
            LOG.info("\u67e5\u8be2sku\u5546\u54c1\u4e3a\u7a7a,  statusOnItemIdList: {}", statusOnItemIdList);
            return -1;
        }
        List stockIds = skuList.stream().map(QihoItemSkuEntity::getStockId).collect(Collectors.toList());
        Map stockMap = (Map)this.remoteStockService.findBatch(stockIds).getResult();
        Pair<Map, Map> stockPair = this.getSkuStockInfo(stockMap, skuList);
        Map itemStockMap = (Map)stockPair.getValue0();
        List itemIdsWithStockNot0 = statusOnItemIdList.stream().filter(e -> 0L != (Long)itemStockMap.get(e)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(itemIdsWithStockNot0)) {
            LOG.info("\u8fc7\u6ee4\u5e93\u5b58\u975e0\u7684\u5546\u54c1id\u4e3a\u7a7a");
            return -1;
        }
        return this.qihoTabItemDAO.updateStatus(itemIdsWithStockNot0, null, TabItemStatusEnum.STATUS_ON.getValue(), null);
    }

    private Pair<Map, Map> getSkuStockInfo(Map<Long, Long> stockMap, List<QihoItemSkuEntity> skuList) {
        HashMap itemStockMap = Maps.newHashMap();
        HashMap itemEnableStockMap = Maps.newHashMap();
        for (QihoItemSkuEntity skuEntity : skuList) {
            Long itemStock;
            Long itemId;
            Long stock = stockMap.get(skuEntity.getStockId());
            if (stock == null || stock <= 0L) {
                stock = 0L;
            }
            itemStockMap.put(itemId, (itemStock = (Long)itemStockMap.get(itemId = skuEntity.getItemId())) == null ? stock : itemStock + stock);
            if (!skuEntity.getSkuEnable().booleanValue()) continue;
            Long itemEnableStock = (Long)itemEnableStockMap.get(itemId);
            itemEnableStockMap.put(itemId, itemEnableStock == null ? stock : itemEnableStock + stock);
        }
        return Pair.with((Object)itemStockMap, (Object)itemEnableStockMap);
    }
}

