/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.logistics;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.qiho.center.biz.service.logistics.Express100LogisticsService;
import com.qiho.center.common.daoh.qiho.logistics.BaiqiLogisticsMapper;
import com.qiho.center.common.daoh.qiho.logistics.Express100LogisticsMapper;
import com.qiho.center.common.entityd.qiho.logistics.BaiqiLogisticsEntity;
import com.qiho.center.common.entityd.qiho.logistics.Express100LogisticsEntity;
import java.text.MessageFormat;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="express100LogisticsService")
public class Express100LogisticsServiceImpl
implements Express100LogisticsService {
    @Resource
    private Express100LogisticsMapper express100LogisticsMapper;
    @Resource
    private BaiqiLogisticsMapper baiqiLogisticsMapper;
    private static final String BAQILOGISTICSCODE_EXPRESS100LOGISTICS_KEY = "baqiLogisticsCode_Express100Logistics_{0}";
    private static final Cache<String, Express100LogisticsEntity> baiqi_express100_LogisticsLocalCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(15L, TimeUnit.MINUTES).build();

    @Override
    public Express100LogisticsEntity findByCode(String logisticsCode) {
        return this.express100LogisticsMapper.findByCode(logisticsCode);
    }

    @Override
    public Express100LogisticsEntity findByBaiqiLogisticsCode(String baiqiLogisticsCode) {
        BaiqiLogisticsEntity baiqiLogisticsEntity;
        String key = MessageFormat.format(BAQILOGISTICSCODE_EXPRESS100LOGISTICS_KEY, baiqiLogisticsCode);
        Express100LogisticsEntity entity = (Express100LogisticsEntity)baiqi_express100_LogisticsLocalCache.getIfPresent((Object)key);
        if (entity == null && (baiqiLogisticsEntity = this.baiqiLogisticsMapper.findByCode(baiqiLogisticsCode)) != null) {
            entity = this.express100LogisticsMapper.findByBaiqiLogisticsId(baiqiLogisticsEntity.getId());
            baiqi_express100_LogisticsLocalCache.put((Object)key, (Object)entity);
        }
        return entity;
    }
}

