/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.logistics;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.qiho.center.biz.service.logistics.ExpressBirdService;
import com.qiho.center.common.daoh.qiho.logistics.BaiqiExpressCodeMappingMapper;
import com.qiho.center.common.daoh.qiho.logistics.BaiqiLogisticsMapper;
import com.qiho.center.common.entityd.qiho.logistics.BaiqiExpressCodeMappingEntity;
import com.qiho.center.common.entityd.qiho.logistics.BaiqiLogisticsEntity;
import com.qiho.center.common.util.ExpressBirdProvideUtil;
import java.text.MessageFormat;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ExpressBirdServiceImpl
implements ExpressBirdService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExpressBirdServiceImpl.class);
    @Value(value="${kuaidiniao.express.key}")
    private static String key;
    @Autowired
    private BaiqiLogisticsMapper baiqiLogisticsMapper;
    @Autowired
    private BaiqiExpressCodeMappingMapper baiqiExpressCodeMapper;
    private static final String BAQILOGISTICSCODE_EXPRESSBIRDLOGISTICS_KEY = "baqiLogisticsCode_ExpressBirdLogistics_{0}";
    private static final Cache<String, BaiqiExpressCodeMappingEntity> baiqi_expressBird_LogisticsLocalCache;

    @Override
    public boolean checkExpressSign(String sign, String resData) {
        try {
            String createSign = ExpressBirdProvideUtil.encrypt((String)resData, (String)key, (String)"UTF-8");
            return sign.equals(createSign);
        }
        catch (Exception e) {
            LOGGER.warn("\u5feb\u9012\u9e1f\u7b7e\u540d\u6821\u9a8c\u5931\u8d25,error:" + e.getMessage());
            return false;
        }
    }

    @Override
    public boolean dealExpressStatus(String code, String postId, String status) {
        return false;
    }

    @Override
    public BaiqiExpressCodeMappingEntity findByBaiqiLogisticsCode(String logisticsCode, String expressPlatform) {
        BaiqiLogisticsEntity baiqiLogisticsEntity;
        String key = MessageFormat.format(BAQILOGISTICSCODE_EXPRESSBIRDLOGISTICS_KEY, logisticsCode);
        BaiqiExpressCodeMappingEntity entity = (BaiqiExpressCodeMappingEntity)baiqi_expressBird_LogisticsLocalCache.getIfPresent((Object)key);
        if (entity == null && (baiqiLogisticsEntity = this.baiqiLogisticsMapper.findByCode(logisticsCode)) != null) {
            entity = this.baiqiExpressCodeMapper.findByBaiqiLogisticsCodeAndCompany(baiqiLogisticsEntity.getId(), expressPlatform);
            baiqi_expressBird_LogisticsLocalCache.put((Object)key, (Object)entity);
        }
        return entity;
    }

    static {
        baiqi_expressBird_LogisticsLocalCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(15L, TimeUnit.MINUTES).build();
    }
}

