/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.logistics;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.base.Objects;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.logistics.LogisticsDto;
import com.qiho.center.api.dto.logistics.LogisticsNicknameDto;
import com.qiho.center.api.params.logitics.LogisticsQueryParam;
import com.qiho.center.biz.service.logistics.LogisticsService;
import com.qiho.center.common.daoh.qiho.logistics.BaiqiLogisticsMapper;
import com.qiho.center.common.daoh.qiho.logistics.BaiqiLogisticsNicknameMapper;
import com.qiho.center.common.entity.BaseEntity;
import com.qiho.center.common.entityd.qiho.logistics.BaiqiLogisticsEntity;
import com.qiho.center.common.entityd.qiho.logistics.BaiqiLogisticsNicknameEntity;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogisticsServiceImpl
implements LogisticsService {
    @Autowired
    private BaiqiLogisticsMapper baiqiLogisticsMapper;
    @Autowired
    private BaiqiLogisticsNicknameMapper baiqiLogisticsNicknameMapper;
    private static final String BAIQILOGISTICSLOCALCACHEKEY = "baiqiLogisticsLocalCacheKey";
    private static final Cache<String, List<BaiqiLogisticsEntity>> baiqiLogisticsLocalCache = CacheBuilder.newBuilder().maximumSize(5L).expireAfterWrite(10L, TimeUnit.MINUTES).build();

    @Override
    public PagenationDto<LogisticsDto> queryPage(LogisticsQueryParam param) {
        PagenationDto page = new PagenationDto();
        Integer total = this.baiqiLogisticsMapper.countByParam(param);
        page.setTotal(total);
        if (total == 0) {
            page.setList((List)Lists.newArrayList());
            return page;
        }
        List entityList = this.baiqiLogisticsMapper.findByParam(param);
        List logisticsIds = entityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List nicknameList = this.baiqiLogisticsNicknameMapper.findByList(logisticsIds);
        HashMap<Long, String> nicknameMap = new HashMap<Long, String>();
        for (BaiqiLogisticsNicknameEntity entity2 : nicknameList) {
            if (nicknameMap.get(entity2.getLogisticsId()) == null) {
                nicknameMap.put(entity2.getLogisticsId(), entity2.getNickname());
                continue;
            }
            nicknameMap.put(entity2.getLogisticsId(), (String)nicknameMap.get(entity2.getLogisticsId()) + "|" + entity2.getNickname());
        }
        List list = Lists.transform((List)entityList, entity -> {
            LogisticsDto dto = (LogisticsDto)BeanUtils.copy((Object)entity, LogisticsDto.class);
            dto.setNickname((String)nicknameMap.get(entity.getId()));
            return dto;
        });
        page.setList(list);
        return page;
    }

    @Override
    public List<LogisticsNicknameDto> findNickname(Long logisticsId) {
        List nicknameEntities = this.baiqiLogisticsNicknameMapper.findByLogisticsIdDesc(logisticsId);
        return BeanUtils.copyList((List)nicknameEntities, LogisticsNicknameDto.class);
    }

    @Override
    public List<BaiqiLogisticsEntity> findAll() {
        return this.baiqiLogisticsMapper.findAll();
    }

    @Override
    public Boolean addNickname(LogisticsNicknameDto dto) throws BizException {
        BaiqiLogisticsNicknameEntity entity = (BaiqiLogisticsNicknameEntity)BeanUtils.copy((Object)dto, BaiqiLogisticsNicknameEntity.class);
        Integer count = this.baiqiLogisticsNicknameMapper.countByParam(entity);
        if (count > 0) {
            throw new BizException("\u8be5\u5916\u90e8\u540d\u79f0\u5df2\u5b58\u5728");
        }
        this.baiqiLogisticsNicknameMapper.insertNickname(entity);
        return Boolean.TRUE;
    }

    @Override
    public Boolean deleteNickname(Long nicknameId) throws BizException {
        BaiqiLogisticsNicknameEntity nicknameEntity = this.baiqiLogisticsNicknameMapper.findById(nicknameId);
        if (Objects.equal(null, (Object)nicknameEntity)) {
            throw new BizException("\u8be5\u5916\u90e8\u540d\u79f0\u4e0d\u5b58\u5728");
        }
        this.baiqiLogisticsNicknameMapper.deleteNickname(nicknameId);
        return Boolean.TRUE;
    }

    @Override
    public List<BaiqiLogisticsEntity> findAllByCache() {
        List<BaiqiLogisticsEntity> list = (List<BaiqiLogisticsEntity>)baiqiLogisticsLocalCache.getIfPresent((Object)BAIQILOGISTICSLOCALCACHEKEY);
        if (CollectionUtils.isEmpty((Collection)list)) {
            list = this.findAll();
            baiqiLogisticsLocalCache.put((Object)BAIQILOGISTICSLOCALCACHEKEY, list);
        }
        return list;
    }

    @Override
    public BaiqiLogisticsEntity findByCode(String logisticsCode) {
        return this.baiqiLogisticsMapper.findByCode(logisticsCode);
    }

    @Override
    public BaiqiLogisticsEntity findById(Long id) {
        return this.baiqiLogisticsMapper.findById(id);
    }

    @Override
    public Boolean insertLogistics(LogisticsDto dto) {
        BaiqiLogisticsEntity entity = (BaiqiLogisticsEntity)BeanUtils.copy((Object)dto, BaiqiLogisticsEntity.class);
        return this.baiqiLogisticsMapper.insertLogistics(entity) == 1;
    }

    @Override
    public Boolean deleteLogistics(Long id) {
        return this.baiqiLogisticsMapper.deleteLogistics(id) == 1;
    }
}

