/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.merchant;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.dto.OpenInterfaceDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.merchant.MerchantDto;
import com.qiho.center.api.dto.merchant.MerchantSimpleDto;
import com.qiho.center.api.dto.merchant.MerchantSpacialDto;
import com.qiho.center.api.enums.finance.BaiqiCommercialTenantTypeEnum;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.api.params.MerchantQueryParams;
import com.qiho.center.api.params.OpenInterfaceQueryParams;
import com.qiho.center.biz.service.merchant.MerchantService;
import com.qiho.center.common.dao.QihoMerchantDAO;
import com.qiho.center.common.daoh.qiho.OpenInterfaceMapper;
import com.qiho.center.common.daoh.qiho.finance.BaiqiFinanceMapper;
import com.qiho.center.common.entity.merchant.QihoMerchantEntity;
import com.qiho.center.common.entityd.qiho.OpenInterfaceEntity;
import com.qiho.center.common.entityd.qiho.finance.BaiqiFinanceEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MerchantServiceImpl
implements MerchantService {
    @Autowired
    private QihoMerchantDAO qihoMerchantDAO;
    @Autowired
    private OpenInterfaceMapper openInterfaceMapper;
    @Resource
    private BaiqiFinanceMapper baiqiFinanceMapper;
    @Resource(name="stringRedisTemplate")
    private StringRedisTemplate redisTemplate;
    private static final String MERCHANT_CACHAE_KEY = "BAIQI_MERCHANT_NAMES";
    private LoadingCache<String, Map<Long, String>> merchantCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Map<Long, String>>(){

        public Map<Long, String> load(String key) throws Exception {
            List merchantList = MerchantServiceImpl.this.qihoMerchantDAO.findAllIdAndNames();
            HashMap map = Maps.newHashMap();
            merchantList.stream().forEach(e -> map.put(e.getId(), e.getMerchantName()));
            return map;
        }
    });

    @Override
    public MerchantDto findById(Long merchantId) {
        return (MerchantDto)BeanUtils.copy((Object)this.qihoMerchantDAO.getById(merchantId), MerchantDto.class);
    }

    @Override
    public Boolean saveMerchant(MerchantDto dto) throws BizException {
        if (null == dto) {
            return Boolean.FALSE;
        }
        QihoMerchantEntity merchantEntity = (QihoMerchantEntity)BeanUtils.copy((Object)dto, QihoMerchantEntity.class);
        QihoMerchantEntity oldMerchant = this.qihoMerchantDAO.findByMerchantName(dto.getMerchantName());
        if (merchantEntity.getId() == null) {
            if (oldMerchant != null) {
                throw new BizException("\u5546\u5bb6\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
            }
            this.createMerchant(merchantEntity);
        } else {
            if (oldMerchant != null && merchantEntity.getId().longValue() != oldMerchant.getId().longValue()) {
                throw new BizException("\u5546\u5bb6\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u4fdd\u5b58");
            }
            this.qihoMerchantDAO.updateMerchant(merchantEntity);
        }
        return Boolean.TRUE;
    }

    @Transactional(value="QIHO")
    private void createMerchant(QihoMerchantEntity merchantEntity) {
        merchantEntity.setVersionSign("v2.0");
        this.qihoMerchantDAO.insertMerchant(merchantEntity);
        BaiqiFinanceEntity financeEntity = new BaiqiFinanceEntity();
        financeEntity.setRelationId(merchantEntity.getId());
        financeEntity.setRelationType(Integer.valueOf(BaiqiCommercialTenantTypeEnum.MERCHANT.getType()));
        this.baiqiFinanceMapper.insertAccountFinance(financeEntity);
    }

    @Override
    public PagenationDto<MerchantDto> queryPage(MerchantQueryParams params) {
        PagenationDto page = new PagenationDto();
        if (params.getOffset() == null || params.getMax() == null) {
            page.setTotal(Integer.valueOf(0));
            return page;
        }
        Integer count = this.qihoMerchantDAO.countByQuery(params);
        page.setTotal(count);
        if (count == 0) {
            page.setList((List)Lists.newArrayList());
            return page;
        }
        List merchantDtoList = BeanUtils.copyList((List)this.qihoMerchantDAO.listByQuery(params), MerchantDto.class);
        page.setList(merchantDtoList);
        return page;
    }

    @Override
    public List<MerchantDto> findByName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return new ArrayList<MerchantDto>();
        }
        return BeanUtils.copyList((List)this.qihoMerchantDAO.listByName(name.trim()), MerchantDto.class);
    }

    @Override
    public MerchantDto findByItemId(Long itemId) {
        if (itemId == null || itemId < 1L) {
            throw new QihoException("\u5546\u54c1id\u65e0\u6548");
        }
        QihoMerchantEntity entity = this.qihoMerchantDAO.getByItemId(itemId);
        return (MerchantDto)BeanUtils.copy((Object)entity, MerchantDto.class);
    }

    @Override
    public Map<Long, MerchantDto> findByIdList(List<Long> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return Collections.emptyMap();
        }
        List qihoMerchantEntities = this.qihoMerchantDAO.listByIds(idList);
        HashMap<Long, MerchantDto> map = new HashMap<Long, MerchantDto>();
        if (CollectionUtils.isEmpty((Collection)qihoMerchantEntities)) {
            return map;
        }
        for (QihoMerchantEntity qihoMerchantEntity : qihoMerchantEntities) {
            MerchantDto merchantDto = (MerchantDto)BeanUtils.copy((Object)qihoMerchantEntity, MerchantDto.class);
            map.put(merchantDto.getId(), merchantDto);
        }
        return map;
    }

    @Override
    public List<MerchantSimpleDto> findAllIdAndNames() {
        return this.qihoMerchantDAO.findAllIdAndNames();
    }

    @Override
    public List<MerchantSimpleDto> findIdAndNamesByIds(List<Long> ids) {
        return this.qihoMerchantDAO.findIdAndNamesByIds(ids);
    }

    @Override
    public List<MerchantSpacialDto> findAll() {
        return BeanUtils.copyList((List)this.qihoMerchantDAO.findAll(), MerchantSpacialDto.class);
    }

    @Override
    public Map<Long, String> fetchNamesWithCache() {
        return (Map)this.merchantCache.getUnchecked((Object)"");
    }

    @Override
    public Map<Long, String> fetchNamesWithCache(Set<Long> idSet) {
        if (CollectionUtils.isEmpty(idSet)) {
            throw new IllegalArgumentException("\u53c2\u6570idSet\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Map allNames = (Map)this.merchantCache.getUnchecked((Object)"");
        HashMap resMap = Maps.newHashMap();
        idSet.stream().forEach(e -> resMap.put(e, allNames.get(e)));
        return resMap;
    }

    @Override
    public PagenationDto<OpenInterfaceDto> openInterfacePageQuery(OpenInterfaceQueryParams params) {
        PagenationDto page = new PagenationDto();
        Integer count = this.openInterfaceMapper.countByQuery(params);
        page.setTotal(count);
        if (count == 0) {
            return page;
        }
        List openInterfaceDtos = this.openInterfaceMapper.listByQuery(params);
        for (OpenInterfaceDto dto : openInterfaceDtos) {
            QihoMerchantEntity merchantEntity = this.qihoMerchantDAO.getById(dto.getMerchantId());
            if (merchantEntity == null || merchantEntity.getMerchantName() == null) continue;
            dto.setMerchantName(merchantEntity.getMerchantName());
        }
        page.setList(openInterfaceDtos);
        return page;
    }

    @Override
    public Boolean saveOpenInterface(OpenInterfaceDto dto) {
        if (null == dto) {
            return Boolean.FALSE;
        }
        OpenInterfaceEntity openInterfaceEntity = (OpenInterfaceEntity)BeanUtils.copy((Object)dto, OpenInterfaceEntity.class);
        return this.openInterfaceMapper.saveOpenInterface(openInterfaceEntity) == 1;
    }

    @Override
    public OpenInterfaceDto findByMerchantId(Long merchantId) {
        return (OpenInterfaceDto)BeanUtils.copy((Object)this.openInterfaceMapper.findByMerchantId(merchantId), OpenInterfaceDto.class);
    }

    @Override
    public OpenInterfaceDto findByAppKey(String appKey) {
        return (OpenInterfaceDto)BeanUtils.copy((Object)this.openInterfaceMapper.findByAppKey(appKey), OpenInterfaceDto.class);
    }

    @Override
    public List<MerchantSimpleDto> findNoOpenInterface(String merchantName) {
        List entityList = this.qihoMerchantDAO.listByName(merchantName);
        ArrayList<MerchantSimpleDto> simpleDtoList = new ArrayList<MerchantSimpleDto>();
        if (entityList == null || StringUtils.isBlank((CharSequence)merchantName)) {
            return simpleDtoList;
        }
        for (int i = 0; i < entityList.size(); ++i) {
            MerchantSimpleDto simpleDto = new MerchantSimpleDto();
            simpleDto.setId(((QihoMerchantEntity)entityList.get(i)).getId());
            simpleDto.setMerchantName(((QihoMerchantEntity)entityList.get(i)).getMerchantName());
            simpleDtoList.add(simpleDto);
        }
        OpenInterfaceQueryParams params = new OpenInterfaceQueryParams();
        params.setMax(this.openInterfaceMapper.countByQuery(params));
        List openInterfaceDtoList = this.openInterfacePageQuery(params).getList();
        if (openInterfaceDtoList != null) {
            ArrayList<MerchantSimpleDto> tempList = new ArrayList<MerchantSimpleDto>();
            for (int i = 0; i < openInterfaceDtoList.size(); ++i) {
                MerchantSimpleDto simpleDto = new MerchantSimpleDto();
                simpleDto.setId(((OpenInterfaceDto)openInterfaceDtoList.get(i)).getMerchantId());
                simpleDto.setMerchantName(((OpenInterfaceDto)openInterfaceDtoList.get(i)).getMerchantName());
                tempList.add(simpleDto);
            }
            simpleDtoList.removeAll(tempList);
        }
        return simpleDtoList;
    }

    @Override
    public Boolean updateOpenInterface(OpenInterfaceDto dto) {
        if (null == dto) {
            return Boolean.FALSE;
        }
        OpenInterfaceEntity openInterfaceEntity = (OpenInterfaceEntity)BeanUtils.copy((Object)dto, OpenInterfaceEntity.class);
        return this.openInterfaceMapper.updateOpenInterface(openInterfaceEntity) == 1;
    }

    @Override
    public Integer findHasAppKeyCount() {
        return this.openInterfaceMapper.countByQuery(null);
    }

    @Override
    public OpenInterfaceDto checkedAppKey(String appKey, String appSecret) {
        OpenInterfaceEntity openInterfaceEntity = new OpenInterfaceEntity();
        openInterfaceEntity.setAppkey(appKey);
        openInterfaceEntity.setAppsecret(appSecret);
        return this.openInterfaceMapper.checkedAppKey(openInterfaceEntity);
    }

    @Override
    public boolean updateVersionSign(String versionSign, Long id) {
        this.qihoMerchantDAO.updateVersionSign(versionSign, id);
        return Boolean.TRUE;
    }
}

