/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.operatelog;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.merchant.MerchantDto;
import com.qiho.center.api.dto.operatelog.BaiqiOperateLogDto;
import com.qiho.center.api.enums.account.BaiqiAccountTypeEnum;
import com.qiho.center.api.params.operatelog.BaiqOperateLogParams;
import com.qiho.center.biz.service.agent.BaiqiAgentService;
import com.qiho.center.biz.service.merchant.MerchantService;
import com.qiho.center.biz.service.operatelog.BaiqiOperateLogService;
import com.qiho.center.common.daoh.qiho.operatelog.BaiqiOperateLogMapper;
import com.qiho.center.common.entityd.qiho.agent.BaiqiAgentEntity;
import com.qiho.center.common.entityd.qiho.operatelog.BaiqiOperateLogEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service(value="baiqiOperateLogService")
public class BaiqiOperateLogServiceImpl
implements BaiqiOperateLogService {
    @Resource
    private BaiqiOperateLogMapper baiqiOperateLogMapper;
    @Resource
    private MerchantService merchantService;
    @Resource
    private BaiqiAgentService baiqiAgentService;

    @Override
    public Boolean insertLog(BaiqiOperateLogEntity operateLogEntity) {
        return this.baiqiOperateLogMapper.insertLog(operateLogEntity) == 1;
    }

    @Override
    public PagenationDto<BaiqiOperateLogDto> findLogPage(BaiqOperateLogParams operateLogParams) {
        PagenationDto pagenationDto = new PagenationDto();
        List logEntities = this.baiqiOperateLogMapper.findLogPage(operateLogParams);
        if (CollectionUtils.isEmpty((Collection)logEntities)) {
            pagenationDto.setList(Collections.emptyList());
            pagenationDto.setTotal(Integer.valueOf(0));
            return pagenationDto;
        }
        HashSet<Long> agentIds = new HashSet<Long>();
        HashSet<Long> merchantIds = new HashSet<Long>();
        for (BaiqiOperateLogEntity operateLogEntity : logEntities) {
            int type = operateLogEntity.getRelationType();
            Long relationId = operateLogEntity.getRelationId();
            if (type == BaiqiAccountTypeEnum.AGENT_ACCOUNT.getCode()) {
                agentIds.add(relationId);
                continue;
            }
            merchantIds.add(relationId);
        }
        Map<Long, BaiqiAgentEntity> agentMap = this.baiqiAgentService.findByIdsMap(Lists.newArrayList(agentIds));
        Map<Long, MerchantDto> maerchantMap = this.merchantService.findByIdList(Lists.newArrayList(merchantIds));
        ArrayList<BaiqiOperateLogDto> result = new ArrayList<BaiqiOperateLogDto>();
        for (BaiqiOperateLogEntity entity : logEntities) {
            BaiqiOperateLogDto logDto = (BaiqiOperateLogDto)BeanUtils.copy((Object)entity, BaiqiOperateLogDto.class);
            int type = entity.getRelationType();
            Long relationId = entity.getRelationId();
            if (type == BaiqiAccountTypeEnum.AGENT_ACCOUNT.getCode()) {
                BaiqiAgentEntity agentEntity = agentMap.get(relationId);
                logDto.setRelationName(agentEntity == null ? null : agentEntity.getAgentName());
            } else {
                MerchantDto merchantDto = maerchantMap.get(relationId);
                logDto.setRelationName(merchantDto == null ? null : merchantDto.getMerchantName());
            }
            result.add(logDto);
        }
        int total = this.baiqiOperateLogMapper.countPage(operateLogParams);
        pagenationDto.setList(result);
        pagenationDto.setTotal(Integer.valueOf(total));
        return pagenationDto;
    }
}

