/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.order;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.AfterSaleOrderDto;
import com.qiho.center.api.dto.AfterSaleStageDto;
import com.qiho.center.api.enums.AfterSaleOrderStageEnum;
import com.qiho.center.api.enums.AfterSaleOrderStatusEnum;
import com.qiho.center.api.enums.AfterSaleOrderTypeEnum;
import com.qiho.center.api.enums.FundBizTypeEnum;
import com.qiho.center.api.enums.FundStatusEnum;
import com.qiho.center.api.enums.OrderStatusEnum;
import com.qiho.center.api.enums.PayTypeEnum;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.api.params.AfterSaleQueryParams;
import com.qiho.center.api.util.JSONUtil;
import com.qiho.center.biz.event.OrderClosedEvent;
import com.qiho.center.biz.paychannel.pay.PayChannelDecider;
import com.qiho.center.biz.paychannel.pay.PayChannelProcessor;
import com.qiho.center.biz.service.order.AfterSaleOrderService;
import com.qiho.center.common.dao.QihoAfterSaleOrderDAO;
import com.qiho.center.common.dao.QihoFundOrderDAO;
import com.qiho.center.common.dao.QihoOrderDAO;
import com.qiho.center.common.dao.QihoOrderSnapshotDAO;
import com.qiho.center.common.entity.fund.QihoFundOrderEntity;
import com.qiho.center.common.entity.order.QihoAfterSaleOrderEntity;
import com.qiho.center.common.entity.order.QihoOrderEntity;
import com.qiho.center.common.entity.order.QihoOrderSnapshotEntity;
import com.qiho.center.common.enums.SeqBizTypeEnum;
import com.qiho.center.common.support.BizEventBus;
import com.qiho.center.common.support.SequenceNoBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AfterSaleOrderServiceImpl
implements AfterSaleOrderService {
    @Autowired
    private QihoAfterSaleOrderDAO qihoAfterSaleOrderDAO;
    @Autowired
    private QihoOrderDAO qihoOrderDAO;
    @Autowired
    private SequenceNoBuilder sequenceNoBuilder;
    @Autowired
    private PayChannelDecider payChannelDecider;
    @Autowired
    private QihoFundOrderDAO qihoFundOrderDAO;
    @Resource
    private QihoOrderSnapshotDAO qihoOrderSnapshotDAO;
    @Autowired
    private BizEventBus eventBus;

    @Override
    public List<AfterSaleOrderDto> findByOrderId(String orderId) {
        List entitys = this.qihoAfterSaleOrderDAO.findByOrderId(orderId);
        if (CollectionUtils.isEmpty((Collection)entitys)) {
            return new ArrayList<AfterSaleOrderDto>();
        }
        return entitys.stream().map(this::convertToDto).collect(Collectors.toList());
    }

    @Override
    @Transactional(value="QIHO")
    public Boolean updateAfterSaleOrder(AfterSaleOrderDto dto) {
        QihoAfterSaleOrderEntity entity = (QihoAfterSaleOrderEntity)BeanUtils.copy((Object)dto, QihoAfterSaleOrderEntity.class);
        String afterSaleId = dto.getAfterSaleId();
        List needProcessStage = dto.getDetailStage();
        QihoAfterSaleOrderEntity afterSaleOrderEntity = this.qihoAfterSaleOrderDAO.queryAfterSaleById(afterSaleId);
        if (null == afterSaleOrderEntity) {
            throw new QihoException("\u9700\u8981\u66f4\u65b0\u7684\u552e\u540e\u5b50\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        String orderId = afterSaleOrderEntity.getOrderId();
        String newMETAValue = this.updateMetaValue(afterSaleOrderEntity, needProcessStage);
        entity.setMetaValue(newMETAValue);
        this.qihoAfterSaleOrderDAO.updateAfterSaleOrder(entity);
        if (StringUtils.isBlank((CharSequence)dto.getAfterSaleStatus())) {
            return Boolean.TRUE;
        }
        switch (AfterSaleOrderStatusEnum.getByCode((String)dto.getAfterSaleStatus())) {
            case AFTER_SALEING: {
                List<QihoFundOrderEntity> fundOrderEntities = this.createAfterSaleFunder(afterSaleOrderEntity);
                fundOrderEntities.forEach(e -> {
                    String payType = e.getPayType();
                    String bizType = e.getBizType();
                    PayTypeEnum payTypeEnum = PayTypeEnum.getEnumByCode((String)payType);
                    FundBizTypeEnum fundBizTypeEnum = FundBizTypeEnum.getByCode((String)bizType);
                    if (fundBizTypeEnum == FundBizTypeEnum.REFREIGHT || payTypeEnum == PayTypeEnum.COD) {
                        PayChannelProcessor payChannelProcessor = this.payChannelDecider.decidePayChannel(PayTypeEnum.ALIPAY);
                        payChannelProcessor.transAccount(e.getAccount(), e.getFundId(), e.getAmt());
                    } else {
                        PayChannelProcessor payChannelProcessor = this.payChannelDecider.decidePayChannel(payTypeEnum);
                        payChannelProcessor.refund(e.getOrderId(), e.getFundId(), e.getAmt());
                    }
                });
                break;
            }
            case SUCCESS: {
                QihoOrderEntity qihoOrderEntity = new QihoOrderEntity();
                qihoOrderEntity.setOrderId(orderId);
                qihoOrderEntity.setOrderStatus(OrderStatusEnum.CLOSED.getCode());
                qihoOrderEntity.setRemark("\u9000\u8d27\u5b8c\u6210");
                this.qihoOrderDAO.updateByOrderId(qihoOrderEntity);
                QihoOrderSnapshotEntity qihoOrderSnapshotEntity = new QihoOrderSnapshotEntity();
                qihoOrderSnapshotEntity.setOrderId(orderId);
                qihoOrderSnapshotEntity.setOrderStatus(OrderStatusEnum.CLOSED.getCode());
                qihoOrderSnapshotEntity.setRemark("\u9000\u8d27\u5b8c\u6210");
                this.qihoOrderSnapshotDAO.updateByOrderId(qihoOrderSnapshotEntity);
                OrderClosedEvent orderClosedEvent = new OrderClosedEvent();
                orderClosedEvent.setOrderId(orderId);
                this.eventBus.post((Object)orderClosedEvent);
                break;
            }
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean updateAfterSaleMetaValue(AfterSaleOrderDto dto) {
        QihoAfterSaleOrderEntity entity = (QihoAfterSaleOrderEntity)BeanUtils.copy((Object)dto, QihoAfterSaleOrderEntity.class);
        JSONObject extjson = new JSONObject();
        String detailStageStr = JSONObject.toJSONString((Object)dto.getDetailStage());
        extjson.put("detailStage", (Object)detailStageStr);
        entity.setMetaValue(extjson.toJSONString());
        return this.qihoAfterSaleOrderDAO.updateAfterSaleMetaValue(entity) > 0;
    }

    @Override
    public Boolean openAfterSale(String orderId) {
        List list = this.qihoAfterSaleOrderDAO.findByOrderId(orderId);
        return !CollectionUtils.isEmpty((Collection)list);
    }

    @Override
    public Boolean sponsorAfterSale(String orderId) {
        QihoOrderEntity order = this.qihoOrderDAO.findByOrderId(orderId);
        if (!StringUtils.equals((CharSequence)order.getOrderStatus(), (CharSequence)OrderStatusEnum.SUCCESS.getCode())) {
            return Boolean.FALSE;
        }
        long days = (new Date().getTime() - order.getGmtModified().getTime()) / 86400000L;
        if (days >= 31L) {
            return Boolean.FALSE;
        }
        QihoAfterSaleOrderEntity afterSaleOrder = this.qihoAfterSaleOrderDAO.findUnfinished(orderId);
        if (afterSaleOrder != null) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public List<AfterSaleOrderDto> findAll(String orderId) {
        List entityList = this.qihoAfterSaleOrderDAO.findAll(orderId);
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            return Lists.newArrayList();
        }
        return entityList.stream().map(this::convertToDto).collect(Collectors.toList());
    }

    @Override
    public List<AfterSaleOrderDto> findAfterSaleByQuery(AfterSaleQueryParams params) {
        List entities = this.qihoAfterSaleOrderDAO.findAfterSaleByQuery(params);
        if (CollectionUtils.isEmpty((Collection)entities)) {
            return Lists.newArrayList();
        }
        List<AfterSaleOrderDto> afterSaleOrderList = entities.stream().map(e -> {
            AfterSaleOrderDto afterSaleOrderDto = (AfterSaleOrderDto)BeanUtils.copy((Object)e, AfterSaleOrderDto.class);
            afterSaleOrderDto.setRefreightAmt(e.getFreightAmt());
            return afterSaleOrderDto;
        }).collect(Collectors.toList());
        afterSaleOrderList.forEach(e -> e.setDetailStage(JSONUtil.parseJSONStrToList((String)"detailStage", (String)e.getMetaValue(), AfterSaleStageDto.class)));
        return afterSaleOrderList;
    }

    @Override
    public Integer countAfterSaleByQuery(AfterSaleQueryParams params) {
        return this.qihoAfterSaleOrderDAO.countAfterSaleByQuery(params);
    }

    @Override
    @Transactional(value="QIHO")
    public String save(AfterSaleOrderDto dto) {
        QihoAfterSaleOrderEntity entity = (QihoAfterSaleOrderEntity)BeanUtils.copy((Object)dto, QihoAfterSaleOrderEntity.class);
        entity.setFreightAmt(dto.getRefreightAmt());
        String orderId = dto.getOrderId();
        String bizId = StringUtils.substring((String)orderId, (int)(StringUtils.indexOf((CharSequence)orderId, (CharSequence)SeqBizTypeEnum.ORDER.getCode()) + 1));
        String afterSaleId = this.sequenceNoBuilder.createSeqNo(SeqBizTypeEnum.AFTER_SALE, Long.valueOf(bizId));
        entity.setAfterSaleId(afterSaleId);
        entity.setAfterSaleStatus(AfterSaleOrderStatusEnum.TO_COMFIRM.getCode());
        List allFundOrderEntitys = this.qihoFundOrderDAO.findByOrderIdAndBizType(orderId, FundBizTypeEnum.PAY.getCode());
        if (CollectionUtils.isEmpty((Collection)allFundOrderEntitys)) {
            throw new QihoException("\u901a\u8fc7\u8ba2\u5355id\u67e5\u8be2\u4e0d\u5230\u8d44\u91d1\u5b50\u8ba2\u5355");
        }
        String payType = ((QihoFundOrderEntity)allFundOrderEntitys.get(0)).getPayType();
        entity.setPayType(payType);
        dto.setPayType(payType);
        dto.setAfterSaleId(afterSaleId);
        if (StringUtils.isBlank((CharSequence)dto.getAccount())) {
            dto.setAccount(((QihoFundOrderEntity)allFundOrderEntitys.get(0)).getAccount());
        }
        List afterSaleStageDtos = dto.getDetailStage();
        JSONObject metaValueJSON = new JSONObject();
        metaValueJSON.put("detailStage", (Object)JSONObject.toJSONString((Object)afterSaleStageDtos));
        entity.setMetaValue(metaValueJSON.toJSONString());
        entity.setFreightAmt(dto.getRefreightAmt());
        this.qihoAfterSaleOrderDAO.save(entity);
        return afterSaleId;
    }

    @Override
    public AfterSaleOrderDto queryAfterSaleById(String afterSaleId) {
        QihoAfterSaleOrderEntity entity = this.qihoAfterSaleOrderDAO.queryAfterSaleById(afterSaleId);
        if (null == entity) {
            return new AfterSaleOrderDto();
        }
        AfterSaleOrderDto afterSaleOrderDto = (AfterSaleOrderDto)BeanUtils.copy((Object)entity, AfterSaleOrderDto.class);
        List detailStage = JSONUtil.parseJSONStrToList((String)"detailStage", (String)afterSaleOrderDto.getMetaValue(), AfterSaleStageDto.class);
        afterSaleOrderDto.setDetailStage(detailStage);
        return afterSaleOrderDto;
    }

    @Override
    public List<AfterSaleOrderDto> queryAfterSaleByIds(List<String> afterSaleIds) {
        List entities = this.qihoAfterSaleOrderDAO.queryAfterSaleByIds(afterSaleIds);
        if (CollectionUtils.isEmpty((Collection)entities)) {
            return new ArrayList<AfterSaleOrderDto>();
        }
        List afterSaleOrderDtos = BeanUtils.copyList((List)entities, AfterSaleOrderDto.class);
        for (AfterSaleOrderDto dto : afterSaleOrderDtos) {
            List detailStage = JSONUtil.parseJSONStrToList((String)"detailStage", (String)dto.getMetaValue(), AfterSaleStageDto.class);
            dto.setDetailStage(detailStage);
        }
        return afterSaleOrderDtos;
    }

    @Override
    public Boolean updateLogistics(AfterSaleOrderDto afterSaleOrderDto) {
        AfterSaleOrderDto afterSaleOrder = this.queryAfterSaleById(afterSaleOrderDto.getAfterSaleId());
        afterSaleOrder.setLogisticsName(afterSaleOrderDto.getLogisticsName());
        afterSaleOrder.setPostId(afterSaleOrderDto.getPostId());
        boolean flag = true;
        AfterSaleStageDto logisticsStage = (AfterSaleStageDto)afterSaleOrderDto.getDetailStage().get(0);
        for (AfterSaleStageDto stage : afterSaleOrder.getDetailStage()) {
            if (!StringUtils.equals((CharSequence)stage.getType(), (CharSequence)AfterSaleOrderStageEnum.SUBMIT_LOGISTICS.getCode())) continue;
            flag = false;
            break;
        }
        if (flag) {
            afterSaleOrder.getDetailStage().add(logisticsStage);
        }
        QihoAfterSaleOrderEntity entity = (QihoAfterSaleOrderEntity)BeanUtils.copy((Object)afterSaleOrder, QihoAfterSaleOrderEntity.class);
        JSONObject metaJson = new JSONObject();
        metaJson.put("detailStage", (Object)JSON.toJSONString((Object)afterSaleOrder.getDetailStage()));
        entity.setMetaValue(metaJson.toJSONString());
        return this.qihoAfterSaleOrderDAO.updateAfterSaleOrder(entity) > 0;
    }

    private AfterSaleOrderDto convertToDto(QihoAfterSaleOrderEntity entity) {
        AfterSaleOrderDto dto = (AfterSaleOrderDto)BeanUtils.copy((Object)entity, AfterSaleOrderDto.class);
        dto.setRefreightAmt(entity.getFreightAmt());
        String mateValue = entity.getMetaValue();
        if (StringUtils.isNotBlank((CharSequence)mateValue)) {
            dto.setDetailStage(JSONUtil.parseJSONStrToList((String)"detailStage", (String)mateValue, AfterSaleStageDto.class));
        }
        return dto;
    }

    private List<QihoFundOrderEntity> createAfterSaleFunder(QihoAfterSaleOrderEntity afterSaleEntity) {
        ArrayList<QihoFundOrderEntity> resultFundList = new ArrayList<QihoFundOrderEntity>();
        if (null == afterSaleEntity) {
            return resultFundList;
        }
        String orderId = afterSaleEntity.getOrderId();
        Integer refundAmt = afterSaleEntity.getRefundAmt();
        Integer freightAmt = afterSaleEntity.getFreightAmt();
        String payType = afterSaleEntity.getPayType();
        String afterSaleId = afterSaleEntity.getAfterSaleId();
        QihoFundOrderEntity entity = new QihoFundOrderEntity();
        String account = afterSaleEntity.getAccount();
        entity.setOrderId(orderId);
        String bizId = StringUtils.substring((String)orderId, (int)(StringUtils.indexOf((CharSequence)orderId, (CharSequence)SeqBizTypeEnum.ORDER.getCode()) + 1));
        if (refundAmt >= 10) {
            QihoFundOrderEntity refundEntity = this.createFundOrder(orderId, bizId, payType, refundAmt, afterSaleId, FundBizTypeEnum.REFUND, SeqBizTypeEnum.FUND, account);
            resultFundList.add(refundEntity);
        }
        if (AfterSaleOrderTypeEnum.getByCode((String)afterSaleEntity.getAfterSaleType()) == AfterSaleOrderTypeEnum.RETURN_AND_FREIGHT) {
            QihoFundOrderEntity freightFundEntity = this.createFundOrder(orderId, bizId, PayTypeEnum.ALIPAY.getCode(), freightAmt, afterSaleId, FundBizTypeEnum.REFREIGHT, SeqBizTypeEnum.FUND, account);
            resultFundList.add(freightFundEntity);
        }
        return resultFundList;
    }

    private QihoFundOrderEntity createFundOrder(String orderId, String bizId, String payType, Integer amt, String afterSaleId, FundBizTypeEnum bizType, SeqBizTypeEnum fundIdType, String account) {
        String fundId = this.sequenceNoBuilder.createSeqNo(fundIdType, Long.valueOf(bizId));
        QihoFundOrderEntity entity = new QihoFundOrderEntity();
        entity.setOrderId(orderId);
        entity.setFundId(fundId);
        entity.setPayType(payType);
        entity.setAmt(amt);
        entity.setFundStatus(FundStatusEnum.TO_PAY.getCode());
        entity.setBizType(bizType.getCode());
        entity.setAftersaleId(afterSaleId);
        entity.setAccount(account);
        this.qihoFundOrderDAO.initFundOrder(entity);
        return entity;
    }

    private String updateMetaValue(QihoAfterSaleOrderEntity afterSaleOrderEntity, List<AfterSaleStageDto> needAfterSaleStageDtos) {
        String metaValueStr = afterSaleOrderEntity.getMetaValue();
        if (StringUtils.isNotBlank((CharSequence)metaValueStr)) {
            List afterSaleStageDtos = JSONUtil.parseJSONStrToList((String)"detailStage", (String)metaValueStr, AfterSaleStageDto.class);
            afterSaleStageDtos.addAll(needAfterSaleStageDtos);
            JSONObject metaValueJson = new JSONObject();
            metaValueJson.put("detailStage", (Object)JSON.toJSONString((Object)afterSaleStageDtos));
            return metaValueJson.toJSONString();
        }
        return new JSONObject().toJSONString();
    }
}

