/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.order;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.order.DeliveryRecordDto;
import com.qiho.center.api.enums.DeliveryRecordStateEnum;
import com.qiho.center.api.params.DeliveryRecordQueryParams;
import com.qiho.center.biz.job.OrderFileDeliveryJob;
import com.qiho.center.biz.service.order.DeliveryRecordService;
import com.qiho.center.common.daoh.qiho.order.DeliveryRecordMapper;
import com.qiho.center.common.entityd.qiho.order.DeliveryRecordEntity;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeliveryRecordServiceImpl
implements DeliveryRecordService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeliveryRecordServiceImpl.class);
    @Autowired
    DeliveryRecordMapper deliveryRecordMapper;
    @Resource
    private ExecutorService executorService;
    @Resource
    private OrderFileDeliveryJob orderFileDeliveryJob;

    @Override
    public Boolean insertDeliveryRecord(DeliveryRecordDto dto) throws BizException {
        DeliveryRecordEntity entity = (DeliveryRecordEntity)BeanUtils.copy((Object)dto, DeliveryRecordEntity.class);
        try {
            if (0 == this.deliveryRecordMapper.insertDeliveryRecord(entity)) {
                return Boolean.FALSE;
            }
            this.executorService.execute(new OrderFileDeliveryJobRunnable(this.orderFileDeliveryJob));
            return Boolean.TRUE;
        }
        catch (Exception e) {
            LOGGER.error("\u4e0a\u4f20\u7269\u6d41\u5355\u53f7\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
            throw new BizException("\u4fdd\u5b58\u5931\u8d25");
        }
    }

    @Override
    public PagenationDto<DeliveryRecordDto> deliveryRecordPageQuery(DeliveryRecordQueryParams params) {
        PagenationDto page = new PagenationDto();
        if (params.getOffset() == null || params.getMax() == null) {
            page.setTotal(Integer.valueOf(0));
            return page;
        }
        Integer count = this.deliveryRecordMapper.countByQuery(params);
        page.setTotal(count);
        if (count == 0) {
            return page;
        }
        List deliveryRecordDtoList = BeanUtils.copyList((List)this.deliveryRecordMapper.listByQuery(params), DeliveryRecordDto.class);
        for (DeliveryRecordDto dto : deliveryRecordDtoList) {
            if (dto.getState() == DeliveryRecordStateEnum.NEW.getCode()) {
                dto.setRemark("\u672a\u5f00\u59cb");
                continue;
            }
            if (dto.getState() == DeliveryRecordStateEnum.RUNNING.getCode()) {
                dto.setRemark("\u6b63\u5728\u5904\u7406\uff0c\u8bf7\u7a0d\u5019 (" + (dto.getSucceedCount() + dto.getFailedCount() + dto.getUpdatedCount()) + "/" + dto.getTotalCount() + ")");
                continue;
            }
            if (dto.getState() != DeliveryRecordStateEnum.COMPLETE.getCode()) continue;
            String recordType = dto.getRecordType() == 1 ? "\u786e\u8ba4\u53d1\u8d27" : "\u53d6\u6d88\u53d1\u8d27";
            StringBuilder remark = new StringBuilder();
            int failedCount = dto.getFailedCount();
            int succeedCount = dto.getSucceedCount();
            int updatedCount = dto.getUpdatedCount();
            String failedList = dto.getRemark();
            remark.append(recordType).append("\u6210\u529f").append(succeedCount).append("\u4e2a\uff0c\u66f4\u65b0\u7269\u6d41").append(updatedCount).append("\u4e2a\uff0c").append(recordType).append("\u5931\u8d25").append(failedCount).append("\u4e2a\uff0c\u8bf7\u68c0\u67e5\u4e0a\u4f20\u6587\u4ef6\u4e2d").append(recordType).append("\u5931\u8d25\u6570\u636e\uff08\u6570\u5b57\u8868\u793a\u884c\u6570\uff09:").append(failedList);
            dto.setRemark(remark.toString());
        }
        page.setList(deliveryRecordDtoList);
        return page;
    }

    @Override
    public int findTodayCount(Long merchantId) {
        Calendar startTime = Calendar.getInstance();
        startTime.set(11, 0);
        startTime.set(12, 0);
        startTime.set(13, 0);
        startTime.set(14, 0);
        Calendar endTime = Calendar.getInstance();
        endTime.set(11, 23);
        endTime.set(12, 59);
        endTime.set(13, 59);
        endTime.set(14, 999);
        return this.deliveryRecordMapper.findTodayCount(merchantId, startTime.getTime(), endTime.getTime());
    }

    static class OrderFileDeliveryJobRunnable
    implements Runnable {
        private final OrderFileDeliveryJob orderFileDeliveryJob;

        OrderFileDeliveryJobRunnable(OrderFileDeliveryJob orderFileDeliveryJob) {
            this.orderFileDeliveryJob = orderFileDeliveryJob;
        }

        @Override
        public void run() {
            try {
                this.orderFileDeliveryJob.doStart();
            }
            catch (Exception e) {
                LOGGER.warn("\u4e0a\u4f20\u7269\u6d41\u5355\u53f7\u542f\u52a8\u4efb\u52a1\u9519\u8bef", (Throwable)e);
            }
        }
    }
}

