/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.order;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.ErpOrderDto;
import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.enums.ErpStatusEnum;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.api.params.ErpOrderPageParams;
import com.qiho.center.biz.service.impl.OrderStockService;
import com.qiho.center.biz.service.order.ErpOrderService;
import com.qiho.center.biz.service.order.OrderSnapshotService;
import com.qiho.center.common.dao.QihoErpOrderDAO;
import com.qiho.center.common.dao.QihoOrderSnapshotDAO;
import com.qiho.center.common.entity.order.QihoErpOrderEntity;
import com.qiho.center.common.enums.SeqBizTypeEnum;
import com.qiho.center.common.support.SequenceNoBuilder;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ErpOrderServiceImpl
implements ErpOrderService {
    @Autowired
    private QihoErpOrderDAO qihoErpOrderDAO;
    @Autowired
    private SequenceNoBuilder builder;
    @Autowired
    private OrderStockService orderStockService;
    @Autowired
    QihoOrderSnapshotDAO qihoOrderSnapshotDAO;
    @Autowired
    OrderSnapshotService orderSnapshotService;

    @Override
    public List<ErpOrderDto> findByOrderId(String orderId) {
        List list = this.qihoErpOrderDAO.findByOrderId(orderId);
        return BeanUtils.copyList((List)list, ErpOrderDto.class);
    }

    @Override
    public List<ErpOrderDto> findByOrderIds(List<String> orderIds) {
        List list = this.qihoErpOrderDAO.findByOrderIds(orderIds);
        return BeanUtils.copyList((List)list, ErpOrderDto.class);
    }

    @Override
    public PagenationDto<ErpOrderDto> findErpOrderPage(ErpOrderPageParams params) {
        List list = this.qihoErpOrderDAO.findErpOrderPage(params);
        int total = this.qihoErpOrderDAO.findErpOrderPageCount(params);
        PagenationDto page = new PagenationDto();
        page.setTotal(Integer.valueOf(total));
        page.setList(BeanUtils.copyList((List)list, ErpOrderDto.class));
        return page;
    }

    @Override
    public int findErpOrderPageCount(ErpOrderPageParams params) {
        return this.qihoErpOrderDAO.findErpOrderPageCount(params);
    }

    @Override
    public ErpOrderDto createErpOrder(QihoErpOrderEntity order) {
        order.setErpId(this.builder.createSeqNo(SeqBizTypeEnum.ERP, order.getItemId()));
        order.setErpStatus(ErpStatusEnum.TO_NOTIFY.getCode());
        this.qihoErpOrderDAO.createErpOrder(order);
        ErpOrderDto dto = new ErpOrderDto();
        BeanUtils.copy((Object)order, (Object)dto);
        return dto;
    }

    @Override
    public ErpOrderDto findErpOrderByErpId(String erpId) {
        QihoErpOrderEntity entity = this.qihoErpOrderDAO.findByErpId(erpId);
        if (entity == null) {
            return null;
        }
        ErpOrderDto dto = new ErpOrderDto();
        BeanUtils.copy((Object)entity, (Object)dto);
        return dto;
    }

    @Override
    public ErpOrderDto updateErpStatus(String erpId, ErpStatusEnum erpStatus, ErpStatusEnum beforeErpStatus, String failedMessage) {
        int ret;
        QihoErpOrderEntity entity = this.qihoErpOrderDAO.findByErpId(erpId);
        if (entity == null || erpStatus == null) {
            throw new QihoException("ERP\u8ba2\u5355\u4e0d\u5b58\u5728,\u6216\u8ba2\u5355\u72b6\u6001\u4e3a\u7a7a");
        }
        String beforeStatus = null;
        if (beforeErpStatus != null) {
            beforeStatus = beforeErpStatus.getCode();
        }
        if ((ret = this.qihoErpOrderDAO.updateErpStatus(erpId, erpStatus.getCode(), failedMessage, beforeStatus)) != 1) {
            throw new QihoException("ERP\u8ba2\u5355\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u5f02\u5e38");
        }
        if (erpStatus.equals((Object)ErpStatusEnum.FAILED)) {
            this.orderStockService.returnSkuStockByOrderId(entity.getOrderId());
        }
        return this.findErpOrderByErpId(erpId);
    }

    @Override
    public void updateErpId(Long id, String erpId) {
        this.qihoErpOrderDAO.updateErpId(id, erpId);
    }

    @Override
    public List<OrderSnapshotDto> findWdtExportErpOrder(ErpOrderPageParams params) {
        List list = this.qihoOrderSnapshotDAO.findWdtExportErpOrder(params);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        return this.orderSnapshotService.getHandlerOrderSnapshotDto(list);
    }
}

