/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.order;

import com.qiho.center.api.dto.order.DeliveryRecordDto;
import com.qiho.center.api.enums.DeliveryRecordStateEnum;
import com.qiho.center.api.params.DeliveryRecordQueryParams;
import com.qiho.center.biz.service.order.OrderFileDeliveryService;
import com.qiho.center.biz.util.DeliveryRecordUtil;
import com.qiho.center.common.daoh.qiho.order.DeliveryRecordMapper;
import com.qiho.center.common.entityd.qiho.order.DeliveryRecordEntity;
import java.util.Calendar;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class OrderFileDeliveryServiceImpl
implements OrderFileDeliveryService {
    @Resource
    private DeliveryRecordMapper deliveryRecordMapper;

    @Override
    public DeliveryRecordDto getJob() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.add(5, -3);
        DeliveryRecordQueryParams params = new DeliveryRecordQueryParams();
        params.setGmtCreateEnd(calendar.getTime());
        return DeliveryRecordUtil.entityToDto(this.deliveryRecordMapper.selectJob(params));
    }

    @Override
    public Boolean setStateRunning(Long id, int totalCount) {
        DeliveryRecordEntity record = new DeliveryRecordEntity();
        record.setId(id);
        record.setRemark("\u5df2\u5f00\u59cb");
        record.setTotalCount(Integer.valueOf(totalCount));
        record.setState(DeliveryRecordStateEnum.RUNNING.getCode());
        if (0 < this.deliveryRecordMapper.updateByIdSelective(record)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean setStateError(Long id, String msg) {
        DeliveryRecordEntity record = new DeliveryRecordEntity();
        record.setId(id);
        record.setRemark(DeliveryRecordStateEnum.ERROR.getName() + ":" + msg);
        record.setState(DeliveryRecordStateEnum.ERROR.getCode());
        if (0 < this.deliveryRecordMapper.updateByIdSelective(record)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean updateByIdSelective(DeliveryRecordEntity entity) {
        if (0 < this.deliveryRecordMapper.updateByIdSelective(entity)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

