/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.order;

import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.qiho.center.api.dto.ChannelInfoDto;
import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.embed.EmbedDto;
import com.qiho.center.api.dto.reply.UserReplyDto;
import com.qiho.center.api.enums.DeliveryEnum;
import com.qiho.center.api.enums.FundStatusEnum;
import com.qiho.center.api.enums.LogisticsOrderStatusEnum;
import com.qiho.center.api.enums.OrderApprovalStatusEnum;
import com.qiho.center.api.enums.OrderStatusEnum;
import com.qiho.center.api.enums.PayTypeEnum;
import com.qiho.center.api.enums.RemoteInvokeEnum;
import com.qiho.center.api.enums.SmsTypeEnum;
import com.qiho.center.api.enums.embed.EmbedResultEnum;
import com.qiho.center.api.enums.ordersms.SmsMobileStatusEnum;
import com.qiho.center.api.params.ForwardToTuiaParams;
import com.qiho.center.api.params.OrderGainParams;
import com.qiho.center.api.params.OrderPageParams;
import com.qiho.center.api.util.BizLog;
import com.qiho.center.biz.bo.SsjxPushOrderBo;
import com.qiho.center.biz.engine.impl.ShotOrderEngine;
import com.qiho.center.biz.event.LogisticsInfoUpdateEvent;
import com.qiho.center.biz.event.OrderCreateEvent;
import com.qiho.center.biz.event.OrderCreateFromTmpEvent;
import com.qiho.center.biz.event.UpdateToCodEvent;
import com.qiho.center.biz.service.MediaWhiteListService;
import com.qiho.center.biz.service.embed.EmbedService;
import com.qiho.center.biz.service.impl.check.IPMobileCheckService;
import com.qiho.center.biz.service.merchant.MerchantService;
import com.qiho.center.biz.service.order.ChannelInfoService;
import com.qiho.center.biz.service.order.OrderSnapshotService;
import com.qiho.center.biz.service.order.SmsService;
import com.qiho.center.common.annotations.BizEventListener;
import com.qiho.center.common.constant.DomainConstantUtil;
import com.qiho.center.common.dao.QihoAnticheateDAO;
import com.qiho.center.common.dao.QihoErpOrderDAO;
import com.qiho.center.common.dao.QihoLogisticsOrderDAO;
import com.qiho.center.common.dao.QihoOrderSnapshotDAO;
import com.qiho.center.common.dao.QihoShortUrlDAO;
import com.qiho.center.common.dao.QihoTemplateDAO;
import com.qiho.center.common.daoh.qiho.ChuangLanSmsCommitMapper;
import com.qiho.center.common.daoh.qiho.ordertmp.BaiqiOrderSmsMapper;
import com.qiho.center.common.daoh.qiho.reply.BaiqiUserReplyMapper;
import com.qiho.center.common.entity.QihoShortUrlEntity;
import com.qiho.center.common.entity.QihoTemplateEntity;
import com.qiho.center.common.entity.order.QihoAnticheateEntity;
import com.qiho.center.common.entity.order.QihoErpOrderEntity;
import com.qiho.center.common.entity.order.QihoOrderSnapshotEntity;
import com.qiho.center.common.entityd.qiho.ChuangLanSmsCommitEntity;
import com.qiho.center.common.entityd.qiho.ordertmp.BaiqiOrderSmsEntity;
import com.qiho.center.common.entityd.qiho.reply.BaiqiUserReplyEntity;
import com.qiho.center.common.enums.SmsTemplateEnum;
import com.qiho.center.common.model.tongdun.FraudApiResponse;
import com.qiho.center.common.util.HttpClientUtil;
import com.qiho.center.common.util.MaxentUtil;
import com.qiho.center.common.util.ShortUrlUtil;
import com.qiho.center.common.util.StringUtil;
import com.qiho.center.common.util.TongdunUtil;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@BizEventListener
public class OrderSnapshotServiceImpl
implements OrderSnapshotService {
    private static final Logger LOG = LoggerFactory.getLogger(OrderSnapshotServiceImpl.class);
    private static final String CALLBACK_DATA = "\u90e8\u5206\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a\uff0c\u672a\u53d1\u9001";
    private static final String TUIA_URL_POSTFIX = "#buyframe";
    @Autowired
    private QihoOrderSnapshotDAO qihoOrderSnapshotDAO;
    @Autowired
    private QihoShortUrlDAO qihoShortUrlDAO;
    @Autowired
    private QihoTemplateDAO qihoTemplateDAO;
    @Autowired
    private SmsService smsService;
    @Resource
    private ShotOrderEngine shotOrderEngine;
    @Autowired
    private QihoAnticheateDAO qihoAnticheateDAO;
    @Autowired
    private ChannelInfoService channelInfoService;
    @Resource
    private MediaWhiteListService mediaWhiteListService;
    @Autowired
    private MerchantService merchantService;
    @Resource
    private SsjxPushOrderBo ssjxPushOrderBo;
    @Resource
    private OrderSnapshotService orderSnapshotService;
    @Autowired
    private QihoLogisticsOrderDAO qihoLogisticsOrderDAO;
    @Autowired
    private EmbedService embedService;
    @Autowired
    private QihoErpOrderDAO qihoErpOrderDAO;
    @Autowired
    IPMobileCheckService ipMobileCheckService;
    @Autowired
    private BaiqiOrderSmsMapper baiqiOrderSmsMapper;
    @Autowired
    private BaiqiUserReplyMapper baiqiUserReplyMapper;
    @Value(value="${qiho.order.ssjx.merchantid}")
    private String ssjxMerchartId;
    @Value(value="${qiho.order.tuia.skinid}")
    private String skinId;
    @Value(value="${qiho.order.tuia.url}")
    private String tuiaUrl;
    @Autowired
    ChuangLanSmsCommitMapper chuangLanSmsCommitMapper;

    @Override
    public PagenationDto<OrderSnapshotDto> findOrderPage(OrderPageParams params) {
        PagenationDto page = new PagenationDto();
        List list = this.qihoOrderSnapshotDAO.findOrderPage(params);
        if (CollectionUtils.isEmpty((Collection)list)) {
            page.setList((List)Lists.newArrayList());
            page.setTotal(Integer.valueOf(0));
            return page;
        }
        page.setTotal(this.qihoOrderSnapshotDAO.findOrderPageCount(params));
        page.setList(this.injectExtraInfo(list, params.getRemoteInvoke()));
        return page;
    }

    private List<OrderSnapshotDto> injectExtraInfo(List<QihoOrderSnapshotEntity> list, RemoteInvokeEnum remoteInvoke) {
        ArrayList orderIds = Lists.newArrayList();
        HashSet merchantIds = Sets.newHashSet();
        list.stream().forEach(e -> {
            orderIds.add(e.getOrderId());
            merchantIds.add(e.getMerchantId());
        });
        List logisticsOrderList = this.qihoLogisticsOrderDAO.findByOrderIds((List)orderIds);
        HashMap logisticsMap = Maps.newHashMap();
        logisticsOrderList.stream().forEach(e -> logisticsMap.put(e.getOrderId(), e.getLogisticsStatus()));
        Map<Long, String> merchantMap = this.merchantService.fetchNamesWithCache(merchantIds);
        list.stream().forEach(e -> {
            e.setLogisticsStatus((String)logisticsMap.get(e.getOrderId()));
            e.setMerchantName((String)merchantMap.get(e.getMerchantId()));
        });
        List<OrderSnapshotDto> orderSnapshotDtoList = this.getHandlerOrderSnapshotDto(list);
        if (Objects.equal((Object)remoteInvoke, (Object)RemoteInvokeEnum.BAIQI_FERRERI_WEB)) {
            return this.paddingUserReply(orderSnapshotDtoList);
        }
        return orderSnapshotDtoList;
    }

    private List<OrderSnapshotDto> paddingUserReply(List<OrderSnapshotDto> orderSnapshotDtoaList) {
        if (CollectionUtils.isEmpty(orderSnapshotDtoaList)) {
            return orderSnapshotDtoaList;
        }
        List orderSnapshotDtoList = BeanUtils.copyList(orderSnapshotDtoaList, OrderSnapshotDto.class);
        List orderIds = orderSnapshotDtoList.stream().map(OrderSnapshotDto::getOrderId).collect(Collectors.toList());
        List userReplyEntities = this.baiqiUserReplyMapper.listUserReplyByOrderIds(orderIds);
        if (CollectionUtils.isEmpty((Collection)userReplyEntities)) {
            return orderSnapshotDtoList;
        }
        HashMap userReplyMap = Maps.newHashMap();
        userReplyEntities.forEach(e -> {
            String orderId = e.getOrderId();
            if (userReplyMap.get(orderId) == null) {
                userReplyMap.put(orderId, Lists.newArrayList((Object[])new BaiqiUserReplyEntity[]{e}));
            } else {
                List orderReplyList = (List)userReplyMap.get(orderId);
                if (orderReplyList.size() < 5) {
                    orderReplyList.add(e);
                    userReplyMap.put(orderId, orderReplyList);
                }
            }
        });
        for (OrderSnapshotDto snapshot : orderSnapshotDtoList) {
            String orderId = snapshot.getOrderId();
            if (CollectionUtils.isEmpty((Collection)((Collection)userReplyMap.get(orderId)))) {
                snapshot.setUserReplyList((List)Lists.newArrayList());
                continue;
            }
            List userReplyEntityList = (List)userReplyMap.get(orderId);
            List userReplyDtoList = BeanUtils.copyList((List)userReplyEntityList, UserReplyDto.class);
            snapshot.setUserReplyList(userReplyDtoList);
        }
        return orderSnapshotDtoList;
    }

    @Override
    public List<OrderSnapshotDto> findOrderPageForExport(OrderPageParams params) {
        ArrayList list = Lists.newArrayList();
        if (!Objects.equal(null, (Object)params.getOrderId())) {
            QihoOrderSnapshotEntity order = this.qihoOrderSnapshotDAO.findByOrderId(params.getOrderId());
            if (order != null) {
                list.add(order);
            }
        } else {
            list.addAll(this.qihoOrderSnapshotDAO.exportOrderPage(params));
        }
        if (!list.isEmpty()) {
            ArrayList orderIds = Lists.newArrayList();
            for (QihoOrderSnapshotEntity qihoOrderSnapshotEntity : list) {
                orderIds.add(qihoOrderSnapshotEntity.getOrderId());
            }
            List list1 = this.qihoErpOrderDAO.findByOrderIds((List)orderIds);
            HashMap map = Maps.newHashMap();
            for (QihoErpOrderEntity erpOrderEntity : list1) {
                map.put(erpOrderEntity.getOrderId(), erpOrderEntity);
            }
            for (QihoOrderSnapshotEntity qihoOrderSnapshotEntity : list) {
                if (!map.containsKey(qihoOrderSnapshotEntity.getOrderId())) continue;
                qihoOrderSnapshotEntity.setErpId(((QihoErpOrderEntity)map.get(qihoOrderSnapshotEntity.getOrderId())).getErpId());
            }
        }
        List<OrderSnapshotDto> orderSnapshotDtoList = this.getHandlerOrderSnapshotDto(list);
        return this.paddingUserReply(orderSnapshotDtoList);
    }

    @Override
    public Integer findAllPageCount(OrderPageParams params) {
        if (!Objects.equal(null, (Object)params.getOrderId())) {
            QihoOrderSnapshotEntity order = this.qihoOrderSnapshotDAO.findByOrderId(params.getOrderId());
            if (order != null) {
                return 1;
            }
            return 0;
        }
        return this.qihoOrderSnapshotDAO.findOrderPageCount(params);
    }

    @Override
    public Integer exportOrderPageCount(OrderPageParams params) {
        if (!Objects.equal(null, (Object)params.getOrderId())) {
            QihoOrderSnapshotEntity order = this.qihoOrderSnapshotDAO.findByOrderId(params.getOrderId());
            if (order != null) {
                return 1;
            }
            return 0;
        }
        return this.qihoOrderSnapshotDAO.exportOrderPageCount(params);
    }

    @Override
    public Integer updateOrderStatus(String orderId, String remark, OrderStatusEnum orderStatus, OrderApprovalStatusEnum orderApprovalStatusEnum) {
        return this.qihoOrderSnapshotDAO.updateOrderStatus(orderId, remark, orderStatus, orderApprovalStatusEnum, null);
    }

    @Override
    public OrderSnapshotDto findByOrderId(String orderId) {
        QihoOrderSnapshotEntity entity = this.qihoOrderSnapshotDAO.findByOrderId(orderId);
        if (entity == null) {
            return null;
        }
        OrderSnapshotDto dto = (OrderSnapshotDto)BeanUtils.copy((Object)entity, OrderSnapshotDto.class);
        dto.setOrderStatusEnum(OrderStatusEnum.getByCode((String)entity.getOrderStatus()));
        dto.setDeliveryEnum(DeliveryEnum.getByCode((String)entity.getDelivery()));
        dto.setFundStatusEnum(FundStatusEnum.getEnumByCode((String)entity.getFundStatus()));
        return dto;
    }

    @Subscribe
    @AllowConcurrentEvents
    @Deprecated
    public void createOrderListener(OrderCreateEvent orderCreateEvent) {
        this.ipMobileCheckService.checkToSave(orderCreateEvent.getOrderSnapshot());
        DBTimeProfile.enter((String)"create order");
        OrderSnapshotDto orderSnapshotDto = orderCreateEvent.getOrderSnapshot();
        String orderId = orderSnapshotDto.getOrderId();
        String shortUrl = this.saveShortUrl(orderId);
        if (StringUtils.equals((CharSequence)orderSnapshotDto.getPayType(), (CharSequence)PayTypeEnum.COD.getCode())) {
            orderSnapshotDto.setGmtCreate(new Date());
            DBTimeProfile.enter((String)"send message");
            boolean flag = this.sendMessage(orderSnapshotDto, shortUrl);
            DBTimeProfile.release();
            if (flag) {
                DBTimeProfile.enter((String)"shot order");
                this.shotOrderEngine.process(orderSnapshotDto);
                DBTimeProfile.release();
            }
        }
        this.updateDeviceId(orderId, orderCreateEvent.getTokenId());
        DBTimeProfile.enter((String)"forward to tuia");
        this.forwardToTuia(orderSnapshotDto);
        DBTimeProfile.release();
        DBTimeProfile.release();
    }

    @Subscribe
    @AllowConcurrentEvents
    private void createOrderFromTmpListener(OrderCreateFromTmpEvent orderCreateEvent) {
        OrderSnapshotDto orderSnapshotDto = orderCreateEvent.getOrderSnapshot();
        if (orderSnapshotDto == null) {
            return;
        }
        String orderId = orderCreateEvent.getOrderSnapshot().getOrderId();
        this.updateDeviceId(orderId, orderCreateEvent.getTokenId());
        this.forwardToTuia(orderSnapshotDto);
        BaiqiOrderSmsEntity orderSms = this.baiqiOrderSmsMapper.findByOrderId(orderId);
        if (null == orderSms) {
            LOG.warn("\u83b7\u53d6\u4e0d\u5230\u4e0b\u5355\u77ed\u4fe1\u8bb0\u5f55\uff0corderId\uff1a{}", (Object)orderId);
            return;
        }
        if (orderSms.getSmsType().intValue() != SmsTypeEnum.CHUANG_LAN.getNum() || orderSms.getSmsType().intValue() == SmsTypeEnum.CHUANG_LAN.getNum() && orderSms.getMobileStatus().intValue() != SmsMobileStatusEnum.DEFAULT.getNum()) {
            orderSnapshotDto.setSmsRetCode(orderSms.getSyncResult());
            this.shotOrderEngine.process(orderSnapshotDto);
        }
        this.toSsjx(orderSnapshotDto, orderId, orderSms);
    }

    @Subscribe
    public void updateToCodListener(UpdateToCodEvent event) {
        DBTimeProfile.enter((String)"updateToCodListener");
        QihoOrderSnapshotEntity order = this.qihoOrderSnapshotDAO.findByOrderId(event.getOrderId());
        OrderSnapshotDto orderSnapshotDto = (OrderSnapshotDto)BeanUtils.copy((Object)order, OrderSnapshotDto.class);
        this.shotOrderEngine.process(orderSnapshotDto);
        String shortUrl = ShortUrlUtil.getShortUrlByOrderId((String)event.getOrderId());
        this.sendMessage(orderSnapshotDto, shortUrl);
        DBTimeProfile.release();
    }

    private String saveShortUrl(String orderId) {
        String qihoWebUrl = DomainConstantUtil.getQihoWebUrl();
        String domain = StringUtils.substring((String)qihoWebUrl, (int)(StringUtils.indexOf((CharSequence)qihoWebUrl, (CharSequence)"//") + 2));
        String longUrl = qihoWebUrl + "/order/detail?orderId=" + orderId;
        int section = Integer.parseInt(StringUtils.substring((String)orderId, (int)15, (int)19));
        String shortUrl = ShortUrlUtil.generateShortUrl((String)longUrl, (int)section);
        QihoShortUrlEntity qihoShortUrlEntity = new QihoShortUrlEntity();
        qihoShortUrlEntity.setShortUrl(shortUrl);
        qihoShortUrlEntity.setLongUrl(longUrl);
        this.qihoShortUrlDAO.insert(qihoShortUrlEntity);
        return domain + "/" + shortUrl;
    }

    private void updateDeviceId(String orderId, String tokenId) {
        FraudApiResponse fraudApiResponse = TongdunUtil.getRiskInfo((String)tokenId);
        if (fraudApiResponse != null) {
            String tongdunId = fraudApiResponse.getDeviceId();
            ChannelInfoDto channelInfo = new ChannelInfoDto();
            channelInfo.addDeviceId("tokenId", tokenId);
            channelInfo.setOrderId(orderId);
            channelInfo.addDeviceId("tongdunId", tongdunId);
            String maxentId = MaxentUtil.getDeviceId((String)tokenId);
            channelInfo.addDeviceId("maxentId", maxentId);
            this.channelInfoService.updateByOrderId(channelInfo);
        }
    }

    private boolean sendMessage(OrderSnapshotDto orderSnapshotDto, String orderDetailUrl) {
        String orderId = orderSnapshotDto.getOrderId();
        String mobile = orderSnapshotDto.getMobile();
        String itemShortName = orderSnapshotDto.getItemShortName();
        QihoTemplateEntity template = null;
        template = this.mediaWhiteListService.isInWhiteList(orderId) ? this.qihoTemplateDAO.findByCode(SmsTemplateEnum.ORDER_SUCC_400.getCode()) : this.qihoTemplateDAO.findByCode(SmsTemplateEnum.ORDER_SUCCESS.getCode());
        OrderSnapshotDto entity = this.orderSnapshotService.findByOrderId(orderId);
        String smsRetCode = "300002";
        DBTimeProfile.enter((String)"send sms");
        boolean smsFlag = true;
        if (null != template && template.getTemplateEnable().booleanValue()) {
            HashMap context = Maps.newHashMap();
            context.put("orderDetailUrl", orderDetailUrl);
            context.put("itemName", itemShortName);
            try {
                template.setReport(Boolean.valueOf(true));
                smsRetCode = this.smsService.singleSendRetCode(template, context, mobile);
                smsFlag = this.chuangLanHandler(orderSnapshotDto, template, smsRetCode, smsFlag);
            }
            catch (Exception e) {
                LOG.warn("\u53d1\u9001\u77ed\u4fe1\u9519\u8bef", (Throwable)e);
                smsRetCode = "900000";
            }
        }
        DBTimeProfile.release();
        this.toSsjx(orderSnapshotDto, orderId, template, entity, smsRetCode);
        QihoTemplateEntity template1 = this.qihoTemplateDAO.findByCode(SmsTemplateEnum.ORDER_NOTIFY.getCode());
        if (template1.getTemplateEnable().booleanValue()) {
            this.smsService.singleSend(template1, mobile);
        }
        return !template.getSmsType().equals(SmsTypeEnum.CHUANG_LAN.getCode()) || template.getTemplateEnable() == false || !smsFlag;
    }

    private boolean chuangLanHandler(OrderSnapshotDto orderSnapshotDto, QihoTemplateEntity template, String smsRetCode, boolean smsFlag) {
        if (template.getSmsType().equals(SmsTypeEnum.CHUANG_LAN.getCode())) {
            JSONObject jsonObject = JSONObject.parseObject((String)smsRetCode);
            if (StringUtils.isBlank((CharSequence)smsRetCode) || StringUtils.isBlank((CharSequence)jsonObject.getString("msgId"))) {
                smsFlag = false;
            } else {
                ChuangLanSmsCommitEntity smsCommitEntity = new ChuangLanSmsCommitEntity();
                smsCommitEntity.setOrderId(orderSnapshotDto.getOrderId());
                smsCommitEntity.setMsgId(jsonObject.getString("msgId"));
                smsCommitEntity.setHandlerStatus(Integer.valueOf(0));
                this.chuangLanSmsCommitMapper.insert(smsCommitEntity);
            }
        }
        return smsFlag;
    }

    private void toSsjx(OrderSnapshotDto orderSnapshotDto, String orderId, QihoTemplateEntity template, OrderSnapshotDto entity, String smsRetCode) {
        orderSnapshotDto.setSmsRetCode(smsRetCode);
        List ssjxMerchartIds = StringUtil.stringToListOrderByIds((String)this.ssjxMerchartId);
        BizLog.log((String)"\u7528\u6237\u4e0b\u5355\u6210\u529f\u77ed\u4fe1\u5df2\u53d1\u9001, orderId:{}, merchantId:{}, smsRetCode:{}, ssjxMerchartId:{}, OrderSnapshotDto:{}", (Object[])new Object[]{orderId, entity.getMerchantId(), smsRetCode, this.ssjxMerchartId, entity});
        if (StringUtils.isNotBlank((CharSequence)smsRetCode) && !CollectionUtils.isEmpty((Collection)ssjxMerchartIds) && ssjxMerchartIds.contains(entity.getMerchantId())) {
            String retCode = this.getSsjxSmsRetCode(smsRetCode);
            BizLog.log((String)"\u76db\u4e16\u5609\u7965\u4e0b\u5355\u6210\u529f\u53d1\u77ed\u4fe1, orderId:{}, merchantId:{}, retCode:{}, ssjxMerchartId:{}", (Object[])new Object[]{orderId, entity.getMerchantId(), retCode, this.ssjxMerchartId});
            if (template.getSmsType().equals(SmsTypeEnum.CHUANG_LAN.getCode())) {
                this.ssjxPushOrderBo.createOrderSnapshotListener(entity, "");
            } else {
                this.ssjxPushOrderBo.createOrderSnapshotListener(entity, retCode);
            }
        }
    }

    private void toSsjx(OrderSnapshotDto orderSnapshotDto, String orderId, BaiqiOrderSmsEntity orderSms) {
        List ssjxMerchartIds = StringUtil.stringToListOrderByIds((String)this.ssjxMerchartId);
        if (CollectionUtils.isNotEmpty((Collection)ssjxMerchartIds) && ssjxMerchartIds.contains(orderSnapshotDto.getMerchantId())) {
            if (SmsTypeEnum.CHUANG_LAN.getNum() == orderSms.getSmsType().intValue()) {
                this.ssjxPushOrderBo.createOrderSnapshotListener(orderSnapshotDto, "");
            } else {
                this.ssjxPushOrderBo.createOrderSnapshotListener(orderSnapshotDto, this.getSsjxSmsRetCode(orderSms.getSyncResult()));
            }
        }
    }

    private String getSsjxSmsRetCode(String smsCode) {
        if ("000000".equals(smsCode)) {
            return "DELIVRD";
        }
        if ("900000".equals(smsCode)) {
            return "TIMEOUT";
        }
        if ("300002".equals(smsCode) || "300003".equals(smsCode)) {
            return "UNDELIV";
        }
        return smsCode;
    }

    @Subscribe
    public void logisticsInfoUpdateListener(LogisticsInfoUpdateEvent event) {
        DBTimeProfile.enter((String)"logisticsInfoUpdateListener");
        String postId = event.getPostId();
        String mobile = event.getMobile();
        QihoTemplateEntity template = this.qihoTemplateDAO.findByCode(SmsTemplateEnum.ORDER_SEND.getCode());
        if (template.getTemplateEnable().booleanValue()) {
            HashMap context = Maps.newHashMap();
            context.put("postId", postId);
            context.put("orderDetailUrl", ShortUrlUtil.getShortUrlByOrderId((String)event.getOrderId()));
            this.smsService.singleSend(template, context, mobile);
        }
        DBTimeProfile.release();
    }

    @Override
    public List<OrderSnapshotDto> findByMobile(String mobile, List<String> statusList) {
        List list = this.qihoOrderSnapshotDAO.findByMobile(mobile, statusList);
        ArrayList orderList = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return orderList;
        }
        for (QihoOrderSnapshotEntity input : list) {
            OrderSnapshotDto dto = new OrderSnapshotDto();
            BeanUtils.copy((Object)input, (Object)dto);
            dto.setFundStatusEnum(FundStatusEnum.getEnumByCode((String)input.getFundStatus()));
            dto.setOrderStatusEnum(OrderStatusEnum.getByCode((String)input.getOrderStatus()));
            dto.setDeliveryEnum(DeliveryEnum.getByCode((String)input.getDelivery()));
            orderList.add(dto);
        }
        return orderList;
    }

    @Override
    public Integer queryItemSaleCount(Long itemId, Date startTime, Date endTime) {
        Integer saleNum = this.qihoOrderSnapshotDAO.queryItemSaleCount(itemId, startTime, endTime);
        return null == saleNum ? 0 : saleNum;
    }

    @Override
    public Integer updateOrderProcessWayByOrderId(OrderGainParams orderGainParams) {
        return this.qihoOrderSnapshotDAO.updateOrderProcessWayByOrderId(orderGainParams);
    }

    @Override
    public List<OrderSnapshotDto> queryOrderByOrderIds(List<String> orderIds) {
        List list = this.qihoOrderSnapshotDAO.queryOrderByOrderIds(orderIds);
        ArrayList orderList = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return orderList;
        }
        return list.stream().map(this::entityToDto).collect(Collectors.toList());
    }

    @Override
    public OrderSnapshotDto queryByMobileAsNewMost(String mobile, String orderStatus) {
        QihoOrderSnapshotEntity entity = this.qihoOrderSnapshotDAO.queryByMobileAsNewMost(mobile, orderStatus);
        return this.entityToDto(entity);
    }

    private OrderSnapshotDto entityToDto(QihoOrderSnapshotEntity entity) {
        if (null == entity) {
            return new OrderSnapshotDto();
        }
        OrderSnapshotDto dto = (OrderSnapshotDto)BeanUtils.copy((Object)entity, OrderSnapshotDto.class);
        dto.setFundStatusEnum(FundStatusEnum.getEnumByCode((String)entity.getFundStatus()));
        dto.setOrderStatusEnum(OrderStatusEnum.getByCode((String)entity.getOrderStatus()));
        dto.setDeliveryEnum(DeliveryEnum.getByCode((String)entity.getDelivery()));
        return dto;
    }

    @Override
    public Map<Long, Integer> queryItemSaleCountBatch(List<Long> itemIdList, Date startTime, Date endTime) {
        HashMap map = Maps.newHashMap();
        itemIdList.stream().forEach(itemId -> map.put(itemId, 0));
        List maps = this.qihoOrderSnapshotDAO.queryItemSaleCountBatch(itemIdList, startTime, endTime);
        maps.stream().forEach(e -> {
            Long itemId = null;
            Integer saleNum = 0;
            for (Map.Entry ma : e.entrySet()) {
                if (StringUtils.equals((CharSequence)"itemId", (CharSequence)((CharSequence)ma.getKey()))) {
                    itemId = (Long)ma.getValue();
                    continue;
                }
                if (!StringUtils.equals((CharSequence)"saleNum", (CharSequence)((CharSequence)ma.getKey()))) continue;
                saleNum = ((BigDecimal)ma.getValue()).intValue();
            }
            map.put(itemId, saleNum);
        });
        return map;
    }

    @Override
    public List<OrderSnapshotDto> queryOrderAsNewMost(OrderPageParams pageParams) {
        List orderSnapshotEntities = this.qihoOrderSnapshotDAO.queryOrderAsNewMost(pageParams);
        return BeanUtils.copyList((List)orderSnapshotEntities, OrderSnapshotDto.class);
    }

    @Override
    public List<OrderSnapshotDto> getHandlerOrderSnapshotDto(List<QihoOrderSnapshotEntity> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        ArrayList orderIds = Lists.newArrayList();
        for (QihoOrderSnapshotEntity order : list) {
            orderIds.add(order.getOrderId());
        }
        List anticheatList = this.qihoAnticheateDAO.findByOrderIds((List)orderIds);
        HashMap map = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)anticheatList)) {
            for (QihoAnticheateEntity anticheat : anticheatList) {
                String rules = (String)map.get(anticheat.getOrderId());
                if (StringUtils.isNotBlank((CharSequence)rules)) {
                    map.put(anticheat.getOrderId(), rules + "," + anticheat.getRule());
                    continue;
                }
                map.put(anticheat.getOrderId(), anticheat.getRule());
            }
        }
        DtoTransform transform = new DtoTransform();
        transform.setAnticheatMap(map);
        return Lists.transform(list, (Function)transform);
    }

    @Override
    public List<QihoOrderSnapshotEntity> findByMobileAndItem(String mobile, Long itemId) {
        return this.qihoOrderSnapshotDAO.findByMobileAndItem(mobile, itemId);
    }

    @Override
    public OrderSnapshotDto findByOderIdAndMobile(String orderId, String mobile) {
        return (OrderSnapshotDto)BeanUtils.copy((Object)this.qihoOrderSnapshotDAO.findByOderIdAndMobile(orderId, mobile), OrderSnapshotDto.class);
    }

    private void forwardToTuia(OrderSnapshotDto orderSnapshotDto) {
        String callbackData;
        String paramUrl;
        if (StringUtils.isBlank((CharSequence)orderSnapshotDto.getUrl()) || orderSnapshotDto.getSkinId() == null) {
            LOG.info("\u4e0b\u5355URL\u6216\u76ae\u80a4id\u4e3a\u7a7a, orderId: {}", (Object)orderSnapshotDto.getOrderId());
            return;
        }
        LOG.info("\u63a8\u554a\u57cb\u70b9\u63a8\u9001, orderId\uff1a{}, url: {}", (Object)orderSnapshotDto.getOrderId(), (Object)orderSnapshotDto.getUrl());
        BizLog.log((String)"\u63a8\u9001\u63a8\u554a\u57cb\u70b9\u7684\u4e0b\u5355URL\uff1a{}", (Object[])new Object[]{orderSnapshotDto.getUrl()});
        try {
            paramUrl = new URL(orderSnapshotDto.getUrl()).getQuery();
        }
        catch (MalformedURLException e) {
            LOG.info("\u524d\u7aef\u4f20\u5165URL\u89e3\u6790\u83b7\u53d6\u53c2\u6570\u5931\u8d25, url: {}", (Object)orderSnapshotDto.getUrl());
            return;
        }
        ForwardToTuiaParams params = this.getParamsByUrl(paramUrl);
        String url = this.tuiaUrl + "?a_oId=" + params.getA_oId() + "&a_cid=" + params.getA_cid() + "&a_timeStamp=" + params.getA_timeStamp() + "&type=" + params.getType();
        if (StringUtils.isNotBlank((CharSequence)params.getA_oId()) && params.getA_cid() != null) {
            callbackData = HttpClientUtil.sendGet((String)url);
            BizLog.log((String)"\u53d1\u9001\u63a8\u554a\u8f6c\u6362\u65e5\u5fd7, orderId\uff1a{}, URL\uff1a{}, result:{}", (Object[])new Object[]{orderSnapshotDto.getOrderId(), url, callbackData});
        } else {
            LOG.info("\u53c2\u6570\u4e0d\u5b8c\u6574, \u4e0d\u53d1\u9001\u57cb\u70b9, orderId\uff1a{}, url: {}", (Object)orderSnapshotDto.getOrderId(), (Object)orderSnapshotDto.getUrl());
            callbackData = CALLBACK_DATA;
        }
        EmbedDto embedDto = new EmbedDto();
        embedDto.setOrderId(orderSnapshotDto.getOrderId());
        embedDto.setResult(this.getEmbedResult(callbackData));
        embedDto.setUrl(orderSnapshotDto.getUrl());
        embedDto.setCallbackData(callbackData);
        embedDto.setSkinId(orderSnapshotDto.getSkinId());
        this.embedService.insert(embedDto);
    }

    private ForwardToTuiaParams getParamsByUrl(String url) {
        String[] params = url.contains(TUIA_URL_POSTFIX) ? url.substring(url.indexOf("?") + 1, url.indexOf(TUIA_URL_POSTFIX)).split("&") : url.substring(url.indexOf("?") + 1).split("&");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String param : params) {
            map.put(param.substring(0, param.indexOf("=")), param.substring(param.indexOf("=") + 1));
        }
        ForwardToTuiaParams forwardToTuiaParams = new ForwardToTuiaParams();
        forwardToTuiaParams.setA_oId((String)map.get("a_oId"));
        if (StringUtils.isBlank((CharSequence)forwardToTuiaParams.getA_oId())) {
            forwardToTuiaParams.setA_oId((String)map.get("a_tuiaId"));
        }
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)map.get("a_cid")))) {
            forwardToTuiaParams.setA_cid((String)map.get("a_cid"));
        }
        forwardToTuiaParams.setChannelId((String)map.get("channelId"));
        forwardToTuiaParams.setA_timeStamp(new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
        return forwardToTuiaParams;
    }

    private EmbedResultEnum getEmbedResult(String callbackData) {
        if (CALLBACK_DATA.equals(callbackData)) {
            return EmbedResultEnum.UNSEND;
        }
        if (callbackData.contains("0000000")) {
            return EmbedResultEnum.SUCCESS;
        }
        return EmbedResultEnum.FAILED;
    }

    private List<String> getSkinIdList(String skinId) {
        if (StringUtils.isBlank((CharSequence)skinId)) {
            return Collections.emptyList();
        }
        return Arrays.asList(skinId.split(","));
    }

    @Override
    public void updateByOrderId(OrderSnapshotDto orderSnapshotDto) {
        QihoOrderSnapshotEntity orderSnapshotEntity = (QihoOrderSnapshotEntity)BeanUtils.copy((Object)orderSnapshotDto, QihoOrderSnapshotEntity.class);
        this.qihoOrderSnapshotDAO.updateByOrderId(orderSnapshotEntity);
    }

    private class DtoTransform
    implements Function<QihoOrderSnapshotEntity, OrderSnapshotDto> {
        private Map<String, String> anticheatMap;

        private DtoTransform() {
        }

        public void setAnticheatMap(Map<String, String> anticheatMap) {
            this.anticheatMap = anticheatMap;
        }

        public OrderSnapshotDto apply(QihoOrderSnapshotEntity input) {
            if (input == null) {
                return null;
            }
            OrderSnapshotDto dto = new OrderSnapshotDto();
            BeanUtils.copy((Object)input, (Object)dto);
            dto.setFundStatusEnum(FundStatusEnum.getEnumByCode((String)input.getFundStatus()));
            dto.setOrderStatusEnum(OrderStatusEnum.getByCode((String)input.getOrderStatus()));
            if (null != LogisticsOrderStatusEnum.getByCode((String)input.getLogisticsStatus())) {
                dto.setLogisticsStatus(LogisticsOrderStatusEnum.getByCode((String)input.getLogisticsStatus()).getDesc());
            }
            dto.setDeliveryEnum(DeliveryEnum.getByCode((String)input.getDelivery()));
            if (this.anticheatMap != null) {
                dto.setAnticheatRules(this.anticheatMap.get(input.getOrderId()));
            }
            return dto;
        }
    }
}

