/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.order;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.OrderStrategyDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.StrategyRuleDto;
import com.qiho.center.api.dto.ordertmp.OrderTmpDetailDto;
import com.qiho.center.api.dto.resultbase.ResultBase;
import com.qiho.center.api.enums.ShotOrder.ShotOrderFieldEnum;
import com.qiho.center.api.enums.ShotOrder.StrategyType;
import com.qiho.center.api.enums.StrategyUseType;
import com.qiho.center.api.params.OrderStrategyParams;
import com.qiho.center.biz.engine.action.OrderMobileAction;
import com.qiho.center.biz.service.order.OrderStrategyService;
import com.qiho.center.biz.service.order.StrategyMerchantService;
import com.qiho.center.biz.service.ordertmp.FilterRuleHitService;
import com.qiho.center.common.dao.QihoOrderStrategyDAO;
import com.qiho.center.common.daoh.qiho.order.StrategyMerchantMapper;
import com.qiho.center.common.entity.order.QihoOrderStrategyEntity;
import com.qiho.center.common.entityd.qiho.order.StrategyMerchantEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrderStrategyServiceImpl
implements OrderStrategyService {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private QihoOrderStrategyDAO qihoOrderStrategyDAO;
    @Resource
    private StrategyMerchantService strategyMerchantService;
    @Resource
    private StrategyMerchantMapper strategyMerchantMapper;
    @Autowired
    private OrderMobileAction orderMobileAction;
    @Autowired
    private FilterRuleHitService filterRuleHitService;

    @Override
    public OrderStrategyDto findStrategyById(Long id) {
        QihoOrderStrategyEntity entity = this.qihoOrderStrategyDAO.findStrategyById(id);
        if (null == entity) {
            return null;
        }
        return (OrderStrategyDto)BeanUtils.copy((Object)entity, OrderStrategyDto.class);
    }

    @Override
    public PagenationDto<OrderStrategyDto> findStrategyByQuery(OrderStrategyParams params, Integer pageNum, Integer pageSize) {
        ArrayList channelDtos = new ArrayList();
        PagenationDto resultBase = new PagenationDto();
        List entities = this.qihoOrderStrategyDAO.findStrategyByQuery(params, pageNum, pageSize);
        if (CollectionUtils.isEmpty((Collection)entities)) {
            return resultBase;
        }
        entities.stream().forEach(e -> channelDtos.add(BeanUtils.copy((Object)e, OrderStrategyDto.class)));
        resultBase.setList(channelDtos);
        Integer channelCount = this.qihoOrderStrategyDAO.countByQuery(params);
        resultBase.setTotal(channelCount);
        return resultBase;
    }

    @Override
    @Transactional(value="QIHO")
    public Integer updateStrategy(OrderStrategyDto orderStrategyDto) {
        this.qihoOrderStrategyDAO.updateByEntity(orderStrategyDto);
        StrategyUseType useType = StrategyUseType.findByValue((int)orderStrategyDto.getUseType());
        if (StrategyUseType.ALL.equals((Object)useType)) {
            this.strategyMerchantService.delMerchantStrategy(null, orderStrategyDto.getId());
        } else if (StrategyUseType.PART.equals((Object)useType)) {
            this.strategyMerchantService.delMerchantStrategy(null, orderStrategyDto.getId());
            this.handleStrategyMerchant(orderStrategyDto.getId(), orderStrategyDto);
        }
        return 1;
    }

    @Override
    @Transactional(value="QIHO")
    public Integer deleteStrategyById(Long id, String updator) {
        return this.qihoOrderStrategyDAO.deleteById(id, updator);
    }

    @Override
    @Transactional(value="QIHO")
    public Integer insertStrategy(OrderStrategyDto orderStrategyDto) {
        Long result = this.qihoOrderStrategyDAO.insertStrategy(orderStrategyDto);
        this.handleStrategyMerchant(result, orderStrategyDto);
        return result == null ? null : Integer.valueOf(result.toString());
    }

    private void handleStrategyMerchant(Long strategyId, OrderStrategyDto orderStrategyDto) {
        StrategyUseType useType = StrategyUseType.findByValue((int)orderStrategyDto.getUseType());
        if (StrategyUseType.PART.equals((Object)useType)) {
            List merchants = orderStrategyDto.getMerchants();
            ArrayList insertList = Lists.newArrayListWithExpectedSize((int)merchants.size());
            merchants.forEach(merchant -> {
                StrategyMerchantEntity merchantEntity = new StrategyMerchantEntity();
                merchantEntity.setMerchantId(merchant.getId());
                merchantEntity.setStrategyId(strategyId);
                insertList.add(merchantEntity);
            });
            this.strategyMerchantService.batchInsert(insertList);
        }
    }

    @Override
    public Integer countStrategyByQuery(OrderStrategyParams params) {
        return this.qihoOrderStrategyDAO.countByQuery(params);
    }

    @Override
    public OrderStrategyDto findStrategyByStrategyType(StrategyType type) {
        QihoOrderStrategyEntity entity = this.qihoOrderStrategyDAO.findStrategyByStrategyType(Integer.valueOf(type.getCode()));
        if (null == entity) {
            return null;
        }
        return (OrderStrategyDto)BeanUtils.copy((Object)entity, OrderStrategyDto.class);
    }

    @Override
    public boolean needCheckPhoneStatues(Long merchantId, StrategyType strategyType) {
        List<QihoOrderStrategyEntity> strategyEntities = this.getStrategy(merchantId, strategyType);
        if (CollectionUtils.isEmpty(strategyEntities)) {
            return false;
        }
        for (QihoOrderStrategyEntity orderStrategy : strategyEntities) {
            List strategyRuleDtos;
            String ruleValue = orderStrategy.getRulevalue();
            if (StringUtils.isBlank((CharSequence)ruleValue) || CollectionUtils.isEmpty((Collection)(strategyRuleDtos = JSONObject.parseArray((String)ruleValue, StrategyRuleDto.class)))) continue;
            for (StrategyRuleDto strategyRuleDto : strategyRuleDtos) {
                if (!StringUtils.equals((CharSequence)strategyRuleDto.getFieldName(), (CharSequence)ShotOrderFieldEnum.PHONE_STATUS.getVal())) continue;
                return true;
            }
        }
        return false;
    }

    private List<QihoOrderStrategyEntity> getStrategy(Long merchantId, StrategyType strategyType) {
        OrderStrategyParams param = new OrderStrategyParams();
        param.setStrategyType(Integer.valueOf(strategyType.getCode()));
        param.setUseType(Integer.valueOf(StrategyUseType.ALL.getValue()));
        List strategyEntities = this.qihoOrderStrategyDAO.findByParam(param);
        List strategyMerchantEntities = this.strategyMerchantMapper.findByMerchantId(merchantId);
        if (CollectionUtils.isNotEmpty((Collection)strategyMerchantEntities)) {
            List strategyIds = strategyMerchantEntities.stream().map(StrategyMerchantEntity::getStrategyId).collect(Collectors.toList());
            param.setIdList(strategyIds);
            param.setUseType(Integer.valueOf(StrategyUseType.PART.getValue()));
            List partStrategyEntities = this.qihoOrderStrategyDAO.findByParam(param);
            strategyEntities.addAll(partStrategyEntities);
        }
        return strategyEntities;
    }

    @Override
    public boolean checkPhoneStatusForFilterRule(OrderTmpDetailDto orderTmpDetailDto) {
        boolean needCheck = this.needCheckPhoneStatues(orderTmpDetailDto.getMerchantId(), StrategyType.FILTER_ORDER_RULE);
        if (!needCheck) {
            return true;
        }
        List<QihoOrderStrategyEntity> strategyEntities = this.getStrategy(orderTmpDetailDto.getMerchantId(), StrategyType.FILTER_ORDER_RULE);
        OrderSnapshotDto orderSnapshotDto = (OrderSnapshotDto)BeanUtils.copy((Object)orderTmpDetailDto, OrderSnapshotDto.class);
        for (QihoOrderStrategyEntity orderStrategyEntity : strategyEntities) {
            List strategyRuleDtos = JSONObject.parseArray((String)orderStrategyEntity.getRulevalue(), StrategyRuleDto.class);
            if (CollectionUtils.isEmpty((Collection)strategyRuleDtos)) continue;
            for (StrategyRuleDto strategyRuleDto : strategyRuleDtos) {
                ResultBase<Boolean> resultBase;
                if (!StringUtils.equals((CharSequence)strategyRuleDto.getFieldName(), (CharSequence)ShotOrderFieldEnum.PHONE_STATUS.getVal()) || !(resultBase = this.orderMobileAction.valuteCostomByQuery(orderSnapshotDto, strategyRuleDto)).hasSuccessValue() || !((Boolean)resultBase.getValue()).booleanValue()) continue;
                this.filterRuleHitService.insert(orderSnapshotDto.getOrderId(), orderStrategyEntity.getStrategyName());
                return false;
            }
        }
        return true;
    }
}

