/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.orderexport;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.orderexport.FieldDto;
import com.qiho.center.api.dto.orderexport.TemplateFieldDto;
import com.qiho.center.biz.service.orderexport.OrderExportTemplateFieldService;
import com.qiho.center.common.daoh.qiho.orderexport.QihoFieldMapper;
import com.qiho.center.common.daoh.qiho.orderexport.QihoOrderExportTemplateFieldMapper;
import com.qiho.center.common.entityd.qiho.orderexport.QihoFieldEntity;
import com.qiho.center.common.entityd.qiho.orderexport.QihoOrderExportTemplateFieldEntity;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="orderExportTemplateFieldService")
public class OrderExportTemplateFieldServiceImpl
implements OrderExportTemplateFieldService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrderExportTemplateFieldServiceImpl.class);
    @Resource
    private QihoOrderExportTemplateFieldMapper templateFieldMapper;
    @Resource
    private QihoFieldMapper qihoFieldMapper;

    @Override
    public TemplateFieldDto findById(Long tempFieldId) {
        if (tempFieldId == null) {
            LOGGER.error("find temp field failed: tempFieldId is null");
            return null;
        }
        QihoOrderExportTemplateFieldEntity templateFieldEntity = this.templateFieldMapper.findById(tempFieldId);
        if (templateFieldEntity == null) {
            return null;
        }
        Long fieldId = templateFieldEntity.getFieldId();
        TemplateFieldDto result = (TemplateFieldDto)BeanUtils.copy((Object)templateFieldEntity, TemplateFieldDto.class);
        QihoFieldEntity fieldEntity = this.qihoFieldMapper.findById(fieldId);
        if (fieldEntity != null) {
            result.setFieldName(fieldEntity.getFieldName());
            result.setFieldValue(fieldEntity.getFieldValue());
        }
        return result;
    }

    @Override
    public List<TemplateFieldDto> findByTempId(Long tempId) {
        if (tempId == null) {
            LOGGER.error("find by tempId failed: tempId is null");
            return Collections.emptyList();
        }
        List templateFieldList = this.templateFieldMapper.findByTempId(tempId);
        if (CollectionUtils.isEmpty((Collection)templateFieldList)) {
            return Collections.emptyList();
        }
        List result = BeanUtils.copyList((List)templateFieldList, TemplateFieldDto.class);
        for (TemplateFieldDto templateFieldDto : result) {
            Long fieldId = templateFieldDto.getFieldId();
            QihoFieldEntity fieldEntity = this.qihoFieldMapper.findById(fieldId);
            if (fieldEntity == null) continue;
            templateFieldDto.setFieldName(fieldEntity.getFieldName());
            templateFieldDto.setFieldValue(fieldEntity.getFieldValue());
        }
        return result;
    }

    @Override
    public Boolean deleteById(Long tempFieldId) {
        if (tempFieldId == null) {
            LOGGER.error("delete temp field failed: tempFieldId is null");
            return false;
        }
        return this.templateFieldMapper.deleteById(tempFieldId) > 0;
    }

    @Override
    public Boolean saveTempField(TemplateFieldDto templateFieldDto) {
        QihoOrderExportTemplateFieldEntity templateFieldEntity = (QihoOrderExportTemplateFieldEntity)BeanUtils.copy((Object)templateFieldDto, QihoOrderExportTemplateFieldEntity.class);
        if (templateFieldEntity == null) {
            return false;
        }
        Long id = templateFieldEntity.getId();
        if (id == null) {
            return this.templateFieldMapper.insert(templateFieldEntity) > 0;
        }
        return this.templateFieldMapper.update(templateFieldEntity) > 0;
    }

    @Override
    public List<FieldDto> findField4Select() {
        List listAll = this.qihoFieldMapper.findAll();
        return BeanUtils.copyList((List)listAll, FieldDto.class);
    }
}

