/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.ordersms;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.qiho.center.api.dto.ordertmp.OrderTmpDetailDto;
import com.qiho.center.api.enums.SmsTypeEnum;
import com.qiho.center.api.enums.ordersms.OrderSmsReceiveStatus;
import com.qiho.center.api.enums.ordersms.OrderSmsSendStatusEnum;
import com.qiho.center.biz.service.MediaWhiteListService;
import com.qiho.center.biz.service.order.SmsService;
import com.qiho.center.biz.service.ordersms.OrderSmsService;
import com.qiho.center.common.dao.QihoTemplateDAO;
import com.qiho.center.common.daoh.qiho.ChuangLanSmsCommitMapper;
import com.qiho.center.common.daoh.qiho.ordertmp.BaiqiOrderSmsMapper;
import com.qiho.center.common.entity.QihoTemplateEntity;
import com.qiho.center.common.entityd.qiho.ChuangLanSmsCommitEntity;
import com.qiho.center.common.entityd.qiho.ordertmp.BaiqiOrderSmsEntity;
import com.qiho.center.common.enums.SmsTemplateEnum;
import com.qiho.center.common.support.ShortUrlProvider;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderSmsServiceImpl
implements OrderSmsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrderSmsServiceImpl.class);
    @Autowired
    private MediaWhiteListService mediaWhiteListService;
    @Autowired
    private QihoTemplateDAO qihoTemplateDAO;
    @Autowired
    private SmsService smsService;
    @Autowired
    private ShortUrlProvider shortUrlProvider;
    @Autowired
    private BaiqiOrderSmsMapper baiqiOrderSmsMapper;
    @Autowired
    ChuangLanSmsCommitMapper chuangLanSmsCommitMapper;

    @Override
    public SmsTypeEnum sendMessage(OrderTmpDetailDto orderTmpDetailDto) {
        String orderId = orderTmpDetailDto.getOrderId();
        String itemShortName = orderTmpDetailDto.getItemShortName();
        String shortUrl = this.shortUrlProvider.saveShortUrl(orderId);
        String mobile = orderTmpDetailDto.getMobile();
        Long appId = orderTmpDetailDto.getAppId();
        QihoTemplateEntity template = null;
        template = this.mediaWhiteListService.appInWhiteList(appId) ? this.qihoTemplateDAO.findByCode(SmsTemplateEnum.ORDER_SUCC_400.getCode()) : this.qihoTemplateDAO.findByCode(SmsTemplateEnum.ORDER_SUCCESS.getCode());
        SmsTypeEnum smsTypeEnum = null;
        if (null != template && template.getTemplateEnable().booleanValue()) {
            HashMap context = Maps.newHashMap();
            context.put("orderDetailUrl", shortUrl);
            context.put("itemName", itemShortName);
            smsTypeEnum = SmsTypeEnum.fromCode((String)template.getSmsType());
            String smsRetCode = "300002";
            try {
                template.setReport(Boolean.valueOf(true));
                smsRetCode = this.smsService.singleSendRetCode(template, context, mobile);
                this.saveOrderSms(orderId, mobile, smsTypeEnum, smsRetCode, OrderSmsSendStatusEnum.SUCCESS);
            }
            catch (Exception e) {
                LOGGER.warn("\u53d1\u9001\u77ed\u4fe1\u9519\u8bef,orderId:{},smsTemplate:{}", new Object[]{orderId, template, e});
                this.saveOrderSms(orderId, mobile, smsTypeEnum, smsRetCode, OrderSmsSendStatusEnum.FAIL);
            }
        } else {
            LOGGER.warn("\u4e0b\u5355\u77ed\u4fe1\u6a21\u677f\u9519\u8bef\uff0corderId\uff1a{}\uff0csmsTemplate:{}", (Object)orderId, (Object)template);
        }
        QihoTemplateEntity remindTemplate = this.qihoTemplateDAO.findByCode(SmsTemplateEnum.ORDER_NOTIFY.getCode());
        if (remindTemplate.getTemplateEnable().booleanValue()) {
            this.smsService.singleSend(remindTemplate, mobile);
        }
        return smsTypeEnum;
    }

    private void saveOrderSms(String orderId, String mobile, SmsTypeEnum smsTypeEnum, String smsRetCode, OrderSmsSendStatusEnum snedStatus) {
        BaiqiOrderSmsEntity entity = new BaiqiOrderSmsEntity();
        entity.setMobile(mobile);
        entity.setSmsType(Integer.valueOf(smsTypeEnum.getNum()));
        entity.setOrderId(orderId);
        entity.setSendStatus(Integer.valueOf(snedStatus.getNum()));
        if (smsTypeEnum.isNeedReport()) {
            entity.setReceiveStatus(Integer.valueOf(OrderSmsReceiveStatus.UNPROCESSES.getNum()));
        } else {
            entity.setReceiveStatus(Integer.valueOf(OrderSmsReceiveStatus.PROCESSES.getNum()));
        }
        if (smsTypeEnum == SmsTypeEnum.CHUANG_LAN) {
            JSONObject jsonObject = JSONObject.parseObject((String)smsRetCode);
            entity.setMsgId(jsonObject.getString("msgId"));
            ChuangLanSmsCommitEntity smsCommitEntity = new ChuangLanSmsCommitEntity();
            smsCommitEntity.setOrderId(orderId);
            smsCommitEntity.setMsgId(jsonObject.getString("msgId"));
            smsCommitEntity.setHandlerStatus(Integer.valueOf(0));
            this.chuangLanSmsCommitMapper.insert(smsCommitEntity);
        } else {
            entity.setSyncResult(smsRetCode);
        }
        this.baiqiOrderSmsMapper.insertOrderSms(entity);
    }
}

