/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.ordertmp;

import com.alibaba.fastjson.JSON;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.constant.ItemConstants;
import com.qiho.center.api.dto.ItemDetailDto;
import com.qiho.center.api.dto.ItemSkuDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.abtest.TestPlanStrategyDetailDto;
import com.qiho.center.api.dto.merchant.MerchantDto;
import com.qiho.center.api.dto.ordertmp.OrderTmpDetailDto;
import com.qiho.center.api.enums.DeliveryEnum;
import com.qiho.center.api.enums.ItemStatusEnum;
import com.qiho.center.api.enums.PayTypeEnum;
import com.qiho.center.api.enums.ordertmp.OrderTmpRiskCheckFailEnum;
import com.qiho.center.api.enums.ordertmp.OrderTmpStatusEnum;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.api.params.ordertmp.OrderTmpPageParam;
import com.qiho.center.biz.event.OrderTmpCreateEvent;
import com.qiho.center.biz.event.OrderTmpToFormalEvent;
import com.qiho.center.biz.service.ItemService;
import com.qiho.center.biz.service.ItemSkuService;
import com.qiho.center.biz.service.abtest.TestPlanService;
import com.qiho.center.biz.service.merchant.MerchantService;
import com.qiho.center.biz.service.merchant.MerchantUndeliveryService;
import com.qiho.center.biz.service.ordersms.OrderSmsService;
import com.qiho.center.biz.service.ordertmp.FilterRuleHitService;
import com.qiho.center.biz.service.ordertmp.OrderTmpService;
import com.qiho.center.common.dao.QihoItemSkuDAO;
import com.qiho.center.common.daoh.qiho.ordertmp.BaiqiFilterRuleHitMapper;
import com.qiho.center.common.daoh.qiho.ordertmp.BaiqiOrderSmsMapper;
import com.qiho.center.common.daoh.qiho.ordertmp.BaiqiOrderTmpExtMapper;
import com.qiho.center.common.daoh.qiho.ordertmp.BaiqiOrderTmpMapper;
import com.qiho.center.common.entity.item.QihoItemSkuEntity;
import com.qiho.center.common.entityd.qiho.ordertmp.BaiqiFilterRuleHitEntity;
import com.qiho.center.common.entityd.qiho.ordertmp.BaiqiOrderSmsEntity;
import com.qiho.center.common.entityd.qiho.ordertmp.BaiqiOrderTmpEntity;
import com.qiho.center.common.entityd.qiho.ordertmp.BaiqiOrderTmpExtEntity;
import com.qiho.center.common.enums.SeqBizTypeEnum;
import com.qiho.center.common.support.BizEventBus;
import com.qiho.center.common.support.SequenceNoBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Service
public class OrderTmpServiceImpl
implements OrderTmpService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrderTmpServiceImpl.class);
    @Autowired
    private SequenceNoBuilder sequenceNoBuilder;
    @Autowired
    private BaiqiOrderTmpMapper baiqiOrderTmpMapper;
    @Autowired
    private BaiqiOrderTmpExtMapper baiqiOrderTmpExtMapper;
    @Autowired
    private BizEventBus eventBus;
    @Autowired
    private ItemService itemService;
    @Autowired
    private ItemSkuService itemSkuService;
    @Autowired
    private TestPlanService testPlanService;
    @Autowired
    private MerchantUndeliveryService merchantUndeliveryService;
    @Autowired
    private QihoItemSkuDAO qihoItemSkuDAO;
    @Autowired
    private BaiqiOrderSmsMapper baiqiOrderSmsMapper;
    @Autowired
    private OrderSmsService orderSmsService;
    @Autowired
    private BaiqiFilterRuleHitMapper baiqiFilterRuleHitMapper;
    private LoadingCache<Long, ItemDetailDto> itemDetailCache = CacheBuilder.newBuilder().refreshAfterWrite(2L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Long, ItemDetailDto>(){

        public ItemDetailDto load(Long itemId) throws Exception {
            return OrderTmpServiceImpl.this.itemService.queryItemDetail(itemId);
        }
    });
    @Autowired
    private MerchantService merchantService;
    @Autowired
    private FilterRuleHitService filterRuleHitService;

    @Override
    @Transactional(value="QIHO", rollbackFor={Exception.class})
    public String submitTmpOrder(OrderTmpDetailDto orderDeatil) {
        final String orderId = this.sequenceNoBuilder.createSeqNo(SeqBizTypeEnum.ORDER, orderDeatil.getItemId());
        QihoItemSkuEntity skuEntity = this.qihoItemSkuDAO.findById(orderDeatil.getSkuId());
        if (skuEntity == null) {
            LOGGER.warn("sku\u5b9e\u4f53\u4e3a\u7a7a, orderId = {}, skuId = {}", (Object)orderId, (Object)orderDeatil.getSkuId());
        } else {
            orderDeatil.setItemCost(skuEntity.getCostPrice());
        }
        this.baiqiOrderTmpMapper.insertTmpOrder(this.buildOrderTmpEntity(orderDeatil, orderId));
        this.baiqiOrderTmpExtMapper.insertOrderTmpExt(this.buildOrderTmpExtEntity(orderDeatil, orderId));
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

            public void afterCompletion(int status) {
                if (0 == status) {
                    OrderTmpServiceImpl.this.postOrderTmpCreateEvent(orderId);
                }
            }
        });
        return orderId;
    }

    @Override
    public OrderTmpDetailDto findByOrderId(String orderId) {
        BaiqiOrderTmpEntity orderTmpEntity = this.baiqiOrderTmpMapper.findByOrderId(orderId);
        if (null == orderTmpEntity) {
            return null;
        }
        OrderTmpDetailDto orderTmpDetail = (OrderTmpDetailDto)cn.com.duiba.wolf.utils.BeanUtils.copy((Object)orderTmpEntity, OrderTmpDetailDto.class);
        BaiqiOrderTmpExtEntity orderTmpExtEntity = this.baiqiOrderTmpExtMapper.findByOrderId(orderId);
        BeanUtils.copyProperties((Object)orderTmpExtEntity, (Object)orderTmpDetail);
        orderTmpDetail.setDeliveryEnum(DeliveryEnum.getByCode((String)orderTmpDetail.getDelivery()));
        return orderTmpDetail;
    }

    @Override
    public OrderTmpDetailDto findDetailByOrderId(String orderId) {
        OrderTmpDetailDto orderTmpDetailDto = this.findByOrderId(orderId);
        if (null != orderTmpDetailDto) {
            List filterRuleHitEntities = this.baiqiFilterRuleHitMapper.findByOrderId(orderId);
            List anticheatRules = filterRuleHitEntities.stream().map(BaiqiFilterRuleHitEntity::getRule).collect(Collectors.toList());
            orderTmpDetailDto.setAnticheatRules(anticheatRules);
        }
        return orderTmpDetailDto;
    }

    @Override
    public boolean bizValidate(OrderTmpDetailDto orderTmpDetailDto) {
        String orderId = orderTmpDetailDto.getOrderId();
        try {
            ItemDetailDto itemDetailDto = (ItemDetailDto)this.itemDetailCache.getUnchecked((Object)orderTmpDetailDto.getItemId());
            this.validateItemStatus(itemDetailDto);
            this.validateSku(orderTmpDetailDto);
            this.validateMerchantUndelivery(itemDetailDto.getMerchantDto(), orderTmpDetailDto.getAreaNum());
            this.validateItemLimit(itemDetailDto, orderTmpDetailDto.getQuantity());
            this.validateSupportCOD(orderTmpDetailDto.getPayType(), itemDetailDto);
            return true;
        }
        catch (QihoException qe) {
            LOGGER.warn("\u4e34\u65f6\u8ba2\u5355\u4e1a\u52a1\u5f02\u5e38\uff0corderId :{}", (Object)orderId, (Object)qe);
            this.updateOrderTmpToInvalid(orderId, qe.getMessage(), OrderTmpRiskCheckFailEnum.BIZ_CHECK_FAIL);
            return false;
        }
        catch (Exception e) {
            LOGGER.warn("\u4e34\u65f6\u8ba2\u5355\u4e1a\u52a1\u6821\u9a8c\u7cfb\u7edf\u5f02\u5e38\uff0corderId\uff1a{}", (Object)orderId, (Object)e);
            this.updateOrderTmpToInvalid(orderId, "\u4e34\u65f6\u8ba2\u5355\u4e1a\u52a1\u6821\u9a8c\u7cfb\u7edf\u5f02\u5e38", OrderTmpRiskCheckFailEnum.BIZ_CHECK_FAIL);
            return false;
        }
    }

    private void validateItemStatus(ItemDetailDto itemDetailDto) {
        if (itemDetailDto == null || itemDetailDto.getDeleted().booleanValue()) {
            throw new QihoException("\u5546\u54c1\u5df2\u5220\u9664");
        }
        if (!StringUtils.equals((CharSequence)itemDetailDto.getItemStatus(), (CharSequence)ItemStatusEnum.STATUS_ON.getCode())) {
            throw new QihoException("\u5546\u54c1\u672a\u4e0a\u67b6");
        }
    }

    private void validateSku(OrderTmpDetailDto orderTmpDetailDto) {
        TestPlanStrategyDetailDto testPlanStrategyDetailDto;
        Long skuId = orderTmpDetailDto.getSkuId();
        Long itemId = orderTmpDetailDto.getItemId();
        ItemSkuDto itemSkuDto = this.itemSkuService.querySku(skuId);
        if (itemSkuDto == null) {
            throw new QihoException("SKU\u4e0d\u5b58\u5728\uff0cskuId=" + skuId + ",itemId=" + itemId);
        }
        if (!itemSkuDto.getSkuEnable().booleanValue()) {
            throw new QihoException("SKU\u65e0\u6548\uff0cskuId" + skuId + ",itemId=" + itemId);
        }
        if (itemSkuDto.getStock() == null || itemSkuDto.getStock() < (long)orderTmpDetailDto.getQuantity().intValue()) {
            throw new QihoException("SKU\u5e93\u5b58\u4e0d\u8db3\uff0cskuId=" + skuId + ",itemId=" + itemId);
        }
        String planCode = orderTmpDetailDto.getPlanCode();
        if (StringUtils.isNotBlank((CharSequence)planCode) && null != (testPlanStrategyDetailDto = this.testPlanService.queryStrategyDetailByPlanCode(planCode))) {
            List priceList = JSON.parseArray((String)testPlanStrategyDetailDto.getPriceInfo(), HashMap.class);
            HashMap map = Maps.newHashMap();
            priceList.forEach(price -> map.put(price.get("skuId").toString(), price.get("price").toString()));
            String sellPrice = (String)map.get(itemSkuDto.getId().toString());
            if (StringUtils.isNotBlank((CharSequence)sellPrice)) {
                itemSkuDto.setSellingPrice(Integer.valueOf(sellPrice));
            }
        }
        if (!Objects.equals(orderTmpDetailDto.getSellingPrice(), itemSkuDto.getSellingPrice())) {
            throw new QihoException("\u5546\u54c1\u4ef7\u683c\u9519\u8bef");
        }
    }

    private void validateMerchantUndelivery(MerchantDto merchantDto, String areaNum) {
        Long merchantId;
        List<String> undeliveryList;
        if (merchantDto == null) {
            throw new QihoException("\u6ca1\u6709\u83b7\u53d6\u5230\u5546\u5bb6\u4fe1\u606f");
        }
        if (!DeliveryEnum.ERP.getCode().equals(merchantDto.getDelivery()) && CollectionUtils.isNotEmpty(undeliveryList = this.merchantUndeliveryService.findUndelivery(merchantId = merchantDto.getId())) && undeliveryList.contains(areaNum)) {
            throw new QihoException("\u7528\u6237\u6536\u8d27\u5730\u533a\u5728\u5546\u5bb6\u4e0d\u914d\u9001\u5730\u533a\u5185");
        }
    }

    private void validateItemLimit(ItemDetailDto itemDetailDto, Integer quantity) {
        Integer limitNumber = itemDetailDto.getExtParam().get("limitNumber") == null ? ItemConstants.DEFAULT_LIMIT_NUMBER : Integer.valueOf((String)itemDetailDto.getExtParam().get("limitNumber"));
        if (quantity > limitNumber) {
            throw new QihoException("\u8d2d\u4e70\u6570\u91cf\u8d85\u8fc7\u5546\u54c1\u9650\u8d2d\u4ef6\u6570");
        }
    }

    private void validateSupportCOD(String payType, ItemDetailDto itemDetailDto) {
        if (StringUtils.equals((CharSequence)PayTypeEnum.COD.getCode(), (CharSequence)payType) && StringUtils.equals((CharSequence)StringUtils.trimToEmpty((String)itemDetailDto.getExtParamValue("supportCOD")), (CharSequence)"0")) {
            throw new QihoException("\u5546\u54c1\u4e0d\u652f\u6301\u8d27\u5230\u4ed8\u6b3e");
        }
    }

    @Override
    public boolean updateOrderTmpToInvalid(String orderId, String remark, OrderTmpRiskCheckFailEnum checkFailEnum) {
        BaiqiOrderTmpEntity param = new BaiqiOrderTmpEntity();
        param.setRiskCheck(Integer.valueOf(checkFailEnum.getNum()));
        param.setOrderStatus(Integer.valueOf(OrderTmpStatusEnum.INVALID.getNum()));
        param.setOrderId(orderId);
        param.setRemark(remark);
        return this.baiqiOrderTmpMapper.updateOrderStatus(param) == 1;
    }

    @Override
    @Transactional(value="QIHO")
    public void deleteOrderTmpByOrderId(String orderId) {
        this.baiqiOrderTmpMapper.deleteOrderTmpByOrderId(orderId);
        this.baiqiOrderTmpExtMapper.deleteOrderTmpExtByOrderId(orderId);
    }

    @Override
    public PagenationDto<OrderTmpDetailDto> queryPage(OrderTmpPageParam pageParam) {
        PagenationDto page = new PagenationDto();
        int count = this.baiqiOrderTmpMapper.countQueryPage(pageParam);
        page.setTotal(Integer.valueOf(count));
        if (count == 0) {
            return page.emptyPage();
        }
        List orderTmpEntities = this.baiqiOrderTmpMapper.queryPage(pageParam);
        List<String> orderIds = orderTmpEntities.stream().map(BaiqiOrderTmpEntity::getOrderId).collect(Collectors.toList());
        Map<Long, String> merMap = this.merchantService.fetchNamesWithCache();
        Map<String, List<String>> ruleMap = this.filterRuleHitService.batchFindFilterRuleHit(orderIds);
        List orderTmpExtEntities = this.baiqiOrderTmpExtMapper.findBatchByOrderIds(orderIds);
        HashMap extMap = Maps.newHashMap();
        orderTmpExtEntities.stream().forEach(e -> extMap.put(e.getOrderId(), e));
        List orderTmpDetailDtoList = Lists.transform((List)orderTmpEntities, e -> {
            OrderTmpDetailDto orderTmpDetailDto = (OrderTmpDetailDto)cn.com.duiba.wolf.utils.BeanUtils.copy((Object)e, OrderTmpDetailDto.class);
            BeanUtils.copyProperties(extMap.get(e.getOrderId()), (Object)orderTmpDetailDto);
            orderTmpDetailDto.setDeliveryEnum(DeliveryEnum.getByCode((String)orderTmpDetailDto.getDelivery()));
            orderTmpDetailDto.setOrderStatusEnum(OrderTmpStatusEnum.getByNum((int)orderTmpDetailDto.getOrderStatus()));
            orderTmpDetailDto.setMerchantName((String)merMap.get(e.getMerchantId()));
            orderTmpDetailDto.setOrderStatusEnum(OrderTmpStatusEnum.getByNum((int)e.getOrderStatus()));
            orderTmpDetailDto.setDeliveryEnum(DeliveryEnum.getByCode((String)e.getDelivery()));
            orderTmpDetailDto.setAnticheatRules(ruleMap.get(e.getOrderId()) == null ? Lists.newArrayList() : (List)ruleMap.get(e.getOrderId()));
            return orderTmpDetailDto;
        });
        page.setList(orderTmpDetailDtoList);
        return page;
    }

    @Override
    public ResultDto<Boolean> toValid(String orderId) {
        boolean bizCheck;
        OrderTmpDetailDto orderTmpDetailDto = this.findByOrderId(orderId);
        if (null == orderTmpDetailDto) {
            return ResultDto.failResult((String)"\u4e34\u65f6\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (orderTmpDetailDto.getOrderStatus().intValue() != OrderTmpStatusEnum.INVALID.getNum()) {
            return ResultDto.failResult((String)"\u4e34\u65f6\u8ba2\u5355\u4e0d\u662f\u65e0\u6548\u72b6\u6001");
        }
        BaiqiOrderSmsEntity orderSmsEntity = this.baiqiOrderSmsMapper.findByOrderId(orderId);
        if (null == orderSmsEntity) {
            this.orderSmsService.sendMessage(orderTmpDetailDto);
        }
        if (!(bizCheck = this.bizValidate(orderTmpDetailDto))) {
            return ResultDto.failResult((String)"\u4e1a\u52a1\u6821\u9a8c\u5931\u8d25");
        }
        OrderTmpToFormalEvent toFormalEvent = new OrderTmpToFormalEvent();
        toFormalEvent.setOrderId(orderId);
        this.eventBus.post((Object)toFormalEvent);
        return ResultDto.successResult();
    }

    @Override
    public int countPageQuery(OrderTmpPageParam pageParam) {
        return this.baiqiOrderTmpMapper.countQueryPage(pageParam);
    }

    private void postOrderTmpCreateEvent(String orderId) {
        OrderTmpCreateEvent event = new OrderTmpCreateEvent();
        event.setOrderId(orderId);
        this.eventBus.post((Object)event);
    }

    private BaiqiOrderTmpEntity buildOrderTmpEntity(OrderTmpDetailDto orderDeatil, String orderId) {
        BaiqiOrderTmpEntity orderTmpEntity = (BaiqiOrderTmpEntity)cn.com.duiba.wolf.utils.BeanUtils.copy((Object)orderDeatil, BaiqiOrderTmpEntity.class);
        orderTmpEntity.setOrderStatus(Integer.valueOf(OrderTmpStatusEnum.TO_FILTER.getNum()));
        orderTmpEntity.setOrderId(orderId);
        return orderTmpEntity;
    }

    private BaiqiOrderTmpExtEntity buildOrderTmpExtEntity(OrderTmpDetailDto orderDeatil, String orderId) {
        BaiqiOrderTmpExtEntity orderTmpExt = (BaiqiOrderTmpExtEntity)cn.com.duiba.wolf.utils.BeanUtils.copy((Object)orderDeatil, BaiqiOrderTmpExtEntity.class);
        orderTmpExt.setOrderId(orderId);
        if (StringUtils.isBlank((CharSequence)orderTmpExt.getTuiaCid())) {
            orderTmpExt.setTuiaCid("0");
        }
        return orderTmpExt;
    }
}

