/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.reply;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.reply.UserReplyDto;
import com.qiho.center.biz.service.reply.UserReplyService;
import com.qiho.center.common.dao.QihoOrderDAO;
import com.qiho.center.common.dao.QihoOrderSnapshotDAO;
import com.qiho.center.common.daoh.qiho.reply.BaiqiUserReplyMapper;
import com.qiho.center.common.entity.order.QihoOrderSnapshotEntity;
import com.qiho.center.common.entityd.qiho.reply.BaiqiUserReplyEntity;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserReplyServiceImpl
implements UserReplyService {
    @Autowired
    private BaiqiUserReplyMapper baiqiUserReplyMapper;
    @Autowired
    private QihoOrderDAO qihoOrderDAO;
    @Autowired
    private QihoOrderSnapshotDAO qihoOrderSnapshotDAO;

    @Override
    public ResultDto<Boolean> saveUserReply(UserReplyDto userReplyDto) {
        String content = userReplyDto.getContent();
        String mobile = userReplyDto.getMobile();
        if (StringUtils.isBlank((CharSequence)content) || StringUtils.isBlank((CharSequence)mobile)) {
            return ResultDto.failResult((String)"\u6570\u636e\u9519\u8bef\uff0c\u624b\u673a\u53f7\u6216\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QihoOrderSnapshotEntity order = this.qihoOrderSnapshotDAO.getLastByMobile(mobile);
        if (order == null) {
            return ResultDto.failResult((String)"\u8be5\u624b\u673a\u53f7\u8fd8\u6ca1\u6709\u6b63\u5f0f\u7684\u8ba2\u5355");
        }
        BaiqiUserReplyEntity userReplyEntity = new BaiqiUserReplyEntity();
        userReplyEntity.setOrderId(order.getOrderId());
        userReplyEntity.setContent(content);
        userReplyEntity.setMobile(mobile);
        this.baiqiUserReplyMapper.insertUserReply(userReplyEntity);
        return ResultDto.successResult((Object)Boolean.TRUE);
    }

    @Override
    public List<UserReplyDto> getUserReplyByOrderId(String orderId) {
        List userReplyEntities = this.baiqiUserReplyMapper.listUserReplyByOrderId(orderId);
        if (CollectionUtils.isEmpty((Collection)userReplyEntities)) {
            return Lists.newArrayList();
        }
        return BeanUtils.copyList((List)userReplyEntities, UserReplyDto.class);
    }
}

