/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.tag;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.tag.TagDto;
import com.qiho.center.biz.service.tag.ItemTagService;
import com.qiho.center.common.dao.QihoItemDAO;
import com.qiho.center.common.daoh.qiho.tag.QihoItemTagMapper;
import com.qiho.center.common.daoh.qiho.tag.QihoTagMapper;
import com.qiho.center.common.entity.item.QihoItemEntity;
import com.qiho.center.common.entityd.qiho.tag.QihoItemTagEntity;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItemTagServiceImpl
implements ItemTagService {
    @Autowired
    private QihoItemTagMapper qihoItemTagMapper;
    @Autowired
    private QihoTagMapper qihoTagMapper;
    @Autowired
    private QihoItemDAO qihoItemDAO;

    @Override
    public List<TagDto> findByItemId(Long itemId) {
        List itemTags = this.qihoItemTagMapper.findByItemId(itemId);
        if (CollectionUtils.isEmpty((Collection)itemTags)) {
            return Lists.newArrayList();
        }
        List tagIds = itemTags.stream().map(QihoItemTagEntity::getTagId).collect(Collectors.toList());
        List tagList = this.qihoTagMapper.findByIds(tagIds);
        return BeanUtils.copyList((List)tagList, TagDto.class);
    }

    @Override
    @Transactional(value="QIHO")
    public ResultDto<Boolean> saveItemTag(Long itemId, List<Long> newTagIds) {
        if (Objects.equals(null, itemId) || itemId <= 0L) {
            return ResultDto.failResult((String)"\u53c2\u6570\u5f02\u5e38\uff0citemId\u4e0d\u5408\u6cd5");
        }
        QihoItemEntity itemEntity = this.qihoItemDAO.findSimpleById(itemId);
        if (Objects.equals(null, itemEntity)) {
            return ResultDto.failResult((String)"\u5546\u54c1\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        }
        if (CollectionUtils.isEmpty(newTagIds)) {
            this.qihoItemTagMapper.deleteByItemId(itemId);
            return ResultDto.successResult((Object)Boolean.TRUE);
        }
        List tagEntities = this.qihoTagMapper.findByIds(newTagIds);
        newTagIds = tagEntities.stream().map(e -> e.getId()).collect(Collectors.toList());
        List copyTagIds = newTagIds.stream().collect(Collectors.toList());
        List itemTagEntities = this.qihoItemTagMapper.findByItemId(itemId);
        List originTagIds = itemTagEntities.stream().map(QihoItemTagEntity::getTagId).collect(Collectors.toList());
        copyTagIds.retainAll(originTagIds);
        newTagIds.removeAll(copyTagIds);
        originTagIds.removeAll(copyTagIds);
        if (CollectionUtils.isNotEmpty(originTagIds)) {
            HashMap param = Maps.newHashMap();
            param.put("itemId", itemId);
            param.put("tagIds", originTagIds);
            this.qihoItemTagMapper.deleteByParam((Map)param);
        }
        if (CollectionUtils.isNotEmpty(newTagIds)) {
            List itemTagParam = newTagIds.stream().map(e -> {
                QihoItemTagEntity qihoItemTagEntity = new QihoItemTagEntity();
                qihoItemTagEntity.setItemId(itemId);
                qihoItemTagEntity.setTagId(e);
                return qihoItemTagEntity;
            }).collect(Collectors.toList());
            this.qihoItemTagMapper.insertBatch(itemTagParam);
        }
        return ResultDto.successResult((Object)Boolean.TRUE);
    }

    @Override
    public Boolean copyItemTag(Long originItemId, Long newItemId) {
        List itemTagEntities = this.qihoItemTagMapper.findByItemId(originItemId);
        if (CollectionUtils.isEmpty((Collection)itemTagEntities)) {
            return Boolean.TRUE;
        }
        itemTagEntities.stream().forEach(e -> e.setItemId(newItemId));
        this.qihoItemTagMapper.insertBatch(itemTagEntities);
        return Boolean.TRUE;
    }

    @Override
    public Boolean deleteByItemId(Long itemId) {
        this.qihoItemTagMapper.deleteByItemId(itemId);
        return Boolean.TRUE;
    }

    @Override
    public Boolean batchDeleteByItemId(List<Long> itemIdList) {
        if (CollectionUtils.isEmpty(itemIdList)) {
            return Boolean.TRUE;
        }
        this.qihoItemTagMapper.deleteByItemIdList(itemIdList);
        return Boolean.TRUE;
    }
}

