/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.tag;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.tag.TagDto;
import com.qiho.center.api.params.tag.TagPageParam;
import com.qiho.center.biz.service.tag.TagService;
import com.qiho.center.common.daoh.qiho.tag.QihoItemTagMapper;
import com.qiho.center.common.daoh.qiho.tag.QihoTagMapper;
import com.qiho.center.common.daoh.qiho.tag.QihoTagTypeMapper;
import com.qiho.center.common.entityd.qiho.tag.QihoTagEntity;
import com.qiho.center.common.entityd.qiho.tag.QihoTagTypeEntity;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TagServiceImpl
implements TagService {
    @Autowired
    private QihoTagMapper qihoTagMapper;
    @Autowired
    private QihoTagTypeMapper qihoTagTypeMapper;
    @Autowired
    private QihoItemTagMapper qihoItemTagMapper;

    @Override
    public ResultDto<Boolean> saveTag(TagDto tagDto) {
        QihoTagTypeEntity tagTypeEntity = this.qihoTagTypeMapper.findById(tagDto.getTypeId());
        if (Objects.equals(null, tagTypeEntity)) {
            return ResultDto.failResult((String)"\u65e0\u6548\u7684\u6807\u7b7e\u7c7b\u578b");
        }
        if (Objects.equals(null, tagDto.getId())) {
            return this.createTag(tagDto);
        }
        return this.updateTag(tagDto);
    }

    @Transactional(value="QIHO")
    public ResultDto<Boolean> createTag(TagDto tagDto) {
        QihoTagEntity param = (QihoTagEntity)BeanUtils.copy((Object)tagDto, QihoTagEntity.class);
        QihoTagEntity tagEntity = this.qihoTagMapper.findByParam(param);
        if (!Objects.equals(null, tagEntity)) {
            return ResultDto.failResult((String)"\u5df2\u6709\u76f8\u540c\u6807\u7b7e\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
        }
        return ResultDto.successResult((Object)(this.qihoTagMapper.insert(param) == 1 ? 1 : 0));
    }

    @Transactional(value="QIHO")
    public ResultDto<Boolean> updateTag(TagDto tagDto) {
        QihoTagEntity param = (QihoTagEntity)BeanUtils.copy((Object)tagDto, QihoTagEntity.class);
        QihoTagEntity tagEntity = this.qihoTagMapper.findByParam(param);
        if (!Objects.equals(null, tagEntity)) {
            return ResultDto.failResult((String)"\u5df2\u6709\u76f8\u540c\u6807\u7b7e\u6216\u6807\u7b7e\u672a\u4fee\u6539\uff0c\u8bf7\u52ff\u91cd\u590d\u4fdd\u5b58");
        }
        QihoTagEntity oldTagEntity = this.qihoTagMapper.findById(tagDto.getId());
        if (oldTagEntity.getTypeId().longValue() != tagDto.getTypeId().longValue()) {
            this.qihoItemTagMapper.deleteByTagId(tagDto.getId());
        }
        return ResultDto.successResult((Object)(this.qihoTagMapper.update(param) == 1 ? 1 : 0));
    }

    @Override
    public Boolean delete(Long tagId) {
        this.qihoItemTagMapper.deleteByTagId(tagId);
        return this.qihoTagMapper.delete(tagId) == 1;
    }

    @Override
    public List<TagDto> findByTypeId(Long typeId) {
        List list = this.qihoTagMapper.findByTypeId(typeId);
        return BeanUtils.copyList((List)list, TagDto.class);
    }

    @Override
    public PagenationDto<TagDto> queryPage(TagPageParam param) {
        PagenationDto page = new PagenationDto();
        Integer count = this.qihoTagMapper.countPage(param);
        page.setTotal(count);
        if (count == 0) {
            page.setList((List)Lists.newArrayList());
            return page;
        }
        List tagEntities = this.qihoTagMapper.queryPage(param);
        List typeIds = tagEntities.stream().map(QihoTagEntity::getTypeId).collect(Collectors.toList());
        List tagType = this.qihoTagTypeMapper.findByTypeIds(typeIds);
        HashMap typaMap = Maps.newHashMap();
        tagType.stream().forEach(e -> typaMap.put(e.getId(), e.getTypeName()));
        List tagDtoList = Lists.transform((List)tagEntities, e -> {
            TagDto tag = (TagDto)BeanUtils.copy((Object)e, TagDto.class);
            tag.setTypeName((String)typaMap.get(e.getTypeId()));
            return tag;
        });
        page.setList(tagDtoList);
        return page;
    }
}

