/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.tag;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.dto.CategoryDto;
import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.tag.TagDto;
import com.qiho.center.api.dto.tag.TagTypeDto;
import com.qiho.center.api.params.tag.QueryTagTypeParam;
import com.qiho.center.biz.service.tag.TagTypeService;
import com.qiho.center.common.dao.QihoCategoryDAO;
import com.qiho.center.common.dao.QihoItemDAO;
import com.qiho.center.common.daoh.qiho.tag.QihoItemTagMapper;
import com.qiho.center.common.daoh.qiho.tag.QihoTagMapper;
import com.qiho.center.common.daoh.qiho.tag.QihoTagTypeCategoryMapper;
import com.qiho.center.common.daoh.qiho.tag.QihoTagTypeMapper;
import com.qiho.center.common.entity.BaseEntity;
import com.qiho.center.common.entity.item.QihoItemEntity;
import com.qiho.center.common.entityd.qiho.tag.QihoTagEntity;
import com.qiho.center.common.entityd.qiho.tag.QihoTagTypeCategoryEntity;
import com.qiho.center.common.entityd.qiho.tag.QihoTagTypeEntity;
import com.qiho.center.common.params.tag.QihoTagTypeQueryParam;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TagTypeServiceImpl
implements TagTypeService {
    @Autowired
    private QihoTagMapper qihoTagMapper;
    @Autowired
    private QihoTagTypeMapper qihoTagTypeMapper;
    @Autowired
    private QihoTagTypeCategoryMapper qihoTagTypeCategoryMapper;
    @Autowired
    private QihoCategoryDAO qihoCategoryDAO;
    @Autowired
    private QihoItemTagMapper qihoItemTagMapper;
    @Autowired
    private QihoItemDAO qihoItemDAO;

    @Override
    public ResultDto<Boolean> saveTagType(TagTypeDto tagTypeDto, List<Long> categoryIds) {
        List categoryEntities;
        if (CollectionUtils.isNotEmpty(categoryIds) && (categoryEntities = this.qihoCategoryDAO.findByCategoryIds(categoryIds)).size() < categoryIds.size()) {
            categoryIds = categoryEntities.stream().map(BaseEntity::getId).collect(Collectors.toList());
        }
        if (Objects.equals(null, tagTypeDto.getId())) {
            return this.createTagType(tagTypeDto, categoryIds);
        }
        return this.updateTagType(tagTypeDto, categoryIds);
    }

    @Transactional(value="QIHO")
    public ResultDto<Boolean> createTagType(TagTypeDto tagTypeDto, List<Long> categoryIds) {
        QihoTagTypeEntity qihoTagTypeEntity = this.qihoTagTypeMapper.findByTypeName(tagTypeDto.getTypeName());
        if (!Objects.equals(null, qihoTagTypeEntity)) {
            return ResultDto.failResult((String)"\u6807\u7b7e\u7c7b\u578b\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
        }
        QihoTagTypeEntity tagTypeEntity = (QihoTagTypeEntity)BeanUtils.copy((Object)tagTypeDto, QihoTagTypeEntity.class);
        this.qihoTagTypeMapper.insert(tagTypeEntity);
        if (CollectionUtils.isNotEmpty(categoryIds)) {
            List typeCategoryEntities = categoryIds.stream().map(e -> {
                QihoTagTypeCategoryEntity entity = new QihoTagTypeCategoryEntity();
                entity.setTypeId(tagTypeEntity.getId());
                entity.setCategoryId(e);
                return entity;
            }).collect(Collectors.toList());
            this.qihoTagTypeCategoryMapper.insertBatch(typeCategoryEntities);
        }
        return ResultDto.successResult((Object)true);
    }

    @Transactional(value="QIHO")
    public ResultDto<Boolean> updateTagType(TagTypeDto tagTypeDto, List<Long> newCategoryIds) {
        QihoTagTypeEntity tagTypeEntity = this.qihoTagTypeMapper.findByTypeName(tagTypeDto.getTypeName());
        if (!Objects.equals(null, tagTypeEntity) && tagTypeEntity.getId().longValue() != tagTypeDto.getId().longValue()) {
            return ResultDto.failResult((String)"\u6807\u7b7e\u7c7b\u578b\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
        }
        List typeCategoryEntities = this.qihoTagTypeCategoryMapper.findByTypeId(tagTypeDto.getId());
        List oldCategoryIds = typeCategoryEntities.stream().map(QihoTagTypeCategoryEntity::getCategoryId).collect(Collectors.toList());
        List intersecIds = newCategoryIds.stream().collect(Collectors.toList());
        intersecIds.retainAll(oldCategoryIds);
        newCategoryIds.removeAll(intersecIds);
        oldCategoryIds.removeAll(intersecIds);
        QihoTagTypeEntity qihoTagTypeEntity = (QihoTagTypeEntity)BeanUtils.copy((Object)tagTypeDto, QihoTagTypeEntity.class);
        this.qihoTagTypeMapper.update(qihoTagTypeEntity);
        if (CollectionUtils.isNotEmpty(oldCategoryIds)) {
            HashMap param = Maps.newHashMap();
            param.put("typeId", tagTypeDto.getId());
            param.put("categoryIdList", oldCategoryIds);
            this.qihoTagTypeCategoryMapper.deleteBatch((Map)param);
            List itemEntityList = this.qihoItemDAO.findByCategoryIds(oldCategoryIds);
            List tagEntityList = this.qihoTagMapper.findByTypeId(tagTypeDto.getId());
            if (CollectionUtils.isNotEmpty((Collection)itemEntityList) && CollectionUtils.isNotEmpty((Collection)tagEntityList)) {
                List itemIdList = itemEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
                List tagIdList = tagEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
                HashMap paramMap = Maps.newHashMap();
                paramMap.put("itemIdList", itemIdList);
                paramMap.put("tagIdList", tagIdList);
                this.qihoItemTagMapper.deleteByItemTagIds((Map)paramMap);
            }
        }
        if (CollectionUtils.isNotEmpty(newCategoryIds)) {
            List tagTypeCategoryEntities = newCategoryIds.stream().map(e -> {
                QihoTagTypeCategoryEntity entity = new QihoTagTypeCategoryEntity();
                entity.setTypeId(tagTypeDto.getId());
                entity.setCategoryId(e);
                return entity;
            }).collect(Collectors.toList());
            this.qihoTagTypeCategoryMapper.insertBatch(tagTypeCategoryEntities);
        }
        return ResultDto.successResult((Object)true);
    }

    @Override
    public List<TagTypeDto> queryTagType(QueryTagTypeParam param) {
        QihoTagTypeQueryParam queryParam = new QihoTagTypeQueryParam();
        queryParam.setTypeName(param.getTypeName());
        if (!Objects.equals(null, param.getCategoryId()) && param.getCategoryId() > 0L) {
            List typeCategorys = this.qihoTagTypeCategoryMapper.findByCategoryId(param.getCategoryId());
            if (CollectionUtils.isEmpty((Collection)typeCategorys)) {
                return Lists.newArrayList();
            }
            List typeIds = typeCategorys.stream().map(QihoTagTypeCategoryEntity::getTypeId).collect(Collectors.toList());
            queryParam.setTypeIdList(typeIds);
        }
        return BeanUtils.copyList((List)this.qihoTagTypeMapper.queryTayType(queryParam), TagTypeDto.class);
    }

    @Override
    @Transactional(value="QIHO")
    public Boolean deleteTagType(Long typeId) {
        this.qihoTagTypeMapper.deleteTagType(typeId);
        this.qihoTagMapper.deleteByTypeId(typeId);
        this.qihoTagTypeCategoryMapper.deleteBatchByTypeId(typeId);
        return Boolean.TRUE;
    }

    @Override
    public ResultDto<List<TagTypeDto>> findByItemId(Long itemId) {
        if (Objects.equals(null, itemId) || itemId <= 0L) {
            return ResultDto.failResult((String)"\u975e\u6cd5\u7684\u5546\u54c1id");
        }
        QihoItemEntity item = this.qihoItemDAO.findSimpleById(itemId);
        if (Objects.equals(null, item)) {
            return ResultDto.failResult((String)"\u65e0\u6548\u7684\u5546\u54c1");
        }
        Long categoryId = item.getTopCategoryId();
        List typeCategorys = this.qihoTagTypeCategoryMapper.findByCategoryId(categoryId);
        if (CollectionUtils.isEmpty((Collection)typeCategorys)) {
            return ResultDto.successResult((Object)Lists.newArrayList());
        }
        List typeIds = typeCategorys.stream().map(QihoTagTypeCategoryEntity::getTypeId).collect(Collectors.toList());
        List tagTypes = this.qihoTagTypeMapper.findByTypeIds(typeIds);
        List typeDtos = BeanUtils.copyList((List)tagTypes, TagTypeDto.class);
        List tagEntities = this.qihoTagMapper.findByTypeIds(typeIds);
        HashMap map = Maps.newHashMap();
        for (QihoTagEntity tagEntity : tagEntities) {
            TagDto tagDto = (TagDto)BeanUtils.copy((Object)tagEntity, TagDto.class);
            Long typeId = tagEntity.getTypeId();
            if (map.get(typeId) == null) {
                map.put(typeId, Lists.newArrayList((Object[])new TagDto[]{tagDto}));
                continue;
            }
            List tagDtoList = (List)map.get(typeId);
            tagDtoList.add(tagDto);
            map.put(typeId, tagDtoList);
        }
        typeDtos.stream().peek(e -> e.setTagList(map.get(e.getId()) == null ? Lists.newArrayList() : (List)map.get(e.getId()))).collect(Collectors.toList());
        return ResultDto.successResult((Object)typeDtos);
    }

    @Override
    public List<CategoryDto> findCategoryByTypeId(Long typeId) {
        List typeCategorys = this.qihoTagTypeCategoryMapper.findByTypeId(typeId);
        if (CollectionUtils.isEmpty((Collection)typeCategorys)) {
            return Lists.newArrayList();
        }
        List categoryIds = typeCategorys.stream().map(QihoTagTypeCategoryEntity::getCategoryId).collect(Collectors.toList());
        List categoryEntities = this.qihoCategoryDAO.findByCategoryIds(categoryIds);
        return BeanUtils.copyList((List)categoryEntities, CategoryDto.class);
    }
}

