/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.logistics;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.logistics.LogisticsProcessDto;
import com.qiho.center.api.enums.LogisticsNameEnum;
import com.qiho.center.biz.service.logistics.LogisticsQueryDecider;
import com.qiho.center.biz.service.logistics.LogisticsQueryProcessor;
import com.qiho.center.common.params.QueryYTOLogisticProcessParams;
import com.qiho.center.common.params.YTOLogisticProcessParams;
import com.qiho.center.common.util.JaxbUtil;
import com.qiho.center.common.util.YTOClientUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class YtoQueryProcessor
implements LogisticsQueryProcessor,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(YtoQueryProcessor.class);
    private static final String YTO_FAILED_RETURN = "<success>false</success>";

    @Override
    public List<LogisticsProcessDto> queryWaybillTrace(String postId) {
        List list = Lists.newArrayList();
        if (StringUtils.isBlank((String)postId)) {
            return list;
        }
        QueryYTOLogisticProcessParams queryXml = new QueryYTOLogisticProcessParams(new QueryYTOLogisticProcessParams.Result(new QueryYTOLogisticProcessParams.Result.WaybillCode(postId)));
        try {
            YTOLogisticProcessParams returnLogistics;
            String logisticsString = YTOClientUtil.execute((String)YTOClientUtil.getQueryLogisticsUrl(), (Object)queryXml);
            if (StringUtils.isNotBlank((String)logisticsString) && !StringUtils.contains((String)logisticsString, (String)YTO_FAILED_RETURN) && (returnLogistics = (YTOLogisticProcessParams)JaxbUtil.converyToJavaBean((String)logisticsString, YTOLogisticProcessParams.class)) != null) {
                List logisticDetail = returnLogistics.getResult().getLogisticDetail();
                list = BeanUtils.copyList((List)logisticDetail, LogisticsProcessDto.class);
            }
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                Collections.reverse(list);
            }
        }
        catch (Exception e) {
            LOG.warn("\u67e5\u8be2\u5706\u901a\u5feb\u9012\u8fd0\u5355\u8d70\u4ef6\u6d41\u7a0b\u5f02\u5e38\uff0c postId=" + postId, (Throwable)e);
        }
        return list;
    }

    public void afterPropertiesSet() throws Exception {
        LogisticsQueryDecider.registLogisticsQueryProcessor(LogisticsNameEnum.YTO, this);
    }
}

