/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.menu.impl;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import com.qiho.center.api.dto.menu.MenuDto;
import com.qiho.center.api.params.menu.MenuParams;
import com.qiho.center.biz.service.account.BaiqiAccountService;
import com.qiho.center.biz.service.menu.MenuService;
import com.qiho.center.common.daoh.qiho.menu.BaiqiMenuMapper;
import com.qiho.center.common.entityd.qiho.menu.BaiqiMenuEntity;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MenuServiceImpl
implements MenuService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MenuServiceImpl.class);
    @Resource
    private BaiqiMenuMapper baiqiMenuMapper;
    @Resource(name="redisTemplate")
    private AdvancedCacheClient advancedCacheClient;
    @Resource
    private BaiqiAccountService baiqiAccountService;

    @Override
    public boolean initMenu() {
        try {
            this.updateSortByCode("AllOrder", "\u5168\u90e8\u8ba2\u5355", 100);
            this.updateSortByCode("ExamineOrder", "\u5f85\u5ba1\u6838\u8ba2\u5355", 101);
            this.updateSortByCode("ERPSubOrder", "\u5f85\u53d1\u8d27\u8ba2\u5355", 102);
            this.updateSortByCode("AlreadySendOrder", "\u5df2\u53d1\u8d27\u8ba2\u5355", 103);
            this.updateSortByCode("CancelSendOrder", "\u53d6\u6d88\u53d1\u8d27\u8ba2\u5355", 104);
            this.updateSortByCode("CustomerServiceOrder", "\u552e\u540e\u5b50\u8ba2\u5355", 105);
            return Boolean.TRUE;
        }
        catch (Exception e) {
            LOGGER.error("\u521d\u59cb\u5316\u6570\u636e\u83dc\u5355\u9519\u8bef", (Throwable)e);
            return Boolean.FALSE;
        }
    }

    @Override
    public Long saveMenu(MenuDto menuDto) throws BizException {
        BaiqiMenuEntity entity = MenuServiceImpl.menuDtoToEntity(menuDto);
        if (null == entity) {
            return 0L;
        }
        Integer result = this.baiqiMenuMapper.insert(entity);
        if (0 >= result) {
            return 0L;
        }
        this.removeCacheLogin();
        return entity.getId();
    }

    @Override
    public Integer updateMenu(MenuDto menuDto) throws BizException {
        BaiqiMenuEntity entity = MenuServiceImpl.menuDtoToEntity(menuDto);
        if (null == entity) {
            return 0;
        }
        entity.setSorted(Integer.valueOf(this.getSorted(entity.getSorted())));
        Integer result = this.baiqiMenuMapper.updateById(entity);
        this.removeCacheLogin();
        return result;
    }

    @Override
    public Integer updateByCode(MenuDto menuDto) throws BizException {
        BaiqiMenuEntity entity = MenuServiceImpl.menuDtoToEntity(menuDto);
        if (null == entity) {
            return 0;
        }
        entity.setSorted(Integer.valueOf(this.getSorted(entity.getSorted())));
        Integer result = this.baiqiMenuMapper.updateByCode(entity);
        this.removeCacheLogin();
        return result;
    }

    @Override
    public Integer deleteById(Long id) throws BizException {
        Integer result = this.baiqiMenuMapper.deleteById(id);
        this.removeCacheLogin();
        return result;
    }

    @Override
    public Integer deleteByCode(String code) throws BizException {
        Integer result = this.baiqiMenuMapper.deleteByCode(code);
        this.removeCacheLogin();
        return result;
    }

    @Override
    public MenuDto findByCode(String code) throws BizException {
        MenuParams params = new MenuParams();
        params.setMenuCode(code);
        List<MenuDto> menuDtoList = this.findByParam(params);
        if (CollectionUtils.isEmpty(menuDtoList)) {
            return null;
        }
        return menuDtoList.get(0);
    }

    @Override
    public List<MenuDto> findByParam(MenuParams menuParams) throws BizException {
        List entityList = this.baiqiMenuMapper.selectByParam(menuParams);
        return MenuServiceImpl.menuEntityToDto(entityList);
    }

    private void removeCacheLogin() {
        List<String> accountList = this.baiqiAccountService.findAllMainAccount();
        if (CollectionUtils.isEmpty(accountList)) {
            return;
        }
        for (String account : accountList) {
            this.advancedCacheClient.remove("BAIQI:FERRARI:USER:" + account);
        }
    }

    public static BaiqiMenuEntity menuDtoToEntity(MenuDto menuDto) {
        if (menuDto == null) {
            return null;
        }
        BaiqiMenuEntity baiqiMenuEntity = new BaiqiMenuEntity();
        baiqiMenuEntity.setId(menuDto.getId());
        baiqiMenuEntity.setParentId(menuDto.getParentId());
        baiqiMenuEntity.setMenuCode(menuDto.getMenuCode());
        baiqiMenuEntity.setMenuName(menuDto.getMenuName());
        baiqiMenuEntity.setRemark(menuDto.getRemark());
        baiqiMenuEntity.setSorted(menuDto.getSorted());
        baiqiMenuEntity.setDeleted(menuDto.getDeleted());
        baiqiMenuEntity.setGmtCreate(menuDto.getGmtCreate());
        baiqiMenuEntity.setGmtModified(menuDto.getGmtModified());
        return baiqiMenuEntity;
    }

    public static MenuDto menuEntityToDto(BaiqiMenuEntity entity) {
        if (entity == null) {
            return null;
        }
        MenuDto menuDto = new MenuDto();
        menuDto.setId(entity.getId());
        menuDto.setParentId(entity.getParentId());
        menuDto.setMenuCode(entity.getMenuCode());
        menuDto.setMenuName(entity.getMenuName());
        menuDto.setRemark(entity.getRemark());
        menuDto.setSorted(entity.getSorted());
        menuDto.setDeleted(entity.getDeleted());
        menuDto.setGmtCreate(entity.getGmtCreate());
        menuDto.setGmtModified(entity.getGmtModified());
        return menuDto;
    }

    public static List<MenuDto> menuEntityToDto(List<BaiqiMenuEntity> entityList) {
        if (null == entityList || entityList.isEmpty()) {
            return Collections.emptyList();
        }
        return entityList.stream().map(MenuServiceImpl::menuEntityToDto).collect(Collectors.toList());
    }

    private int getSorted(Integer sort) {
        if (null == sort || sort < 0) {
            return 0;
        }
        if (sort > 1000) {
            return 1000;
        }
        return sort;
    }

    private Boolean updateSortByCode(String code, String name, int sort) throws BizException {
        MenuDto menuDto = new MenuDto();
        menuDto.setMenuCode(code);
        menuDto.setMenuName(name);
        menuDto.setSorted(Integer.valueOf(this.getSorted(sort)));
        if (1 == this.updateByCode(menuDto)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

