/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.merchant.impl;

import com.google.common.collect.Lists;
import com.qiho.center.api.dto.merchant.MerchantAdvertDto;
import com.qiho.center.api.dto.merchant.MerchantDto;
import com.qiho.center.api.dto.merchant.MerchantSimpleDto;
import com.qiho.center.api.enums.merchant.BaiqiMerchantLinkTypeEnum;
import com.qiho.center.biz.service.merchant.BaiqiMerchantLinkService;
import com.qiho.center.biz.service.merchant.MerchantService;
import com.qiho.center.common.daoh.qiho.merchant.BaiqiMerchantLinkMapper;
import com.qiho.center.common.entityd.qiho.merchant.BaiqiMerchantLinkEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service(value="baiqiMerchantLinkService")
public class BaiqiMerchantLinkSerivceImpl
implements BaiqiMerchantLinkService {
    @Resource
    private BaiqiMerchantLinkMapper merchantLinkMapper;
    @Resource
    private MerchantService merchantService;

    @Override
    @Transactional(rollbackFor={Exception.class}, value="QIHO")
    public void batchInsertTuiaLink(List<BaiqiMerchantLinkEntity> insertEntityList) {
        if (CollectionUtils.isEmpty(insertEntityList)) {
            return;
        }
        List<Object> resultList = insertEntityList;
        List allTuiaList = this.merchantLinkMapper.findByType(BaiqiMerchantLinkTypeEnum.TUI_A.getType());
        if (CollectionUtils.isNotEmpty((Collection)allTuiaList)) {
            List existAdvertIdList = allTuiaList.stream().map(BaiqiMerchantLinkEntity::getRelationId).collect(Collectors.toList());
            resultList = insertEntityList.stream().filter(e -> !existAdvertIdList.contains(e.getRelationId())).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty(resultList)) {
            this.merchantLinkMapper.batchInsert(resultList);
        }
    }

    @Override
    public BaiqiMerchantLinkEntity findByRelation(Integer relationType, Long relationId) {
        Assert.notNull((Object)relationId, (String)"\u5173\u8054id\u4e0d\u80fd\u4e3a\u7a7a");
        BaiqiMerchantLinkTypeEnum typeEnum = BaiqiMerchantLinkTypeEnum.findByType((Integer)relationType);
        if (typeEnum == null) {
            return null;
        }
        return this.merchantLinkMapper.findByRelation(relationType, relationId);
    }

    @Override
    public List<BaiqiMerchantLinkEntity> findByType(BaiqiMerchantLinkTypeEnum tuiAEnum) {
        if (tuiAEnum == null) {
            return Collections.emptyList();
        }
        return this.merchantLinkMapper.findByType(tuiAEnum.getType());
    }

    @Override
    public List<BaiqiMerchantLinkEntity> findByTypeWithLinked(BaiqiMerchantLinkTypeEnum typeEnum) {
        if (typeEnum == null) {
            return Collections.emptyList();
        }
        List<BaiqiMerchantLinkEntity> allList = this.findByType(typeEnum);
        if (CollectionUtils.isEmpty(allList)) {
            return Collections.emptyList();
        }
        return allList.stream().filter(e -> e.getMerchantId() != null).collect(Collectors.toList());
    }

    @Override
    public List<MerchantAdvertDto> findAllWithUnlinked(Long merchantId) {
        List<BaiqiMerchantLinkEntity> advertList = this.findByType(BaiqiMerchantLinkTypeEnum.TUI_A);
        if (merchantId != null) {
            return this.findWithMerchantId(merchantId, advertList);
        }
        List<MerchantSimpleDto> allMerchantList = this.merchantService.findAllIdAndNames();
        if (CollectionUtils.isEmpty(allMerchantList)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)allMerchantList.size());
        allMerchantList.forEach(e -> {
            MerchantAdvertDto merchantAdvertDto = new MerchantAdvertDto();
            merchantAdvertDto.setMerchantId(e.getId());
            merchantAdvertDto.setMerchantName(e.getMerchantName());
            this.setAdvertInfo(e.getId(), merchantAdvertDto, advertList);
            result.add(merchantAdvertDto);
        });
        return this.sortMerchant(result);
    }

    @Override
    public Boolean insert(MerchantAdvertDto merchantAdvertDto) {
        BaiqiMerchantLinkEntity insertEntity = new BaiqiMerchantLinkEntity();
        insertEntity.setRelationType(Integer.valueOf(BaiqiMerchantLinkTypeEnum.TUI_A.getType()));
        insertEntity.setRelationId(merchantAdvertDto.getAdvertId());
        insertEntity.setRelationName(merchantAdvertDto.getAdvertName());
        insertEntity.setMerchantId(merchantAdvertDto.getMerchantId());
        return this.merchantLinkMapper.insert(insertEntity) > 0;
    }

    @Override
    public Long findRelationIdByMerchantIdAndRelationType(Long merchantId, BaiqiMerchantLinkTypeEnum relationType) {
        BaiqiMerchantLinkEntity entity = this.merchantLinkMapper.findByMerchantIdAndRelationType(merchantId, Integer.valueOf(relationType.getType()));
        if (null == entity) {
            return 0L;
        }
        return entity.getRelationId();
    }

    private List<MerchantAdvertDto> sortMerchant(List<MerchantAdvertDto> list) {
        List unlinkedList = list.stream().filter(e -> e.getAdvertId() == null).collect(Collectors.toList());
        List linkedList = list.stream().filter(e -> e.getAdvertId() != null).collect(Collectors.toList());
        ArrayList result = Lists.newArrayListWithExpectedSize((int)list.size());
        if (CollectionUtils.isNotEmpty(unlinkedList)) {
            result.addAll(unlinkedList);
        }
        if (CollectionUtils.isNotEmpty(linkedList)) {
            result.addAll(linkedList);
        }
        return result;
    }

    private void setAdvertInfo(Long merchantId, MerchantAdvertDto merchantAdvertDto, List<BaiqiMerchantLinkEntity> advertList) {
        BaiqiMerchantLinkEntity linkEntity;
        if (CollectionUtils.isNotEmpty(advertList) && (linkEntity = (BaiqiMerchantLinkEntity)advertList.stream().filter(n -> merchantId.equals(n.getMerchantId())).findFirst().orElse(null)) != null) {
            merchantAdvertDto.setAdvertId(linkEntity.getRelationId());
            merchantAdvertDto.setAdvertName(linkEntity.getRelationName());
            merchantAdvertDto.setLinked(Boolean.valueOf(true));
        }
    }

    private List<MerchantAdvertDto> findWithMerchantId(Long merchantId, List<BaiqiMerchantLinkEntity> advertList) {
        MerchantDto merchantDto = this.merchantService.findById(merchantId);
        if (merchantDto == null) {
            return Collections.emptyList();
        }
        MerchantAdvertDto merchantAdvertDto = new MerchantAdvertDto();
        this.setAdvertInfo(merchantId, merchantAdvertDto, advertList);
        merchantAdvertDto.setMerchantId(merchantId);
        merchantAdvertDto.setMerchantName(merchantDto.getMerchantName());
        return Lists.newArrayList((Object[])new MerchantAdvertDto[]{merchantAdvertDto});
    }
}

