/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.merchant.impl;

import com.qiho.center.api.dto.merchant.MerchantSimpleDto;
import com.qiho.center.api.dto.merchant.MerchantUndeliveryDto;
import com.qiho.center.api.params.merchant.MerchantUndeliveryQueryParams;
import com.qiho.center.biz.service.merchant.MerchantService;
import com.qiho.center.biz.service.merchant.MerchantUndeliveryService;
import com.qiho.center.common.daoh.qiho.merchant.MerchantUndeliveryMapper;
import com.qiho.center.common.entityd.qiho.merchant.BaiqiMerchantUndeliveryEntity;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class MerchantUndeliveryServiceImpl
implements MerchantUndeliveryService {
    @Resource
    private MerchantUndeliveryMapper merchantUndeliveryMapper;
    @Resource
    private MerchantService merchantService;

    @Override
    public List<MerchantUndeliveryDto> findByParams(MerchantUndeliveryQueryParams queryParams) {
        Assert.notNull((Object)queryParams, (String)"\u67e5\u8be2\u53c2\u6570\u4e3a\u7a7a");
        List dtoList = this.merchantUndeliveryMapper.findByParams(queryParams);
        if (CollectionUtils.isNotEmpty((Collection)dtoList)) {
            this.addMerchantName(dtoList);
        }
        return dtoList;
    }

    private void addMerchantName(List<MerchantUndeliveryDto> dtoList) {
        List<Long> merchantIdList = dtoList.stream().map(MerchantUndeliveryDto::getMerchantId).distinct().collect(Collectors.toList());
        List<MerchantSimpleDto> simpleDtoList = this.merchantService.findIdAndNamesByIds(merchantIdList);
        if (CollectionUtils.isEmpty(simpleDtoList)) {
            return;
        }
        Map idAndNameMap = simpleDtoList.stream().collect(Collectors.toMap(MerchantSimpleDto::getId, MerchantSimpleDto::getMerchantName, (oldOne, newOne) -> newOne, HashMap::new));
        dtoList.forEach(dto -> dto.setMerchantName((String)idAndNameMap.get(dto.getMerchantId())));
    }

    @Override
    public int countByParams(MerchantUndeliveryQueryParams queryParams) {
        Assert.notNull((Object)queryParams, (String)"\u67e5\u8be2\u53c2\u6570\u4e3a\u7a7a");
        return this.merchantUndeliveryMapper.countByParams(queryParams);
    }

    @Override
    public Boolean deleteByIds(List<Long> idList) {
        return !CollectionUtils.isEmpty(idList) && this.merchantUndeliveryMapper.deleteByIds(idList) > 0;
    }

    @Override
    public Boolean batchInsert(List<BaiqiMerchantUndeliveryEntity> undeliveryList) {
        return !CollectionUtils.isEmpty(undeliveryList) && this.merchantUndeliveryMapper.batchInsert(undeliveryList) > 0;
    }

    @Override
    public List<String> findUndelivery(Long merchantId) {
        if (merchantId == null) {
            return Collections.emptyList();
        }
        return this.merchantUndeliveryMapper.findUndelivery(merchantId);
    }
}

