/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.page.impl;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.abtest.TestMetadataDto;
import com.qiho.center.api.dto.page.BaiqiPageDto;
import com.qiho.center.api.enums.MetadataTypeEnum;
import com.qiho.center.biz.service.abtest.TestMetadataService;
import com.qiho.center.biz.service.page.BaiqiPageService;
import com.qiho.center.common.daoh.qiho.QihoTestMetadataMapper;
import com.qiho.center.common.daoh.qiho.page.BaiqiPageMapper;
import com.qiho.center.common.entityd.qiho.page.BaiqiPageEntity;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BaiqiPageServiceImpl
implements BaiqiPageService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaiqiPageServiceImpl.class);
    @Resource
    private BaiqiPageMapper baiqiPageMapper;
    @Resource
    QihoTestMetadataMapper qihoTestMetadataMapper;
    @Resource
    private TestMetadataService testMetadataService;

    @Override
    @Transactional(value="QIHO", rollbackFor={Exception.class})
    public Long savePage(BaiqiPageDto pageDto) {
        BaiqiPageEntity pageEntity = (BaiqiPageEntity)BeanUtils.copy((Object)pageDto, BaiqiPageEntity.class);
        if (pageEntity == null) {
            return null;
        }
        Long pageId = pageEntity.getId();
        if (pageId == null) {
            try {
                this.baiqiPageMapper.insert(pageEntity);
                TestMetadataDto testMetadataDto = new TestMetadataDto();
                testMetadataDto.setItemId(Long.valueOf(0L));
                testMetadataDto.setMetadataKey(MetadataTypeEnum.SKIN.getCode());
                testMetadataDto.setMetadataValue(pageEntity.getId().toString());
                testMetadataDto.setDataName(pageEntity.getPageName());
                testMetadataDto.setDataDesc(pageEntity.getPageName());
                testMetadataDto.setSkinType(1);
                this.testMetadataService.saveMetadata(testMetadataDto);
            }
            catch (Exception e) {
                LOGGER.error("BaiqiPageServiceImpl savePage call saveMetadata error,param={}", (Object)JSON.toJSONString((Object)pageEntity), (Object)e);
            }
            return pageEntity.getId();
        }
        try {
            this.baiqiPageMapper.update(pageEntity);
            TestMetadataDto testMetadataDto = new TestMetadataDto();
            testMetadataDto.setMetadataKey(MetadataTypeEnum.SKIN.getCode());
            testMetadataDto.setMetadataValue(pageEntity.getId().toString());
            testMetadataDto.setDataName(pageEntity.getPageName());
            testMetadataDto.setDataDesc(pageEntity.getPageName());
            testMetadataDto.setSkinType(1);
            HashMap map = Maps.newHashMap();
            map.put("metadataKey", MetadataTypeEnum.SKIN.getCode());
            map.put("metadataValue", pageEntity.getId().toString());
            map.put("skinType", 1);
            List entityList = this.qihoTestMetadataMapper.selectListByField((Map)map);
            if (CollectionUtils.isEmpty((Collection)entityList)) {
                testMetadataDto.setItemId(Long.valueOf(0L));
                this.testMetadataService.saveMetadata(testMetadataDto);
            } else {
                this.testMetadataService.updateMetadata(testMetadataDto);
            }
        }
        catch (Exception e) {
            LOGGER.error("BaiqiPageServiceImpl savePage call saveMetadata error,param={}", (Object)JSON.toJSONString((Object)pageEntity), (Object)e);
        }
        return pageId;
    }

    @Override
    public PagenationDto<BaiqiPageDto> find4Paging(String pageName, Integer pageType, Integer offset, Integer pageSize) {
        List pageList = this.baiqiPageMapper.find4Paging(pageName, pageType, offset, pageSize);
        if (CollectionUtils.isEmpty((Collection)pageList)) {
            return new PagenationDto();
        }
        int count = this.baiqiPageMapper.count4Paging(pageName, pageType);
        PagenationDto pagenation = new PagenationDto();
        pagenation.setList(this.transToDto(pageList));
        pagenation.setTotal(Integer.valueOf(count));
        return pagenation;
    }

    @Override
    public String findPageUrl(Long pageId) {
        if (pageId == null) {
            return null;
        }
        return this.baiqiPageMapper.findPageUrl(pageId);
    }

    @Override
    public String findPageMd5(Long pageId) {
        if (pageId == null) {
            return null;
        }
        return this.baiqiPageMapper.findPageMd5(pageId);
    }

    @Override
    public BaiqiPageDto findById(Long pageId) {
        if (pageId == null || pageId <= 0L) {
            return null;
        }
        BaiqiPageEntity pageEntity = this.baiqiPageMapper.findById(pageId);
        return (BaiqiPageDto)BeanUtils.copy((Object)pageEntity, BaiqiPageDto.class);
    }

    private List<BaiqiPageDto> transToDto(List<BaiqiPageEntity> pageList) {
        return BeanUtils.copyList(pageList, BaiqiPageDto.class);
    }
}

