/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.sms.impl;

import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.sms.ChuangLanSmsReportDto;
import com.qiho.center.api.enums.OrderStatusEnum;
import com.qiho.center.api.enums.ordersms.SmsMobileStatusEnum;
import com.qiho.center.api.params.OrderAuditParams;
import com.qiho.center.biz.engine.impl.ShotOrderEngine;
import com.qiho.center.biz.service.order.OrderService;
import com.qiho.center.biz.service.sms.ChuangLanService;
import com.qiho.center.common.dao.QihoOrderSnapshotDAO;
import com.qiho.center.common.daoh.qiho.ChuangLanSmsCommitMapper;
import com.qiho.center.common.daoh.qiho.ChuangLanSmsReportMapper;
import com.qiho.center.common.daoh.qiho.anticheate.AnticheateMapper;
import com.qiho.center.common.entity.order.QihoOrderSnapshotEntity;
import com.qiho.center.common.entityd.qiho.ChuangLanSmsCommitEntity;
import com.qiho.center.common.entityd.qiho.ChuangLanSmsReportEntity;
import com.qiho.center.common.entityd.qiho.anticheate.AnticheateEntity;
import com.qiho.center.common.util.HttpClientUtil;
import com.qiho.center.common.util.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ChuangLanServiceImpl
implements ChuangLanService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChuangLanServiceImpl.class);
    @Autowired
    private QihoOrderSnapshotDAO qihoOrderSnapshotDAO;
    @Resource
    private ShotOrderEngine shotOrderEngine;
    @Autowired
    ChuangLanSmsCommitMapper chuangLanSmsCommitMapper;
    @Autowired
    ChuangLanSmsReportMapper chuangLanSmsReportMapper;
    @Autowired
    AnticheateMapper anticheateMapper;
    @Resource
    private OrderService orderService;
    @Value(value="${qiho.ssjx.sms.status.push}")
    private String pushUrl;
    @Value(value="${qiho.order.ssjx.merchantid}")
    private String ssjxMerchartId;

    @Override
    @Transactional(value="QIHO", rollbackFor={Exception.class})
    public void processReport(ChuangLanSmsCommitEntity commitEntity, ChuangLanSmsReportDto dto) {
        HashMap<String, String> map = new HashMap<String, String>();
        String status = dto.getStatus();
        String baiqiCode = this.getBaiqiCode(status);
        LOGGER.info("\u8fd4\u56de\u7684\u77ed\u4fe1\u7801\u4e3a:{} ,\u547d\u4e2d\u7684\u77ed\u4fe1\u7801\u4e3a:{},orderId: {} ,mobile: {} ,handlerStatus:{}", new Object[]{status, baiqiCode, commitEntity.getOrderId(), dto.getMobile(), commitEntity.getHandlerStatus()});
        QihoOrderSnapshotEntity entity = this.qihoOrderSnapshotDAO.findByOrderId(commitEntity.getOrderId());
        if (entity != null) {
            if (StringUtils.equals((String)entity.getOrderStatus(), (String)OrderStatusEnum.TO_APPROVE.getCode()) && StringUtils.isBlank((String)entity.getOrderProcessWay())) {
                LOGGER.info("\u63a5\u6536\u5230\u521b\u84dd\u6d88\u606f\u542f\u52a8\u8e22\u5355\u89c4\u5219\uff0c orderId\uff1a {} ", (Object)entity.getOrderId());
                OrderSnapshotDto orderSnapshotDto = (OrderSnapshotDto)BeanUtils.copy((Object)entity, OrderSnapshotDto.class);
                orderSnapshotDto.setSmsRetCode(baiqiCode);
                DBTimeProfile.enter((String)("ChuangLanServiceImpl.processReport \u8e22\u5355\u89c4\u5219, orderId: " + entity.getOrderId()));
                this.shotOrderEngine.process(orderSnapshotDto);
                DBTimeProfile.release();
            } else {
                List anticheateEntities = this.anticheateMapper.selectByAll(commitEntity.getOrderId());
                if (this.isOrderToSend(entity, anticheateEntities, baiqiCode)) {
                    DBTimeProfile.enter((String)"\u5c06\u5f85\u5ba1\u6838\u7684\u8ba2\u5355\u53d8\u6210\u5f85\u53d1\u8d27");
                    LOGGER.info("\u5c06\u5f85\u5ba1\u6838\u7684\u8ba2\u5355\u53d8\u6210\u5f85\u53d1\u8d27\u5e76\u4fee\u6539\u9632\u4f5c\u5f0a\u4fe1\u606f\uff0corderId\uff1a {} ", (Object)entity.getOrderId());
                    OrderAuditParams params = new OrderAuditParams();
                    params.setOrderId(commitEntity.getOrderId());
                    params.setAuditResult(Integer.valueOf(1));
                    this.orderService.auditOrder(params);
                    this.updateAnticheatInfo(baiqiCode, commitEntity);
                    DBTimeProfile.release();
                } else if (this.isUpdateAnticheat(entity, anticheateEntities, baiqiCode)) {
                    LOGGER.info("\u8ba2\u5355\u4fee\u6539\u9632\u4f5c\u5f0a\u7ec6\u4fe1\u606f\uff0corderId\uff1a {} ", (Object)entity.getOrderId());
                    this.updateAnticheatInfo(baiqiCode, commitEntity);
                }
                map.put("update", "baiqi");
            }
            this.pushMobileToSSJX(entity, map, dto);
        }
        this.dealChuangLanReportData(dto, commitEntity);
    }

    private void pushMobileToSSJX(QihoOrderSnapshotEntity entity, Map<String, String> map, ChuangLanSmsReportDto dto) {
        List merchantIds = StringUtil.stringToListOrderByIds((String)this.ssjxMerchartId);
        if (merchantIds.contains(entity.getMerchantId())) {
            DBTimeProfile.enter((String)"\u63a8\u9001\u76db\u4e16\u5609\u7965");
            try {
                map.put("phone", dto.getMobile());
                map.put("msgBacKcode", dto.getStatus());
                map.put("sendTime", Long.toString(System.currentTimeMillis()));
                HttpClientUtil.sendPost((String)this.pushUrl, map);
            }
            catch (Exception e) {
                LOGGER.error("\u624b\u673a\u53f7\u72b6\u6001\u63a8\u9001\u76db\u4e16\u5609\u7965\u5f02\u5e38\uff0c orderId\uff1a{}\uff0cmobile\uff1a{} ", new Object[]{entity.getOrderId(), dto.getMobile(), e});
            }
            DBTimeProfile.release();
        }
    }

    private void dealChuangLanReportData(ChuangLanSmsReportDto dto, ChuangLanSmsCommitEntity commitEntity) {
        DBTimeProfile.enter((String)"\u5904\u7406\u521b\u84dd\u62a5\u544a\u6570\u636e");
        ChuangLanSmsReportEntity reportEntity = (ChuangLanSmsReportEntity)BeanUtils.copy((Object)dto, ChuangLanSmsReportEntity.class);
        reportEntity.setReportStatus(dto.getStatus());
        reportEntity.setReportStatusDesc(dto.getStatusDesc());
        reportEntity.setOrderId(commitEntity.getOrderId());
        this.chuangLanSmsReportMapper.insert(reportEntity);
        this.chuangLanSmsCommitMapper.deleteByPrimaryKey(commitEntity.getId());
        DBTimeProfile.release();
    }

    private boolean isOrderToSend(QihoOrderSnapshotEntity entity, List<AnticheateEntity> anticheateEntities, String baiqiCode) {
        return StringUtils.equals((String)entity.getOrderStatus(), (String)OrderStatusEnum.TO_APPROVE.getCode()) && StringUtils.isNotBlank((String)entity.getOrderProcessWay()) && anticheateEntities.size() == 1 && StringUtils.equals((String)anticheateEntities.get(0).getRule(), (String)"\u4e0b\u5355\u624b\u673a\u53f7\u8fd8\u672a\u6210\u529f\u63a5\u6536\u77ed\u4fe1") && baiqiCode.equals("bq888");
    }

    private boolean isUpdateAnticheat(QihoOrderSnapshotEntity entity, List<AnticheateEntity> anticheateEntities, String baiqiCode) {
        if (!StringUtils.equals((String)entity.getOrderStatus(), (String)OrderStatusEnum.TO_APPROVE.getCode()) || !StringUtils.isNotBlank((String)entity.getOrderProcessWay())) {
            return false;
        }
        boolean flag = false;
        for (AnticheateEntity an : anticheateEntities) {
            if (!StringUtils.equals((String)an.getRule(), (String)"\u4e0b\u5355\u624b\u673a\u53f7\u8fd8\u672a\u6210\u529f\u63a5\u6536\u77ed\u4fe1")) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private void updateAnticheatInfo(String baiqiCode, ChuangLanSmsCommitEntity commitEntity) {
        AnticheateEntity record = new AnticheateEntity();
        record.setOrderId(commitEntity.getOrderId());
        record.setRule("\u4e0b\u5355\u624b\u673a\u53f7\u8fd8\u672a\u6210\u529f\u63a5\u6536\u77ed\u4fe1");
        record.setNewRule(SmsMobileStatusEnum.getUpdateTextByCode((String)baiqiCode));
        this.anticheateMapper.updateByOrderId(record);
    }

    @NotNull
    private String getBaiqiCode(String status) {
        String baiqiCode = "";
        baiqiCode = status.equals("ERRNUM") || status.equals("SGIP:1") || status.equals("MN:0001") || status.equals("MK:0001") || status.equals("CB:0001") || status.equals("6640") || status.equals("0006") || status.equals("XL:169") || status.equals("1") || status.equals("10") || status.equals("67") || status.equals("61") || status.equals("72") || status.equals("101") || status.equals("-1") || status.equals("RP:1") || status.equals("Deliver") || status.equals("LT:0001") ? "bq003" : (status.equals("MBBLACK") ? "bq002" : (status.startsWith("MK") || status.startsWith("MI") || status.startsWith("MN") || status.startsWith("SGIP") || status.startsWith("UNDELIV") || status.startsWith("CU") || status.startsWith("RP:") || status.equals("0005") || status.equals("IB:0064") || status.equals("4") || status.equals("54") || status.equals("51") || status.equals("-37") || status.equals("53") || status.equals("4716") || status.equals("0007") || status.equals("5") || status.equals("50") || status.equals("45") || status.equals("36") || status.equals("56") || status.equals("213") || status.equals("ID:0102") || status.equals("SPMSERR:102") ? "bq001" : (status.equals("DELIVRD") ? "bq888" : "bq000")));
        return baiqiCode;
    }
}

