/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.task.impl;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.task.OrderConfirmTaskDto;
import com.qiho.center.api.params.task.OrderConfirmTaskPageParams;
import com.qiho.center.biz.service.task.OrderConfirmTaskService;
import com.qiho.center.common.daoh.qiho.OrderConfirmTaskDetailMapper;
import com.qiho.center.common.daoh.qiho.OrderConfirmTaskMapper;
import com.qiho.center.common.entityd.qiho.OrderConfirmTaskEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class OrderConfirmTaskServiceImpl
implements OrderConfirmTaskService {
    @Autowired
    OrderConfirmTaskMapper orderConfirmTaskMapper;
    @Autowired
    StringRedisTemplate redisTemplate;
    @Autowired
    OrderConfirmTaskDetailMapper detailMapper;

    @Override
    public PagenationDto<OrderConfirmTaskDto> selectForPage(OrderConfirmTaskPageParams pageParams) {
        PagenationDto pagenationDto = new PagenationDto();
        List result = this.orderConfirmTaskMapper.selectForPage(pageParams);
        if (result.isEmpty()) {
            pagenationDto.setList((List)Lists.newArrayList());
            pagenationDto.setTotal(Integer.valueOf(0));
            return pagenationDto;
        }
        int count = this.orderConfirmTaskMapper.selectForPageCount(pageParams);
        ArrayList dtos = Lists.newArrayList();
        for (OrderConfirmTaskEntity taskEntity : result) {
            BoundHashOperations ops;
            Map info;
            OrderConfirmTaskDto dto = (OrderConfirmTaskDto)BeanUtils.copy((Object)taskEntity, OrderConfirmTaskDto.class);
            if (taskEntity.getTaskStatus() == 0 && !(info = (ops = this.redisTemplate.boundHashOps((Object)taskEntity.getTaskId())).entries()).isEmpty()) {
                dto.setHandleNum(Integer.valueOf((String)info.get("handleCount")));
            }
            dtos.add(dto);
        }
        pagenationDto.setList((List)dtos);
        pagenationDto.setTotal(Integer.valueOf(count));
        return pagenationDto;
    }

    @Override
    public OrderConfirmTaskDto selectTaskByTaskId(String taskId, Long merchantId) {
        return (OrderConfirmTaskDto)BeanUtils.copy((Object)this.orderConfirmTaskMapper.selectTaskByTaskId(taskId, merchantId), OrderConfirmTaskDto.class);
    }
}

