/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.subscribe;

import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.baiqi.shield.center.api.dto.BlackListCheckDto;
import com.baiqi.shield.center.api.param.BlackListCheckParam;
import com.baiqi.shield.center.api.remoteservice.blacklist.RemoteShieldBlackListService;
import com.google.common.eventbus.Subscribe;
import com.qiho.center.api.dto.ChannelInfoDto;
import com.qiho.center.api.dto.OrderDto;
import com.qiho.center.api.dto.OrderItemDto;
import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.ordertmp.OrderTmpDetailDto;
import com.qiho.center.api.dto.sms.ChuangLanSmsReportDto;
import com.qiho.center.api.dto.strategy.FilterOrderCheckDto;
import com.qiho.center.api.enums.ShotOrder.StrategyType;
import com.qiho.center.api.enums.SmsTypeEnum;
import com.qiho.center.api.enums.ordertmp.OrderTmpRiskCheckFailEnum;
import com.qiho.center.api.enums.ordertmp.OrderTmpStatusEnum;
import com.qiho.center.biz.engine.impl.FilterOrderEngine;
import com.qiho.center.biz.event.ChuangLanReportReceiveEvent;
import com.qiho.center.biz.event.OrderTmpCreateEvent;
import com.qiho.center.biz.event.OrderTmpToFormalEvent;
import com.qiho.center.biz.service.impl.check.IPMobileCheckService;
import com.qiho.center.biz.service.order.OrderService;
import com.qiho.center.biz.service.order.OrderSnapshotService;
import com.qiho.center.biz.service.order.OrderStrategyService;
import com.qiho.center.biz.service.ordersms.OrderSmsService;
import com.qiho.center.biz.service.ordertmp.OrderTmpService;
import com.qiho.center.common.annotations.BizEventListener;
import com.qiho.center.common.entityd.qiho.ordertmp.BaiqiOrderSmsEntity;
import com.qiho.center.common.support.BizEventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@BizEventListener
public class OrderTmpSubscribe {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrderTmpSubscribe.class);
    @Autowired
    private OrderTmpService orderTmpService;
    @Autowired
    private BizEventBus eventBus;
    @Autowired
    private OrderService orderService;
    @Autowired
    private RemoteShieldBlackListService remoteShieldBlackListService;
    @Autowired
    private FilterOrderEngine filterOrderEngine;
    @Autowired
    private OrderSmsService orderSmsService;
    @Autowired
    private OrderStrategyService orderStrategyService;
    @Autowired
    IPMobileCheckService ipMobileCheckService;
    @Autowired
    private OrderSnapshotService orderSnapshotService;

    @Subscribe
    public void processOrderTmpCreateEvent(OrderTmpCreateEvent event) {
        DBTimeProfile.enter((String)"\u4e34\u65f6\u8ba2\u5355\u521b\u5efa\u4e8b\u4ef6\u5904\u7406");
        String orderId = event.getOrderId();
        OrderTmpDetailDto orderTmpDetailDto = this.orderTmpService.findByOrderId(orderId);
        if (null == orderTmpDetailDto) {
            DBTimeProfile.release();
            return;
        }
        OrderSnapshotDto orderSnapshotDto = (OrderSnapshotDto)BeanUtils.copy((Object)orderTmpDetailDto, OrderSnapshotDto.class);
        try {
            this.ipMobileCheckService.checkToSave(orderSnapshotDto);
        }
        catch (Exception e) {
            LOGGER.error("ip\u624b\u673a\u53f7\u5f52\u5c5e\u5730\u68c0\u6d4b\u5f02\u5e38\uff0corderId\uff1a{}", (Object)orderId, (Object)e);
        }
        boolean blackListCheckResult = this.blackListCheck(orderTmpDetailDto);
        if (!blackListCheckResult) {
            this.orderTmpService.updateOrderTmpToInvalid(orderId, "\u9ed1\u540d\u5355\u4e0d\u901a\u8fc7", OrderTmpRiskCheckFailEnum.BLACKLIST_FAIL);
            DBTimeProfile.release();
            return;
        }
        boolean filterResult = this.filterOrderCheck(orderTmpDetailDto);
        if (filterResult) {
            this.orderTmpService.updateOrderTmpToInvalid(orderId, "\u8fc7\u6ee4\u89c4\u5219\u4e0d\u901a\u8fc7", OrderTmpRiskCheckFailEnum.FILTER_ORDER_RULE_FAIL);
            DBTimeProfile.release();
            return;
        }
        SmsTypeEnum smsType = this.orderSmsService.sendMessage(orderTmpDetailDto);
        boolean needPhoneCheck = this.orderStrategyService.needCheckPhoneStatues(orderTmpDetailDto.getMerchantId(), StrategyType.FILTER_ORDER_RULE);
        if (smsType != null && smsType.isNeedReport() && needPhoneCheck) {
            LOGGER.info("\u9700\u8981\u624b\u673a\u53f7\u6821\u9a8c \u4e14 \u77ed\u4fe1\u901a\u9053\u53ef\u4ee5\u63a8\u9001\u6d88\u606f\u62a5\u544a\u65f6 \u6d41\u7a0b\u6682\u65f6\u7ed3\u675f,orderId,{}", (Object)orderId);
        } else {
            boolean result = this.orderTmpService.bizValidate(orderTmpDetailDto);
            if (result) {
                OrderTmpToFormalEvent toFormalEvent = new OrderTmpToFormalEvent();
                toFormalEvent.setOrderId(orderId);
                this.eventBus.post((Object)toFormalEvent);
            }
        }
        DBTimeProfile.release();
    }

    private boolean blackListCheck(OrderTmpDetailDto orderTmpDetailDto) {
        BlackListCheckParam blackListCheckParam = new BlackListCheckParam();
        blackListCheckParam.setItemId(orderTmpDetailDto.getItemId());
        blackListCheckParam.setMobile(orderTmpDetailDto.getMobile());
        blackListCheckParam.setMerchantId(orderTmpDetailDto.getMerchantId());
        BlackListCheckDto blackListCheckDto = this.remoteShieldBlackListService.checkBlackList(blackListCheckParam);
        return blackListCheckDto.getCheckResult();
    }

    private boolean filterOrderCheck(OrderTmpDetailDto orderTmpDetailDto) {
        OrderSnapshotDto orderSnapshotDto = (OrderSnapshotDto)BeanUtils.copy((Object)orderTmpDetailDto, OrderSnapshotDto.class);
        FilterOrderCheckDto filterOrderCheckDto = new FilterOrderCheckDto();
        filterOrderCheckDto.setOrderSnapshotDto(orderSnapshotDto);
        this.filterOrderEngine.process(filterOrderCheckDto);
        return filterOrderCheckDto.isCheckResult();
    }

    @Subscribe
    public void processOrderTmpToFormal(OrderTmpToFormalEvent event) {
        String orderId = event.getOrderId();
        OrderTmpDetailDto orderTmpDetailDto = this.orderTmpService.findByOrderId(orderId);
        if (null == orderTmpDetailDto) {
            LOGGER.warn("\u4e34\u65f6\u8ba2\u5355\u53d8\u66f4\u4e3a\u6b63\u5f0f\u8ba2\u5355\u5931\u8d25\uff0c\u4e34\u65f6\u8ba2\u5355\u4e0d\u5b58\u5728\uff0corderId\uff1a{}", (Object)orderId);
            return;
        }
        this.orderService.createOrderFromTmp(this.buildOrder(orderTmpDetailDto), this.buildChannel(orderTmpDetailDto), orderTmpDetailDto.getPayType());
    }

    @Subscribe
    public void chuangLanReportReceiveEvent(ChuangLanReportReceiveEvent event) {
        ChuangLanSmsReportDto smsReport = event.getChuangLanSmsReportDto();
        BaiqiOrderSmsEntity orderSmsEntity = event.getOrderSmsEntity();
        if (smsReport == null || orderSmsEntity == null) {
            return;
        }
        OrderTmpDetailDto orderTmpDetailDto = this.orderTmpService.findByOrderId(orderSmsEntity.getOrderId());
        if (null == orderTmpDetailDto || orderTmpDetailDto.getOrderStatus().intValue() != OrderTmpStatusEnum.TO_FILTER.getNum()) {
            return;
        }
        boolean phoneCheckResult = this.orderStrategyService.checkPhoneStatusForFilterRule(orderTmpDetailDto);
        if (!phoneCheckResult) {
            this.orderTmpService.updateOrderTmpToInvalid(orderTmpDetailDto.getOrderId(), "\u624b\u673a\u53f7\u72b6\u6001\u6821\u9a8c\u4e0d\u901a\u8fc7", OrderTmpRiskCheckFailEnum.FILTER_ORDER_RULE_FAIL);
            return;
        }
        boolean bizCheckResult = this.orderTmpService.bizValidate(orderTmpDetailDto);
        if (!bizCheckResult) {
            return;
        }
        OrderTmpToFormalEvent toFormalEvent = new OrderTmpToFormalEvent();
        toFormalEvent.setOrderId(orderTmpDetailDto.getOrderId());
        this.eventBus.post((Object)toFormalEvent);
    }

    private OrderDto buildOrder(OrderTmpDetailDto orderTmpDetailDto) {
        OrderDto order = (OrderDto)BeanUtils.copy((Object)orderTmpDetailDto, OrderDto.class);
        OrderItemDto orderItem = (OrderItemDto)BeanUtils.copy((Object)orderTmpDetailDto, OrderItemDto.class);
        orderItem.setCostPrice(orderTmpDetailDto.getItemCost());
        order.setOrderItem(orderItem);
        return order;
    }

    private ChannelInfoDto buildChannel(OrderTmpDetailDto orderTmpDetailDto) {
        ChannelInfoDto channel = (ChannelInfoDto)BeanUtils.copy((Object)orderTmpDetailDto, ChannelInfoDto.class);
        channel.setaCid(orderTmpDetailDto.getTuiaCid());
        return channel;
    }
}

