/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.subscribe;

import cn.com.duiba.stock.service.api.remoteservice.RemoteStockBackendService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.google.common.eventbus.Subscribe;
import com.qiho.center.api.enums.StockWarnStatusEnum;
import com.qiho.center.biz.event.WarningEvent;
import com.qiho.center.common.annotations.BizEventListener;
import com.qiho.center.common.dao.QihoItemDAO;
import com.qiho.center.common.dao.QihoItemSkuDAO;
import com.qiho.center.common.dao.QihoMerchantDAO;
import com.qiho.center.common.dao.QihoSkuPropertyValueDAO;
import com.qiho.center.common.daoh.qiho.StockWarningMapper;
import com.qiho.center.common.daoh.qihostatistics.SkuDaySaleMapper;
import com.qiho.center.common.entity.item.QihoItemEntity;
import com.qiho.center.common.entity.item.QihoItemSkuEntity;
import com.qiho.center.common.entity.item.QihoSkuPropertyValueEntity;
import com.qiho.center.common.entity.merchant.QihoMerchantEntity;
import com.qiho.center.common.entityd.qiho.StockWarningEntity;
import com.qiho.center.common.entityd.qihostatistics.SkuDaySaleEntity;
import com.qiho.center.common.util.DingTalkUtil;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@BizEventListener
public class WarningSubscribeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(WarningSubscribeService.class);
    @Resource
    StockWarningMapper stockWarningMapper;
    @Resource
    SkuDaySaleMapper skuDaySaleMapper;
    @Resource
    RemoteStockBackendService remoteStockBackendService;
    @Resource
    QihoSkuPropertyValueDAO qihoSkuPropertyValueDAO;
    @Resource
    QihoItemSkuDAO qihoItemSkuDAO;
    @Resource
    private QihoItemDAO qihoItemDAO;
    @Resource
    private QihoMerchantDAO qihoMerchantDAO;

    @Subscribe
    public void warningHandler(WarningEvent warningEvent) {
        DBTimeProfile.enter((String)"warningHandler");
        QihoItemSkuEntity qihoItemSkuEntity = this.qihoItemSkuDAO.findById(warningEvent.getSkuId());
        if (qihoItemSkuEntity == null) {
            DBTimeProfile.release();
            return;
        }
        int saleNum = this.getAvgSale(qihoItemSkuEntity.getSkuNo());
        StockWarningEntity param = new StockWarningEntity();
        param.setSkuId(qihoItemSkuEntity.getId());
        param.setItemId(qihoItemSkuEntity.getItemId());
        StockWarningEntity result = this.stockWarningMapper.selectBySkuIdAndItemId(param);
        if (saleNum == 0) {
            if (result != null) {
                this.stockWarningMapper.deleteByPrimaryKey(result.getId());
            }
            DBTimeProfile.release();
            return;
        }
        DubboResult dubboResult = this.remoteStockBackendService.find(qihoItemSkuEntity.getStockId().longValue());
        String name = this.getName(qihoItemSkuEntity);
        this.dbHandler(qihoItemSkuEntity, saleNum, (DubboResult<Long>)dubboResult, name, result);
        DBTimeProfile.release();
    }

    private void dbHandler(QihoItemSkuEntity qihoItemSkuEntity, int saleNum, DubboResult<Long> dubboResult, String name, StockWarningEntity result) {
        StockWarningEntity stockWarningEntity = new StockWarningEntity();
        stockWarningEntity.setItemId(qihoItemSkuEntity.getItemId());
        stockWarningEntity.setSkuId(qihoItemSkuEntity.getId());
        stockWarningEntity.setSkuName(name);
        stockWarningEntity.setStockNum(Integer.valueOf(((Long)dubboResult.getResult()).intValue()));
        stockWarningEntity.setSuggestNum(Integer.valueOf(7 * saleNum));
        stockWarningEntity.setAvgSaleStock(Integer.valueOf(saleNum));
        if ((Long)dubboResult.getResult() < (long)(7 * saleNum)) {
            stockWarningEntity.setWarnStatus(Integer.valueOf(0));
            if ((Long)dubboResult.getResult() <= 0L) {
                stockWarningEntity.setWarnStatus(Integer.valueOf(1));
            }
            if (result == null) {
                this.stockWarningMapper.insert(stockWarningEntity);
                this.sendDingTalk(stockWarningEntity);
            } else {
                stockWarningEntity.setId(result.getId());
                this.stockWarningMapper.updateByPrimaryKeySelective(stockWarningEntity);
            }
        } else if (result != null) {
            this.stockWarningMapper.deleteByPrimaryKey(result.getId());
        }
    }

    private void sendDingTalk(StockWarningEntity stockWarningEntity) {
        QihoItemEntity itemEntity = this.qihoItemDAO.findSimpleById(stockWarningEntity.getItemId());
        QihoMerchantEntity merchantEntity = null;
        if (itemEntity != null) {
            merchantEntity = this.qihoMerchantDAO.getByItemId(itemEntity.getId());
        }
        StringBuilder msg = new StringBuilder();
        msg.append("\u4ea7\u751f\u4e00\u6761\u65b0\u7684\u5e93\u5b58\u9884\u8b66\uff01\uff01\u9884\u8b66\u5185\u5bb9\u5982\u4e0b\uff1a").append("\n");
        msg.append("\u5546\u5bb6id\uff1a").append(merchantEntity != null ? merchantEntity.getId() : null).append("\uff0c\u5546\u5bb6\u540d\u79f0\uff1a").append(merchantEntity != null ? merchantEntity.getMerchantName() : null).append("\n");
        msg.append("\u5546\u54c1id\uff1a").append(stockWarningEntity.getItemId()).append("\uff0c\u5546\u54c1\u540d\u79f0\uff1a").append(itemEntity != null ? itemEntity.getItemName() : null).append("\n");
        msg.append("\u9884\u8b66\u72b6\u6001\uff1a").append(StockWarnStatusEnum.getName((Integer)stockWarningEntity.getWarnStatus())).append("\uff0c\u9884\u8b66\u65f6\u95f4\uff1a").append(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"))).append("\n");
        DingTalkUtil.sendTextMessageWith((String)String.valueOf(msg), (String)"https://oapi.dingtalk.com/robot/send?access_token=03c4cbb5274845ca4daee753f33edb6097f7d284cfe6e170e2c65c0ef32ab425", (boolean)true);
    }

    private String getName(QihoItemSkuEntity qihoItemSkuEntity) {
        String name = "";
        if (StringUtils.isNotBlank((String)qihoItemSkuEntity.getProperties())) {
            String[] p;
            String properties = qihoItemSkuEntity.getProperties();
            for (String s : p = properties.split(";")) {
                String value = s.split(":")[1];
                QihoSkuPropertyValueEntity qihoSkuPropertyValueEntity = this.qihoSkuPropertyValueDAO.findById(value);
                name = name + qihoSkuPropertyValueEntity.getPropertyValue() + "-";
            }
            if (StringUtils.isNotBlank((String)name)) {
                name = name.substring(0, name.length() - 1);
            }
        }
        return name;
    }

    private int getAvgSale(String skuNo) {
        Date weekAgoTime = this.getWeekAgoTime();
        SkuDaySaleEntity skuDaySale = new SkuDaySaleEntity();
        skuDaySale.setSaleDate(weekAgoTime);
        skuDaySale.setSkuNo(skuNo);
        List list = this.skuDaySaleMapper.selectByDate(skuDaySale);
        if (list.isEmpty()) {
            return 0;
        }
        int total = 0;
        for (SkuDaySaleEntity daySale : list) {
            total += daySale.getSaleNum().intValue();
        }
        return total % list.size() == 0 ? total / list.size() : total / list.size() + 1;
    }

    private Date getWeekAgoTime() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -7);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal.getTime();
    }
}

