/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.task;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.dto.order.BatchOrderCancelDto;
import com.qiho.center.api.enums.OrderStatusEnum;
import com.qiho.center.biz.service.OSSFileService;
import com.qiho.center.biz.service.order.OrderService;
import com.qiho.center.biz.task.bo.OrderCancelDo;
import com.qiho.center.biz.task.to.OrderCancelTo;
import com.qiho.center.common.daoh.qiho.OrderConfirmTaskDetailMapper;
import com.qiho.center.common.daoh.qiho.OrderConfirmTaskMapper;
import com.qiho.center.common.daoh.qiho.OrderSnapshotMapper;
import com.qiho.center.common.entityd.qiho.OrderConfirmTaskDetailEntity;
import com.qiho.center.common.entityd.qiho.OrderConfirmTaskEntity;
import com.qiho.center.common.entityd.qiho.OrderSnapshotEntity;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class BatchOrderCancelTask
implements Runnable {
    private Logger logger = LoggerFactory.getLogger(BatchOrderCancelTask.class);
    @Autowired
    private OSSFileService ossFileService;
    private BatchOrderCancelDto dto;
    @Autowired
    StringRedisTemplate redisTemplate;
    private BoundHashOperations<String, String, String> ops;
    private OrderConfirmTaskEntity taskEntity;
    private OrderConfirmTaskDetailEntity detailEntity;
    @Autowired
    OrderConfirmTaskMapper orderConfirmTaskMapper;
    @Autowired
    OrderConfirmTaskDetailMapper orderConfirmTaskDetailMapper;
    @Autowired
    OrderService orderService;
    @Autowired
    OrderSnapshotMapper orderSnapshotMapper;
    private long startTime;
    private int failNum;
    private String failLines = "";
    List<OrderCancelDo> dos;
    List<OrderConfirmTaskDetailEntity> detailEntities = Lists.newArrayList();
    Map<String, OrderSnapshotEntity> entityMap;

    public void init(BatchOrderCancelDto batchOrderCancelDto, OrderConfirmTaskEntity taskEntity) {
        this.dto = batchOrderCancelDto;
        this.ops = this.redisTemplate.boundHashOps((Object)this.dto.getTaskId());
        this.startTime = System.currentTimeMillis();
        this.taskEntity = taskEntity;
    }

    public void init(BatchOrderCancelDto batchOrderCancelDto, OrderConfirmTaskEntity taskEntity, List<OrderCancelDo> dos) {
        this.dos = dos;
        this.dto = batchOrderCancelDto;
        this.ops = this.redisTemplate.boundHashOps((Object)this.dto.getTaskId());
        this.startTime = System.currentTimeMillis();
        this.taskEntity = taskEntity;
    }

    @Override
    public void run() {
        if (this.dto.getTaskType() <= 2) {
            this.getOrderDosByExcel();
        }
        this.initTask();
        this.checkDos();
        if (!this.dos.isEmpty()) {
            this.getStringOrderSnapshotEntityMap();
            this.handlerBos();
        }
        this.handlerResult();
    }

    private void checkDos() {
        ArrayList list = Lists.newArrayList();
        ArrayList maps = Lists.newArrayList();
        for (OrderCancelDo aDo : this.dos) {
            if (StringUtils.isNotBlank((CharSequence)aDo.getOrderId()) && maps.contains(aDo.getOrderId())) {
                OrderConfirmTaskDetailEntity detailEntity = new OrderConfirmTaskDetailEntity();
                detailEntity.setOrderId(aDo.getOrderId());
                detailEntity.setOrderConfirmTaskId(this.taskEntity.getId());
                detailEntity.setLineNum(Integer.valueOf(aDo.getLineNum()));
                detailEntity.setFailMsg("\u8ba2\u5355ID\u91cd\u590d");
                this.detailEntities.add(detailEntity);
                ++this.failNum;
                this.failLines = this.failLines + aDo.getLineNum() + ",";
                this.ops.increment((Object)"handleCount", 1L);
                continue;
            }
            maps.add(aDo.getOrderId());
            list.add(aDo);
        }
        this.dos = list;
    }

    private void handlerResult() {
        if (!this.detailEntities.isEmpty()) {
            this.orderConfirmTaskDetailMapper.batchInsert(this.detailEntities);
        }
        this.ops.put((Object)"status", (Object)"over");
        this.ops.put((Object)"failLines", (Object)this.failLines);
        this.ops.put((Object)"failNum", (Object)String.valueOf(this.failNum));
        this.taskEntity.setConsumeTime(Long.valueOf(System.currentTimeMillis() - this.startTime));
        this.taskEntity.setFailNum(Integer.valueOf(this.failNum));
        this.taskEntity.setTaskStatus(Integer.valueOf(1));
        this.orderConfirmTaskMapper.updateByPrimaryKeySelective(this.taskEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlerBos() {
        for (OrderCancelDo bo : this.dos) {
            Integer lineNum = bo.getLineNum();
            try {
                OrderSnapshotEntity orderSnapshotEntity = this.entityMap.get(bo.getOrderId());
                boolean checkFlag = this.checkParam(bo, orderSnapshotEntity, lineNum);
                if (!checkFlag) {
                    this.detailEntities.add(this.detailEntity);
                    ++this.failNum;
                    this.failLines = this.failLines + lineNum + ",";
                    continue;
                }
                this.orderService.orderCancel(bo.getOrderId());
            }
            catch (Exception e) {
                ++this.failNum;
                this.failLines = this.failLines + lineNum + ",";
                this.detailEntity.setFailMsg("\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38!" + e.getMessage());
                this.detailEntities.add(this.detailEntity);
            }
            finally {
                this.ops.increment((Object)"handleCount", 1L);
            }
        }
    }

    private void initTask() {
        this.ops.put((Object)"totalCount", (Object)String.valueOf(this.dos.size()));
        this.ops.put((Object)"status", (Object)"handling");
        this.taskEntity.setAllNum(Integer.valueOf(this.dos.size()));
        if (this.dos.size() == 0) {
            this.taskEntity.setTaskStatus(Integer.valueOf(1));
        } else {
            this.taskEntity.setTaskStatus(Integer.valueOf(0));
        }
        this.orderConfirmTaskMapper.updateByPrimaryKeySelective(this.taskEntity);
    }

    private boolean checkParam(OrderCancelDo orderCancelDo, OrderSnapshotEntity orderSnapshotEntity, int lineNum) {
        this.detailEntity = new OrderConfirmTaskDetailEntity();
        this.detailEntity.setOrderId(orderCancelDo.getOrderId());
        this.detailEntity.setOrderConfirmTaskId(this.taskEntity.getId());
        this.detailEntity.setLineNum(Integer.valueOf(lineNum));
        if ("ERROR_CELL".equals(orderCancelDo.getOrderId())) {
            this.detailEntity.setOrderId("");
            this.detailEntity.setFailMsg("\u9519\u8bef\u7684\u5355\u5143\u683c");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)orderCancelDo.getOrderId())) {
            this.detailEntity.setFailMsg("\u8ba2\u5355ID\u4e3a\u7a7a!");
            return false;
        }
        if (orderSnapshotEntity.getDelivery().equals("ERP")) {
            this.detailEntity.setFailMsg("ERP\u8ba2\u5355\u64cd\u4f5c\u5931\u8d25!");
            return false;
        }
        if (orderSnapshotEntity == null) {
            this.detailEntity.setFailMsg("\u8ba2\u5355\u4e0d\u5b58\u5728!");
            return false;
        }
        if (!OrderStatusEnum.TO_SEND.getCode().equals(orderSnapshotEntity.getOrderStatus()) && !OrderStatusEnum.TO_APPROVE.getCode().equals(orderSnapshotEntity.getOrderStatus())) {
            this.detailEntity.setFailMsg("\u8ba2\u5355\u975e\u5f85\u53d1\u8d27\u6216\u5f85\u5ba1\u6838\u72b6\u6001!");
            return false;
        }
        if (orderCancelDo.getMerchantId() == -1L) {
            return true;
        }
        if (!orderCancelDo.getMerchantId().equals(orderSnapshotEntity.getMerchantId())) {
            this.detailEntity.setFailMsg("\u4e0d\u5c5e\u4e8e\u5bfc\u5165\u7684\u5546\u5bb6!");
            return false;
        }
        return true;
    }

    private void getOrderDosByExcel() {
        InputStream input = this.ossFileService.getOssFileInputStream(this.dto.getFileUrl());
        ImportParams params = new ImportParams();
        String[] importFields = new String[]{"\u8ba2\u5355ID"};
        params.setImportFields(importFields);
        params.setKeyIndex(null);
        List list = Lists.newArrayList();
        try {
            list = ExcelImportUtil.importExcel((InputStream)input, OrderCancelTo.class, (ImportParams)params);
        }
        catch (Exception e) {
            this.logger.warn("\u5bfc\u5165\u6587\u4ef6\u7684\u8868\u5934\u683c\u5f0f\u4e0d\u6b63\u786e!");
        }
        ArrayList dos = Lists.newArrayList();
        for (OrderCancelTo to : list) {
            if (StringUtils.isBlank((CharSequence)to.getOrderId())) continue;
            OrderCancelDo bo = new OrderCancelDo();
            bo.setLineNum(to.getRowNum());
            bo.setOrderId(to.getOrderId().trim());
            bo.setMerchantId(this.dto.getMerchantId());
            dos.add(bo);
        }
        this.dos = dos;
    }

    private void getStringOrderSnapshotEntityMap() {
        ArrayList orderIds = Lists.newArrayList();
        for (OrderCancelDo orderCancelBo : this.dos) {
            orderIds.add(orderCancelBo.getOrderId());
        }
        List entities = this.orderSnapshotMapper.selectByOrderIds((List)orderIds);
        HashMap entityMap = Maps.newHashMap();
        for (OrderSnapshotEntity entity : entities) {
            entityMap.put(entity.getOrderId(), entity);
        }
        this.entityMap = entityMap;
    }
}

