/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.task;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.dubbo.common.utils.ConcurrentHashSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.dto.order.BatchOrderConfirmDto;
import com.qiho.center.biz.bo.domain.LogisticsOrderDo;
import com.qiho.center.biz.event.KuaiDi100Event;
import com.qiho.center.biz.service.OSSFileService;
import com.qiho.center.biz.service.logistics.LogisticsService;
import com.qiho.center.biz.task.OrderBoRunnable;
import com.qiho.center.biz.task.OrderConfirmBoRunnable;
import com.qiho.center.biz.task.OrderUpdateBoRunnable;
import com.qiho.center.biz.task.bo.OrderConfirmDo;
import com.qiho.center.biz.task.to.OrderConfirmTo;
import com.qiho.center.common.dao.QihoErpOrderDAO;
import com.qiho.center.common.daoh.qiho.OrderConfirmTaskDetailMapper;
import com.qiho.center.common.daoh.qiho.OrderConfirmTaskMapper;
import com.qiho.center.common.daoh.qiho.OrderSnapshotMapper;
import com.qiho.center.common.entity.order.QihoErpOrderEntity;
import com.qiho.center.common.entityd.qiho.OrderConfirmTaskDetailEntity;
import com.qiho.center.common.entityd.qiho.OrderConfirmTaskEntity;
import com.qiho.center.common.entityd.qiho.OrderSnapshotEntity;
import com.qiho.center.common.entityd.qiho.logistics.BaiqiLogisticsEntity;
import com.qiho.center.common.support.BizEventBus;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class BatchOrderTask
implements Runnable {
    private Logger logger = LoggerFactory.getLogger(BatchOrderTask.class);
    private static final ExecutorService executorService = new ThreadPoolExecutor(20, 35, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(200));
    @Autowired
    LogisticsService logisticsService;
    @Autowired
    OrderSnapshotMapper orderSnapshotMapper;
    @Autowired
    OSSFileService ossFileService;
    BatchOrderConfirmDto dto;
    OrderConfirmTaskEntity taskEntity;
    List<OrderConfirmTaskDetailEntity> detailEntities = Lists.newArrayList();
    List<LogisticsOrderDo> logisticsOrderDos = Lists.newArrayList();
    @Autowired
    OrderConfirmTaskMapper orderConfirmTaskMapper;
    @Autowired
    OrderConfirmTaskDetailMapper orderConfirmTaskDetailMapper;
    @Autowired
    StringRedisTemplate redisTemplate;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private BizEventBus eventBus;
    @Autowired
    private QihoErpOrderDAO qihoErpOrderDAO;
    BoundHashOperations<String, String, String> ops;
    LinkedBlockingQueue<OrderConfirmDo> blockingQueue = new LinkedBlockingQueue();
    Map<String, OrderSnapshotEntity> entityMap;
    Map<String, QihoErpOrderEntity> erpOrderEntityMap;
    final ConcurrentHashSet<Integer> failLines = new ConcurrentHashSet();
    long startTime;
    AtomicInteger failNum = new AtomicInteger(0);
    List<OrderConfirmDo> dos = null;
    BaiqiLogisticsEntity logisticsEntity = null;

    @Override
    public void run() {
        if (this.dto.getTaskType() <= 2) {
            this.getOrderDosByExcel();
        }
        this.updateTask();
        this.checkDos();
        if (!this.dos.isEmpty()) {
            this.getStringOrderSnapshotEntityMap();
            this.handlerBos();
        }
        this.handlerResult();
    }

    private void checkDos() {
        ArrayList list = Lists.newArrayList();
        ArrayList maps = Lists.newArrayList();
        for (OrderConfirmDo aDo : this.dos) {
            if (StringUtils.isNotBlank((CharSequence)aDo.getOrderId()) && maps.contains(aDo.getOrderId())) {
                OrderConfirmTaskDetailEntity detailEntity = new OrderConfirmTaskDetailEntity();
                detailEntity.setOrderId(aDo.getOrderId());
                detailEntity.setOrderConfirmTaskId(this.taskEntity.getId());
                detailEntity.setPostId(aDo.getPostId());
                detailEntity.setLineNum(aDo.getLineNum());
                detailEntity.setFailMsg("\u8ba2\u5355ID\u91cd\u590d");
                this.detailEntities.add(detailEntity);
                this.failLines.add((Object)aDo.getLineNum());
                this.failNum.addAndGet(1);
                this.ops.increment((Object)"handleCount", 1L);
                continue;
            }
            maps.add(aDo.getOrderId());
            list.add(aDo);
        }
        this.dos = list;
    }

    public void init(BatchOrderConfirmDto batchOrderConfirmDto, OrderConfirmTaskEntity taskEntity) {
        this.dto = batchOrderConfirmDto;
        this.ops = this.redisTemplate.boundHashOps((Object)this.dto.getTaskId());
        this.startTime = System.currentTimeMillis();
        this.taskEntity = taskEntity;
    }

    public void init(BatchOrderConfirmDto batchOrderConfirmDto, OrderConfirmTaskEntity taskEntity, List<OrderConfirmDo> dos) {
        this.dos = dos;
        this.dto = batchOrderConfirmDto;
        this.ops = this.redisTemplate.boundHashOps((Object)this.dto.getTaskId());
        this.startTime = System.currentTimeMillis();
        this.taskEntity = taskEntity;
    }

    public void handlerBos() {
        try {
            this.blockingQueue.addAll(this.dos);
            this.dos.clear();
            CountDownLatch countDownLatch = new CountDownLatch(5);
            for (int i = 0; i < 5; ++i) {
                OrderBoRunnable boRunnable = null;
                if (this.dto.getTaskType() == 0 || this.dto.getTaskType() == 3) {
                    boRunnable = (OrderBoRunnable)this.context.getBean(OrderConfirmBoRunnable.class, new Object[]{this, countDownLatch});
                }
                if (this.dto.getTaskType() == 1 || this.dto.getTaskType() == 4) {
                    boRunnable = (OrderBoRunnable)this.context.getBean(OrderUpdateBoRunnable.class, new Object[]{this, countDownLatch});
                }
                executorService.submit(boRunnable);
            }
            countDownLatch.await();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateTask() {
        this.ops.put((Object)"totalCount", (Object)String.valueOf(this.dos.size()));
        this.ops.put((Object)"status", (Object)"handling");
        this.taskEntity.setAllNum(Integer.valueOf(this.dos.size()));
        this.taskEntity.setLogisticsCode(this.dto.getExpress());
        if (this.dos.size() == 0) {
            this.taskEntity.setTaskStatus(Integer.valueOf(1));
        } else {
            this.taskEntity.setTaskStatus(Integer.valueOf(0));
        }
        this.orderConfirmTaskMapper.updateByPrimaryKeySelective(this.taskEntity);
    }

    public void getOrderDosByExcel() {
        this.logisticsEntity = this.logisticsService.findByCode(this.dto.getExpress());
        InputStream input = this.ossFileService.getOssFileInputStream(this.dto.getFileUrl());
        ImportParams params = new ImportParams();
        String[] importFields = new String[]{"\u8ba2\u5355ID", "\u7269\u6d41\u5355\u53f7"};
        params.setImportFields(importFields);
        params.setKeyIndex(null);
        List list = Lists.newArrayList();
        try {
            list = ExcelImportUtil.importExcel((InputStream)input, OrderConfirmTo.class, (ImportParams)params);
        }
        catch (Exception e) {
            this.logger.warn("\u5bfc\u5165\u6587\u4ef6\u7684\u8868\u5934\u683c\u5f0f\u4e0d\u6b63\u786e!");
        }
        ArrayList dos = Lists.newArrayList();
        for (OrderConfirmTo orderConfirmTo : list) {
            if (StringUtils.isBlank((CharSequence)orderConfirmTo.getOrderId()) && StringUtils.isBlank((CharSequence)orderConfirmTo.getPostId())) continue;
            OrderConfirmDo orderConfirmDo = (OrderConfirmDo)BeanUtils.copy((Object)orderConfirmTo, OrderConfirmDo.class);
            orderConfirmDo.setLogisticsCode(this.logisticsEntity.getLogisticsCode());
            orderConfirmDo.setLogisticsName(this.logisticsEntity.getLogisticsName());
            orderConfirmDo.setMerchantId(this.dto.getMerchantId());
            orderConfirmDo.setLineNum(orderConfirmTo.getRowNum());
            if (StringUtils.isNotBlank((CharSequence)orderConfirmDo.getOrderId())) {
                orderConfirmDo.setOrderId(orderConfirmDo.getOrderId().trim());
            }
            if (StringUtils.isNotBlank((CharSequence)orderConfirmDo.getPostId())) {
                orderConfirmDo.setPostId(orderConfirmDo.getPostId().trim());
            }
            dos.add(orderConfirmDo);
        }
        this.dos = dos;
    }

    public void getStringOrderSnapshotEntityMap() {
        ArrayList orderIds = Lists.newArrayList();
        for (OrderConfirmDo orderConfirmBo : this.dos) {
            orderIds.add(orderConfirmBo.getOrderId());
        }
        List entities = this.orderSnapshotMapper.selectByOrderIds((List)orderIds);
        HashMap entityMap = Maps.newHashMap();
        for (OrderSnapshotEntity entity : entities) {
            entityMap.put(entity.getOrderId(), entity);
        }
        List erpOrderEntities = this.qihoErpOrderDAO.findByOrderIds((List)orderIds);
        HashMap erpMaps = Maps.newHashMap();
        for (QihoErpOrderEntity entity : erpOrderEntities) {
            erpMaps.put(entity.getOrderId(), entity);
        }
        this.erpOrderEntityMap = erpMaps;
        this.entityMap = entityMap;
    }

    public void handlerResult() {
        this.ops.put((Object)"status", (Object)"over");
        this.ops.put((Object)"failLines", (Object)StringUtils.join((Iterator)this.failLines.iterator(), (String)","));
        this.ops.put((Object)"failNum", (Object)String.valueOf(this.failNum.intValue()));
        if (!this.detailEntities.isEmpty()) {
            this.orderConfirmTaskDetailMapper.batchInsert(this.detailEntities);
        }
        this.taskEntity.setConsumeTime(Long.valueOf(System.currentTimeMillis() - this.startTime));
        this.taskEntity.setFailNum(Integer.valueOf(this.failNum.intValue()));
        this.taskEntity.setTaskStatus(Integer.valueOf(1));
        this.orderConfirmTaskMapper.updateByPrimaryKeySelective(this.taskEntity);
        if (!this.logisticsOrderDos.isEmpty()) {
            KuaiDi100Event event = new KuaiDi100Event();
            event.setLogisticsOrderDos(this.logisticsOrderDos);
            this.eventBus.post((Object)event);
        }
    }

    public LinkedBlockingQueue<OrderConfirmDo> getBlockingQueue() {
        return this.blockingQueue;
    }

    public Map<String, OrderSnapshotEntity> getEntityMap() {
        return this.entityMap;
    }

    public Map<String, QihoErpOrderEntity> getErpOrderEntityMap() {
        return this.erpOrderEntityMap;
    }

    public OrderConfirmTaskEntity getTaskEntity() {
        return this.taskEntity;
    }

    public synchronized void addDetailEntity(OrderConfirmTaskDetailEntity detailEntity) {
        this.detailEntities.add(detailEntity);
    }

    public synchronized void addLogistics(LogisticsOrderDo logisticsOrderDo) {
        this.logisticsOrderDos.add(logisticsOrderDo);
    }
}

