/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.task;

import com.qiho.center.api.enums.ErpStatusEnum;
import com.qiho.center.api.enums.ErpTypeEnum;
import com.qiho.center.api.enums.OrderApprovalStatusEnum;
import com.qiho.center.api.enums.OrderStatusEnum;
import com.qiho.center.api.params.OrderAuditParams;
import com.qiho.center.biz.service.LogisticsOrderService;
import com.qiho.center.biz.task.BatchOrderTask;
import com.qiho.center.biz.task.bo.OrderConfirmDo;
import com.qiho.center.common.dao.QihoErpOrderDAO;
import com.qiho.center.common.dao.QihoOrderDAO;
import com.qiho.center.common.dao.QihoOrderSnapshotDAO;
import com.qiho.center.common.entity.order.QihoErpOrderEntity;
import com.qiho.center.common.entityd.qiho.OrderConfirmTaskDetailEntity;
import com.qiho.center.common.entityd.qiho.OrderSnapshotEntity;
import com.qiho.center.common.enums.SeqBizTypeEnum;
import com.qiho.center.common.support.SequenceNoBuilder;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Scope(value="prototype")
public abstract class OrderBoRunnable
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(OrderBoRunnable.class);
    @Autowired
    LogisticsOrderService logisticsOrderService;
    @Autowired
    private QihoOrderSnapshotDAO qihoOrderSnapshotDAO;
    @Autowired
    private QihoOrderDAO qihoOrderDAO;
    @Autowired
    private QihoErpOrderDAO qihoErpOrderDAO;
    @Autowired
    private SequenceNoBuilder sequenceNoBuilder;
    BatchOrderTask task;
    final CountDownLatch countDownLatch;
    OrderConfirmTaskDetailEntity detailEntity;

    public OrderBoRunnable(BatchOrderTask batchOrderTask, CountDownLatch countDownLatch) {
        this.task = batchOrderTask;
        this.countDownLatch = countDownLatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        OrderConfirmDo orderConfirmDo;
        while ((orderConfirmDo = this.task.getBlockingQueue().poll()) != null) {
            Integer lineNum = orderConfirmDo.getLineNum();
            try {
                OrderSnapshotEntity orderSnapshotEntity = this.task.getEntityMap().get(orderConfirmDo.getOrderId());
                QihoErpOrderEntity erpOrderEntity = this.task.getErpOrderEntityMap().get(orderConfirmDo.getOrderId());
                boolean checkFlag = this.checkParam(orderConfirmDo, orderSnapshotEntity);
                if (!checkFlag) {
                    this.task.addDetailEntity(this.detailEntity);
                    this.task.failLines.add((Object)lineNum);
                    this.task.failNum.addAndGet(1);
                    continue;
                }
                this.auditOrder(orderConfirmDo, orderSnapshotEntity, erpOrderEntity);
            }
            catch (Exception e) {
                this.logger.error("\u4efb\u52a1\u7f16\u53f7:" + this.task.dto.getTaskId() + "\u6570\u636e\u5e93\u64cd\u4f5c\u5931\u8d25\uff01");
                e.printStackTrace();
            }
            finally {
                this.task.ops.increment((Object)"handleCount", 1L);
            }
        }
        this.countDownLatch.countDown();
    }

    abstract boolean checkParam(OrderConfirmDo var1, OrderSnapshotEntity var2);

    abstract void auditOrder(OrderConfirmDo var1, OrderSnapshotEntity var2, QihoErpOrderEntity var3);

    @Transactional(value="QIHO", rollbackFor={Exception.class})
    public QihoErpOrderEntity auditOrderToSuccess(OrderSnapshotEntity order) {
        OrderAuditParams params = new OrderAuditParams();
        params.setOrderId(order.getOrderId());
        this.qihoOrderDAO.auditOrderToSuccess(params);
        this.qihoOrderSnapshotDAO.updateOrderStatus(params.getOrderId(), params.getRemark(), OrderStatusEnum.TO_SEND, OrderApprovalStatusEnum.APPROVE_SUCCESS, null);
        QihoErpOrderEntity erpOrder = new QihoErpOrderEntity();
        erpOrder.setOrderId(order.getOrderId());
        erpOrder.setDelivery(order.getDelivery());
        erpOrder.setItemId(order.getItemId());
        erpOrder.setItemName(order.getItemName());
        erpOrder.setItemNo(order.getItemNo());
        erpOrder.setSkuNo(order.getSkuNo());
        erpOrder.setConsumerName(order.getConsumerName());
        erpOrder.setMobile(order.getMobile());
        erpOrder.setProvince(order.getProvince());
        erpOrder.setCity(order.getCity());
        erpOrder.setDistrict(order.getDistrict());
        erpOrder.setAddress(order.getAddress());
        erpOrder.setErpType(ErpTypeEnum.SEND.getCode());
        erpOrder.setErpId(this.sequenceNoBuilder.createSeqNo(SeqBizTypeEnum.ERP, order.getItemId()));
        erpOrder.setErpStatus(ErpStatusEnum.TO_NOTIFY.getCode());
        this.qihoErpOrderDAO.createErpOrder(erpOrder);
        return erpOrder;
    }
}

