/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.task;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.enums.LogisticsOrderStatusEnum;
import com.qiho.center.api.enums.OrderStatusEnum;
import com.qiho.center.api.enums.YTOLogisticsStatusEnum;
import com.qiho.center.biz.bo.domain.LogisticsOrderDo;
import com.qiho.center.biz.task.BatchOrderTask;
import com.qiho.center.biz.task.OrderBoRunnable;
import com.qiho.center.biz.task.bo.OrderConfirmDo;
import com.qiho.center.common.entity.logistics.LogisticsOrderEntity;
import com.qiho.center.common.entity.order.QihoErpOrderEntity;
import com.qiho.center.common.entityd.qiho.OrderConfirmTaskDetailEntity;
import com.qiho.center.common.entityd.qiho.OrderSnapshotEntity;
import com.qiho.center.common.enums.SeqBizTypeEnum;
import com.qiho.center.common.support.SequenceNoBuilder;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class OrderConfirmBoRunnable
extends OrderBoRunnable {
    private final Logger logger = LoggerFactory.getLogger(OrderConfirmBoRunnable.class);
    private static final String NUM_AND_LETTER_REG_EX = "^[A-Za-z0-9]{1,40}$";
    @Autowired
    SequenceNoBuilder builder;

    public OrderConfirmBoRunnable(BatchOrderTask batchOrderTask, CountDownLatch countDownLatch) {
        super(batchOrderTask, countDownLatch);
    }

    @Override
    public boolean checkParam(OrderConfirmDo confirmDo, OrderSnapshotEntity orderSnapshotEntity) {
        this.detailEntity = new OrderConfirmTaskDetailEntity();
        this.detailEntity.setOrderId(confirmDo.getOrderId());
        this.detailEntity.setOrderConfirmTaskId(this.task.getTaskEntity().getId());
        this.detailEntity.setPostId(confirmDo.getPostId());
        this.detailEntity.setLineNum(confirmDo.getLineNum());
        if ("ERROR_CELL".equals(confirmDo.getPostId()) || "ERROR_CELL".equals(confirmDo.getOrderId())) {
            this.detailEntity.setOrderId("");
            this.detailEntity.setFailMsg("\u9519\u8bef\u7684\u5355\u5143\u683c");
            return false;
        }
        if (orderSnapshotEntity == null) {
            this.detailEntity.setFailMsg("\u8ba2\u5355ID\u4e0d\u5b58\u5728!");
            return false;
        }
        if (orderSnapshotEntity.getDelivery().equals("ERP")) {
            this.detailEntity.setFailMsg("ERP\u8ba2\u5355\u64cd\u4f5c\u5931\u8d25!");
            return false;
        }
        if (!OrderStatusEnum.TO_SEND.getCode().equals(orderSnapshotEntity.getOrderStatus()) && !OrderStatusEnum.TO_APPROVE.getCode().equals(orderSnapshotEntity.getOrderStatus())) {
            this.detailEntity.setFailMsg("\u8ba2\u5355\u975e\u5f85\u53d1\u8d27\u6216\u5f85\u5ba1\u6838\u72b6\u6001!");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)confirmDo.getPostId()) || StringUtils.isBlank((CharSequence)confirmDo.getOrderId())) {
            this.detailEntity.setFailMsg("\u8ba2\u5355ID\u6216\u7269\u6d41\u5355\u53f7\u4e3a\u7a7a!");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)confirmDo.getLogisticsCode()) || StringUtils.isBlank((CharSequence)confirmDo.getLogisticsName())) {
            this.detailEntity.setFailMsg("\u7269\u6d41\u7f16\u7801\u6709\u8bef!");
            return false;
        }
        Pattern pat = Pattern.compile(NUM_AND_LETTER_REG_EX, 2);
        Matcher matcher = pat.matcher(confirmDo.getPostId());
        boolean rs = matcher.matches();
        if (!rs) {
            this.detailEntity.setFailMsg("\u7269\u6d41\u5355\u53f7\u683c\u5f0f\u6709\u8bef!");
            return false;
        }
        if (confirmDo.getMerchantId() == -1L) {
            return true;
        }
        if (!confirmDo.getMerchantId().equals(orderSnapshotEntity.getMerchantId())) {
            this.detailEntity.setFailMsg("\u4e0d\u5c5e\u4e8e\u5bfc\u5165\u7684\u5546\u5bb6!");
            return false;
        }
        return true;
    }

    @Override
    public void auditOrder(OrderConfirmDo bo, OrderSnapshotEntity orderSnapshotEntity, QihoErpOrderEntity erpOrderEntity) {
        if (OrderStatusEnum.TO_APPROVE.getCode().equals(orderSnapshotEntity.getOrderStatus()) && Objects.isNull(erpOrderEntity)) {
            erpOrderEntity = this.auditOrderToSuccess(orderSnapshotEntity);
        }
        LogisticsOrderEntity logisticsOrderEntity = new LogisticsOrderEntity();
        logisticsOrderEntity.setOrderId(bo.getOrderId());
        logisticsOrderEntity.setErpId(erpOrderEntity.getErpId());
        logisticsOrderEntity.setPostId(bo.getPostId());
        logisticsOrderEntity.setLogisticsCode(bo.getLogisticsCode());
        logisticsOrderEntity.setLogisticsName(bo.getLogisticsName());
        logisticsOrderEntity.setLogisticsStatus(YTOLogisticsStatusEnum.ACCEPT.getDesc());
        logisticsOrderEntity.setOrderStatus(LogisticsOrderStatusEnum.ACCEPT.getCode());
        logisticsOrderEntity.setLogisticsId(this.builder.createSeqNo(SeqBizTypeEnum.LOGISTICS, orderSnapshotEntity.getItemId()));
        logisticsOrderEntity.setConsumerName(orderSnapshotEntity.getConsumerName());
        logisticsOrderEntity.setItemId(orderSnapshotEntity.getItemId());
        logisticsOrderEntity.setItemName(orderSnapshotEntity.getItemName());
        logisticsOrderEntity.setItemNo(orderSnapshotEntity.getItemNo());
        logisticsOrderEntity.setMobile(orderSnapshotEntity.getMobile());
        logisticsOrderEntity.setOrderId(orderSnapshotEntity.getOrderId());
        logisticsOrderEntity.setSkuNo(orderSnapshotEntity.getSkuNo());
        logisticsOrderEntity.setProvince(orderSnapshotEntity.getProvince());
        this.logisticsOrderService.createLogisticsOrderBatchDelivery(logisticsOrderEntity);
        this.task.addLogistics((LogisticsOrderDo)BeanUtils.copy((Object)logisticsOrderEntity, LogisticsOrderDo.class));
    }
}

