/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.task;

import com.qiho.center.api.enums.OrderStatusEnum;
import com.qiho.center.biz.bo.OrderLogisticBo;
import com.qiho.center.biz.bo.domain.LogisticsOrderDo;
import com.qiho.center.biz.task.BatchOrderTask;
import com.qiho.center.biz.task.OrderBoRunnable;
import com.qiho.center.biz.task.bo.OrderConfirmDo;
import com.qiho.center.common.entity.order.QihoErpOrderEntity;
import com.qiho.center.common.entityd.qiho.OrderConfirmTaskDetailEntity;
import com.qiho.center.common.entityd.qiho.OrderSnapshotEntity;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class OrderUpdateBoRunnable
extends OrderBoRunnable {
    private final Logger logger = LoggerFactory.getLogger(OrderUpdateBoRunnable.class);
    private static final String NUM_AND_LETTER_REG_EX = "^[A-Za-z0-9]{1,40}$";
    @Autowired
    OrderLogisticBo orderLogisticBo;

    public OrderUpdateBoRunnable(BatchOrderTask batchOrderTask, CountDownLatch countDownLatch) {
        super(batchOrderTask, countDownLatch);
    }

    @Override
    boolean checkParam(OrderConfirmDo confirmDo, OrderSnapshotEntity orderSnapshotEntity) {
        this.detailEntity = new OrderConfirmTaskDetailEntity();
        this.detailEntity.setOrderId(confirmDo.getOrderId());
        this.detailEntity.setOrderConfirmTaskId(this.task.taskEntity.getId());
        this.detailEntity.setPostId(confirmDo.getPostId());
        this.detailEntity.setLineNum(confirmDo.getLineNum());
        if ("ERROR_CELL".equals(confirmDo.getPostId()) || "ERROR_CELL".equals(confirmDo.getOrderId())) {
            this.detailEntity.setOrderId("");
            this.detailEntity.setFailMsg("\u9519\u8bef\u7684\u5355\u5143\u683c");
            return false;
        }
        if (orderSnapshotEntity == null) {
            this.detailEntity.setFailMsg("\u8ba2\u5355ID\u4e0d\u5b58\u5728!");
            return false;
        }
        if (!OrderStatusEnum.SEND_OUT.getCode().equals(orderSnapshotEntity.getOrderStatus())) {
            this.detailEntity.setFailMsg("\u8ba2\u5355\u975e\u5df2\u53d1\u8d27\u72b6\u6001!");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)confirmDo.getPostId()) || StringUtils.isBlank((CharSequence)confirmDo.getOrderId())) {
            this.detailEntity.setFailMsg("\u8ba2\u5355ID\u6216\u7269\u6d41\u5355\u53f7\u4e3a\u7a7a!");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)confirmDo.getLogisticsCode()) || StringUtils.isBlank((CharSequence)confirmDo.getLogisticsName())) {
            this.detailEntity.setFailMsg("\u7269\u6d41\u7f16\u7801\u6709\u8bef!");
            return false;
        }
        Pattern pat = Pattern.compile(NUM_AND_LETTER_REG_EX, 2);
        Matcher matcher = pat.matcher(confirmDo.getPostId().trim());
        boolean rs = matcher.matches();
        if (!rs) {
            this.detailEntity.setFailMsg("\u7269\u6d41\u5355\u53f7\u683c\u5f0f\u6709\u8bef!");
            return false;
        }
        if (confirmDo.getMerchantId() == -1L) {
            return true;
        }
        if (!confirmDo.getMerchantId().equals(orderSnapshotEntity.getMerchantId())) {
            this.detailEntity.setFailMsg("\u4e0d\u5c5e\u4e8e\u5bfc\u5165\u7684\u5546\u5bb6!");
            return false;
        }
        return true;
    }

    @Override
    void auditOrder(OrderConfirmDo confirmDo, OrderSnapshotEntity orderSnapshotEntity, QihoErpOrderEntity erpOrderEntity) {
        this.orderLogisticBo.updateLogistics(confirmDo.getLogisticsCode(), confirmDo.getLogisticsName(), confirmDo.getPostId(), confirmDo.getOrderId());
        LogisticsOrderDo logisticsOrderDo = new LogisticsOrderDo();
        logisticsOrderDo.setPostId(confirmDo.getPostId());
        logisticsOrderDo.setLogisticsCode(confirmDo.getLogisticsCode());
        this.task.addLogistics(logisticsOrderDo);
    }
}

