package com.qiho.center.biz.bo;

import com.qiho.center.api.dto.agent.BaiqiAgentMerchantDto;
import com.qiho.center.api.dto.merchant.MerchantDto;
import com.qiho.center.api.enums.account.BaiqiAccountTypeEnum;
import com.qiho.center.biz.service.account.BaiqiAccountService;
import com.qiho.center.biz.service.agent.BaiqiAgentMerchantService;
import com.qiho.center.biz.service.merchant.MerchantService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * Created by sunchangji on 2017/12/20.
 */
@Service
public class BaiqiAgentBO {
    @Resource
    private BaiqiAgentMerchantService baiqiAgentMerchantService;
    @Resource
    private MerchantService merchantService;
    @Resource
    private BaiqiAccountService baiqiAccountService;

    /**
     * 根据代理商id查询代理商下商家信息
     *
     * @param agentId 代理商id
     * @return
     */
    public List<BaiqiAgentMerchantDto> findAgentMerchantsById(Long agentId) {
        List<Long> merchantIds = baiqiAgentMerchantService.findExistMerchantIds(agentId);
        if (CollectionUtils.isEmpty(merchantIds)) {
            return Collections.emptyList();
        }
        //过滤掉不没有创建账号的商家
        List<Long> filterMerchantIds = baiqiAccountService.filterMerchantIds(merchantIds);
        if(CollectionUtils.isEmpty(filterMerchantIds)){
            return Collections.emptyList();
        }
        Map<Long, MerchantDto> merchantDtoMap = merchantService.findByIdList(filterMerchantIds);
        List<BaiqiAgentMerchantDto> agentMerchantDtos = new ArrayList<>(merchantIds.size());
        for (Long merchantId : merchantIds) {
            if(filterMerchantIds.contains(merchantId)){
                MerchantDto merchantDto = merchantDtoMap.get(merchantId);
                if (merchantDto != null) {
                    BaiqiAgentMerchantDto agentMerchantDto = new BaiqiAgentMerchantDto();
                    agentMerchantDto.setAccountType(BaiqiAccountTypeEnum.MAIN_ACCOUNT.getCode());
                    agentMerchantDto.setMerchantId(merchantDto.getId());
                    agentMerchantDto.setMerchantName(merchantDto.getMerchantName());
                    agentMerchantDtos.add(agentMerchantDto);
                }
            }
        }
        return agentMerchantDtos;
    }

}
