package com.qiho.center.biz.bo;

import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

import javax.annotation.Resource;

import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import com.qiho.center.api.params.ForwardToTuiaParams;

import cn.com.duiba.tuia.activity.center.api.remoteservice.RemoteActivityOrderService;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duiba.wolf.utils.UrlUtils;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.CanAccessInsideNetwork;

/**
 * 推啊数据对接
 *
 * @author jiafeng.geng
 * @since 2018-8-13.
 */
@Component
public class DeliverData2TuiaBo {

    private static final Logger LOGGER = LoggerFactory.getLogger(DeliverData2TuiaBo.class);

    @Resource
    private RemoteActivityOrderService remoteActivityOrderService;

    @Resource
    @CanAccessInsideNetwork
    private CloseableHttpClient httpClient;

    /**
     * 推啊api转化对接url
     */
    @Value("${qiho.order.tuia.url}")
    private String tuiaUrl;

    /**
     * 向推啊回传数据
     *
     * @param url     用于解析参数的url
     * @param subType 9-签收/10-拒签
     * @return String
     */
    public String deliverData(String url, Integer subType) {
        if (StringUtils.isBlank(url)) {
            LOGGER.info("向推啊回传数据_url为空");
            return null;
        }

        DBTimeProfile.enter("解析url参数");
        // 从url中解析参数
        ForwardToTuiaParams params = getParamsByUrl(url);
        if (null == params) {
            LOGGER.info("向推啊回传数据_解析参数为空, URL={}", url);
            DBTimeProfile.release();
            return null;
        }
        DBTimeProfile.release();

        String deliverUrl = tuiaUrl + "?a_oId=" + params.getA_oId() + "&a_tuiaid="
                + params.getA_oId() + "&a_cid=" + params.getA_cid() + "&a_timeStamp="
                + params.getA_timeStamp() + "&type=" + params.getType() + "&subType=" + subType;

        // 向推啊回传数据
        DBTimeProfile.enter("向推啊回传数据");

        String callbackData = "回传推啊返回数据为空";
        String result = sendWithGet(deliverUrl);
        callbackData = StringUtils.isNotBlank(result) ? result : callbackData;

        DBTimeProfile.release();

        return callbackData;
    }

    /**
     * 发送get请求至推啊
     *
     * @param deliverUrl
     * @return
     */
    private String sendWithGet(String deliverUrl) {
        HttpGet httpGet = new HttpGet(deliverUrl);
        httpGet.setConfig(RequestConfig.custom().setSocketTimeout(5000).setConnectTimeout(2000).setConnectionRequestTimeout(100).build());
        try (CloseableHttpResponse resp = httpClient.execute(httpGet)) {
            return EntityUtils.toString(resp.getEntity(), Charset.defaultCharset());
        } catch (Exception e) {
            LOGGER.error("发送get请求至推啊失败, deliverUrl={}", deliverUrl, e);
            return null;
        }
    }

    /**
     * 从url中解析参数
     *
     * @param url
     * @return ForwardToTuiaParams
     */
    private ForwardToTuiaParams getParamsByUrl(String url) {
        if (StringUtils.isEmpty(url)) {
            return null;
        }

        // 解析参数
        Map<String, String> map;
        try {
            map = UrlUtils.uRLRequest(url);
        } catch (Exception e) {
            LOGGER.info("从去除多余内容的URL中解析参数失败, url={}", url, e);
            return null;
        }

        // 封装参数
        ForwardToTuiaParams forwardToTuiaParams = new ForwardToTuiaParams();
        // a_oId
        String aOId = StringUtils.isNotBlank(map.get("a_oId")) ? map.get("a_oId") : map.get("a_tuiaId");
        forwardToTuiaParams.setA_oId(StringUtils.isNotBlank(aOId) ? aOId : "");

        // a_cid
        String aCid = map.get("a_cid");
        if (StringUtils.isBlank(aCid) && StringUtils.isNotBlank(aOId)) {

            DBTimeProfile.enter("根据oid获取acid");
            // 如果地址栏没有a_cid，用a_oId获取
            String acidByOid = getAcidByOid(aOId);
            DBTimeProfile.release();

            forwardToTuiaParams.setA_cid(StringUtils.isNotBlank(acidByOid) ? acidByOid : "");
        } else if (StringUtils.isNotBlank(aCid)) {
            forwardToTuiaParams.setA_cid(aCid);
        } else {
            forwardToTuiaParams.setA_cid("");
        }

        forwardToTuiaParams.setChannelId(map.get("channelId"));
        forwardToTuiaParams.setA_timeStamp(new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
        return forwardToTuiaParams;
    }

    private String getAcidByOid(String aOid) {
        // 截取 aOid中taw-后面的部分做为tuia orderId
        String tuiaOrderId = StringUtils.substringAfter(aOid, "taw-");
        try {
            Long consumerId = remoteActivityOrderService.selectConsumerIdByOrderId(tuiaOrderId);
            return consumerId != null ? consumerId.toString() : null;
        } catch (Exception e) {
            LOGGER.error("aOid查询aCid错误，aOid={}, tuiaOrderId={}, remoteActivityOrderService={}", aOid, tuiaOrderId, remoteActivityOrderService, e);
            return null;
        }
    }
}
