package com.qiho.center.biz.bo;

import cn.com.duiba.stock.service.api.dto.UpdateStockReqDto;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockBackendService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.qiho.center.biz.model.EdbItemStockResponse;
import com.qiho.center.biz.service.impl.OrderStockService;
import com.qiho.center.common.util.EdbLib;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * E店宝商品库存同步逻辑类
 * Created by sunchangji on 2017/11/10.
 */
@Service
public class EdbItemStockBo {
    private static final Logger LOGGER = LoggerFactory.getLogger(EdbItemStockBo.class);
    //每次请求数据条数
    private static final String PAGE_SIZE = "100";
    @Autowired
    private RemoteStockBackendService remoteStockBackendService;

    @Autowired
    private OrderStockService orderStockService;

    @Autowired
    private EdbLib edbLib;

    /***
     * 旺店通同步功能
     * 每个{}进行同步一次
     * {}可配置
     */
    public void syncEdbStock() {
        List<UpdateStockReqDto> increaseStock = Lists.newArrayList();
        List<UpdateStockReqDto> decreaseStock = Lists.newArrayList();
        int pageNo = 1;
        while (true) {
            List<EdbItemStockResponse> responses = edbProductGet(pageNo);
            if (CollectionUtils.isEmpty(responses)) {
                break;
            }
            orderStockService.handleEdbErpStocks(increaseStock, decreaseStock, responses);
            pageNo++;
        }

        DubboResult<Boolean> incResult = remoteStockBackendService.increaseItemStockBatch(increaseStock);
        DubboResult<Boolean> desResult = remoteStockBackendService.decreaseItemStockBatch(decreaseStock);
        if (!incResult.isSuccess() || !desResult.isSuccess()) {
            LOGGER.warn("库存同步失败：{},{}", incResult.getMsg(), desResult.getMsg());
        }
    }


    /**
     * 获取产品库存信息
     * 没有按库存变动时间查询的方法。一般业务下每隔5~10分钟需要查询一遍所有商品的库存
     * 无数据的接口返回数据情况
     * {"Success":{"total_results":"0","items":{"item":[]}}}
     */
    private List<EdbItemStockResponse> edbProductGet(int pageNo) {
        Map<String, String> params = edbLib.edbGetCommonParams("edbProductGet");
        params.put("page_no", String.valueOf(pageNo));
        params.put("page_size", PAGE_SIZE);
        String res = edbLib.edbRequstPost(params);
        if (StringUtils.isBlank(res)) {
            return Collections.emptyList();
        }
        JSONObject json = JSONObject.parseObject(res);

        JSONObject successList = json.getJSONObject("Success");
        if (successList == null) {
            return Collections.emptyList();
        }
        Integer totalResults = successList.getInteger("total_results");
        if (totalResults == 0) {
            return Collections.emptyList();
        }

        String items = successList.getJSONObject("items").getString("item");
        return JSONObject.parseArray(items, EdbItemStockResponse.class);

    }


}
