package com.qiho.center.biz.bo;

import com.qiho.center.api.dto.logistics.LogisticsProcessDto;
import com.qiho.center.biz.bo.domain.LogisticsOrderDo;
import com.qiho.center.common.constant.ExpressEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * 快递工具
 *
 * @author: wangjin
 * @create 2018-06-11 17:13
 **/
@Service
public class ExpressBo {


    @Autowired
    private KuaiDi100Bo kuaiDi100Bo;

    @Autowired
    private ExpressBirdBo expressBirdBo;

    @Autowired
    private ExpressEnvironment expressEnvironment;

    /**
     * 选择物流平台，订阅
     *
     * @param list
     * @return
     */
    public void subscribeExpress(List<LogisticsOrderDo> list) {

        //判断开关
        if (expressEnvironment.isExpressBird()) {
            List<LogisticsOrderDo> bird = new ArrayList<>();
            List<LogisticsOrderDo> hundred = new ArrayList<>();
            list.forEach(item -> {
                if (checkExpress(item.getLogisticsCode())) {
                    bird.add(item);
                } else {
                    hundred.add(item);
                }
            });

            if (!bird.isEmpty()) {
                expressBirdBo.dealPostOrders(bird);
            }
            if (!hundred.isEmpty()) {
                kuaiDi100Bo.dealpostOrders(list);
            }

        } else {
            kuaiDi100Bo.dealpostOrders(list);
        }

    }


    /**
     * 选择物流平台，即时查询
     *
     * @param logisticsCode
     * @param postId
     * @return
     */
    public List<LogisticsProcessDto> queryWaybillTrace(String logisticsCode, String postId) {
        if (expressEnvironment.isExpressBird() && checkExpress(logisticsCode)) {
            List<LogisticsProcessDto> list = expressBirdBo.queryWaybillTrace(logisticsCode, postId);
            if (CollectionUtils.isEmpty(list)){
                return Collections.emptyList();
            }
            Collections.reverse(list);
            return list;
        }

        return kuaiDi100Bo.queryWaybillTrace(logisticsCode, postId);
    }

    /**
     * 即时查询状态
     * @param logisticsCode
     * @param postId
     * @param orderId
     * @return
     */
    public void queryStatus(String logisticsCode, String postId,String orderId){

        // 目前只走快递 100 做修复
        kuaiDi100Bo.queryStatus(logisticsCode, postId,orderId);

    }





    /**
     * 判断快递公司
     *
     * @param code
     * @return
     */
    private boolean checkExpress(String code) {
        //百世，德创，顺丰
        return !("BTWL".equals(code) || "BEST_EX".equals(code) || "SF".equals(code) || "DCWL".equals(code));
    }

}
