package com.qiho.center.biz.bo;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.qiho.center.api.dto.item.ItemEvaluateDto;
import com.qiho.center.api.params.item.BatchImportItemEvaluateParams;
import com.qiho.center.biz.service.item.ItemEvaluateService;
import com.qiho.center.common.annotations.BizEventListener;
import com.qiho.center.common.constant.DsConstants;
import com.qiho.center.common.daoh.qiho.region.BaiqiRegionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.List;
import java.util.concurrent.ExecutorService;

/**
 * @author jiafeng.geng
 * @date 2018-8-31
 */
@Service
@BizEventListener
public class ItemEvaluateBo {

    private static final Logger LOGGER = LoggerFactory.getLogger(ItemEvaluateBo.class);

    private ListeningExecutorService service;

    @Resource
    private ExecutorService executorService;

    @Resource
    private ItemEvaluateService itemEvaluateService;

    @Resource
    private BaiqiRegionMapper baiqiRegionMapper;

    @PostConstruct
    public void init() {
        service = MoreExecutors.listeningDecorator(executorService);
    }

    /**
     * 导入商品评价
     *
     * @param paramsList
     */
    @Transactional(value = DsConstants.DATABASE_QIHO, rollbackFor = Exception.class)
    public void BatchimportItemEvaluate(List<BatchImportItemEvaluateParams> paramsList) {
        // 转换格式
        List<ItemEvaluateDto> itemEvaluateDtoList = BeanUtils.copyList(paramsList, ItemEvaluateDto.class);

        // 批量插入商品评价
        itemEvaluateService.batchInsertItemEval(itemEvaluateDtoList.get(0).getItemId(), itemEvaluateDtoList);
    }
}
