package com.qiho.center.biz.bo;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.qiho.center.api.dto.ItemDto;
import com.qiho.center.biz.service.ItemRecommendService;
import com.qiho.center.biz.service.ItemService;
import com.qiho.center.common.entity.item.QihoItemRecommendEntity;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * Created by liuyao on 2017/5/23.
 *
 */
@Service
public class ItemRecommendBo {

    @Autowired
    private ItemRecommendService itemRecommendService;
    @Autowired
    private ItemService itemService;



    /**
     * 获取所有的推荐商品
     * @return
     */
    public List<ItemDto> findRecommendItemList(){

        List<QihoItemRecommendEntity> recommends = itemRecommendService.findAllItemRecommend();
        Map<Long,QihoItemRecommendEntity> recommendEntityMap = Maps.newHashMap();

        for(QihoItemRecommendEntity it:recommends){
            recommendEntityMap.put(it.getItemId(),it);
        }

        List<ItemDto> dtoList = itemService.findItemDtoByItemIds(recommendEntityMap.keySet());

        ItemOrdering itemOrdering = new ItemOrdering();
        itemOrdering.setRecommendEntityMap(recommendEntityMap);
        Ordering<ItemDto> ordering = Ordering.natural().reverse().onResultOf(itemOrdering);
        return ordering.sortedCopy(dtoList);
    }

    /**
     * 排序器
     */
    private class ItemOrdering implements Function<ItemDto,Integer>{

        private Map<Long,QihoItemRecommendEntity> recommendEntityMap;

        public void setRecommendEntityMap(Map<Long, QihoItemRecommendEntity> recommendEntityMap) {
            this.recommendEntityMap = recommendEntityMap;
        }

        @Override
        public Integer apply(ItemDto input) {
            QihoItemRecommendEntity recommendEntity = recommendEntityMap.get(input.getId());
            return recommendEntity.getPayload();
        }
    }
}
