package com.qiho.center.biz.bo;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.qiho.center.common.constant.DsConstants;
import com.qiho.center.common.dao.QihoCategoryDAO;
import com.qiho.center.common.dao.QihoItemExtDAO;
import com.qiho.center.common.daoh.qiho.tag.BaiqiTagCategoryWeightMapper;
import com.qiho.center.common.daoh.qiho.tag.QihoItemTagMapper;
import com.qiho.center.common.daoh.qiho.tag.QihoTagMapper;
import com.qiho.center.common.daoh.qiho.tag.QihoTagTypeCategoryMapper;
import com.qiho.center.common.daoh.qihostatistics.data.QihoAdvertReportMapper;
import com.qiho.center.common.entity.item.QihoCategoryEntity;
import com.qiho.center.common.entity.item.QihoItemExtEntity;
import com.qiho.center.common.entityd.qiho.data.QihoAdvertReportSumEntity;
import com.qiho.center.common.entityd.qiho.tag.BaiqiTagCategoryWeightEntity;
import com.qiho.center.common.entityd.qiho.tag.QihoItemTagEntity;
import com.qiho.center.common.entityd.qiho.tag.QihoTagEntity;
import com.qiho.center.common.entityd.qiho.tag.QihoTagTypeCategoryEntity;
import com.qiho.center.common.util.SimilarityUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * Author：zhanghuifeng
 * Date: Created in 13:48 2018/3/29
 */
@Service
public class ItemSimilarityBo {

    @Resource
    private QihoAdvertReportMapper qihoAdvertReportMapper;
    @Resource
    private QihoItemTagMapper qihoItemTagMapper;
    @Resource
    private BaiqiTagCategoryWeightMapper baiqiTagCategoryWeightMapper;
    @Resource
    private QihoItemExtDAO qihoItemExtDAO;
    @Resource
    private QihoTagMapper qihoTagMapper;
    @Resource
    private QihoTagTypeCategoryMapper qihoTagTypeCategoryMapper;
    @Resource
    private QihoCategoryDAO qihoCategoryDAO;
    @Resource
    private RedisTemplate<String, Map<Long, Map<Long, Float>>> redisTemplate;

    public void doSimilarity() {

        baiqiTagCategoryWeightMapper.deleteAll();
        LocalDate curDateStart = LocalDate.now().minusWeeks(1);
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zdt = curDateStart.atStartOfDay(zoneId);
        List<QihoAdvertReportSumEntity> sumEntityList = qihoAdvertReportMapper.findByCurDate(Date.from(zdt.toInstant()));
        List<Long> itemIdList = sumEntityList.stream().map(QihoAdvertReportSumEntity::getItemId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(itemIdList)){
            return;
        }

        //商品ID对应的广告效果总量
        Map<Long, QihoAdvertReportSumEntity> itemIdToSumMap = sumEntityList.stream().collect(Collectors.toMap(QihoAdvertReportSumEntity::getItemId, a->a));

        List<QihoItemTagEntity> itemTagEntityList = qihoItemTagMapper.findByItemIds(itemIdList);
        if (CollectionUtils.isEmpty(itemTagEntityList)){
            return;
        }

        //标签所对应商品id集合
        Map<Long,List<Long>> tagIdToItemIdsMap = new HashMap<>();
        //商品所对应的标签id集合
        Map<Long, List<Long>> itemIdToTagIdsMap = new HashMap<>();
        dealItemAndTagMap(itemTagEntityList,tagIdToItemIdsMap,itemIdToTagIdsMap);


        //获取商品身上所有二级类目
        List<QihoItemExtEntity> itemExtEntityList = qihoItemExtDAO.queryAllExtParam(itemIdList);

        //在投的商品所有二级类目
        Set<Long> allSecondCategoryIdList = new HashSet<>();
        //二级类目id所对应的商品集合
        Map<Long, List<Long>> categoryIdToItemIdsMap = new HashMap<>();

        //商品所对应的二级类目集合
        Map<Long, List<Long>> itemIdToCategoryIdsMap = new HashMap<>();
        dealItemAndCategory(itemExtEntityList,allSecondCategoryIdList,categoryIdToItemIdsMap,itemIdToCategoryIdsMap);

        //获取需要做权重处理的标签
        Set<Long> tagIdList = itemTagEntityList.stream().map(QihoItemTagEntity::getTagId).collect(Collectors.toSet());
        List<QihoTagEntity> tagEntityList = qihoTagMapper.findIdAndTypeId(new ArrayList<>(tagIdList));

        //标签对应类型集合
        Map<Long, Long>  tagToTypeIdMap = tagEntityList.stream().collect(Collectors.toMap(QihoTagEntity::getId,QihoTagEntity::getTypeId));

        Set<Long> tagTypeIds = tagEntityList.stream().map(QihoTagEntity::getTypeId).collect(Collectors.toSet());
        List<QihoTagTypeCategoryEntity> tagTypeCategoryEntityList = qihoTagTypeCategoryMapper.findByTypeIds(new ArrayList<>(tagTypeIds));

        //标签类型对应一级类目ID集合
        Map<Long, List<Long>> tagTypeToCategoryIdsMap = dealTagTypeToCategoryIdsMap(tagTypeCategoryEntityList);


        Set<Long> categoryIds = tagTypeCategoryEntityList.stream().map(QihoTagTypeCategoryEntity::getCategoryId).collect(Collectors.toSet());

        List<QihoCategoryEntity> categoryEntityList = qihoCategoryDAO.findByPids(new ArrayList<>(categoryIds));
        //一级类目所对应的二级类目集合
        Map<Long, List<Long>> firstCategoryIdToSeccendIdsMap = dealFirstCategoryIdToSeccendIdsMap(categoryEntityList);

        //计算权重
        List<BaiqiTagCategoryWeightEntity> list = new ArrayList<>();
        Map<String, BigDecimal> tagWeightMap = new HashMap<>();
        for (Long tagId : tagIdList){
            Long tagTypeId = tagToTypeIdMap.get(tagId);
            List<Long> firstCategoryIds = tagTypeToCategoryIdsMap.get(tagTypeId);
            List<Long> secondCategoryIds = new ArrayList<>();
            deal(firstCategoryIds,firstCategoryIdToSeccendIdsMap,secondCategoryIds);
            Set<Long> finalSecondCategoryIds = secondCategoryIds.stream().filter(allSecondCategoryIdList::contains).collect(Collectors.toSet());
            //在投的当前标签下的所有商品
            List<Long> itemIdsByTagId = tagIdToItemIdsMap.get(tagId);

            //获取有当前标签的商品的二级类目数量
            Set<Long> finalCategoryIds = doo(itemIdsByTagId,itemIdToCategoryIdsMap);

            if (CollectionUtils.isNotEmpty(finalSecondCategoryIds)){
                for (Long secondCategoryId : finalSecondCategoryIds){
                    List<Long> itemIds = categoryIdToItemIdsMap.get(secondCategoryId);
                    //当前类目下含有当前标签的商品的总个数
                    List<Long> finalItemIds = itemIdsByTagId.stream().filter(itemIds::contains).collect(Collectors.toList());
                    //当前类目下全部商品标签的总个数
                    List<Long> allTagIds = dealAllTagIds(itemIds,itemIdToTagIdsMap);

                    dealWeight(finalItemIds,allTagIds,itemIdToSumMap,allSecondCategoryIdList,finalCategoryIds,list,secondCategoryId,tagId,tagWeightMap);
                }
            }


        }
        if (CollectionUtils.isNotEmpty(list)){
            baiqiTagCategoryWeightMapper.batchInsert(list);

            //计算相似度
            dealSimilarity(categoryIdToItemIdsMap,itemIdToTagIdsMap,tagWeightMap);

        }
    }

    private List<Long> dealAllTagIds(List<Long> itemIds, Map<Long, List<Long>> itemIdToTagIdsMap){
        //当前类目下全部商品标签的总个数
        List<Long> allTagIds = new ArrayList<>();
        for (Long itemId : itemIds){
            List<Long> tagIds = itemIdToTagIdsMap.get(itemId);
            if (CollectionUtils.isNotEmpty(tagIds)){
                allTagIds.addAll(tagIds);
            }
        }
        return allTagIds;
    }


    /**
     * 处理权重
     * @param finalItemIds
     * @param allTagIds
     * @param itemIdToSumMap
     * @param allSecondCategoryIdList
     * @param finalCategoryIds
     * @param list
     * @param secondCategoryId
     * @param tagId
     * @param tagWeightMap
     */
    private void dealWeight(List<Long> finalItemIds, List<Long> allTagIds, Map<Long, QihoAdvertReportSumEntity> itemIdToSumMap,
                            Set<Long> allSecondCategoryIdList, Set<Long> finalCategoryIds,List<BaiqiTagCategoryWeightEntity> list,Long secondCategoryId,
                            Long tagId,Map<String, BigDecimal> tagWeightMap){
        if (CollectionUtils.isNotEmpty(finalItemIds) && CollectionUtils.isNotEmpty(allTagIds)){
            //获取点击率和下单率
            long allIssueCouponsSum = 0;
            long allOrderCountSum = 0;
            for (Long itemId : finalItemIds){
                QihoAdvertReportSumEntity entity = itemIdToSumMap.get(itemId);
                allIssueCouponsSum = allIssueCouponsSum + entity.getIssueCouponsSum();
                allOrderCountSum = allOrderCountSum + entity.getOrderCountSum();
            }
            BigDecimal tagWeight;
            if (allIssueCouponsSum == 0){
                tagWeight = new BigDecimal(0);
            }else {
                tagWeight = BigDecimal.valueOf(finalItemIds.size())
                        .divide(BigDecimal.valueOf(allTagIds.size()),10,BigDecimal.ROUND_DOWN)
                        .multiply(
                                BigDecimal.valueOf(Math.log(
                                        BigDecimal.valueOf(allSecondCategoryIdList.size())
                                                .divide(BigDecimal.valueOf(finalCategoryIds.size()),10,BigDecimal.ROUND_DOWN).doubleValue()
                                ))
                        )
                        .divide(BigDecimal.valueOf(allIssueCouponsSum),10,BigDecimal.ROUND_DOWN)
                        .multiply(BigDecimal.valueOf(allOrderCountSum)).setScale(10,BigDecimal.ROUND_DOWN)
                        .stripTrailingZeros();
            }

            BaiqiTagCategoryWeightEntity entity = new BaiqiTagCategoryWeightEntity();
            entity.setCategoryId(secondCategoryId);
            entity.setTagId(tagId);
            entity.setWeight(tagWeight);
            list.add(entity);
            tagWeightMap.put(tagId+"_"+secondCategoryId,tagWeight);
        }
    }


    private void deal(List<Long> firstCategoryIds,Map<Long, List<Long>> firstCategoryIdToSeccendIdsMap,List<Long> secondCategoryIds){
        for (Long firstCategoryId : firstCategoryIds){
            List<Long> ids = firstCategoryIdToSeccendIdsMap.get(firstCategoryId);
            if (CollectionUtils.isNotEmpty(ids)){
                secondCategoryIds.addAll(ids);
            }
        }
    }

    //获取有当前标签的商品的二级类目数量
    private Set<Long> doo(List<Long> itemIdsByTagId, Map<Long, List<Long>> itemIdToCategoryIdsMap){
        Set<Long> finalCategoryIds = new HashSet<>();
        for (Long itemId : itemIdsByTagId){
            List<Long> ids = itemIdToCategoryIdsMap.get(itemId);
            if (CollectionUtils.isNotEmpty(ids)){
                finalCategoryIds.addAll(ids);
            }
        }
        return finalCategoryIds;
    }

    private void dealItemAndCategory(List<QihoItemExtEntity> itemExtEntityList, Set<Long> allSecondCategoryIdList, Map<Long, List<Long>> categoryIdToItemIdsMap,
                     Map<Long, List<Long>> itemIdToCategoryIdsMap){
        for (QihoItemExtEntity entity : itemExtEntityList){
            Map<String, String> extParam = JSON.parseObject(entity.getExtParam(),
                    new TypeReference<Map<String, String>>() {
                    });
            List<Long> categoryIds = JSON.parseObject(extParam.get(DsConstants.CATEGORY_ID_LIST),
                    new TypeReference<List<Long>>() {
                    });
            if (categoryIds.size() > 1){
                //获取二级类目ID
                Long categoryId = categoryIds.get(1);
                allSecondCategoryIdList.add(categoryId);
                List<Long> itemIds = categoryIdToItemIdsMap.get(categoryId);
                if (CollectionUtils.isEmpty(itemIds)){
                    itemIds = new ArrayList<>();
                    itemIds.add(entity.getItemId());
                    categoryIdToItemIdsMap.put(categoryId,itemIds);
                }else {
                    itemIds.add(entity.getItemId());
                }
                List<Long> secondCategoryIds = itemIdToCategoryIdsMap.get(entity.getItemId());
                if (CollectionUtils.isEmpty(secondCategoryIds)){
                    secondCategoryIds = new ArrayList<>();
                    secondCategoryIds.add(categoryId);
                    itemIdToCategoryIdsMap.put(entity.getItemId(),secondCategoryIds);
                }else {
                    secondCategoryIds.add(categoryId);
                }
            }
        }
    }

    private Map<Long, List<Long>> dealTagTypeToCategoryIdsMap(List<QihoTagTypeCategoryEntity> tagTypeCategoryEntityList){
        //标签类型对应一级类目ID集合
        Map<Long, List<Long>> tagTypeToCategoryIdsMap = new HashMap<>();
        for (QihoTagTypeCategoryEntity entity : tagTypeCategoryEntityList){
            List<Long> firstCategoryIds = tagTypeToCategoryIdsMap.get(entity.getTypeId());
            if (CollectionUtils.isEmpty(firstCategoryIds)){
                firstCategoryIds = new ArrayList<>();
                firstCategoryIds.add(entity.getCategoryId());
                tagTypeToCategoryIdsMap.put(entity.getTypeId(),firstCategoryIds);
            }else {
                firstCategoryIds.add(entity.getCategoryId());
            }
        }
        return tagTypeToCategoryIdsMap;
    }

    private void dealItemAndTagMap(List<QihoItemTagEntity> itemTagEntityList,Map<Long,List<Long>> tagIdToItemIdsMap,Map<Long, List<Long>> itemIdToTagIdsMap){
        for (QihoItemTagEntity entity : itemTagEntityList){
            List<Long> itemIds = tagIdToItemIdsMap.get(entity.getTagId());
            if (CollectionUtils.isEmpty(itemIds)){
                itemIds = new ArrayList<>();
                itemIds.add(entity.getItemId());
                tagIdToItemIdsMap.put(entity.getTagId(),itemIds);
            }else {
                itemIds.add(entity.getItemId());
            }
            List<Long> tagIds = itemIdToTagIdsMap.get(entity.getItemId());
            if (CollectionUtils.isEmpty(tagIds)){
                tagIds = new ArrayList<>();
                tagIds.add(entity.getTagId());
                itemIdToTagIdsMap.put(entity.getItemId(),tagIds);
            }else {
                tagIds.add(entity.getTagId());
            }
        }
    }

    private Map<Long, List<Long>> dealFirstCategoryIdToSeccendIdsMap(List<QihoCategoryEntity> categoryEntityList){
        //一级类目所对应的二级类目集合
        Map<Long, List<Long>> firstCategoryIdToSeccendIdsMap = new HashMap<>();
        for (QihoCategoryEntity entity : categoryEntityList){
            List<Long> secondCategoryIds = firstCategoryIdToSeccendIdsMap.get(entity.getPid());
            if (CollectionUtils.isEmpty(secondCategoryIds)){
                secondCategoryIds = new ArrayList<>();
                secondCategoryIds.add(entity.getId());
                firstCategoryIdToSeccendIdsMap.put(entity.getPid(),secondCategoryIds);
            }else {
                secondCategoryIds.add(entity.getId());
            }
        }
        return firstCategoryIdToSeccendIdsMap;
    }

    private void dealSimilarity(Map<Long, List<Long>> categoryIdToItemIdsMap, Map<Long, List<Long>> itemIdToTagIdsMap, Map<String, BigDecimal> tagWeightMap){
        //计算相似度
        //keys为二级类目id
        Set<Long> secondCategoryIds = categoryIdToItemIdsMap.keySet();
        Map<Long, Map<Long, Float>> similarityMap = new HashMap<>();
        for(Long secondCategoryId : secondCategoryIds){

            //当类目下商品数小于2个时，不满足处理相似度
            List<Long> itemIds = categoryIdToItemIdsMap.get(secondCategoryId);
            if (itemIds.size() < 2){
                continue;
            }

            //构建标签、商品、权重数据结构
            Map<Long, Map<Long,BigDecimal>> map = dealItemAndTagAndWeight(itemIds,itemIdToTagIdsMap,tagWeightMap,secondCategoryId);
            //计算相似度
            SimilarityUtil util = new SimilarityUtil(map);
            int size = itemIds.size();
            for (int i=0 ; i < size -1 ;i++){
                Long itemId = itemIds.get(i);
                Map<Long, Float> itemMap = similarityMap.get(itemId);
                for (int j = i+1; j < size; j++){
                    Long anotherItemId = itemIds.get(j);
                    Float similarity = util.sim(itemId,anotherItemId).floatValue();
                    dealMap(itemMap,similarityMap,itemId,anotherItemId,similarity);

                    Map<Long, Float> itemMap2 = similarityMap.get(anotherItemId);
                    dealMap(itemMap2,similarityMap,anotherItemId,itemId,similarity);

                }
            }
        }
        redisTemplate.opsForValue().set(DsConstants.ITEM_SIMILARITY_KEY,similarityMap,1, TimeUnit.DAYS);
    }

    private void dealMap(Map<Long, Float> itemMap,Map<Long, Map<Long, Float>> similarityMap, Long itemId, Long anotherItemId,Float similarity){
        if (MapUtils.isEmpty(itemMap)){
            itemMap = new HashMap<>();
            itemMap.put(anotherItemId,similarity);
            similarityMap.put(itemId, itemMap);
        }else {
            itemMap.put(anotherItemId,similarity);
        }
    }

    private Map<Long, Map<Long,BigDecimal>> dealItemAndTagAndWeight(List<Long> itemIds, Map<Long, List<Long>> itemIdToTagIdsMap,Map<String, BigDecimal> tagWeightMap, Long secondCategoryId){
        //构建标签、商品、权重数据结构
        Map<Long, Map<Long,BigDecimal>> map = new HashMap<>();
        Iterator<Long> iterator = itemIds.listIterator();
        while (iterator.hasNext()){
            //获取该商品所有标签集合
            Long itemId = iterator.next();
            List<Long> tagIds = itemIdToTagIdsMap.get(itemId);
            if (CollectionUtils.isEmpty(tagIds)){
                iterator.remove();
                continue;
            }
            for (Long tagId : tagIds){
                //获取标签权重
                Map<Long,BigDecimal> itemToWeight = map.get(tagId);
                BigDecimal weight = tagWeightMap.get(tagId+"_"+secondCategoryId);
                weight = weight==null?BigDecimal.valueOf(0):weight;
                if (MapUtils.isEmpty(itemToWeight)){
                    itemToWeight = new HashMap<>();
                    itemToWeight.put(itemId,weight);
                    map.put(tagId,itemToWeight);
                }else {
                    itemToWeight.put(itemId,weight);
                }
            }
        }
        return map;
    }
}
