package com.qiho.center.biz.bo;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.qiho.center.common.constant.DsConstants;
import com.qiho.center.common.daoh.qiho.LogisticsOrderMapper;
import com.qiho.center.common.daoh.qiho.OrderSnapshotMapper;
import com.qiho.center.common.entityd.qiho.LogisticsOrderEntity;
import com.qiho.center.common.entityd.qiho.OrderSnapshotEntity;

/**
 * Created by weny.cai on 2018/3/21.
 */
@Service
public class OrderLogisticBo {

    @Autowired
    LogisticsOrderMapper logisticsOrderMapper;

    @Autowired
    OrderSnapshotMapper orderSnapshotMapper;

    @Transactional(value = DsConstants.DATABASE_QIHO, rollbackFor = Exception.class)
    public void updateLogistics(String logisticsCode, String logisticsName, String postId, String orderId){
        LogisticsOrderEntity entity = new LogisticsOrderEntity();
        entity.setLogisticsCode(logisticsCode);
        entity.setLogisticsName(logisticsName);
        entity.setPostId(postId);
        entity.setOrderId(orderId);
        logisticsOrderMapper.updateByOrderId(entity);
        OrderSnapshotEntity updateEntity = new OrderSnapshotEntity();
        updateEntity.setOrderId(orderId);
        updateEntity.setPostId(postId);
        updateEntity.setLogisticsCode(logisticsCode);
        updateEntity.setLogisticsName(logisticsName);
        orderSnapshotMapper.updateByOrderIdSelective(updateEntity);
    }

}
